/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.excel.utils;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.EasyExcelFactory;
import com.alibaba.excel.read.builder.ExcelReaderBuilder;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.alibaba.excel.read.listener.ReadListener;
import com.ebaiyihui.excel.listener.AnalysisClassListener;
import com.ebaiyihui.excel.listener.AnalysisMapListener;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import javafx.util.Pair;
import org.springframework.web.multipart.MultipartFile;

public class ReadExcelUtils {
    public static <T> Pair<Map<Integer, String>, List<T>> analysisExcel(MultipartFile file, Class<T> cla, int sheetNo, int headRowNumber) {
        try {
            InputStream inputStream = file.getInputStream();
            AnalysisClassListener<T> analysisClassListener = new AnalysisClassListener<T>(cla, headRowNumber);
            ((ExcelReaderSheetBuilder)EasyExcel.read((InputStream)inputStream, cla, analysisClassListener).sheet(Integer.valueOf(sheetNo)).headRowNumber(Integer.valueOf(headRowNumber))).doRead();
            List<T> list = analysisClassListener.getDataList();
            Map<Integer, String> headMap = analysisClassListener.getHeadMap();
            return new Pair(headMap, list);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Pair<List<Map<Integer, String>>, List<Map<Integer, String>>> analysisExcel(MultipartFile file, int sheetNo, int headRowNumber) {
        try {
            AnalysisMapListener analysisMapListener = new AnalysisMapListener();
            InputStream inputStream = file.getInputStream();
            ((ExcelReaderBuilder)((ExcelReaderBuilder)EasyExcelFactory.read((InputStream)inputStream).registerReadListener((ReadListener)analysisMapListener)).headRowNumber(Integer.valueOf(headRowNumber))).sheet(Integer.valueOf(sheetNo)).doRead();
            List<Map<Integer, String>> headList = analysisMapListener.getHeadList();
            List<Map<Integer, String>> dataList = analysisMapListener.getDataList();
            return new Pair(headList, dataList);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

