/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.excel.utils;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.util.StringUtils;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.builder.ExcelWriterTableBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.alibaba.excel.write.metadata.WriteTable;
import com.alibaba.excel.write.style.column.LongestMatchColumnWidthStyleStrategy;
import com.ebaiyihui.excel.dto.ExcelRemarkDTO;
import com.ebaiyihui.excel.dto.ExportClassDTO;
import com.ebaiyihui.excel.dto.ExportStringDTO;
import com.ebaiyihui.excel.strategy.CommonMergeStrategy;
import com.ebaiyihui.excel.strategy.DataCellMergeStrategy;
import com.ebaiyihui.excel.strategy.RemarkCellMergeStrategy;
import com.ebaiyihui.excel.style.DataCellStyle;
import com.ebaiyihui.excel.style.RemarkCellStyle;
import com.ebaiyihui.excel.style.TitleCellStyle;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;

public class WriteExcelUtils {
    public static void setHeader(HttpServletResponse httpServletResponse, String fileName) {
        try {
            httpServletResponse.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            httpServletResponse.setCharacterEncoding("utf-8");
            fileName = URLEncoder.encode(fileName, "UTF-8");
            httpServletResponse.setHeader("Content-disposition", "attachment;filename*=utf-8''" + fileName + ".xlsx");
            httpServletResponse.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> void exportExcel(ExportClassDTO<T> exportClassDTO) {
        try {
            HttpServletResponse httpServletResponse = exportClassDTO.getHttpServletResponse();
            String fileName = StringUtils.isEmpty((Object)exportClassDTO.getFileName()) ? "" : exportClassDTO.getFileName();
            WriteExcelUtils.setHeader(httpServletResponse, fileName);
            WriteExcelUtils.write(exportClassDTO, (OutputStream)httpServletResponse.getOutputStream());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> ByteArrayOutputStream builderDataToExcel(List<T> data, Class<T> clazz, String fileName, String sheetName) {
        if (CollectionUtils.isEmpty(data) || Objects.isNull(clazz) || StringUtils.isEmpty((Object)fileName) || StringUtils.isEmpty((Object)sheetName)) {
            throw new RuntimeException("\u6570\u636e\u8f6cexcel\u53c2\u6570\u4fe1\u606f\u6709\u8bef");
        }
        ExportClassDTO exportClassDTO = new ExportClassDTO().setFileName(fileName).setSheetName(sheetName).setDataList(data).setDataClass(clazz);
        return WriteExcelUtils.getExcelOutputStream(exportClassDTO);
    }

    public static <T> ByteArrayOutputStream getExcelOutputStream(ExportClassDTO<T> exportClassDTO) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            WriteExcelUtils.write(exportClassDTO, (OutputStream)outputStream);
            return outputStream;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static <T> void write(ExportClassDTO<T> exportClassDTO, OutputStream outputStream) {
        WriteTable remarkTable;
        String fileName = StringUtils.isEmpty((Object)exportClassDTO.getFileName()) ? "" : exportClassDTO.getFileName();
        String sheetName = StringUtils.isEmpty((Object)exportClassDTO.getSheetName()) ? fileName : exportClassDTO.getSheetName();
        List<Object> list = CollectionUtils.isEmpty(exportClassDTO.getDataList()) ? new ArrayList() : exportClassDTO.getDataList();
        Class<T> dataClass = exportClassDTO.getDataClass();
        String title = exportClassDTO.getTitle();
        List<String> remarks = exportClassDTO.getRemarkList();
        int rowCount = WriteExcelUtils.getColumnSize(dataClass);
        ExcelWriter excelWriter = EasyExcel.write((OutputStream)outputStream).build();
        WriteSheet writeSheet = ((ExcelWriterSheetBuilder)EasyExcel.writerSheet((String)sheetName).needHead(Boolean.FALSE)).build();
        int i = 0;
        if (!StringUtils.isEmpty((Object)title)) {
            ArrayList<ExcelRemarkDTO> titleList = new ArrayList<ExcelRemarkDTO>();
            titleList.add(new ExcelRemarkDTO(title));
            remarkTable = ((ExcelWriterTableBuilder)((ExcelWriterTableBuilder)((ExcelWriterTableBuilder)((ExcelWriterTableBuilder)EasyExcel.writerTable((Integer)i).head(ExcelRemarkDTO.class)).needHead(Boolean.FALSE)).registerWriteHandler((WriteHandler)new TitleCellStyle())).registerWriteHandler((WriteHandler)new RemarkCellMergeStrategy(rowCount))).build();
            excelWriter.write(titleList, writeSheet, remarkTable);
            ++i;
        }
        if (CollectionUtils.isNotEmpty(remarks)) {
            ArrayList remarkList = new ArrayList();
            remarks.forEach(bean -> remarkList.add(new ExcelRemarkDTO((String)bean)));
            remarkTable = ((ExcelWriterTableBuilder)((ExcelWriterTableBuilder)((ExcelWriterTableBuilder)((ExcelWriterTableBuilder)EasyExcel.writerTable((Integer)i).head(ExcelRemarkDTO.class)).needHead(Boolean.FALSE)).registerWriteHandler((WriteHandler)new RemarkCellMergeStrategy(rowCount))).registerWriteHandler((WriteHandler)new RemarkCellStyle())).build();
            excelWriter.write(remarkList, writeSheet, remarkTable);
            ++i;
        }
        ExcelWriterTableBuilder excelWriterTableBuilder = (ExcelWriterTableBuilder)((ExcelWriterTableBuilder)((ExcelWriterTableBuilder)((ExcelWriterTableBuilder)EasyExcel.writerTable((Integer)i).head(dataClass)).needHead(Boolean.TRUE)).registerWriteHandler((WriteHandler)new DataCellStyle())).registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy());
        if (exportClassDTO.getRowMergeMap() != null) {
            excelWriterTableBuilder.registerWriteHandler((WriteHandler)new CommonMergeStrategy(exportClassDTO.getRowMergeMap()));
        }
        excelWriter.write(list, writeSheet, excelWriterTableBuilder.build());
        excelWriter.finish();
    }

    public static void exportExcel(ExportStringDTO exportStringDTO) {
        try {
            HttpServletResponse httpServletResponse = exportStringDTO.getHttpServletResponse();
            String fileName = StringUtils.isEmpty((Object)exportStringDTO.getFileName()) ? "" : exportStringDTO.getFileName();
            WriteExcelUtils.setHeader(httpServletResponse, fileName);
            WriteExcelUtils.write(exportStringDTO, (OutputStream)httpServletResponse.getOutputStream());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static ByteArrayOutputStream getExcelOutputStream(ExportStringDTO exportStringDTO) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            WriteExcelUtils.write(exportStringDTO, (OutputStream)outputStream);
            return outputStream;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void write(ExportStringDTO exportStringDTO, OutputStream outputStream) {
        WriteTable remarkTable;
        String fileName = StringUtils.isEmpty((Object)exportStringDTO.getFileName()) ? "" : exportStringDTO.getFileName();
        String sheetName = StringUtils.isEmpty((Object)exportStringDTO.getSheetName()) ? fileName : exportStringDTO.getFileName();
        List<List<Object>> list = exportStringDTO.getDataList();
        List<List<String>> heads = exportStringDTO.getHeads();
        String title = exportStringDTO.getTitle();
        List<String> remarks = exportStringDTO.getRemarkList();
        Integer mergeRowIndex = exportStringDTO.getMergeRowIndex();
        int[] mergeColumnIndex = exportStringDTO.getMergeColumnIndex();
        int rowCount = heads.size();
        ExcelWriter excelWriter = EasyExcel.write((OutputStream)outputStream).build();
        WriteSheet writeSheet = ((ExcelWriterSheetBuilder)EasyExcel.writerSheet((String)sheetName).needHead(Boolean.FALSE)).build();
        int i = 0;
        if (!StringUtils.isEmpty((Object)title)) {
            ArrayList<ExcelRemarkDTO> titleList = new ArrayList<ExcelRemarkDTO>();
            titleList.add(new ExcelRemarkDTO(title));
            remarkTable = ((ExcelWriterTableBuilder)((ExcelWriterTableBuilder)((ExcelWriterTableBuilder)((ExcelWriterTableBuilder)EasyExcel.writerTable((Integer)i).head(ExcelRemarkDTO.class)).needHead(Boolean.FALSE)).registerWriteHandler((WriteHandler)new TitleCellStyle())).registerWriteHandler((WriteHandler)new RemarkCellMergeStrategy(rowCount))).build();
            excelWriter.write(titleList, writeSheet, remarkTable);
            ++i;
        }
        if (!StringUtils.isEmpty(remarks)) {
            ArrayList remarkList = new ArrayList();
            remarks.forEach(bean -> remarkList.add(new ExcelRemarkDTO((String)bean)));
            remarkTable = ((ExcelWriterTableBuilder)((ExcelWriterTableBuilder)((ExcelWriterTableBuilder)((ExcelWriterTableBuilder)EasyExcel.writerTable((Integer)i).head(ExcelRemarkDTO.class)).needHead(Boolean.FALSE)).registerWriteHandler((WriteHandler)new RemarkCellMergeStrategy(rowCount))).registerWriteHandler((WriteHandler)new RemarkCellStyle())).build();
            excelWriter.write(remarkList, writeSheet, remarkTable);
            ++i;
        }
        ExcelWriterTableBuilder excelWriterTableBuilder = (ExcelWriterTableBuilder)((ExcelWriterTableBuilder)((ExcelWriterTableBuilder)((ExcelWriterTableBuilder)EasyExcel.writerTable((Integer)i).head(heads)).needHead(Boolean.TRUE)).registerWriteHandler((WriteHandler)new DataCellStyle())).registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy());
        if (mergeRowIndex != null && mergeColumnIndex != null) {
            excelWriterTableBuilder.registerWriteHandler((WriteHandler)new DataCellMergeStrategy(mergeRowIndex, mergeColumnIndex));
        }
        excelWriter.write(list, writeSheet, excelWriterTableBuilder.build());
        excelWriter.finish();
    }

    private static <T> Integer getColumnSize(Class<T> tClass) {
        Field[] fields = tClass.getDeclaredFields();
        ArrayList<Field> fieldList = new ArrayList<Field>();
        for (Field field : fields) {
            field.setAccessible(true);
            if (!field.isAnnotationPresent(ExcelProperty.class)) continue;
            fieldList.add(field);
        }
        return fieldList.size();
    }
}

