/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.helper;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.his.helper.InvoiceApiProxy;
import com.ebaiyihui.his.helper.InvoiceConfig;
import com.ebaiyihui.his.pojo.dto.InvoiceOperationResponseDTO;
import com.ebaiyihui.his.pojo.dto.InvoiceWriteOffResponseDTO;
import com.ebaiyihui.his.pojo.vo.invoice.InvoiceRequestBodyVO;
import com.ebaiyihui.his.utils.Base64Util;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InvoiceRequestHelper {
    private static final Logger log = LoggerFactory.getLogger(InvoiceRequestHelper.class);
    private static final InvoiceApiProxy INVOICE_API_PROXY = new InvoiceApiProxy();

    public static InvoiceOperationResponseDTO createInvoice(InvoiceRequestBodyVO invoiceRequestBodyVO) {
        log.info("\u5f00\u59cb\u8bf7\u6c42\u521b\u5efa\u53d1\u7968\u63a5\u53e3");
        String jsonReqStr = JSON.toJSONString((Object)invoiceRequestBodyVO);
        log.info("\u672a\u52a0\u5bc6\u524d\u7684\u53c2\u6570\u4e3a");
        InvoiceOperationResponseDTO callResp = null;
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("invEBillCheckUp", Base64Util.encode((String)jsonReqStr));
            StringBuilder result = new StringBuilder();
            callResp = (InvoiceOperationResponseDTO)INVOICE_API_PROXY.callApi(InvoiceConfig.INVOICE_REQUEST_PREFIX_URL + InvoiceConfig.OPEN_INVOICE_REQUEST_URL, params, InvoiceOperationResponseDTO.class, result);
            log.info("\u8bf7\u6c42\u7ed3\u675f\uff0c\u7ed3\u679c\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)callResp));
            if (callResp == null) {
                throw new RuntimeException("\u521b\u5efa\u53d1\u7968\u63a5\u53e3\u8fd4\u56de\u503c\u4e3a\u7a7a");
            }
            callResp.setRequestBody(jsonReqStr);
            callResp.setResponseBody(result.toString());
            callResp.setRequestUrl(InvoiceConfig.INVOICE_REQUEST_PREFIX_URL + InvoiceConfig.OPEN_INVOICE_REQUEST_URL);
            return callResp;
        }
        catch (Exception e) {
            log.info("\u8bf7\u6c42\u63a5\u53e3\u62a5\u9519", (Throwable)e);
            throw new RuntimeException(e.getCause().getMessage());
        }
    }

    public static InvoiceWriteOffResponseDTO overWriteInvoice(String patientId, String billNo) {
        log.info("\u5f00\u59cb\u8bf7\u6c42\u51b2\u7ea2\u53d1\u7968\u63a5\u53e3,patientId:{},billNo:{}", (Object)patientId, (Object)billNo);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("patientId", Base64Util.encode((String)patientId));
        params.put("billNo", Base64Util.encode((String)billNo));
        String jsonReqStr = JSON.toJSONString(params);
        InvoiceWriteOffResponseDTO callResp = null;
        try {
            StringBuilder result = new StringBuilder();
            callResp = (InvoiceWriteOffResponseDTO)INVOICE_API_PROXY.callApi(InvoiceConfig.INVOICE_REQUEST_PREFIX_URL + InvoiceConfig.OVER_WRITE_REQUEST_PREFIX_URL, params, InvoiceWriteOffResponseDTO.class, result);
            log.info("\u8bf7\u6c42\u7ed3\u675f\uff0c\u7ed3\u679c\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)callResp));
            if (callResp == null) {
                throw new RuntimeException("\u51b2\u7ea2\u53d1\u7968\u63a5\u53e3\u8fd4\u56de\u503c\u4e3a\u7a7a");
            }
            callResp.setRequestBody(jsonReqStr);
            callResp.setResponseBody(result.toString());
            callResp.setRequestUrl(InvoiceConfig.INVOICE_REQUEST_PREFIX_URL + InvoiceConfig.OPEN_INVOICE_REQUEST_URL);
            return callResp;
        }
        catch (Exception e) {
            log.info(e.getMessage());
            throw new RuntimeException(e.getCause().getMessage());
        }
    }
}

