/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.service.impl;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.his.common.enums.AdmTimeRangeEnum;
import com.ebaiyihui.his.common.enums.EntityKeyEnum;
import com.ebaiyihui.his.common.enums.MethodCodeEnum;
import com.ebaiyihui.his.common.enums.PayTypeEnums;
import com.ebaiyihui.his.common.enums.ServiceEnums;
import com.ebaiyihui.his.pojo.dto.GetAppointRecordReqDTO;
import com.ebaiyihui.his.pojo.dto.GetAppointRecordResDTO;
import com.ebaiyihui.his.pojo.dto.GetAppointRecordResItemDTO;
import com.ebaiyihui.his.pojo.dto.PayAppointmentReqDTO;
import com.ebaiyihui.his.pojo.dto.PayAppointmentResDTO;
import com.ebaiyihui.his.pojo.dto.RegisteredNowDayReqDTO;
import com.ebaiyihui.his.pojo.dto.RegisteredNowDayResDTO;
import com.ebaiyihui.his.pojo.dto.ReturnRegisterReqDTO;
import com.ebaiyihui.his.pojo.dto.ReturnRegisterResDTO;
import com.ebaiyihui.his.pojo.vo.appoint.AppointRecordItem;
import com.ebaiyihui.his.pojo.vo.appoint.DayRegisterReq;
import com.ebaiyihui.his.pojo.vo.appoint.DayRegisterRes;
import com.ebaiyihui.his.pojo.vo.appoint.GetAppointRecordReq;
import com.ebaiyihui.his.pojo.vo.appoint.GetAppointRecordRes;
import com.ebaiyihui.his.pojo.vo.appoint.PayHisNoticeReq;
import com.ebaiyihui.his.pojo.vo.appoint.PayRegistrationMsg;
import com.ebaiyihui.his.pojo.vo.appoint.PayRegistrationReq;
import com.ebaiyihui.his.pojo.vo.appoint.PayRegistrationRes;
import com.ebaiyihui.his.pojo.vo.appoint.ReturnRegisterReq;
import com.ebaiyihui.his.pojo.vo.appoint.ReturnRegisterRes;
import com.ebaiyihui.his.pojo.vo.base.FrontRequest;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import com.ebaiyihui.his.service.AppointService;
import com.ebaiyihui.his.service.HisRemoteService;
import com.ebaiyihui.his.service.PayService;
import com.ebaiyihui.his.utils.DateUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AppointServiceImpl
implements AppointService {
    public static final String CLINIC_TYPE_APPOINT = "0";
    public static final String CLINIC_TYPE_CANCEL = "1";
    private static final String PAY_SUCCESS = "Y";
    private static final String PAY_FAIL = "N";
    private static final String HIS_PAY_SUCCESS = "SUCCESS";
    private static final String HIS_PAY_FAIL = "FAIL";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private HisRemoteService hisRemoteService;
    @Autowired
    PayService payService;

    public FrontResponse<PayRegistrationRes> payRegistration(FrontRequest<PayRegistrationReq> param) {
        PayRegistrationRes payRegistrationRes = new PayRegistrationRes();
        PayRegistrationReq payRegistrationReq = (PayRegistrationReq)param.getBody();
        PayRegistrationMsg respMsg = payRegistrationReq.getRespMsg();
        PayAppointmentReqDTO payAppointmentReqDTO = new PayAppointmentReqDTO();
        payAppointmentReqDTO.setPayChannel(PayTypeEnums.getDisplay((String)payRegistrationReq.getPayChannel()));
        payAppointmentReqDTO.setCardNo(payRegistrationReq.getCardNo());
        payAppointmentReqDTO.setScheduleCode(payRegistrationReq.getScheduleId());
        payAppointmentReqDTO.setScheduleDate(respMsg.getAccdate());
        payAppointmentReqDTO.setSerialNumber(payRegistrationReq.getSerialNumber());
        payAppointmentReqDTO.setRegistrationType(payRegistrationReq.getRegistrationType());
        payAppointmentReqDTO.setPayAmount(respMsg.getPayment());
        payAppointmentReqDTO.setPayTime(respMsg.getAccdate());
        payAppointmentReqDTO.setTradNo(respMsg.getOrderid());
        payAppointmentReqDTO.setDepartmentsCode(payRegistrationReq.getDepartmentsCode());
        HashMap<String, PayAppointmentReqDTO> payAppointMap = new HashMap<String, PayAppointmentReqDTO>(1);
        payAppointMap.put(EntityKeyEnum.PAY_REGISTRATION.getValue(), payAppointmentReqDTO);
        FrontResponse response = this.hisRemoteService.requestHis(ServiceEnums.DO_REGISTER.getDisplay(), param.getTransactionId(), MethodCodeEnum.APPOINTMENT_REGISTRATION_PAY.getValue(), payAppointMap, PayAppointmentResDTO.class);
        if (null == response) {
            return FrontResponse.error((String)response.getTransactionId(), (String)CLINIC_TYPE_CANCEL, (String)response.getMessage());
        }
        PayAppointmentResDTO body = (PayAppointmentResDTO)response.getBody();
        if (null == body) {
            return FrontResponse.error((String)param.getTransactionId(), (String)CLINIC_TYPE_APPOINT, (String)"\u8c03\u7528\u63a5\u53e3\u5931\u8d25");
        }
        if (!CLINIC_TYPE_CANCEL.equals(body.getState())) {
            return FrontResponse.error((String)param.getTransactionId(), (String)CLINIC_TYPE_APPOINT, (String)body.getError());
        }
        PayAppointmentResDTO.itemDTO payAppointmentResDTO = (PayAppointmentResDTO.itemDTO)body.getData().getItem().get(0);
        payRegistrationRes.setAdmId(payAppointmentResDTO.getPatientNumber());
        payRegistrationRes.setReceiptId(payAppointmentResDTO.getPayDemandNote());
        payRegistrationRes.setNo(payAppointmentResDTO.getPatientNumber());
        try {
            FrontRequest frontRequest = new FrontRequest();
            PayHisNoticeReq payHisNoticeReq = new PayHisNoticeReq();
            payHisNoticeReq.setOrderId(payAppointmentReqDTO.getTradNo());
            payHisNoticeReq.setDjysj(DateUtil.getCurrentDateStr((String)"yyyy-MM"));
            payHisNoticeReq.setCBRH(payAppointmentResDTO.getPatientNumber());
            payHisNoticeReq.setCYNLSH(payAppointmentResDTO.getPayDemandNote());
            payHisNoticeReq.setSign("");
            frontRequest.setBody((Object)payHisNoticeReq);
            frontRequest.setChannel(param.getChannel());
            frontRequest.setChannelName(param.getChannelName());
            this.logger.info("\u8c03\u7528\u652f\u4ed8\u5e73\u53f0\u901a\u77e5\u63a5\u53e3\u5165\u53c2\uff1a" + JSON.toJSONString((Object)frontRequest));
            FrontResponse frontResponse = this.payService.payHisNotice(frontRequest);
            if (frontResponse.getCode().equals(CLINIC_TYPE_APPOINT)) {
                this.logger.info("\u8c03\u7528\u652f\u4ed8\u5e73\u53f0\u901a\u77e5\u63a5\u53e3\u5931\u8d25\u8ba2\u5355\u53f7\u4e3a\uff1a" + payHisNoticeReq.getOrderId());
            } else {
                this.logger.info("\u8c03\u7528\u652f\u4ed8\u5e73\u53f0\u901a\u77e5\u63a5\u53e3\u6210\u529f\u8ba2\u5355\u53f7\u4e3a\uff1a" + payHisNoticeReq.getOrderId());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.info("\u8c03\u7528\u652f\u4ed8\u5e73\u53f0\u901a\u77e5\u63a5\u53e3\u5f02\u5e38\u8ba2\u5355\u53f7\u4e3a\uff1a" + payAppointmentReqDTO.getTradNo());
        }
        return FrontResponse.success((String)param.getTransactionId(), (Object)payRegistrationRes);
    }

    public FrontResponse<ReturnRegisterRes> returnRegister(FrontRequest<ReturnRegisterReq> param) {
        ReturnRegisterReqDTO returnRegisterReqDTO = new ReturnRegisterReqDTO();
        ReturnRegisterReq returnRegisterReq = (ReturnRegisterReq)param.getBody();
        returnRegisterReqDTO.setCardNo(returnRegisterReq.getCardNo());
        returnRegisterReqDTO.setClinicNo(returnRegisterReq.getAppointId());
        HashMap<String, ReturnRegisterReqDTO> returnRegMap = new HashMap<String, ReturnRegisterReqDTO>(1);
        returnRegMap.put(EntityKeyEnum.RETURN_REGISTER.getValue(), returnRegisterReqDTO);
        FrontResponse returnRegisterResDTO = this.hisRemoteService.requestHis(ServiceEnums.DO_CANCELREGISTER.getDisplay(), param.getTransactionId(), MethodCodeEnum.ONLINE_REGISTRATION_REFUND.getValue(), returnRegMap, ReturnRegisterResDTO.class);
        if (null == returnRegisterResDTO) {
            return FrontResponse.error((String)param.getTransactionId(), (String)CLINIC_TYPE_APPOINT, (String)"\u9000\u53f7\u5931\u8d25");
        }
        ReturnRegisterResDTO body = (ReturnRegisterResDTO)returnRegisterResDTO.getBody();
        if (null == body) {
            return FrontResponse.error((String)param.getTransactionId(), (String)CLINIC_TYPE_APPOINT, (String)"\u8c03\u7528\u63a5\u53e3\u5931\u8d25");
        }
        if (!CLINIC_TYPE_CANCEL.equals(body.getState())) {
            return FrontResponse.error((String)param.getTransactionId(), (String)CLINIC_TYPE_APPOINT, (String)body.getError());
        }
        ReturnRegisterResDTO.itemDTO itemDTO2 = (ReturnRegisterResDTO.itemDTO)body.getData().getItem().get(0);
        ReturnRegisterRes returnRegisterRes = new ReturnRegisterRes();
        returnRegisterRes.setPatientId(itemDTO2.getPatientId());
        returnRegisterRes.setRegistrationTime(itemDTO2.getRegistrationTime());
        return FrontResponse.success((String)param.getTransactionId(), (Object)returnRegisterRes);
    }

    public FrontResponse<GetAppointRecordRes> getAppointRecord(FrontRequest<GetAppointRecordReq> param) {
        GetAppointRecordRes getAppointRecordRes = new GetAppointRecordRes();
        ArrayList<AppointRecordItem> items = new ArrayList<AppointRecordItem>();
        GetAppointRecordReqDTO getAppointRecordReqDTO = new GetAppointRecordReqDTO();
        getAppointRecordReqDTO.setCardNo(((GetAppointRecordReq)param.getBody()).getCardNo());
        getAppointRecordReqDTO.setStartDate(((GetAppointRecordReq)param.getBody()).getStartDate());
        getAppointRecordReqDTO.setEndDate(((GetAppointRecordReq)param.getBody()).getEndDate());
        HashMap<String, GetAppointRecordReqDTO> appointRecordMap = new HashMap<String, GetAppointRecordReqDTO>(1);
        appointRecordMap.put(EntityKeyEnum.GET_APPOINT_RECORD.getValue(), getAppointRecordReqDTO);
        FrontResponse appointRecordRes = this.hisRemoteService.requestHis("", param.getTransactionId(), MethodCodeEnum.PATIENT_APPOINTMENT_LIST_QUERY.getValue(), appointRecordMap, GetAppointRecordResDTO.class);
        if (null == appointRecordRes) {
            return FrontResponse.error((String)appointRecordRes.getTransactionId(), (String)CLINIC_TYPE_APPOINT, (String)appointRecordRes.getMessage());
        }
        if (!CLINIC_TYPE_APPOINT.equals(((GetAppointRecordResDTO)appointRecordRes.getBody()).getResultCode())) {
            return FrontResponse.error((String)appointRecordRes.getTransactionId(), (String)CLINIC_TYPE_APPOINT, (String)((GetAppointRecordResDTO)appointRecordRes.getBody()).getResultMsg());
        }
        List getAppointRecordResItemDTOList = ((GetAppointRecordResDTO)appointRecordRes.getBody()).getItem();
        if (CollectionUtils.isEmpty((Collection)getAppointRecordResItemDTOList)) {
            return FrontResponse.error((String)appointRecordRes.getTransactionId(), (String)CLINIC_TYPE_APPOINT, (String)((GetAppointRecordResDTO)appointRecordRes.getBody()).getResultMsg());
        }
        for (GetAppointRecordResItemDTO getAppointRecordResItemDTO : getAppointRecordResItemDTOList) {
            AppointRecordItem appointRecordItem = new AppointRecordItem();
            BeanUtils.copyProperties((Object)getAppointRecordResItemDTO, (Object)appointRecordItem);
            appointRecordItem.setAdmitTimeRange(AdmTimeRangeEnum.getDisplay((String)getAppointRecordResItemDTO.getAdmTimeRange()));
            items.add(appointRecordItem);
        }
        getAppointRecordRes.setItems(items);
        getAppointRecordRes.setCardNo(((GetAppointRecordResItemDTO)getAppointRecordResItemDTOList.get(0)).getCardNo());
        getAppointRecordRes.setName(((GetAppointRecordResItemDTO)getAppointRecordResItemDTOList.get(0)).getPatientName());
        return FrontResponse.success((String)param.getTransactionId(), (Object)getAppointRecordRes);
    }

    public FrontResponse<DayRegisterRes> lock(FrontRequest<DayRegisterReq> param) {
        DayRegisterReq dayRegisterReq = (DayRegisterReq)param.getBody();
        if (null == dayRegisterReq) {
            this.logger.error("\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        RegisteredNowDayReqDTO registeredNowDayReqDTO = new RegisteredNowDayReqDTO();
        registeredNowDayReqDTO.setCardNo(dayRegisterReq.getCardNo());
        registeredNowDayReqDTO.setSchedualNo(dayRegisterReq.getRbasId());
        registeredNowDayReqDTO.setTimeArrangeNo(dayRegisterReq.getTimeArrangeId());
        HashMap<String, RegisteredNowDayReqDTO> registeredNowDayReqMap = new HashMap<String, RegisteredNowDayReqDTO>(1);
        registeredNowDayReqMap.put(EntityKeyEnum.REGISTERED_NOWDAY.getValue(), registeredNowDayReqDTO);
        FrontResponse registeredNowDayRes = this.hisRemoteService.requestHis(ServiceEnums.DO_LOCKSERIAL.getDisplay(), param.getTransactionId(), MethodCodeEnum.REGISTERED_NOWDAY.getValue(), registeredNowDayReqMap, RegisteredNowDayResDTO.class);
        RegisteredNowDayResDTO body = (RegisteredNowDayResDTO)registeredNowDayRes.getBody();
        if (null == registeredNowDayRes) {
            return FrontResponse.error((String)param.getTransactionId(), (String)CLINIC_TYPE_CANCEL, (String)registeredNowDayRes.getMessage());
        }
        if (null == body) {
            return FrontResponse.error((String)param.getTransactionId(), (String)CLINIC_TYPE_APPOINT, (String)"\u8c03\u7528\u63a5\u53e3\u5931\u8d25");
        }
        if (!CLINIC_TYPE_CANCEL.equals(body.getState())) {
            return FrontResponse.error((String)param.getTransactionId(), (String)CLINIC_TYPE_APPOINT, (String)body.getError());
        }
        DayRegisterRes dayRegisterRes = new DayRegisterRes();
        dayRegisterRes.setNo(((RegisteredNowDayResDTO.itemDTO)body.getData().getItem().get(0)).getSerialNumber());
        dayRegisterRes.setAppointId(((RegisteredNowDayResDTO.itemDTO)body.getData().getItem().get(0)).getScheduleCode());
        return FrontResponse.success((String)registeredNowDayRes.getTransactionId(), (Object)dayRegisterRes);
    }

    public FrontResponse<DayRegisterRes> unLock(FrontRequest<DayRegisterReq> param) {
        DayRegisterReq dayRegisterReq = (DayRegisterReq)param.getBody();
        if (null == dayRegisterReq) {
            this.logger.error("\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        RegisteredNowDayReqDTO registeredNowDayReqDTO = new RegisteredNowDayReqDTO();
        registeredNowDayReqDTO.setCardNo(dayRegisterReq.getCardNo());
        registeredNowDayReqDTO.setSchedualNo(dayRegisterReq.getRbasId());
        registeredNowDayReqDTO.setTimeArrangeNo(dayRegisterReq.getTimeArrangeId());
        HashMap<String, RegisteredNowDayReqDTO> registeredNowDayReqMap = new HashMap<String, RegisteredNowDayReqDTO>(1);
        registeredNowDayReqMap.put(EntityKeyEnum.UN_REGISTERED_NOWDAY.getValue(), registeredNowDayReqDTO);
        FrontResponse registeredNowDayRes = this.hisRemoteService.requestHis(ServiceEnums.DO_UNLOCKSERIAL.getDisplay(), param.getTransactionId(), MethodCodeEnum.UN_REGISTERED_NOWDAY.getValue(), registeredNowDayReqMap, RegisteredNowDayResDTO.class);
        RegisteredNowDayResDTO body = (RegisteredNowDayResDTO)registeredNowDayRes.getBody();
        if (null == registeredNowDayRes) {
            return FrontResponse.error((String)param.getTransactionId(), (String)CLINIC_TYPE_CANCEL, (String)registeredNowDayRes.getMessage());
        }
        if (!CLINIC_TYPE_CANCEL.equals(body.getState())) {
            return FrontResponse.error((String)param.getTransactionId(), (String)CLINIC_TYPE_APPOINT, (String)body.getError());
        }
        DayRegisterRes dayRegisterRes = new DayRegisterRes();
        dayRegisterRes.setNo(dayRegisterReq.getTimeArrangeId());
        dayRegisterRes.setAppointId(dayRegisterReq.getRbasId());
        return FrontResponse.success((String)registeredNowDayRes.getTransactionId(), (Object)dayRegisterRes);
    }
}

