/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.service.impl;

import com.ebaiyihui.framework.utils.IdCardUtil;
import com.ebaiyihui.his.common.enums.EntityKeyEnum;
import com.ebaiyihui.his.common.enums.MethodCodeEnum;
import com.ebaiyihui.his.common.enums.ServiceEnums;
import com.ebaiyihui.his.pojo.dto.CreatePatientInfoReqDTO;
import com.ebaiyihui.his.pojo.dto.CreatePatientInfoResDTO;
import com.ebaiyihui.his.pojo.dto.QueryCardInfoReqDTO;
import com.ebaiyihui.his.pojo.dto.QueryCardInfoResDTO;
import com.ebaiyihui.his.pojo.vo.base.FrontRequest;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import com.ebaiyihui.his.pojo.vo.card.QueryCardInfoReqVO;
import com.ebaiyihui.his.pojo.vo.card.QueryCardInfoResVO;
import com.ebaiyihui.his.pojo.vo.card.RegisteredCardReqVO;
import com.ebaiyihui.his.pojo.vo.card.RegisteredCardResVO;
import com.ebaiyihui.his.service.HisRemoteService;
import com.ebaiyihui.his.service.ICardService;
import com.ebaiyihui.his.utils.IDCardUtil;
import com.ebaiyihui.his.utils.SnowflakeIdWorker;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CardServiceImpl
implements ICardService {
    @Autowired
    private HisRemoteService hisRemoteService;
    @Autowired
    private SnowflakeIdWorker snowflakeIdWorker;

    public FrontResponse<QueryCardInfoResVO> queryCardInfo(FrontRequest<QueryCardInfoReqVO> param) {
        QueryCardInfoResVO queryCardInfoResVO = new QueryCardInfoResVO();
        QueryCardInfoReqDTO cardInfoReqDTO = new QueryCardInfoReqDTO();
        cardInfoReqDTO.setCardNo(((QueryCardInfoReqVO)param.getBody()).getCardNo());
        cardInfoReqDTO.setIdNo(((QueryCardInfoReqVO)param.getBody()).getCredNo());
        cardInfoReqDTO.setPatientName(((QueryCardInfoReqVO)param.getBody()).getName());
        HashMap<String, QueryCardInfoReqDTO> cardInfoMap = new HashMap<String, QueryCardInfoReqDTO>(1);
        cardInfoMap.put(EntityKeyEnum.QUERY_CARD_INFO.getValue(), cardInfoReqDTO);
        FrontResponse queryCardInfoRes = this.hisRemoteService.requestHis(ServiceEnums.QUERY_PATIENT.getDisplay(), param.getTransactionId(), MethodCodeEnum.FIND_PATIENT_INFO.getValue(), cardInfoMap, QueryCardInfoResDTO.class);
        QueryCardInfoResDTO queryCardInfoResDTO = (QueryCardInfoResDTO)queryCardInfoRes.getBody();
        if (null == queryCardInfoResDTO) {
            return FrontResponse.error((String)queryCardInfoRes.getTransactionId(), (String)"0", (String)queryCardInfoRes.getMessage());
        }
        if (!"1".equals(queryCardInfoResDTO.getState())) {
            return FrontResponse.error((String)queryCardInfoRes.getTransactionId(), (String)"0", (String)"\u8c03\u7528\u63a5\u53e3\u5931\u8d25");
        }
        QueryCardInfoResDTO.ItemDTO itemDTO2 = (QueryCardInfoResDTO.ItemDTO)queryCardInfoResDTO.getData().getItem().get(0);
        queryCardInfoResVO.setCredType(((QueryCardInfoReqVO)param.getBody()).getCredType());
        queryCardInfoResVO.setCredNo(((QueryCardInfoReqVO)param.getBody()).getCredNo());
        queryCardInfoResVO.setName(((QueryCardInfoReqVO)param.getBody()).getName());
        queryCardInfoResVO.setCardType(((QueryCardInfoReqVO)param.getBody()).getCardType());
        queryCardInfoResVO.setCardNo(itemDTO2.getPatientId());
        queryCardInfoResVO.setPatientId(itemDTO2.getFileNumber());
        queryCardInfoResVO.setSex(itemDTO2.getSex());
        return FrontResponse.success((String)queryCardInfoRes.getTransactionId(), (Object)queryCardInfoResVO);
    }

    public FrontResponse<RegisteredCardResVO> registerCard(FrontRequest<RegisteredCardReqVO> param) {
        RegisteredCardReqVO registeredCardReqVO = (RegisteredCardReqVO)param.getBody();
        CreatePatientInfoReqDTO createPatientInfoReqDTO = new CreatePatientInfoReqDTO();
        createPatientInfoReqDTO.setAge(Integer.valueOf(IdCardUtil.getAgeByIdCard((String)registeredCardReqVO.getCredNo())));
        createPatientInfoReqDTO.setPatientName(registeredCardReqVO.getName());
        createPatientInfoReqDTO.setSex("M".equals(IdCardUtil.getGenderByIdCard((String)registeredCardReqVO.getCredNo())) ? "\u7537" : "\u5973");
        createPatientInfoReqDTO.setSexCode("M".equals(IdCardUtil.getGenderByIdCard((String)registeredCardReqVO.getCredNo())) ? "1" : "2");
        createPatientInfoReqDTO.setBirthday(IDCardUtil.getBirthDate((String)registeredCardReqVO.getCredNo()));
        createPatientInfoReqDTO.setIdNo(registeredCardReqVO.getCredNo());
        createPatientInfoReqDTO.setPhone(registeredCardReqVO.getTelephone());
        createPatientInfoReqDTO.setAddress(registeredCardReqVO.getAddress());
        HashMap<String, CreatePatientInfoReqDTO> map = new HashMap<String, CreatePatientInfoReqDTO>(1);
        map.put(EntityKeyEnum.CREATE_PATIENT_INFO.getValue(), createPatientInfoReqDTO);
        FrontResponse resDTO = this.hisRemoteService.requestHis(ServiceEnums.ADD_PATIENT.getDisplay(), param.getTransactionId(), MethodCodeEnum.CREATE_PATIENT_FILE.getValue(), map, CreatePatientInfoResDTO.class);
        CreatePatientInfoResDTO createPatientInfoResDTO = (CreatePatientInfoResDTO)resDTO.getBody();
        if (null == createPatientInfoResDTO) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)resDTO.getMessage());
        }
        if (!"1".equals(createPatientInfoResDTO.getState())) {
            return FrontResponse.error((String)resDTO.getTransactionId(), (String)"0", (String)"\u8c03\u7528\u63a5\u53e3\u5931\u8d25");
        }
        RegisteredCardResVO registeredCardResVO = new RegisteredCardResVO();
        String patientId = ((CreatePatientInfoResDTO.ItemDTO)createPatientInfoResDTO.getData().getItem().get(0)).getPatientId();
        registeredCardResVO.setPatientId(patientId);
        registeredCardResVO.setCardNo(patientId);
        registeredCardResVO.setTelephone(registeredCardReqVO.getTelephone());
        registeredCardResVO.setSex(registeredCardReqVO.getSex());
        registeredCardResVO.setCredNo(registeredCardReqVO.getCredNo());
        registeredCardResVO.setCardType(registeredCardReqVO.getCardType());
        registeredCardResVO.setDob(createPatientInfoReqDTO.getBirthday());
        registeredCardResVO.setAddress(registeredCardReqVO.getAddress());
        registeredCardResVO.setName(registeredCardReqVO.getName());
        registeredCardResVO.setCredType(registeredCardReqVO.getCredType());
        registeredCardResVO.setPatientNo(patientId);
        return FrontResponse.success((String)resDTO.getTransactionId(), (Object)registeredCardResVO);
    }
}

