/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.service.impl;

import com.ebaiyihui.his.common.enums.EntityKeyEnum;
import com.ebaiyihui.his.common.enums.MethodCodeEnum;
import com.ebaiyihui.his.pojo.dto.DrugCatalogBodyRepDTO;
import com.ebaiyihui.his.pojo.dto.DrugCatalogRepDTO;
import com.ebaiyihui.his.pojo.dto.DrugStockRepBodyDTO;
import com.ebaiyihui.his.pojo.dto.DrugStockRepDTO;
import com.ebaiyihui.his.pojo.dto.DrugStockResDTO;
import com.ebaiyihui.his.pojo.vo.DrugStockVO;
import com.ebaiyihui.his.pojo.vo.base.FrontRequest;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import com.ebaiyihui.his.service.HisRemoteService;
import com.ebaiyihui.his.service.IDrugService;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="iDrugService")
public class DrugServiceImpl
implements IDrugService {
    @Autowired
    private HisRemoteService hisRemoteService;

    public FrontResponse<DrugStockRepBodyDTO> getDrugStock(FrontRequest<DrugStockVO> stockVOFrontRequest) {
        DrugStockResDTO drugStockResDTO = new DrugStockResDTO();
        drugStockResDTO.setCommonCode(((DrugStockVO)stockVOFrontRequest.getBody()).getCommonCode());
        HashMap<String, DrugStockResDTO> cardInfoMap = new HashMap<String, DrugStockResDTO>(1);
        cardInfoMap.put(EntityKeyEnum.DRUG_STOCK.getValue(), drugStockResDTO);
        FrontResponse queryCardInfoRes = this.hisRemoteService.requestHis("", stockVOFrontRequest.getTransactionId(), MethodCodeEnum.DRUG_STOCK.getValue(), cardInfoMap, DrugStockRepDTO.class);
        DrugStockRepDTO drugStockRepDTO = (DrugStockRepDTO)queryCardInfoRes.getBody();
        if (null == drugStockRepDTO) {
            return FrontResponse.error((String)queryCardInfoRes.getTransactionId(), (String)"0", (String)queryCardInfoRes.getMessage());
        }
        if (!"0".equals(drugStockRepDTO.getResultCode())) {
            return FrontResponse.error((String)queryCardInfoRes.getTransactionId(), (String)"0", (String)drugStockRepDTO.getResultMsg());
        }
        return FrontResponse.success((String)stockVOFrontRequest.getTransactionId(), (Object)drugStockRepDTO.getBodyDTO());
    }

    public FrontResponse<List<DrugCatalogBodyRepDTO>> getDrugCatalog(FrontRequest frontRequest) {
        HashMap<String, Object> cardInfoMap = new HashMap<String, Object>(1);
        cardInfoMap.put(EntityKeyEnum.DRUG_CATALOG.getValue(), null);
        FrontResponse queryCardInfoRes = this.hisRemoteService.requestHis("", frontRequest.getTransactionId(), MethodCodeEnum.DRUG_CATALOG.getValue(), cardInfoMap, DrugCatalogRepDTO.class);
        DrugCatalogRepDTO drugStockRepDTO = (DrugCatalogRepDTO)queryCardInfoRes.getBody();
        if (null == drugStockRepDTO) {
            return FrontResponse.error((String)queryCardInfoRes.getTransactionId(), (String)"0", (String)queryCardInfoRes.getMessage());
        }
        if (!"0".equals(drugStockRepDTO.getResultCode())) {
            return FrontResponse.error((String)queryCardInfoRes.getTransactionId(), (String)"0", (String)drugStockRepDTO.getResultMsg());
        }
        return FrontResponse.success((String)frontRequest.getTransactionId(), (Object)drugStockRepDTO.getDrugCatalogBodyRepDTOS());
    }
}

