/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.service.impl;

import com.ebaiyihui.his.common.enums.EntityKeyEnum;
import com.ebaiyihui.his.common.enums.MethodCodeEnum;
import com.ebaiyihui.his.common.enums.ServiceEnums;
import com.ebaiyihui.his.pojo.dto.AssayReportDetailQueryDetailInfoResDTO;
import com.ebaiyihui.his.pojo.dto.AssayReportDetailQueryItemResDTO;
import com.ebaiyihui.his.pojo.dto.AssayReportDetailQueryReqDTO;
import com.ebaiyihui.his.pojo.dto.AssayReportDetailQueryResDTO;
import com.ebaiyihui.his.pojo.dto.AssayReportQueryItemResDTO;
import com.ebaiyihui.his.pojo.dto.AssayReportQueryReqDTO;
import com.ebaiyihui.his.pojo.dto.AssayReportQueryResDTO;
import com.ebaiyihui.his.pojo.vo.base.FrontRequest;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import com.ebaiyihui.his.pojo.vo.report.GetReportListsReq;
import com.ebaiyihui.his.pojo.vo.report.GetReportListsRes;
import com.ebaiyihui.his.pojo.vo.report.GetReportUrlReq;
import com.ebaiyihui.his.pojo.vo.report.GetReportUrlRes;
import com.ebaiyihui.his.pojo.vo.report.LisReportListReq;
import com.ebaiyihui.his.pojo.vo.report.LisReportListRes;
import com.ebaiyihui.his.pojo.vo.report.PacsReportListReq;
import com.ebaiyihui.his.pojo.vo.report.PacsReportListRes;
import com.ebaiyihui.his.pojo.vo.report.datas.GetReportListsData;
import com.ebaiyihui.his.pojo.vo.report.datas.LisReportListResData;
import com.ebaiyihui.his.service.ElectronicReportService;
import com.ebaiyihui.his.service.HisRemoteService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ElectronicReportServiceImpl
implements ElectronicReportService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final int MAP_SIZE = 1;
    public static final String SUCCESS_FLAG = "0";
    @Autowired
    private HisRemoteService hisRemoteService;

    public FrontResponse<GetReportListsRes> getReportLists(FrontRequest<GetReportListsReq> param) {
        GetReportListsRes getReportListsRes = new GetReportListsRes();
        AssayReportQueryReqDTO reportQueryReqDTO = new AssayReportQueryReqDTO();
        reportQueryReqDTO.setPatientId(((GetReportListsReq)param.getBody()).getPatientId());
        reportQueryReqDTO.setQueryType(String.valueOf(((GetReportListsReq)param.getBody()).getQueryType()));
        reportQueryReqDTO.setBeginTime(((GetReportListsReq)param.getBody()).getBeginTime());
        reportQueryReqDTO.setEndTime(((GetReportListsReq)param.getBody()).getEndTime());
        reportQueryReqDTO.setApplyNo(((GetReportListsReq)param.getBody()).getApplyNo());
        HashMap<String, AssayReportQueryReqDTO> reportQueryReqMap = new HashMap<String, AssayReportQueryReqDTO>(1);
        FrontResponse response = null;
        String reportType = ((GetReportListsReq)param.getBody()).getReportType();
        if ("2".equals(reportType)) {
            reportQueryReqMap.put(EntityKeyEnum.ASSAY_REPORT_QUERY.getValue(), reportQueryReqDTO);
            response = this.hisRemoteService.requestHis(ServiceEnums.QUERY_PACSREPORTINFO.getDisplay(), param.getTransactionId(), MethodCodeEnum.INSPECTION_REPORT_LIST_QUERY.getValue(), reportQueryReqMap, AssayReportQueryResDTO.class);
        } else {
            reportQueryReqMap.put(EntityKeyEnum.ASSAY_REPORT_QUERY.getValue(), reportQueryReqDTO);
            response = this.hisRemoteService.requestHis(ServiceEnums.QUERY_LISREPORTLNFO.getDisplay(), param.getTransactionId(), MethodCodeEnum.ASSAY_REPORT_QUERY.getValue(), reportQueryReqMap, AssayReportQueryResDTO.class);
        }
        if (null == response) {
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u67e5\u8be2\u5931\u8d25");
        }
        if (SUCCESS_FLAG.equals(response.getCode())) {
            return FrontResponse.error((String)response.getTransactionId(), (String)SUCCESS_FLAG, (String)response.getMessage());
        }
        List reportQueryItemResDTOList = ((AssayReportQueryResDTO)response.getBody()).getData().getItem();
        if (CollectionUtils.isEmpty((Collection)reportQueryItemResDTOList)) {
            return FrontResponse.error((String)response.getTransactionId(), (String)SUCCESS_FLAG, (String)response.getMessage());
        }
        ArrayList<GetReportListsData> getReportList = new ArrayList<GetReportListsData>();
        for (AssayReportQueryItemResDTO assayReportQueryItemResDTO : reportQueryItemResDTOList) {
            GetReportListsData getReportListsData = new GetReportListsData();
            BeanUtils.copyProperties((Object)assayReportQueryItemResDTO, (Object)getReportListsData);
            getReportListsData.setReportType(((GetReportListsReq)param.getBody()).getReportType());
            getReportList.add(getReportListsData);
        }
        getReportListsRes.setDatas(getReportList);
        getReportListsRes.setPatientName(((AssayReportQueryItemResDTO)reportQueryItemResDTOList.get(0)).getReportName());
        getReportListsRes.setPatientID(((AssayReportQueryItemResDTO)reportQueryItemResDTOList.get(0)).getPatientId());
        return FrontResponse.success((String)response.getTransactionId(), (Object)getReportListsRes);
    }

    public FrontResponse<LisReportListRes> lisReportList(FrontRequest<LisReportListReq> param) {
        ArrayList<LisReportListResData> lisReportList = new ArrayList<LisReportListResData>();
        LisReportListReq lisReportListReq = (LisReportListReq)param.getBody();
        if (null == lisReportListReq.getReportNo()) {
            this.logger.error("\u67e5\u8be2\u62a5\u544a\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        AssayReportDetailQueryReqDTO assayReportDetailQueryReqDTO = new AssayReportDetailQueryReqDTO();
        assayReportDetailQueryReqDTO.setApplyno(lisReportListReq.getReportNo());
        assayReportDetailQueryReqDTO.setReportDate(lisReportListReq.getReportDate());
        HashMap<String, AssayReportDetailQueryReqDTO> assayReportDetailQueryMap = new HashMap<String, AssayReportDetailQueryReqDTO>(1);
        assayReportDetailQueryMap.put(EntityKeyEnum.ASSAY_REPORT_DETAIL_QUERY.getValue(), assayReportDetailQueryReqDTO);
        FrontResponse assayReportDetailQueryRes = this.hisRemoteService.requestHis(ServiceEnums.query_lisReportDetaillnfo.getDisplay(), param.getTransactionId(), MethodCodeEnum.ASSAY_REPORT_DETAIL_QUERY.getValue(), assayReportDetailQueryMap, AssayReportDetailQueryResDTO.class);
        AssayReportDetailQueryResDTO assayReportDetailQueryResDTO = (AssayReportDetailQueryResDTO)assayReportDetailQueryRes.getBody();
        if (null == assayReportDetailQueryResDTO) {
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)assayReportDetailQueryRes.getMessage());
        }
        if (SUCCESS_FLAG.equals(assayReportDetailQueryResDTO.getState())) {
            return FrontResponse.error((String)assayReportDetailQueryRes.getTransactionId(), (String)SUCCESS_FLAG, (String)assayReportDetailQueryRes.getMessage());
        }
        LisReportListRes lisReportListRes = new LisReportListRes();
        if (assayReportDetailQueryResDTO.getData().getItem().isEmpty()) {
            return FrontResponse.error((String)assayReportDetailQueryRes.getTransactionId(), (String)SUCCESS_FLAG, (String)assayReportDetailQueryRes.getMessage());
        }
        AssayReportDetailQueryItemResDTO detailQueryItemResDTO = (AssayReportDetailQueryItemResDTO)assayReportDetailQueryResDTO.getData().getItem().get(0);
        BeanUtils.copyProperties((Object)detailQueryItemResDTO, (Object)lisReportListRes);
        lisReportListRes.setSex("\u7537\u6027".equals(lisReportListRes.getSex()) ? "1" : "2");
        lisReportListRes.setAge(lisReportListRes.getAge().replaceAll("\\D+", ""));
        List detailItem = detailQueryItemResDTO.getDetailInfo().getDetailItem();
        if (CollectionUtils.isEmpty((Collection)detailItem)) {
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)assayReportDetailQueryRes.getMessage());
        }
        for (AssayReportDetailQueryDetailInfoResDTO assayReportDetailQueryItemResDTO : detailItem) {
            LisReportListResData lisReportListResData = new LisReportListResData();
            BeanUtils.copyProperties((Object)assayReportDetailQueryItemResDTO, (Object)lisReportListResData);
            String hisItmCrises = assayReportDetailQueryItemResDTO.getItmCrises();
            if ("\u2191".equals(hisItmCrises)) {
                lisReportListResData.setItmCrises("\u504f\u9ad8");
            } else if ("\u2193".equals(hisItmCrises)) {
                lisReportListResData.setItmCrises("\u504f\u4f4e");
            } else {
                lisReportListResData.setItmCrises("");
            }
            lisReportList.add(lisReportListResData);
        }
        lisReportListRes.setDatas(lisReportList);
        return FrontResponse.success((String)assayReportDetailQueryRes.getTransactionId(), (Object)lisReportListRes);
    }

    public FrontResponse<GetReportUrlRes> getReportUrl(FrontRequest<GetReportUrlReq> param) {
        return null;
    }

    public FrontResponse<PacsReportListRes> pacsReportList(FrontRequest<PacsReportListReq> param) {
        AssayReportQueryReqDTO reportQueryReqDTO = new AssayReportQueryReqDTO();
        reportQueryReqDTO.setPatientId(((PacsReportListReq)param.getBody()).getPatientId());
        reportQueryReqDTO.setQueryType(String.valueOf(((PacsReportListReq)param.getBody()).getQueryType()));
        reportQueryReqDTO.setReportType("2");
        HashMap<String, AssayReportQueryReqDTO> reportQueryReqMap = new HashMap<String, AssayReportQueryReqDTO>(1);
        reportQueryReqMap.put(EntityKeyEnum.ASSAY_REPORT_QUERY.getValue(), reportQueryReqDTO);
        FrontResponse response = this.hisRemoteService.requestHis(ServiceEnums.QUERY_PACSREPORTINFO.getDisplay(), param.getTransactionId(), MethodCodeEnum.INSPECTION_REPORT_LIST_QUERY.getValue(), reportQueryReqMap, AssayReportQueryResDTO.class);
        if (null == response) {
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u67e5\u8be2\u5931\u8d25");
        }
        if (SUCCESS_FLAG.equals(response.getCode())) {
            return FrontResponse.error((String)response.getTransactionId(), (String)SUCCESS_FLAG, (String)response.getMessage());
        }
        List reportQueryItemResDTOList = ((AssayReportQueryResDTO)response.getBody()).getData().getItem();
        if (CollectionUtils.isEmpty((Collection)reportQueryItemResDTOList)) {
            return FrontResponse.error((String)response.getTransactionId(), (String)SUCCESS_FLAG, (String)response.getMessage());
        }
        List filteredList = reportQueryItemResDTOList.stream().filter(item -> ((PacsReportListReq)param.getBody()).getPatientId().equals(item.getPatientId()) && ((PacsReportListReq)param.getBody()).getReportNo().equals(item.getReportNo())).collect(Collectors.toList());
        if (filteredList.isEmpty()) {
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u67e5\u8be2\u5931\u8d25");
        }
        AssayReportQueryItemResDTO assayReportQueryItemResDTO = (AssayReportQueryItemResDTO)filteredList.get(0);
        PacsReportListRes pacsReportListRes = new PacsReportListRes();
        BeanUtils.copyProperties((Object)assayReportQueryItemResDTO, (Object)pacsReportListRes);
        pacsReportListRes.setAdmType("O");
        return FrontResponse.success((String)response.getTransactionId(), (Object)pacsReportListRes);
    }
}

