/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.service.impl;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import com.ebaiyihui.his.service.HisRemoteService;
import com.ebaiyihui.his.utils.HttpUtils;
import com.ebaiyihui.his.utils.XmlTemplateKit;
import com.ebaiyihui.his.utils.XmlUtil;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class HisRemoteServiceImpl
implements HisRemoteService {
    private static final Logger log = LoggerFactory.getLogger(HisRemoteServiceImpl.class);
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${debug}")
    private Boolean debug;
    @Value(value="${hsyyUrl}")
    private String hsyyUrl;
    @Value(value="${hisNewUrl}")
    private String hisNewUrl;

    public <T> FrontResponse<T> requestHis(String service, String transactionId, String methodStr, Map map, Class<T> clazz) {
        try {
            String requestHisXml = XmlTemplateKit.process((String)methodStr, (Map)map);
            if (StringUtils.isEmpty((CharSequence)requestHisXml)) {
                return FrontResponse.error((String)transactionId, (String)"0", (String)"\u53c2\u6570\u6a21\u677f\u4e0d\u5b58\u5728");
            }
            String responseHisXml = "";
            if (this.debug.booleanValue()) {
                responseHisXml = XmlTemplateKit.processDebug((String)methodStr);
            } else {
                String url = this.hisNewUrl + service;
                this.logger.info("requestHisXml\uff1a" + url);
                this.logger.info("requestHisXml\uff1a" + requestHisXml);
                responseHisXml = HttpUtils.doPost((String)url, (String)requestHisXml);
                this.logger.info("responseHisXml\uff1a" + responseHisXml);
            }
            if (StringUtils.isEmpty((CharSequence)responseHisXml)) {
                return FrontResponse.error((String)transactionId, (String)"0", (String)"his\u54cd\u5e94\u7ed3\u679c\u5931\u8d25");
            }
            Object resHisDTO = XmlUtil.convertToJavaBean((String)responseHisXml.replaceAll(";<", "&lt;"), clazz);
            this.logger.info("JAXB\u6267\u884c\u7ed3\u679c\uff1a" + JSON.toJSONString((Object)resHisDTO));
            if (null == resHisDTO) {
                return FrontResponse.error((String)transactionId, (String)"0", (String)"JAXB\u6267\u884c\u5931\u8d25");
            }
            return FrontResponse.success((String)transactionId, (Object)resHisDTO);
        }
        catch (Exception e) {
            return FrontResponse.error((String)transactionId, (String)"0", (String)"\u6267\u884c\u5f02\u5e38");
        }
    }

    public <T> FrontResponse<T> newRequestHis(String transactionId, String methodStr, Map map, Class<T> clazz) {
        String requestHisXml = XmlTemplateKit.process((String)methodStr, (Map)map);
        if (StringUtils.isEmpty((CharSequence)requestHisXml)) {
            return FrontResponse.error((String)transactionId, (String)"0", (String)"\u53c2\u6570\u6a21\u677f\u4e0d\u5b58\u5728");
        }
        log.info("requestHisXml\u6838\u9178\u6a21\u677f\uff1a" + requestHisXml);
        String responseHisXml = "";
        try {
            responseHisXml = HttpUtils.doPost((String)this.hsyyUrl, (String)requestHisXml);
        }
        catch (Exception e) {
            e.printStackTrace();
            return FrontResponse.error((String)transactionId, (String)"0", (String)"his\u54cd\u5e94\u7ed3\u679c\u5931\u8d25");
        }
        if (StringUtils.isEmpty((CharSequence)responseHisXml)) {
            return FrontResponse.error((String)transactionId, (String)"0", (String)"his\u54cd\u5e94\u7ed3\u679c\u5931\u8d25");
        }
        log.info("requestHisXml\u6838\u9178\u6267\u884c\u7ed3\u679c\uff1a" + responseHisXml);
        responseHisXml = responseHisXml.replace("<?xml version=\"1.0\" encoding=\"UTF-8\"?>", "");
        responseHisXml = responseHisXml.replace("\n", "");
        log.info("xml\u6838\u9178\u5904\u7406\u7ed3\u679c\uff1a" + JSON.toJSONString((Object)responseHisXml));
        Object resHisDTO = XmlUtil.convertToJavaBean((String)responseHisXml, clazz);
        log.info("JAXB\u6838\u9178\u6267\u884c\u7ed3\u679c\uff1a" + JSON.toJSONString((Object)resHisDTO));
        if (null == resHisDTO) {
            return FrontResponse.error((String)transactionId, (String)"0", (String)"JAXB\u6267\u884c\u5931\u8d25");
        }
        return FrontResponse.success((String)transactionId, (Object)resHisDTO);
    }

    static {
        XmlTemplateKit.init();
    }
}

