/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.service.impl;

import com.ebaiyihui.his.common.enums.EntityKeyEnum;
import com.ebaiyihui.his.common.enums.MethodCodeEnum;
import com.ebaiyihui.his.common.enums.PayTypeEnums;
import com.ebaiyihui.his.common.enums.ServiceEnums;
import com.ebaiyihui.his.pojo.dto.GetInHospFeeDetailReqDTO;
import com.ebaiyihui.his.pojo.dto.GetInHospFeeDetailResDTO;
import com.ebaiyihui.his.pojo.dto.GetInHospFeeDetailResItemDTO;
import com.ebaiyihui.his.pojo.dto.GetInpAdmissionResDTO;
import com.ebaiyihui.his.pojo.dto.GetInpAdmissionResItemDTO;
import com.ebaiyihui.his.pojo.dto.GetInpAdmisssionReqDTO;
import com.ebaiyihui.his.pojo.dto.HospDepositRecordsItemResDTO;
import com.ebaiyihui.his.pojo.dto.HospDepositRecordsResDTO;
import com.ebaiyihui.his.pojo.dto.InHospDepositReqDTO;
import com.ebaiyihui.his.pojo.dto.InHospDepositResDTO;
import com.ebaiyihui.his.pojo.vo.appoint.PayHisNoticeReq;
import com.ebaiyihui.his.pojo.vo.base.FrontRequest;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import com.ebaiyihui.his.pojo.vo.hospitalization.DepositReq;
import com.ebaiyihui.his.pojo.vo.hospitalization.DepositRes;
import com.ebaiyihui.his.pojo.vo.hospitalization.GetIPDepositRecordsReq;
import com.ebaiyihui.his.pojo.vo.hospitalization.GetIPDepositRecordsRes;
import com.ebaiyihui.his.pojo.vo.hospitalization.GetInpAdmissionReq;
import com.ebaiyihui.his.pojo.vo.hospitalization.GetInpAdmissionRes;
import com.ebaiyihui.his.pojo.vo.hospitalization.GetOrdItemsReq;
import com.ebaiyihui.his.pojo.vo.hospitalization.GetOrdItemsRes;
import com.ebaiyihui.his.pojo.vo.hospitalization.items.GetIPDepositRecordsItems;
import com.ebaiyihui.his.pojo.vo.hospitalization.items.GetInpAdmissionResItems;
import com.ebaiyihui.his.pojo.vo.hospitalization.items.GetOrdItemsResItems;
import com.ebaiyihui.his.pojo.vo.hospitalization.respmsg.DepositRespmsg;
import com.ebaiyihui.his.service.HisRemoteService;
import com.ebaiyihui.his.service.HospitalizationService;
import com.ebaiyihui.his.service.PayService;
import com.ebaiyihui.his.utils.DateUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class HospitalizationServiceImpl
implements HospitalizationService {
    private static final Logger log = LoggerFactory.getLogger(HospitalizationServiceImpl.class);
    public static final String HIS_OUT_HOSP_STATUS = "1";
    public static final String BYH_OUT_HOSP_STATUS = "D";
    public static final String BYH_IN_HOSP_STATUS = "A";
    public static final int MAP_SIZE = 1;
    public static final String SUCCESS_FLAG = "0";
    private static final String PAY_SUCCESS = "Y";
    private static final String PAY_FAIL = "N";
    private static final String HIS_PAY_SUCCESS = "SUCCESS";
    private static final String HIS_PAY_FAIL = "FAIL";
    @Autowired
    private HisRemoteService hisRemoteService;
    @Autowired
    PayService payService;

    public FrontResponse<GetInpAdmissionRes> getInpAdmission(FrontRequest<GetInpAdmissionReq> param) {
        GetInpAdmissionRes getInpAdmissionRes = new GetInpAdmissionRes();
        GetInpAdmisssionReqDTO getInpAdmisssionReqDTO = new GetInpAdmisssionReqDTO();
        getInpAdmisssionReqDTO.setCardNo(((GetInpAdmissionReq)param.getBody()).getCardNo());
        getInpAdmisssionReqDTO.setInHospNo(((GetInpAdmissionReq)param.getBody()).getInHospNo());
        HashMap<String, GetInpAdmisssionReqDTO> inpAdmissionMap = new HashMap<String, GetInpAdmisssionReqDTO>(1);
        inpAdmissionMap.put(EntityKeyEnum.GET_INP_ADMISSION.getValue(), getInpAdmisssionReqDTO);
        FrontResponse inpAdmissionResDTO = this.hisRemoteService.requestHis(ServiceEnums.QUERY_INHOSPITAL.getDisplay(), param.getTransactionId(), MethodCodeEnum.PATIENT_HOSPITALIZATION_INFO_INQUIRY.getValue(), inpAdmissionMap, GetInpAdmissionResDTO.class);
        if (null == inpAdmissionResDTO) {
            return FrontResponse.error((String)inpAdmissionResDTO.getTransactionId(), (String)SUCCESS_FLAG, (String)inpAdmissionResDTO.getMessage());
        }
        GetInpAdmissionResDTO body = (GetInpAdmissionResDTO)inpAdmissionResDTO.getBody();
        if (null == body || !HIS_OUT_HOSP_STATUS.equals(body.getState()) || null == body.getData()) {
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u8c03\u7528\u63a5\u53e3\u5931\u8d25");
        }
        List getPayRecordsResItemDTOList = body.getData().getItems();
        if (CollectionUtils.isEmpty((Collection)getPayRecordsResItemDTOList)) {
            return FrontResponse.error((String)inpAdmissionResDTO.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u8c03\u7528\u63a5\u53e3\u5931\u8d25");
        }
        ArrayList<GetInpAdmissionResItems> items = new ArrayList<GetInpAdmissionResItems>();
        for (GetInpAdmissionResItemDTO getInpAdmissionResItemDTO : getPayRecordsResItemDTOList) {
            GetInpAdmissionResItems getInpAdmissionResItems = new GetInpAdmissionResItems();
            BeanUtils.copyProperties((Object)getInpAdmissionResItemDTO, (Object)getInpAdmissionResItems);
            items.add(getInpAdmissionResItems);
        }
        getInpAdmissionRes.setItems(items);
        return FrontResponse.success((String)param.getTransactionId(), (Object)getInpAdmissionRes);
    }

    public FrontResponse<DepositRes> deposit(FrontRequest<DepositReq> param) {
        DepositRes depositRes = new DepositRes();
        DepositReq depositReq = (DepositReq)param.getBody();
        DepositRespmsg respmsg = depositReq.getRespmsg();
        InHospDepositReqDTO inHospDepositReqDTO = new InHospDepositReqDTO();
        inHospDepositReqDTO.setInHosNo(depositReq.getInHospNo());
        inHospDepositReqDTO.setOrderId(depositReq.getFlowNo());
        inHospDepositReqDTO.setPayType(PayTypeEnums.getDisplay((String)depositReq.getPayChannel()));
        inHospDepositReqDTO.setPayAmount(respmsg.getAmount());
        inHospDepositReqDTO.setTradDate(respmsg.getAccDate());
        inHospDepositReqDTO.setTradNo(respmsg.getOrderid());
        inHospDepositReqDTO.setTransFlag(HIS_PAY_SUCCESS);
        HashMap<String, InHospDepositReqDTO> depositMap = new HashMap<String, InHospDepositReqDTO>(1);
        depositMap.put(EntityKeyEnum.IN_HOSP_DEPOSIT.getValue(), inHospDepositReqDTO);
        FrontResponse depositResDTO = this.hisRemoteService.requestHis(ServiceEnums.DO_PREPAY.getDisplay(), param.getTransactionId(), MethodCodeEnum.HOSPITAL_RENEWAL_DEPOSIT.getValue(), depositMap, InHospDepositResDTO.class);
        if (null == depositResDTO) {
            return FrontResponse.error((String)depositResDTO.getTransactionId(), (String)SUCCESS_FLAG, (String)depositResDTO.getMessage());
        }
        InHospDepositResDTO body = (InHospDepositResDTO)depositResDTO.getBody();
        if (null == body || !HIS_OUT_HOSP_STATUS.equals(body.getState()) || null == body.getData()) {
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u8c03\u7528\u63a5\u53e3\u5931\u8d25");
        }
        try {
            FrontRequest frontRequest = new FrontRequest();
            PayHisNoticeReq payHisNoticeReq = new PayHisNoticeReq();
            payHisNoticeReq.setOrderId(inHospDepositReqDTO.getTradNo());
            payHisNoticeReq.setDjysj(DateUtil.getCurrentDateStr((String)"yyyy-MM"));
            payHisNoticeReq.setCZFFXM("");
            payHisNoticeReq.setCBRH(depositReq.getInHospNo());
            payHisNoticeReq.setCYNLSH(depositRes.getReceiptId());
            payHisNoticeReq.setSign("");
            frontRequest.setBody((Object)payHisNoticeReq);
            frontRequest.setChannel(param.getChannel());
            frontRequest.setChannelName(param.getChannelName());
            frontRequest.setOrganCode(param.getOrganCode());
            FrontResponse frontResponse = this.payService.payHisNotice(frontRequest);
            if (frontResponse.getCode().equals(SUCCESS_FLAG)) {
                log.info("\u8c03\u7528\u652f\u4ed8\u5e73\u53f0\u901a\u77e5\u63a5\u53e3\u5931\u8d25\u8ba2\u5355\u53f7\u4e3a\uff1a" + payHisNoticeReq.getOrderId());
                return FrontResponse.error((String)"", (String)SUCCESS_FLAG, (String)("\u8c03\u7528\u652f\u4ed8\u5e73\u53f0\u901a\u77e5\u63a5\u53e3\u5931\u8d25\u8ba2\u5355\u53f7\u4e3a\uff1a" + depositReq.getFlowNo()));
            }
            log.info("\u8c03\u7528\u652f\u4ed8\u5e73\u53f0\u901a\u77e5\u63a5\u53e3\u6210\u529f\u8ba2\u5355\u53f7\u4e3a\uff1a" + payHisNoticeReq.getOrderId());
        }
        catch (Exception e) {
            log.info("\u8c03\u7528\u652f\u4ed8\u5e73\u53f0\u901a\u77e5\u63a5\u53e3\u5f02\u5e38\u8ba2\u5355\u53f7\u4e3a\uff1a" + depositReq.getFlowNo());
            return FrontResponse.error((String)"", (String)SUCCESS_FLAG, (String)("\u8c03\u7528\u652f\u4ed8\u5e73\u53f0\u901a\u77e5\u63a5\u53e3\u5f02\u5e38\u8ba2\u5355\u53f7\u4e3a\uff1a" + depositReq.getFlowNo()));
        }
        GetInHospFeeDetailResItemDTO getInHospFeeDetailResItemDTO = (GetInHospFeeDetailResItemDTO)body.getData().getItems().get(0);
        depositRes.setReceiptId(getInHospFeeDetailResItemDTO.getPayDemandNote());
        return FrontResponse.success((String)param.getTransactionId(), (Object)depositRes);
    }

    public FrontResponse<GetIPDepositRecordsRes> getIPDepositRecords(FrontRequest<GetIPDepositRecordsReq> param) {
        ArrayList<GetIPDepositRecordsItems> getIPDepositRecordsItems = new ArrayList<GetIPDepositRecordsItems>();
        HashMap<String, Object> hospDepositRecordsReqMap = new HashMap<String, Object>(1);
        hospDepositRecordsReqMap.put(EntityKeyEnum.GET_IP_DEPOSIT_RECORDS.getValue(), param.getBody());
        FrontResponse hospDepositRecordsRes = this.hisRemoteService.requestHis(ServiceEnums.QUERY_PREPAY.getDisplay(), param.getTransactionId(), MethodCodeEnum.GET_IP_DEPOSIT_RECORDS.getValue(), hospDepositRecordsReqMap, HospDepositRecordsResDTO.class);
        if (null == hospDepositRecordsRes) {
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)hospDepositRecordsRes.getMessage());
        }
        HospDepositRecordsResDTO body = (HospDepositRecordsResDTO)hospDepositRecordsRes.getBody();
        if (null == body || !HIS_OUT_HOSP_STATUS.equals(body.getState()) || null == body.getData()) {
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u8c03\u7528\u63a5\u53e3\u5931\u8d25");
        }
        List hospDepositRecordsItemResDTOS = body.getData().getItems();
        if (CollectionUtils.isEmpty((Collection)hospDepositRecordsItemResDTOS)) {
            return FrontResponse.error((String)hospDepositRecordsRes.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u8c03\u7528\u63a5\u53e3\u5931\u8d25");
        }
        GetIPDepositRecordsRes getIPDepositRecordsRes = new GetIPDepositRecordsRes();
        for (HospDepositRecordsItemResDTO hospDepositRecordsItemResDTO : hospDepositRecordsItemResDTOS) {
            GetIPDepositRecordsItems getIPDepositRecords = new GetIPDepositRecordsItems();
            BeanUtils.copyProperties((Object)hospDepositRecordsItemResDTO, (Object)getIPDepositRecords);
            getIPDepositRecords.setPayStatus(SUCCESS_FLAG);
            getIPDepositRecordsItems.add(getIPDepositRecords);
            getIPDepositRecordsRes.setItems(getIPDepositRecordsItems);
        }
        return FrontResponse.success((String)hospDepositRecordsRes.getTransactionId(), (Object)getIPDepositRecordsRes);
    }

    public FrontResponse<GetOrdItemsRes> getOrdItems(FrontRequest<GetOrdItemsReq> param) {
        GetOrdItemsRes getOrdItemsRes = new GetOrdItemsRes();
        ArrayList<GetOrdItemsResItems> ordItem = new ArrayList<GetOrdItemsResItems>();
        GetInHospFeeDetailReqDTO getInHospFeeDetailReqDTO = new GetInHospFeeDetailReqDTO();
        getInHospFeeDetailReqDTO.setInHosNo(((GetOrdItemsReq)param.getBody()).getInHospNo());
        getInHospFeeDetailReqDTO.setStartDate(((GetOrdItemsReq)param.getBody()).getStartDate());
        getInHospFeeDetailReqDTO.setEndDate(((GetOrdItemsReq)param.getBody()).getEndDate());
        HashMap<String, GetInHospFeeDetailReqDTO> inHospFeeDetailMap = new HashMap<String, GetInHospFeeDetailReqDTO>(1);
        inHospFeeDetailMap.put(EntityKeyEnum.IN_HOSP_FEE_DETAIL.getValue(), getInHospFeeDetailReqDTO);
        FrontResponse inHospFeeDetailResDTOResponse = this.hisRemoteService.requestHis(ServiceEnums.QUERY_DAILYCOST.getDisplay(), param.getTransactionId(), MethodCodeEnum.HOSPITALIZATION_LIST_INQUIRY.getValue(), inHospFeeDetailMap, GetInHospFeeDetailResDTO.class);
        if (null == inHospFeeDetailResDTOResponse) {
            return FrontResponse.error((String)inHospFeeDetailResDTOResponse.getTransactionId(), (String)SUCCESS_FLAG, (String)inHospFeeDetailResDTOResponse.getMessage());
        }
        GetInHospFeeDetailResDTO body = (GetInHospFeeDetailResDTO)inHospFeeDetailResDTOResponse.getBody();
        if (null == body || !HIS_OUT_HOSP_STATUS.equals(body.getState()) || null == body.getData()) {
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u8c03\u7528\u63a5\u53e3\u5931\u8d25");
        }
        List hospDepositRecordsItemResDTOS = body.getData().getItems();
        if (CollectionUtils.isEmpty((Collection)hospDepositRecordsItemResDTOS)) {
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u8c03\u7528\u63a5\u53e3\u5931\u8d25");
        }
        for (GetInHospFeeDetailResItemDTO getInHospFeeDetailResItemDTO : hospDepositRecordsItemResDTOS) {
            GetOrdItemsResItems getOrdItemsResItems = new GetOrdItemsResItems();
            BeanUtils.copyProperties((Object)getInHospFeeDetailResItemDTO, (Object)getOrdItemsResItems);
            getOrdItemsResItems.setFeeType(getInHospFeeDetailResItemDTO.getFeeType());
            getOrdItemsResItems.setFeeDate(((GetOrdItemsReq)param.getBody()).getStartDate());
            ordItem.add(getOrdItemsResItems);
        }
        getOrdItemsRes.setOrdItem(ordItem);
        return FrontResponse.success((String)param.getTransactionId(), (Object)getOrdItemsRes);
    }
}

