/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.service.impl;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.framework.utils.UUIDUtils;
import com.ebaiyihui.his.helper.InvoiceRequestHelper;
import com.ebaiyihui.his.pojo.dto.InvoiceOperationResponseDTO;
import com.ebaiyihui.his.pojo.dto.InvoiceWriteOffResponseDTO;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import com.ebaiyihui.his.pojo.vo.invoice.InvoiceRequestBodyVO;
import com.ebaiyihui.his.pojo.vo.invoice.InvoiceRequestListDetailVO;
import com.ebaiyihui.his.service.IInvoiceService;
import com.ebaiyihui.his.utils.DateUtil;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service(value="iInvoiceService")
public class InvoiceServiceImpl
implements IInvoiceService {
    private static final Logger log = LoggerFactory.getLogger(InvoiceServiceImpl.class);

    public FrontResponse<InvoiceOperationResponseDTO> createInvoice(InvoiceRequestBodyVO invoiceRequestBodyVO) {
        log.info("\u5f00\u59cb\u8bf7\u6c42\u5f00\u5177\u53d1\u7968\u63a5\u53e3\uff0c\u53c2\u6570\u4e3a{}", (Object)JSON.toJSONString((Object)invoiceRequestBodyVO));
        if (Objects.isNull(invoiceRequestBodyVO)) {
            return FrontResponse.error((String)"", (String)"500", (String)"\u8f93\u5165\u53c2\u6570\u4e3a\u7a7a");
        }
        List listDetail = invoiceRequestBodyVO.getListDetail();
        for (InvoiceRequestListDetailVO invoiceRequestListDetailVO : listDetail) {
            invoiceRequestListDetailVO.setPayDate(DateUtil.dateToJavaDateString((String)invoiceRequestBodyVO.getBusDateTime(), (String)"yyyyMMdd", (String)"yyyy-MM-dd HH:mm:ss"));
        }
        invoiceRequestBodyVO.setListDetail(listDetail);
        invoiceRequestBodyVO.setBusDateTime(DateUtil.dateToJavaDateString((String)invoiceRequestBodyVO.getBusDateTime(), (String)"yyyyMMddHHmmssSSS", (String)"yyyy-MM-dd HH:mm:ss"));
        invoiceRequestBodyVO.setConsultationDate(DateUtil.dateToJavaDateString((String)invoiceRequestBodyVO.getConsultationDate(), (String)"yyyyMMdd", (String)"yyyy-MM-dd HH:mm:ss"));
        log.info("\u6574\u7406\u540e\u7684\u53c2\u6570\u4e3a{}", (Object)JSON.toJSONString((Object)invoiceRequestBodyVO));
        InvoiceOperationResponseDTO invoiceOperationResponseDTO = InvoiceRequestHelper.createInvoice((InvoiceRequestBodyVO)invoiceRequestBodyVO);
        return FrontResponse.success((String)UUIDUtils.getUUID(), (Object)invoiceOperationResponseDTO);
    }

    public FrontResponse<InvoiceOperationResponseDTO> writeOffInvoice(InvoiceRequestBodyVO invoiceRequestBodyVO) {
        log.info("\u5f00\u59cb\u8bf7\u6c42\u51b2\u7ea2\u53d1\u7968\u63a5\u53e3\uff0c\u53c2\u6570\u4e3a{}", (Object)JSON.toJSONString((Object)invoiceRequestBodyVO));
        if (Objects.isNull(invoiceRequestBodyVO)) {
            return FrontResponse.error((String)"", (String)"500", (String)"\u8f93\u5165\u53c2\u6570\u4e3a\u7a7a");
        }
        InvoiceWriteOffResponseDTO invoice = InvoiceRequestHelper.overWriteInvoice((String)invoiceRequestBodyVO.getPatientId(), (String)invoiceRequestBodyVO.getBusNo());
        InvoiceOperationResponseDTO responseDTO = new InvoiceOperationResponseDTO();
        BeanUtils.copyProperties((Object)invoice, (Object)responseDTO);
        responseDTO.setBillBatchCode(invoice.getEScarletBillBatchCode());
        responseDTO.setBillNo(invoice.getEScarletBillNo());
        responseDTO.setRandom(invoice.getEScarletRandom());
        return FrontResponse.success((String)UUIDUtils.getUUID(), (Object)responseDTO);
    }
}

