/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.service.impl;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.his.pojo.vo.appoint.PayHisNoticeReq;
import com.ebaiyihui.his.pojo.vo.base.FrontRequest;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import com.ebaiyihui.his.pojo.vo.nucleicacid.PayAppointmentReq;
import com.ebaiyihui.his.pojo.vo.nucleicacid.PayAppointmentRes;
import com.ebaiyihui.his.pojo.vo.nucleicacid.PayAppointmentResRowData;
import com.ebaiyihui.his.pojo.vo.nucleicacid.QueryAppointmentReq;
import com.ebaiyihui.his.pojo.vo.nucleicacid.QueryAppointmentRes;
import com.ebaiyihui.his.pojo.vo.nucleicacid.QueryPackageInfoReq;
import com.ebaiyihui.his.pojo.vo.nucleicacid.QueryPackageInfoRes;
import com.ebaiyihui.his.pojo.vo.nucleicacid.QueryPackageInfoResData;
import com.ebaiyihui.his.pojo.vo.nucleicacid.QueryPackageReq;
import com.ebaiyihui.his.pojo.vo.nucleicacid.QueryPackageRes;
import com.ebaiyihui.his.pojo.vo.nucleicacid.QueryPackageResData;
import com.ebaiyihui.his.pojo.vo.nucleicacid.QueryPackageResRowData;
import com.ebaiyihui.his.pojo.vo.nucleicacid.QueryResultReq;
import com.ebaiyihui.his.pojo.vo.nucleicacid.QueryResultRes;
import com.ebaiyihui.his.service.HisRemoteService;
import com.ebaiyihui.his.service.NucleicAcidService;
import com.ebaiyihui.his.service.PayService;
import com.ebaiyihui.his.utils.DateUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class NucleicAcidServiceImpl
implements NucleicAcidService {
    private static final Logger log = LoggerFactory.getLogger(NucleicAcidServiceImpl.class);
    @Autowired
    HisRemoteService hisRemoteService;
    @Autowired
    PayService payService;

    public FrontResponse<QueryPackageRes> queryPackage(FrontRequest<QueryPackageReq> queryPackageReq) {
        QueryPackageReq param = (QueryPackageReq)queryPackageReq.getBody();
        param.setServiceId("query_yytcxx");
        param.setHospitalId("37");
        param.setSerial(DateUtil.getCurrentDateTimeString());
        param.setOrpId("06258");
        HashMap<String, QueryPackageReq> map = new HashMap<String, QueryPackageReq>();
        map.put("query", param);
        FrontResponse response = this.hisRemoteService.newRequestHis(queryPackageReq.getTransactionId(), "8001", map, QueryPackageRes.class);
        if (Objects.isNull(response)) {
            return FrontResponse.error((String)queryPackageReq.getTransactionId(), (String)"0", (String)"\u67e5\u8be2\u6838\u9178\u5957\u9910his\u54cd\u5e94\u7ed3\u679c\u5931\u8d25");
        }
        if (!Objects.equals(response.getCode(), "1")) {
            return FrontResponse.error((String)queryPackageReq.getTransactionId(), (String)"0", (String)"\u67e5\u8be2\u6838\u9178\u5957\u9910\u5931\u8d25");
        }
        QueryPackageRes responseBody = (QueryPackageRes)response.getBody();
        if (Objects.isNull(responseBody)) {
            return FrontResponse.error((String)queryPackageReq.getTransactionId(), (String)"0", (String)"\u67e5\u8be2\u6838\u9178\u5957\u9910\u4e3a\u7a7a");
        }
        QueryPackageResData rows = responseBody.getRows();
        if (Objects.isNull(rows)) {
            return FrontResponse.error((String)queryPackageReq.getTransactionId(), (String)"0", (String)"\u67e5\u8be2\u6838\u9178\u5957\u9910rows\u4e3a\u7a7a");
        }
        List rowData = rows.getRowData();
        if (Objects.isNull(rows) && rowData.isEmpty()) {
            return FrontResponse.error((String)queryPackageReq.getTransactionId(), (String)"0", (String)"\u67e5\u8be2\u6838\u9178\u5957\u9910rowData\u4e3a\u7a7a");
        }
        for (QueryPackageResRowData rowDatum : rowData) {
            List row;
            QueryPackageInfoResData newRow;
            String cbm = rowDatum.getCbm();
            QueryPackageInfoRes queryPackageInfoRes = this.queryPackageInfoNew(cbm, queryPackageReq.getTransactionId());
            log.info("queryPackageInfoRes\uff1a" + JSON.toJSONString((Object)queryPackageInfoRes));
            if (Objects.isNull(queryPackageInfoRes) || Objects.isNull(newRow = queryPackageInfoRes.getRows()) || Objects.isNull(row = newRow.getRow()) || row.isEmpty()) continue;
            rowDatum.setRowInfo(queryPackageInfoRes.getRows().getRow());
        }
        return FrontResponse.success((String)queryPackageReq.getTransactionId(), (Object)response.getBody());
    }

    public QueryPackageInfoRes queryPackageInfoNew(String cbm, String transactionId) {
        QueryPackageInfoReq param = new QueryPackageInfoReq();
        param.setCbm(cbm);
        param.setServiceId("query_hsxmxx");
        param.setHospitalId("37");
        param.setSerial(DateUtil.getCurrentDateTimeString());
        param.setOrpId("06292");
        HashMap<String, QueryPackageInfoReq> map = new HashMap<String, QueryPackageInfoReq>();
        map.put("query", param);
        FrontResponse response = this.hisRemoteService.newRequestHis(transactionId, "8002", map, QueryPackageInfoRes.class);
        QueryPackageInfoRes queryPackageInfoRes = null;
        if (Objects.isNull(response)) {
            return queryPackageInfoRes;
        }
        if (!Objects.equals(response.getCode(), "1")) {
            return queryPackageInfoRes;
        }
        if (Objects.isNull(response.getBody())) {
            return queryPackageInfoRes;
        }
        queryPackageInfoRes = (QueryPackageInfoRes)response.getBody();
        return queryPackageInfoRes;
    }

    public FrontResponse<QueryPackageInfoRes> queryPackageInfo(FrontRequest<QueryPackageInfoReq> queryPackageInfoReq) {
        QueryPackageInfoReq param = (QueryPackageInfoReq)queryPackageInfoReq.getBody();
        param.setServiceId("query_hsxmxx");
        param.setHospitalId("37");
        param.setSerial(DateUtil.getCurrentDateTimeString());
        param.setOrpId("06292");
        HashMap<String, QueryPackageInfoReq> map = new HashMap<String, QueryPackageInfoReq>();
        map.put("query", param);
        FrontResponse response = this.hisRemoteService.newRequestHis(queryPackageInfoReq.getTransactionId(), "8002", map, QueryPackageInfoRes.class);
        return response;
    }

    public FrontResponse<QueryAppointmentRes> queryAppointment(FrontRequest<QueryAppointmentReq> queryAppointmentReq) {
        QueryAppointmentReq param = (QueryAppointmentReq)queryAppointmentReq.getBody();
        param.setServiceId("query_hsjl");
        param.setHospitalId("37");
        param.setSerial(DateUtil.getCurrentDateTimeString());
        param.setOrpId("06292");
        HashMap<String, QueryAppointmentReq> map = new HashMap<String, QueryAppointmentReq>();
        map.put("query", param);
        FrontResponse response = this.hisRemoteService.newRequestHis(queryAppointmentReq.getTransactionId(), "8003", map, QueryAppointmentRes.class);
        return response;
    }

    public FrontResponse<QueryResultRes> queryResult(FrontRequest<QueryResultReq> queryResultReq) {
        QueryResultReq param = (QueryResultReq)queryResultReq.getBody();
        param.setServiceId("query_hsbg");
        param.setHospitalId("37");
        param.setSerial(DateUtil.getCurrentDateTimeString());
        param.setOrpId("06292");
        HashMap<String, QueryResultReq> map = new HashMap<String, QueryResultReq>();
        map.put("query", param);
        FrontResponse response = this.hisRemoteService.newRequestHis(queryResultReq.getTransactionId(), "8004", map, QueryResultRes.class);
        return response;
    }

    public FrontResponse<PayAppointmentRes> payAppointment(FrontRequest<PayAppointmentReq> payAppointmentReq) {
        PayAppointmentReq param = (PayAppointmentReq)payAppointmentReq.getBody();
        param.setServiceId("do_hszf");
        param.setHospitalId("37");
        param.setSerial(DateUtil.getCurrentDateTimeString());
        param.setOrpId("06292");
        HashMap<String, PayAppointmentReq> map = new HashMap<String, PayAppointmentReq>();
        map.put("query", param);
        FrontResponse response = this.hisRemoteService.newRequestHis(payAppointmentReq.getTransactionId(), "8005", map, PayAppointmentRes.class);
        if (response.getCode().equals("0")) {
            return response;
        }
        try {
            String csfd = ((PayAppointmentResRowData)((PayAppointmentRes)response.getBody()).getRows().getRow().get(0)).getCsfd();
            String brh = ((PayAppointmentResRowData)((PayAppointmentRes)response.getBody()).getRows().getRow().get(0)).getCbrh();
            FrontRequest frontRequest = new FrontRequest();
            PayHisNoticeReq payHisNoticeReq = new PayHisNoticeReq();
            payHisNoticeReq.setOrderId(param.getCddh());
            payHisNoticeReq.setDjysj(DateUtil.getCurrentDateStr((String)"yyyy-MM"));
            payHisNoticeReq.setCZFFXM(param.getCbrxm());
            payHisNoticeReq.setCBRH(brh);
            payHisNoticeReq.setCYNLSH(csfd);
            payHisNoticeReq.setSign("");
            frontRequest.setBody((Object)payHisNoticeReq);
            log.info("\u8c03\u7528\u652f\u4ed8\u5e73\u53f0\u901a\u77e5\u63a5\u53e3\u5165\u53c2\uff1a" + JSON.toJSONString((Object)payHisNoticeReq));
            FrontResponse frontResponse = this.payService.payHisNotice(frontRequest);
            if (frontResponse.getCode().equals("0")) {
                log.info("\u8c03\u7528\u652f\u4ed8\u5e73\u53f0\u901a\u77e5\u63a5\u53e3\u5931\u8d25\u8ba2\u5355\u53f7\u4e3a\uff1a" + payHisNoticeReq.getOrderId());
            } else {
                log.info("\u8c03\u7528\u652f\u4ed8\u5e73\u53f0\u901a\u77e5\u63a5\u53e3\u6210\u529f\u8ba2\u5355\u53f7\u4e3a\uff1a" + payHisNoticeReq.getOrderId());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u8c03\u7528\u652f\u4ed8\u5e73\u53f0\u901a\u77e5\u63a5\u53e3\u5f02\u5e38\u8ba2\u5355\u53f7\u4e3a\uff1a" + param.getCddh());
        }
        return response;
    }
}

