/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.service.impl;

import com.ebaiyihui.framework.response.IError;
import com.ebaiyihui.his.common.enums.MethodCodeEnum;
import com.ebaiyihui.his.common.enums.RouteEnum;
import com.ebaiyihui.his.pojo.vo.GetMedicalRecordResVO;
import com.ebaiyihui.his.pojo.vo.GetReferralAdmissionReqVO;
import com.ebaiyihui.his.pojo.vo.GetReferralSummaryResVO;
import com.ebaiyihui.his.pojo.vo.MedicalRecordItemsResVO;
import com.ebaiyihui.his.pojo.vo.ReferralAdmissionItemResVO;
import com.ebaiyihui.his.pojo.vo.ReferralAdmissionResVO;
import com.ebaiyihui.his.pojo.vo.base.FrontRequest;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import com.ebaiyihui.his.service.HisRemoteService;
import com.ebaiyihui.his.service.OnlineReferralService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class OnlineReferralServiceImpl
implements OnlineReferralService {
    private static final Logger log = LoggerFactory.getLogger(OnlineReferralServiceImpl.class);
    @Autowired
    private HisRemoteService hisRemoteService;

    public FrontResponse<List<GetReferralSummaryResVO>> getReferralSummary(FrontRequest<GetReferralAdmissionReqVO> param) {
        ArrayList<GetReferralSummaryResVO> resultList = new ArrayList<GetReferralSummaryResVO>();
        GetReferralAdmissionReqVO paramBody = (GetReferralAdmissionReqVO)param.getBody();
        HashMap<String, GetReferralAdmissionReqVO> refMap = new HashMap<String, GetReferralAdmissionReqVO>(1);
        refMap.put(RouteEnum.GET_ADMISSION.getValue(), paramBody);
        FrontResponse response = this.hisRemoteService.requestHis("", param.getTransactionId(), MethodCodeEnum.MEDICAL_INFORMATION.getValue(), refMap, ReferralAdmissionResVO.class);
        if (null == response) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u8c03\u7528his\u63a5\u53e3\u5f02\u5e38");
        }
        if (!"1".equals(response.getCode())) {
            return FrontResponse.success((String)param.getTransactionId(), new ArrayList());
        }
        ReferralAdmissionResVO admissionResVO = (ReferralAdmissionResVO)response.getBody();
        if (!"0".equals(admissionResVO.getResultCode())) {
            return FrontResponse.error((String)param.getTransactionId(), (String)IError.DATA_ERROR.getErrCode(), (String)admissionResVO.getResultMsg());
        }
        List referralAdmissionResVOItem = admissionResVO.getItem();
        if (CollectionUtils.isEmpty((Collection)referralAdmissionResVOItem)) {
            return FrontResponse.success((String)param.getTransactionId(), new ArrayList());
        }
        if (CollectionUtils.isEmpty((Collection)referralAdmissionResVOItem)) {
            return FrontResponse.success((String)param.getTransactionId(), new ArrayList());
        }
        for (ReferralAdmissionItemResVO referralAdmissionItemResVO : referralAdmissionResVOItem) {
            List medicalRecordItems;
            GetMedicalRecordResVO medicalRecordResBody;
            paramBody.setClinicNo(referralAdmissionItemResVO.getClinicNo());
            HashMap<String, GetReferralAdmissionReqVO> medMap = new HashMap<String, GetReferralAdmissionReqVO>(1);
            medMap.put(RouteEnum.GET_MEDICAL_RECORD.getValue(), paramBody);
            FrontResponse getMedicalRecordRes = this.hisRemoteService.requestHis("", param.getTransactionId(), MethodCodeEnum.PATIENT_RECORD.getValue(), medMap, GetMedicalRecordResVO.class);
            if (null == getMedicalRecordRes || null == (medicalRecordResBody = (GetMedicalRecordResVO)getMedicalRecordRes.getBody()) || !"0".equals(medicalRecordResBody.getResultCode()) || CollectionUtils.isEmpty((Collection)(medicalRecordItems = medicalRecordResBody.getItems())) || StringUtils.isBlank((CharSequence)((MedicalRecordItemsResVO)medicalRecordItems.get(0)).getPrimaryDiagno())) continue;
            GetReferralSummaryResVO getReferralSummaryResVO = new GetReferralSummaryResVO();
            getReferralSummaryResVO.setCardNo(paramBody.getCardNo());
            getReferralSummaryResVO.setClinicNO(referralAdmissionItemResVO.getClinicNo());
            getReferralSummaryResVO.setDoctCode(referralAdmissionItemResVO.getDoctorCode());
            getReferralSummaryResVO.setDoctName(referralAdmissionItemResVO.getDoctorName());
            getReferralSummaryResVO.setPatientId(referralAdmissionItemResVO.getPatientId());
            getReferralSummaryResVO.setName(referralAdmissionItemResVO.getPatientName());
            getReferralSummaryResVO.setSex(medicalRecordResBody.getSex());
            getReferralSummaryResVO.setAge(medicalRecordResBody.getAge());
            getReferralSummaryResVO.setDeptCode(referralAdmissionItemResVO.getDeptCode());
            getReferralSummaryResVO.setDeptName(referralAdmissionItemResVO.getDeptName());
            getReferralSummaryResVO.setAdmDate(referralAdmissionItemResVO.getAdmDate());
            getReferralSummaryResVO.setDiagnose(((MedicalRecordItemsResVO)medicalRecordItems.get(0)).getPrimaryDiagno());
            getReferralSummaryResVO.setMainSuit(((MedicalRecordItemsResVO)medicalRecordItems.get(0)).getMainSuit());
            getReferralSummaryResVO.setPastHistory(((MedicalRecordItemsResVO)medicalRecordItems.get(0)).getPastHistory());
            getReferralSummaryResVO.setAdvice(((MedicalRecordItemsResVO)medicalRecordItems.get(0)).getTreatAdvice());
            resultList.add(getReferralSummaryResVO);
        }
        return FrontResponse.success((String)param.getTransactionId(), resultList);
    }

    public FrontResponse<List<GetReferralSummaryResVO>> getRegisterRecord(FrontRequest<GetReferralAdmissionReqVO> param) {
        ArrayList<GetReferralSummaryResVO> list = new ArrayList<GetReferralSummaryResVO>();
        GetReferralAdmissionReqVO paramBody = (GetReferralAdmissionReqVO)param.getBody();
        HashMap<String, GetReferralAdmissionReqVO> refMap = new HashMap<String, GetReferralAdmissionReqVO>(1);
        refMap.put(RouteEnum.GET_ADMISSION.getValue(), paramBody);
        FrontResponse response = this.hisRemoteService.requestHis("", param.getTransactionId(), MethodCodeEnum.MEDICAL_INFORMATION.getValue(), refMap, ReferralAdmissionResVO.class);
        if (response == null || !"1".equals(response.getCode()) || !"0".equals(((ReferralAdmissionResVO)response.getBody()).getResultCode())) {
            return FrontResponse.success((String)param.getTransactionId(), new ArrayList());
        }
        List referralAdmissionItemResVOS = ((ReferralAdmissionResVO)response.getBody()).getItem();
        if (CollectionUtils.isEmpty((Collection)referralAdmissionItemResVOS)) {
            return FrontResponse.success((String)param.getTransactionId(), new ArrayList());
        }
        HashMap<String, GetReferralAdmissionReqVO> medMap = new HashMap<String, GetReferralAdmissionReqVO>(1);
        medMap.put(RouteEnum.GET_MEDICAL_RECORD.getValue(), paramBody);
        FrontResponse response1 = this.hisRemoteService.requestHis("", param.getTransactionId(), MethodCodeEnum.PATIENT_RECORD.getValue(), medMap, GetMedicalRecordResVO.class);
        if (response1 == null || !"1".equals(response1.getCode()) || !"0".equals(((GetMedicalRecordResVO)response1.getBody()).getResultCode())) {
            return FrontResponse.success((String)param.getTransactionId(), new ArrayList());
        }
        List medicalRecordItemsResVOS = ((GetMedicalRecordResVO)response1.getBody()).getItems();
        if (CollectionUtils.isEmpty((Collection)medicalRecordItemsResVOS)) {
            return FrontResponse.success((String)param.getTransactionId(), new ArrayList());
        }
        for (ReferralAdmissionItemResVO referralAdmissionItemResVO : referralAdmissionItemResVOS) {
            for (MedicalRecordItemsResVO medicalRecordItemsResVO : medicalRecordItemsResVOS) {
                if (!referralAdmissionItemResVO.getClinicNo().equals(medicalRecordItemsResVO.getClinicNo()) || !StringUtils.isNotEmpty((CharSequence)medicalRecordItemsResVO.getPrimaryDiagno())) continue;
                GetReferralSummaryResVO getReferralSummaryResVO = new GetReferralSummaryResVO();
                getReferralSummaryResVO.setCardNo(referralAdmissionItemResVO.getCardNo());
                getReferralSummaryResVO.setClinicNO(referralAdmissionItemResVO.getClinicNo());
                getReferralSummaryResVO.setDoctCode(referralAdmissionItemResVO.getDoctorCode());
                getReferralSummaryResVO.setDoctName(referralAdmissionItemResVO.getDoctorName());
                getReferralSummaryResVO.setPatientId(referralAdmissionItemResVO.getPatientId());
                getReferralSummaryResVO.setName(referralAdmissionItemResVO.getPatientName());
                getReferralSummaryResVO.setSex(((GetMedicalRecordResVO)response1.getBody()).getSex());
                getReferralSummaryResVO.setAge(((GetMedicalRecordResVO)response1.getBody()).getAge());
                getReferralSummaryResVO.setDeptCode(referralAdmissionItemResVO.getDeptCode());
                getReferralSummaryResVO.setDeptName(referralAdmissionItemResVO.getDeptName());
                getReferralSummaryResVO.setAdmDate(referralAdmissionItemResVO.getAdmDate());
                getReferralSummaryResVO.setDiagnose(medicalRecordItemsResVO.getPrimaryDiagno());
                getReferralSummaryResVO.setMainSuit(medicalRecordItemsResVO.getMainSuit());
                getReferralSummaryResVO.setPastHistory(medicalRecordItemsResVO.getPastHistory());
                getReferralSummaryResVO.setAdvice(medicalRecordItemsResVO.getTreatAdvice());
                list.add(getReferralSummaryResVO);
            }
        }
        return FrontResponse.success((String)param.getTransactionId(), list);
    }
}

