/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.service.impl;

import com.ebaiyihui.his.common.enums.EntityKeyEnum;
import com.ebaiyihui.his.common.enums.MethodCodeEnum;
import com.ebaiyihui.his.common.enums.PayTypeEnums;
import com.ebaiyihui.his.common.enums.ServiceEnums;
import com.ebaiyihui.his.pojo.dto.GetOutPatientAdmResDTO;
import com.ebaiyihui.his.pojo.dto.GetOutPatientAdmResItemDTO;
import com.ebaiyihui.his.pojo.dto.GetPayRecordsReqDTO;
import com.ebaiyihui.his.pojo.dto.GetPayRecordsResDTO;
import com.ebaiyihui.his.pojo.dto.GetPayRecordsResItemDTO;
import com.ebaiyihui.his.pojo.dto.GetPayRecordsResItemDetailDTO;
import com.ebaiyihui.his.pojo.dto.OutpatientComfirePayReqDTO;
import com.ebaiyihui.his.pojo.dto.OutpatientComfirePayResDTO;
import com.ebaiyihui.his.pojo.vo.appoint.PayHisNoticeReq;
import com.ebaiyihui.his.pojo.vo.base.FrontRequest;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import com.ebaiyihui.his.pojo.vo.outpatient.ComfirmPayNewReq;
import com.ebaiyihui.his.pojo.vo.outpatient.ComfirmPayNewRes;
import com.ebaiyihui.his.pojo.vo.outpatient.GetAdmissionReq;
import com.ebaiyihui.his.pojo.vo.outpatient.GetAdmissionRes;
import com.ebaiyihui.his.pojo.vo.outpatient.GetPayRecordsReq;
import com.ebaiyihui.his.pojo.vo.outpatient.GetPayRecordsRes;
import com.ebaiyihui.his.pojo.vo.outpatient.PayItemReq;
import com.ebaiyihui.his.pojo.vo.outpatient.PayItemRes;
import com.ebaiyihui.his.pojo.vo.outpatient.datas.PayItemResDatas;
import com.ebaiyihui.his.pojo.vo.outpatient.items.GetAdmissionItems;
import com.ebaiyihui.his.pojo.vo.outpatient.items.GetPayRecordsResDetails;
import com.ebaiyihui.his.pojo.vo.outpatient.items.GetPayRecordsResItems;
import com.ebaiyihui.his.pojo.vo.outpatient.items.PayItemResItems;
import com.ebaiyihui.his.pojo.vo.outpatient.respmsg.ComfirmPayNewReqMsg;
import com.ebaiyihui.his.service.HisRemoteService;
import com.ebaiyihui.his.service.OutpatientPaymentService;
import com.ebaiyihui.his.service.PayService;
import com.ebaiyihui.his.utils.DateUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class OutpatientPaymentServiceImpl
implements OutpatientPaymentService {
    private static final Logger log = LoggerFactory.getLogger(OutpatientPaymentServiceImpl.class);
    private static final String PAY_SUCCESS = "Y";
    private static final String PAY_FAIL = "N";
    private static final String HIS_PAY_SUCCESS = "SUCCESS";
    private static final String HIS_PAY_FAIL = "FAIL";
    @Autowired
    private HisRemoteService hisRemoteService;
    @Autowired
    PayService payService;

    public FrontResponse<GetAdmissionRes> getAdmission(FrontRequest<GetAdmissionReq> param) {
        GetAdmissionRes getAdmissionRes = new GetAdmissionRes();
        HashMap<String, Object> admMap = new HashMap<String, Object>(1);
        admMap.put(EntityKeyEnum.Get_ADMSSION_INFO.getValue(), param.getBody());
        FrontResponse admRes = this.hisRemoteService.requestHis(ServiceEnums.QUERY_WAITPAYFEES.getDisplay(), param.getTransactionId(), MethodCodeEnum.GET_MEDICAL_RECORDS.getValue(), admMap, GetOutPatientAdmResDTO.class);
        if (null == admRes) {
            return FrontResponse.error((String)admRes.getTransactionId(), (String)"0", (String)admRes.getMessage());
        }
        GetOutPatientAdmResDTO body = (GetOutPatientAdmResDTO)admRes.getBody();
        if (null == body || !"1".equals(body.getState()) || null == body.getData()) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u8c03\u7528\u63a5\u53e3\u5931\u8d25");
        }
        List getOutPatientAdmResItemDTOList = body.getData().getItems();
        if (CollectionUtils.isEmpty((Collection)getOutPatientAdmResItemDTOList)) {
            return FrontResponse.error((String)admRes.getTransactionId(), (String)"0", (String)"\u8c03\u7528\u63a5\u53e3\u5931\u8d25");
        }
        ArrayList<GetAdmissionItems> admissionItemsList = new ArrayList<GetAdmissionItems>();
        for (GetOutPatientAdmResItemDTO getOutPatientAdmResItemDTO : getOutPatientAdmResItemDTOList) {
            if (getOutPatientAdmResItemDTO.getCostType().equals("9")) continue;
            GetAdmissionItems getAdmissionItems = new GetAdmissionItems();
            getAdmissionItems.setAdmDate(getOutPatientAdmResItemDTO.getBillingTime());
            getAdmissionItems.setAdmId(getOutPatientAdmResItemDTO.getReceiptsCode());
            getAdmissionItems.setDeptCode(getOutPatientAdmResItemDTO.getDepartmentCode());
            getAdmissionItems.setDeptName(getOutPatientAdmResItemDTO.getDepartmentName());
            getAdmissionItems.setDocCode(getOutPatientAdmResItemDTO.getDoctorCode());
            getAdmissionItems.setDocName(getOutPatientAdmResItemDTO.getDoctorName());
            getAdmissionItems.setPatientId(((GetAdmissionReq)param.getBody()).getCardNo());
            admissionItemsList.add(getAdmissionItems);
        }
        getAdmissionRes.setItems(admissionItemsList);
        return FrontResponse.success((String)param.getTransactionId(), (Object)getAdmissionRes);
    }

    public FrontResponse<PayItemRes> payItem(FrontRequest<PayItemReq> param) {
        HashMap<String, Object> admMap = new HashMap<String, Object>(1);
        admMap.put(EntityKeyEnum.Get_ADMSSION_INFO.getValue(), param.getBody());
        FrontResponse admRes = this.hisRemoteService.requestHis(ServiceEnums.QUERY_WAITPAYFEES.getDisplay(), param.getTransactionId(), MethodCodeEnum.GET_MEDICAL_RECORDS.getValue(), admMap, GetOutPatientAdmResDTO.class);
        if (null == admRes) {
            return FrontResponse.error((String)admRes.getTransactionId(), (String)"0", (String)admRes.getMessage());
        }
        GetOutPatientAdmResDTO body = (GetOutPatientAdmResDTO)admRes.getBody();
        if (null == body || !"1".equals(body.getState()) || null == body.getData()) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u8c03\u7528\u63a5\u53e3\u5931\u8d25");
        }
        List getOutPatientAdmResItemDTOList = body.getData().getItems();
        if (CollectionUtils.isEmpty((Collection)getOutPatientAdmResItemDTOList)) {
            return FrontResponse.error((String)admRes.getTransactionId(), (String)"0", (String)"\u8c03\u7528\u63a5\u53e3\u5931\u8d25");
        }
        getOutPatientAdmResItemDTOList.removeIf(o -> !o.getReceiptsCode().equals(((PayItemReq)param.getBody()).getAdmId()));
        GetOutPatientAdmResItemDTO getOutPatientAdmResItemDTO = (GetOutPatientAdmResItemDTO)getOutPatientAdmResItemDTOList.get(0);
        List payDetailResList = getOutPatientAdmResItemDTO.getProject();
        PayItemRes payItemRes = new PayItemRes();
        ArrayList<PayItemResDatas> datas = new ArrayList<PayItemResDatas>();
        PayItemResDatas payItemResDatas = new PayItemResDatas();
        ArrayList<PayItemResItems> payItemResItemsList = new ArrayList<PayItemResItems>();
        for (GetOutPatientAdmResItemDTO.ProjectDTO pendingPayDetailResItemDTO : payDetailResList) {
            payItemResDatas.setAdmId(getOutPatientAdmResItemDTO.getReceiptsCode());
            payItemResDatas.setCostType(getOutPatientAdmResItemDTO.getCostType());
            payItemResDatas.setCostName(getOutPatientAdmResItemDTO.getCostName());
            payItemResDatas.setAmount(getOutPatientAdmResItemDTO.getAmountReceivable());
            payItemResDatas.setStartDate(getOutPatientAdmResItemDTO.getBillingTime());
            payItemResDatas.setEndDate(getOutPatientAdmResItemDTO.getBillingTime());
            payItemResDatas.setItemType(getOutPatientAdmResItemDTO.getCostName());
            payItemResDatas.setPatientNumber(getOutPatientAdmResItemDTO.getPatientNumber());
            PayItemResItems payItemResItems = new PayItemResItems();
            BeanUtils.copyProperties((Object)pendingPayDetailResItemDTO, (Object)payItemResItems);
            payItemResItems.setPrescriptionNo(pendingPayDetailResItemDTO.getId());
            payItemResItems.setDesc(pendingPayDetailResItemDTO.getCostName());
            payItemResItems.setQty(String.valueOf(new BigDecimal(payItemResItems.getQty()).setScale(2, 4)));
            payItemResItemsList.add(payItemResItems);
        }
        payItemResDatas.setItems(payItemResItemsList);
        datas.add(payItemResDatas);
        payItemRes.setDatas(datas);
        return FrontResponse.success((String)param.getTransactionId(), (Object)payItemRes);
    }

    public FrontResponse<ComfirmPayNewRes> comfirmPayNew(FrontRequest<ComfirmPayNewReq> param) {
        ComfirmPayNewRes comfirmPayNewRes = new ComfirmPayNewRes();
        ComfirmPayNewReq comfirmPayNewReq = (ComfirmPayNewReq)param.getBody();
        ComfirmPayNewReqMsg comfirmPayNewReqMsg = comfirmPayNewReq.getRespmsg();
        OutpatientComfirePayReqDTO outpatientComfirePayReqDTO = new OutpatientComfirePayReqDTO();
        outpatientComfirePayReqDTO.setPatientNumber(comfirmPayNewReq.getPatientNumber());
        outpatientComfirePayReqDTO.setCostType(comfirmPayNewReq.getCostType());
        outpatientComfirePayReqDTO.setReceiptsCode(comfirmPayNewReq.getAdmId());
        HashMap<String, OutpatientComfirePayReqDTO> beforconfirmPaymap = new HashMap<String, OutpatientComfirePayReqDTO>(1);
        beforconfirmPaymap.put(EntityKeyEnum.BEFOR_CONFIRM_PAY.getValue(), outpatientComfirePayReqDTO);
        FrontResponse beforcomfirePayResDTO = this.hisRemoteService.requestHis(ServiceEnums.DO_BUDGET.getDisplay(), param.getTransactionId(), MethodCodeEnum.BEFOR_CONFIRM_PAY.getValue(), beforconfirmPaymap, OutpatientComfirePayResDTO.class);
        if (null == beforcomfirePayResDTO) {
            return FrontResponse.error((String)beforcomfirePayResDTO.getTransactionId(), (String)"1", (String)beforcomfirePayResDTO.getMessage());
        }
        OutpatientComfirePayResDTO body = (OutpatientComfirePayResDTO)beforcomfirePayResDTO.getBody();
        if (null == body || !"1".equals(body.getState()) || null == body.getData()) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u8c03\u7528\u63a5\u53e3\u5931\u8d25");
        }
        OutpatientComfirePayResDTO.itemDTO itemDTO2 = (OutpatientComfirePayResDTO.itemDTO)body.getData().getItem().get(0);
        outpatientComfirePayReqDTO.setOrderNum(itemDTO2.getOrderNum());
        outpatientComfirePayReqDTO.setPayTime(comfirmPayNewReqMsg.getAccdate());
        outpatientComfirePayReqDTO.setPaymentMoney(itemDTO2.getAmountReceivable());
        outpatientComfirePayReqDTO.setTransactionNo(comfirmPayNewReqMsg.getOrderid());
        outpatientComfirePayReqDTO.setPaySerial(comfirmPayNewReqMsg.getOrderid());
        outpatientComfirePayReqDTO.setOrderNo(comfirmPayNewReqMsg.getOrderid());
        outpatientComfirePayReqDTO.setPaymentScenario("99");
        outpatientComfirePayReqDTO.setPayType(PayTypeEnums.getDisplay((String)comfirmPayNewReq.getPaychannel()));
        HashMap<String, OutpatientComfirePayReqDTO> confirmPaymap = new HashMap<String, OutpatientComfirePayReqDTO>(1);
        confirmPaymap.put(EntityKeyEnum.OUTPATIENT_CONFIRM_PAY.getValue(), outpatientComfirePayReqDTO);
        FrontResponse comfirePayResDTO = this.hisRemoteService.requestHis(ServiceEnums.DO_OUTPATIENTPAY.getDisplay(), param.getTransactionId(), MethodCodeEnum.OUTPATIENT_PAYMENT.getValue(), confirmPaymap, OutpatientComfirePayResDTO.class);
        if (null == comfirePayResDTO) {
            return FrontResponse.error((String)comfirePayResDTO.getTransactionId(), (String)"0", (String)comfirePayResDTO.getMessage());
        }
        OutpatientComfirePayResDTO comfirePayResBody = (OutpatientComfirePayResDTO)comfirePayResDTO.getBody();
        if (null == comfirePayResBody || !"1".equals(comfirePayResBody.getState()) || null == comfirePayResBody.getData()) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u8c03\u7528\u63a5\u53e3\u5931\u8d25");
        }
        OutpatientComfirePayResDTO.itemDTO comfirePayResBodyitemDTO = (OutpatientComfirePayResDTO.itemDTO)comfirePayResBody.getData().getItem().get(0);
        try {
            FrontRequest frontRequest = new FrontRequest();
            PayHisNoticeReq payHisNoticeReq = new PayHisNoticeReq();
            payHisNoticeReq.setOrderId(comfirmPayNewReqMsg.getOrderid());
            payHisNoticeReq.setDjysj(DateUtil.getCurrentDateStr((String)"yyyy-MM"));
            payHisNoticeReq.setCZFFXM("");
            payHisNoticeReq.setCBRH(comfirmPayNewReq.getPatientNumber());
            payHisNoticeReq.setCYNLSH(comfirePayResBodyitemDTO.getPayDemandNote());
            payHisNoticeReq.setSign("");
            frontRequest.setBody((Object)payHisNoticeReq);
            frontRequest.setChannel(param.getChannel());
            frontRequest.setChannelName(param.getChannelName());
            frontRequest.setOrganCode(param.getOrganCode());
            FrontResponse frontResponse = this.payService.payHisNotice(frontRequest);
            if (frontResponse.getCode().equals("0")) {
                log.info("\u8c03\u7528\u652f\u4ed8\u5e73\u53f0\u901a\u77e5\u63a5\u53e3\u5931\u8d25\u8ba2\u5355\u53f7\u4e3a\uff1a" + payHisNoticeReq.getOrderId());
                return FrontResponse.error((String)"", (String)"0", (String)("\u8c03\u7528\u652f\u4ed8\u5e73\u53f0\u901a\u77e5\u63a5\u53e3\u5931\u8d25\u8ba2\u5355\u53f7\u4e3a\uff1a" + payHisNoticeReq.getOrderId()));
            }
            log.info("\u8c03\u7528\u652f\u4ed8\u5e73\u53f0\u901a\u77e5\u63a5\u53e3\u6210\u529f\u8ba2\u5355\u53f7\u4e3a\uff1a" + payHisNoticeReq.getOrderId());
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u8c03\u7528\u652f\u4ed8\u5e73\u53f0\u901a\u77e5\u63a5\u53e3\u5f02\u5e38\u8ba2\u5355\u53f7\u4e3a\uff1a" + comfirmPayNewReqMsg.getOrderid());
            return FrontResponse.error((String)"", (String)"0", (String)("\u8c03\u7528\u652f\u4ed8\u5e73\u53f0\u901a\u77e5\u63a5\u53e3\u5f02\u5e38\u8ba2\u5355\u53f7\u4e3a:" + comfirmPayNewReqMsg.getOrderid()));
        }
        comfirmPayNewRes.setReceiptId(comfirePayResBodyitemDTO.getPayDemandNote());
        comfirmPayNewRes.setAdmId(comfirmPayNewRes.getAdmId());
        return FrontResponse.success((String)param.getTransactionId(), (Object)comfirmPayNewRes);
    }

    public FrontResponse<GetPayRecordsRes> getPayRecords(FrontRequest<GetPayRecordsReq> param) {
        GetPayRecordsRes getPayRecordsRes = new GetPayRecordsRes();
        GetPayRecordsReqDTO getPayRecordsReqDTO = new GetPayRecordsReqDTO();
        getPayRecordsReqDTO.setCardNo(((GetPayRecordsReq)param.getBody()).getCardNo());
        getPayRecordsReqDTO.setStartDate(((GetPayRecordsReq)param.getBody()).getStartDate());
        getPayRecordsReqDTO.setEndDate(((GetPayRecordsReq)param.getBody()).getEndDate());
        HashMap<String, GetPayRecordsReqDTO> recordsMap = new HashMap<String, GetPayRecordsReqDTO>(1);
        recordsMap.put(EntityKeyEnum.GET_PAY_RECORDS.getValue(), getPayRecordsReqDTO);
        FrontResponse recordsResDTO = this.hisRemoteService.requestHis("", param.getTransactionId(), MethodCodeEnum.OUTPATIENT_LIST_INQUIRY.getValue(), recordsMap, GetPayRecordsResDTO.class);
        if (null == recordsResDTO) {
            return FrontResponse.error((String)recordsResDTO.getTransactionId(), (String)"0", (String)recordsResDTO.getMessage());
        }
        if (!"0".equals(((GetPayRecordsResDTO)recordsResDTO.getBody()).getResultCode())) {
            return FrontResponse.error((String)recordsResDTO.getTransactionId(), (String)"0", (String)((GetPayRecordsResDTO)recordsResDTO.getBody()).getResultMsg());
        }
        List getPayRecordsResItemDTOList = ((GetPayRecordsResDTO)recordsResDTO.getBody()).getItem();
        if (CollectionUtils.isEmpty((Collection)getPayRecordsResItemDTOList)) {
            return FrontResponse.error((String)recordsResDTO.getTransactionId(), (String)"0", (String)((GetPayRecordsResDTO)recordsResDTO.getBody()).getResultMsg());
        }
        ArrayList<GetPayRecordsResDetails> details = new ArrayList<GetPayRecordsResDetails>();
        ArrayList<GetPayRecordsResItems> items = new ArrayList<GetPayRecordsResItems>();
        for (GetPayRecordsResItemDTO getPayRecordsResItemDTO : getPayRecordsResItemDTOList) {
            GetPayRecordsResItems getPayRecordsResItems = new GetPayRecordsResItems();
            BeanUtils.copyProperties((Object)getPayRecordsResItemDTO, (Object)getPayRecordsResItems);
            getPayRecordsResItems.setAdmType("O");
            getPayRecordsResItems.setAdmId(getPayRecordsResItemDTO.getClinicNo());
            List itemDetailDTOList = getPayRecordsResItemDTO.getPayRecordsResItemDetailDTOList();
            for (GetPayRecordsResItemDetailDTO itemDetailDTO : itemDetailDTOList) {
                GetPayRecordsResDetails getPayRecordsResDetails = new GetPayRecordsResDetails();
                BeanUtils.copyProperties((Object)itemDetailDTO, (Object)getPayRecordsResDetails);
                details.add(getPayRecordsResDetails);
            }
            getPayRecordsResItems.setDetails(details);
            items.add(getPayRecordsResItems);
        }
        getPayRecordsRes.setCardNo(((GetPayRecordsReq)param.getBody()).getCardNo());
        getPayRecordsRes.setName(((GetPayRecordsResItemDTO)getPayRecordsResItemDTOList.get(0)).getPatientname());
        getPayRecordsRes.setItems(items);
        return FrontResponse.success((String)param.getTransactionId(), (Object)getPayRecordsRes);
    }
}

