/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.service.impl;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.his.pojo.dto.PayNoticeResDTO;
import com.ebaiyihui.his.pojo.dto.PayNoticeResDataDTO;
import com.ebaiyihui.his.pojo.dto.PayRefundResDTO;
import com.ebaiyihui.his.pojo.dto.PaymentEncryptionRes;
import com.ebaiyihui.his.pojo.dto.QueryPayOrderResDTO;
import com.ebaiyihui.his.pojo.dto.QueryPayOrderResDataDTO;
import com.ebaiyihui.his.pojo.vo.appoint.PayHisNoticeReq;
import com.ebaiyihui.his.pojo.vo.appoint.PayHisNoticeResData;
import com.ebaiyihui.his.pojo.vo.appoint.PayRefundReq;
import com.ebaiyihui.his.pojo.vo.appoint.PaymentEncryptionReq;
import com.ebaiyihui.his.pojo.vo.appoint.QueryPayOrderReq;
import com.ebaiyihui.his.pojo.vo.appoint.QueryPayOrderResData;
import com.ebaiyihui.his.pojo.vo.base.FrontRequest;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import com.ebaiyihui.his.service.PayService;
import com.ebaiyihui.his.utils.EncryptionUtil;
import com.ebaiyihui.his.utils.HttpClientUtil;
import com.ebaiyihui.his.utils.PayUtils;
import com.ebaiyihui.his.utils.XmlTemplateKit;
import com.ebaiyihui.his.utils.XmlUtil;
import java.util.HashMap;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class PayServiceImpl
implements PayService {
    private static final Logger log = LoggerFactory.getLogger(PayServiceImpl.class);
    @Value(value="${encryptionKey}")
    private String encryptionKey;
    @Value(value="${aliEncryptionKey}")
    private String aliEncryptionKey;
    @Value(value="${decryptKey}")
    private String decryptKey;
    @Value(value="${aliDecryptKey}")
    private String aliDecryptKey;
    @Value(value="${payUrl}")
    private String payUrl;
    @Value(value="${orgId}")
    private String orgId;
    @Value(value="${aliOrgId}")
    private String aliOrgId;
    @Value(value="${hospitalId}")
    private String hospitalId;
    @Value(value="${aliHospitalId}")
    private String aliHospitalId;
    @Value(value="${busiCode}")
    private String busiCode;
    @Value(value="${aliBusiCode}")
    private String aliBusiCode;
    @Value(value="${serial}")
    private String serial;
    @Value(value="${aliSerial}")
    private String aliSerial;
    @Value(value="${oprId}")
    private String oprId;
    @Value(value="${aliOprId}")
    private String aliOprId;
    @Autowired
    PayUtils payUtils;

    public FrontResponse<String> payment(FrontRequest<PaymentEncryptionReq> param) {
        if (!Objects.isNull(param.getChannel()) && "PATIENT_ALIPAY".equals(param.getChannel())) {
            PaymentEncryptionReq paymentEncryptionReq = (PaymentEncryptionReq)param.getBody();
            HashMap<String, PaymentEncryptionReq> map = new HashMap<String, PaymentEncryptionReq>();
            paymentEncryptionReq.setPayCode("02");
            paymentEncryptionReq.setOrgId(this.aliOrgId);
            paymentEncryptionReq.setHospitalId(this.aliHospitalId);
            paymentEncryptionReq.setBusiCode(this.aliBusiCode);
            paymentEncryptionReq.setSerial(this.aliSerial);
            paymentEncryptionReq.setOprId(this.aliOprId);
            map.put("pay", paymentEncryptionReq);
            String requestHisXml = XmlTemplateKit.process((String)"6101", map);
            try {
                String sign = EncryptionUtil.sign((String)requestHisXml, (String)this.aliEncryptionKey);
                paymentEncryptionReq.setSign(sign);
                map.put("pay", paymentEncryptionReq);
                String url = this.payUrl.concat("/ydpay/v3/integpay");
                FrontResponse pay = this.payUtils.pay(param.getTransactionId(), "6101", map, url);
                if (Objects.equals(pay.getCode(), "1")) {
                    PaymentEncryptionRes body = (PaymentEncryptionRes)pay.getBody();
                    return FrontResponse.success((String)param.getTransactionId(), (Object)JSON.toJSONString((Object)body.getDataRes()));
                }
                return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)pay.getMessage());
            }
            catch (Exception e) {
                e.printStackTrace();
                return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u62c9\u8d77\u652f\u4ed8\u5931\u8d25");
            }
        }
        PaymentEncryptionReq paymentEncryptionReq = (PaymentEncryptionReq)param.getBody();
        HashMap<String, PaymentEncryptionReq> map = new HashMap<String, PaymentEncryptionReq>();
        paymentEncryptionReq.setPayCode("01");
        paymentEncryptionReq.setOrgId(this.orgId);
        paymentEncryptionReq.setHospitalId(this.hospitalId);
        paymentEncryptionReq.setBusiCode(this.busiCode);
        paymentEncryptionReq.setSerial(this.serial);
        paymentEncryptionReq.setOprId(this.oprId);
        map.put("pay", paymentEncryptionReq);
        String requestHisXml = XmlTemplateKit.process((String)"6101", map);
        try {
            String sign = EncryptionUtil.sign((String)requestHisXml, (String)this.encryptionKey);
            paymentEncryptionReq.setSign(sign);
            map.put("pay", paymentEncryptionReq);
            String url = this.payUrl.concat("/ydpay/v3/integpay");
            FrontResponse pay = this.payUtils.pay(param.getTransactionId(), "6101", map, url);
            if (Objects.equals(pay.getCode(), "1")) {
                PaymentEncryptionRes body = (PaymentEncryptionRes)pay.getBody();
                return FrontResponse.success((String)param.getTransactionId(), (Object)JSON.toJSONString((Object)body.getDataRes()));
            }
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)pay.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u62c9\u8d77\u652f\u4ed8\u5931\u8d25");
        }
    }

    public FrontResponse<QueryPayOrderResData> queryPayOrder(FrontRequest<QueryPayOrderReq> param) {
        if (!Objects.isNull(param.getChannel()) && "PATIENT_ALIPAY".equals(param.getChannel())) {
            QueryPayOrderReq paramBody = (QueryPayOrderReq)param.getBody();
            paramBody.setOrgId(this.aliOrgId);
            paramBody.setHospitalId(this.aliHospitalId);
            paramBody.setBusiCode(this.aliBusiCode);
            paramBody.setSerial(this.aliSerial);
            paramBody.setOprId(this.aliOprId);
            String url = this.payUrl.concat("/ydpay/v3/integpay");
            HashMap<String, QueryPayOrderReq> map = new HashMap<String, QueryPayOrderReq>();
            map.put("queryPayOrder", paramBody);
            String requestHisXml = XmlTemplateKit.process((String)"6102", map);
            if (StringUtils.isEmpty((CharSequence)requestHisXml)) {
                return FrontResponse.error((String)"", (String)"0", (String)"\u53c2\u6570\u6a21\u677f\u4e0d\u5b58\u5728");
            }
            try {
                String sign = EncryptionUtil.sign((String)requestHisXml, (String)this.aliEncryptionKey);
                paramBody.setSign(sign);
                map.put("queryPayOrder", paramBody);
                requestHisXml = XmlTemplateKit.process((String)"6102", map);
                log.info("\u67e5\u8be2\u652f\u4ed8\u8ba2\u5355requestHisXml:{}", (Object)requestHisXml);
                String responseHisXml = HttpClientUtil.post((String)url, (String)requestHisXml);
                log.info("\u67e5\u8be2\u652f\u4ed8\u8ba2\u5355responseHisXml:{}", (Object)responseHisXml);
                boolean bool = EncryptionUtil.verifySign((String)responseHisXml, (String)this.aliDecryptKey);
                if (!bool) {
                    return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u9a8c\u7b7e\u5931\u8d25");
                }
                QueryPayOrderResDTO resHisDTO = (QueryPayOrderResDTO)XmlUtil.convertToJavaBean((String)responseHisXml, QueryPayOrderResDTO.class);
                log.info("\u652f\u4ed8\u5e73\u53f0\u9000\u8d39\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)resHisDTO));
                if (Objects.isNull(resHisDTO)) {
                    return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"JAXB\u6267\u884c\u5931\u8d25");
                }
                if (Objects.equals(resHisDTO.getState(), "1")) {
                    QueryPayOrderResDataDTO data = resHisDTO.getData();
                    QueryPayOrderResData queryPayOrderResData = new QueryPayOrderResData();
                    BeanUtils.copyProperties((Object)data, (Object)queryPayOrderResData);
                    return FrontResponse.success((String)param.getTransactionId(), (Object)queryPayOrderResData);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u67e5\u8be2\u652f\u4ed8\u8ba2\u5355\u5931\u8d25");
        }
        QueryPayOrderReq paramBody = (QueryPayOrderReq)param.getBody();
        paramBody.setOrgId(this.orgId);
        paramBody.setHospitalId(this.hospitalId);
        paramBody.setBusiCode(this.busiCode);
        paramBody.setSerial(this.serial);
        paramBody.setOprId(this.oprId);
        String url = this.payUrl.concat("/ydpay/v3/integpay");
        HashMap<String, QueryPayOrderReq> map = new HashMap<String, QueryPayOrderReq>();
        map.put("queryPayOrder", paramBody);
        String requestHisXml = XmlTemplateKit.process((String)"6102", map);
        if (StringUtils.isEmpty((CharSequence)requestHisXml)) {
            return FrontResponse.error((String)"", (String)"0", (String)"\u53c2\u6570\u6a21\u677f\u4e0d\u5b58\u5728");
        }
        try {
            String sign = EncryptionUtil.sign((String)requestHisXml, (String)this.encryptionKey);
            paramBody.setSign(sign);
            map.put("queryPayOrder", paramBody);
            requestHisXml = XmlTemplateKit.process((String)"6102", map);
            log.info("\u67e5\u8be2\u652f\u4ed8\u8ba2\u5355requestHisXml:{}", (Object)requestHisXml);
            String responseHisXml = HttpClientUtil.post((String)url, (String)requestHisXml);
            log.info("\u67e5\u8be2\u652f\u4ed8\u8ba2\u5355responseHisXml:{}", (Object)responseHisXml);
            boolean bool = EncryptionUtil.verifySign((String)responseHisXml, (String)this.decryptKey);
            if (!bool) {
                return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u9a8c\u7b7e\u5931\u8d25");
            }
            QueryPayOrderResDTO resHisDTO = (QueryPayOrderResDTO)XmlUtil.convertToJavaBean((String)responseHisXml, QueryPayOrderResDTO.class);
            log.info("\u67e5\u8be2\u652f\u4ed8\u8ba2\u5355responseHisXml\uff1a" + JSON.toJSONString((Object)resHisDTO));
            if (Objects.isNull(resHisDTO)) {
                return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"JAXB\u6267\u884c\u5931\u8d25");
            }
            if (Objects.equals(resHisDTO.getState(), "1")) {
                QueryPayOrderResDataDTO data = resHisDTO.getData();
                QueryPayOrderResData queryPayOrderResData = new QueryPayOrderResData();
                BeanUtils.copyProperties((Object)data, (Object)queryPayOrderResData);
                return FrontResponse.success((String)param.getTransactionId(), (Object)queryPayOrderResData);
            }
        }
        catch (Exception e) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)e.getMessage());
        }
        return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u67e5\u8be2\u652f\u4ed8\u8ba2\u5355\u5931\u8d25");
    }

    public FrontResponse<String> refund(FrontRequest<PayRefundReq> param) {
        if (!Objects.isNull(param.getChannel()) && "PATIENT_ALIPAY".equals(param.getChannel())) {
            PayRefundReq paramBody = (PayRefundReq)param.getBody();
            paramBody.setOrgId(this.aliOrgId);
            paramBody.setHospitalId(this.aliHospitalId);
            paramBody.setBusiCode(this.aliBusiCode);
            paramBody.setSerial(this.aliSerial);
            paramBody.setOprId(this.aliOprId);
            String url = this.payUrl.concat("/ydpay/v3/integpay");
            HashMap<String, PayRefundReq> map = new HashMap<String, PayRefundReq>();
            map.put("refund", paramBody);
            String requestHisXml = XmlTemplateKit.process((String)"6103", map);
            if (StringUtils.isEmpty((CharSequence)requestHisXml)) {
                return FrontResponse.error((String)"", (String)"0", (String)"\u53c2\u6570\u6a21\u677f\u4e0d\u5b58\u5728");
            }
            try {
                String sign = EncryptionUtil.sign((String)requestHisXml, (String)this.aliEncryptionKey);
                paramBody.setSign(sign);
                map.put("refund", paramBody);
                requestHisXml = XmlTemplateKit.process((String)"6103", map);
                log.info("\u9000\u6b3erequestHisXml:{}", (Object)requestHisXml);
                String responseHisXml = HttpClientUtil.post((String)url, (String)requestHisXml);
                log.info("\u9000\u6b3eresponseHisXml:{}", (Object)responseHisXml);
                boolean bool = EncryptionUtil.verifySign((String)responseHisXml, (String)this.aliDecryptKey);
                if (!bool) {
                    return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u9000\u6b3e\u56de\u53c2\u9a8c\u7b7e\u5931\u8d25");
                }
                PayRefundResDTO resHisDTO = (PayRefundResDTO)XmlUtil.convertToJavaBean((String)responseHisXml, PayRefundResDTO.class);
                log.info("JAXB\u6267\u884c\u7ed3\u679c\uff1a" + JSON.toJSONString((Object)resHisDTO));
                if (Objects.isNull(resHisDTO)) {
                    return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"JAXB\u6267\u884c\u5931\u8d25");
                }
                if (Objects.equals(resHisDTO.getState(), "1")) {
                    return FrontResponse.success((String)param.getTransactionId(), (Object)resHisDTO.getError());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u9000\u6b3e\u8c03\u7528\u5931\u8d25");
        }
        PayRefundReq paramBody = (PayRefundReq)param.getBody();
        paramBody.setOrgId(this.orgId);
        paramBody.setHospitalId(this.hospitalId);
        paramBody.setBusiCode(this.busiCode);
        paramBody.setSerial(this.serial);
        paramBody.setOprId(this.oprId);
        String url = this.payUrl.concat("/ydpay/v3/integpay");
        HashMap<String, PayRefundReq> map = new HashMap<String, PayRefundReq>();
        map.put("refund", paramBody);
        String requestHisXml = XmlTemplateKit.process((String)"6103", map);
        if (StringUtils.isEmpty((CharSequence)requestHisXml)) {
            return FrontResponse.error((String)"", (String)"0", (String)"\u53c2\u6570\u6a21\u677f\u4e0d\u5b58\u5728");
        }
        try {
            String sign = EncryptionUtil.sign((String)requestHisXml, (String)this.encryptionKey);
            paramBody.setSign(sign);
            map.put("refund", paramBody);
            requestHisXml = XmlTemplateKit.process((String)"6103", map);
            log.info("\u9000\u6b3erequestHisXml:{}", (Object)requestHisXml);
            String responseHisXml = HttpClientUtil.post((String)url, (String)requestHisXml);
            log.info("\u9000\u6b3eresponseHisXml:{}", (Object)responseHisXml);
            boolean bool = EncryptionUtil.verifySign((String)responseHisXml, (String)this.decryptKey);
            if (!bool) {
                return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u9000\u6b3e\u56de\u53c2\u9a8c\u7b7e\u5931\u8d25");
            }
            PayRefundResDTO resHisDTO = (PayRefundResDTO)XmlUtil.convertToJavaBean((String)responseHisXml, PayRefundResDTO.class);
            log.info("JAXB\u6267\u884c\u7ed3\u679c\uff1a" + JSON.toJSONString((Object)resHisDTO));
            if (Objects.isNull(resHisDTO)) {
                return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"JAXB\u6267\u884c\u5931\u8d25");
            }
            if (Objects.equals(resHisDTO.getState(), "1")) {
                return FrontResponse.success((String)param.getTransactionId(), (Object)resHisDTO.getError());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u9000\u6b3e\u8c03\u7528\u5931\u8d25");
    }

    public FrontResponse<PayHisNoticeResData> payHisNotice(FrontRequest<PayHisNoticeReq> param) {
        if (!Objects.isNull(param.getChannel()) && "PATIENT_ALIPAY".equals(param.getChannel())) {
            PayHisNoticeReq paramBody = (PayHisNoticeReq)param.getBody();
            paramBody.setOrgId(this.aliOrgId);
            paramBody.setHospitalId(this.aliHospitalId);
            paramBody.setBusiCode(this.aliBusiCode);
            paramBody.setSerial(this.aliSerial);
            paramBody.setOprId(this.aliOprId);
            String url = this.payUrl.concat("/ydpay/v3/integpay");
            HashMap<String, PayHisNoticeReq> map = new HashMap<String, PayHisNoticeReq>();
            map.put("payHisNotice", paramBody);
            String requestHisXml = XmlTemplateKit.process((String)"6104", map);
            if (StringUtils.isEmpty((CharSequence)requestHisXml)) {
                return FrontResponse.error((String)"", (String)"0", (String)"\u53c2\u6570\u6a21\u677f\u4e0d\u5b58\u5728");
            }
            try {
                String sign = EncryptionUtil.sign((String)requestHisXml, (String)this.aliEncryptionKey);
                paramBody.setSign(sign);
                map.put("payHisNotice", paramBody);
                requestHisXml = XmlTemplateKit.process((String)"6104", map);
                log.info("HIS\u4e1a\u52a1\u5904\u7406\u6210\u529frequestHisXml:{}", (Object)requestHisXml);
                String responseHisXml = HttpClientUtil.post((String)url, (String)requestHisXml);
                log.info("HIS\u4e1a\u52a1\u5904\u7406\u6210\u529fresponseHisXml:{}", (Object)responseHisXml);
                if (StringUtils.isEmpty((CharSequence)responseHisXml)) {
                    return FrontResponse.error((String)"", (String)"0", (String)"JAXB\u6267\u884c\u5931\u8d25:responseHisXml\u4e3a\u7a7a");
                }
                boolean bool = EncryptionUtil.verifySign((String)responseHisXml, (String)this.aliDecryptKey);
                if (!bool) {
                    return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u9a8c\u7b7e\u5931\u8d25");
                }
                PayNoticeResDTO resHisDTO = (PayNoticeResDTO)XmlUtil.convertToJavaBean((String)responseHisXml, PayNoticeResDTO.class);
                log.info("JAXB\u6267\u884c\u7ed3\u679c\uff1a" + JSON.toJSONString((Object)resHisDTO));
                if (Objects.isNull(resHisDTO)) {
                    return FrontResponse.error((String)"", (String)"0", (String)"json\u89e3\u6790\u5bf9\u8c61\u4e3a\u7a7a");
                }
                PayNoticeResDataDTO data = resHisDTO.getData();
                PayHisNoticeResData payHisNoticeResData = new PayHisNoticeResData();
                BeanUtils.copyProperties((Object)data, (Object)payHisNoticeResData);
                return FrontResponse.success((String)param.getTransactionId(), (Object)payHisNoticeResData);
            }
            catch (Exception e) {
                e.printStackTrace();
                return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u901a\u77e5his\u5931\u8d25");
            }
        }
        PayHisNoticeReq paramBody = (PayHisNoticeReq)param.getBody();
        paramBody.setOrgId(this.orgId);
        paramBody.setHospitalId(this.hospitalId);
        paramBody.setBusiCode(this.busiCode);
        paramBody.setSerial(this.serial);
        paramBody.setOprId(this.oprId);
        String url = this.payUrl.concat("/ydpay/v3/integpay");
        HashMap<String, PayHisNoticeReq> map = new HashMap<String, PayHisNoticeReq>();
        map.put("payHisNotice", paramBody);
        String requestHisXml = XmlTemplateKit.process((String)"6104", map);
        if (StringUtils.isEmpty((CharSequence)requestHisXml)) {
            return FrontResponse.error((String)"", (String)"0", (String)"\u53c2\u6570\u6a21\u677f\u4e0d\u5b58\u5728");
        }
        try {
            String sign = EncryptionUtil.sign((String)requestHisXml, (String)this.encryptionKey);
            paramBody.setSign(sign);
            map.put("payHisNotice", paramBody);
            requestHisXml = XmlTemplateKit.process((String)"6104", map);
            log.info("HIS\u4e1a\u52a1\u5904\u7406\u6210\u529frequestHisXml:{}", (Object)requestHisXml);
            String responseHisXml = HttpClientUtil.post((String)url, (String)requestHisXml);
            log.info("HIS\u4e1a\u52a1\u5904\u7406\u6210\u529fresponseHisXml:{}", (Object)responseHisXml);
            if (StringUtils.isEmpty((CharSequence)responseHisXml)) {
                return FrontResponse.error((String)"", (String)"0", (String)"JAXB\u6267\u884c\u5931\u8d25:responseHisXml\u4e3a\u7a7a");
            }
            boolean bool = EncryptionUtil.verifySign((String)responseHisXml, (String)this.decryptKey);
            if (!bool) {
                return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u9a8c\u7b7e\u5931\u8d25");
            }
            PayNoticeResDTO resHisDTO = (PayNoticeResDTO)XmlUtil.convertToJavaBean((String)responseHisXml, PayNoticeResDTO.class);
            log.info("JAXB\u6267\u884c\u7ed3\u679c\uff1a" + JSON.toJSONString((Object)resHisDTO));
            if (Objects.isNull(resHisDTO)) {
                return FrontResponse.error((String)"", (String)"0", (String)"json\u89e3\u6790\u5bf9\u8c61\u4e3a\u7a7a");
            }
            PayNoticeResDataDTO data = resHisDTO.getData();
            PayHisNoticeResData payHisNoticeResData = new PayHisNoticeResData();
            BeanUtils.copyProperties((Object)data, (Object)payHisNoticeResData);
            return FrontResponse.success((String)param.getTransactionId(), (Object)payHisNoticeResData);
        }
        catch (Exception e) {
            e.printStackTrace();
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u901a\u77e5his\u5931\u8d25");
        }
    }

    private void buildParam(String channel) {
        log.info("channel========" + channel);
        if (!Objects.isNull(channel) && "PATIENT_ALIPAY".equals(channel)) {
            this.encryptionKey = this.aliEncryptionKey;
            this.decryptKey = this.aliDecryptKey;
            this.orgId = this.aliOrgId;
            this.hospitalId = this.aliHospitalId;
            this.busiCode = this.aliBusiCode;
            this.serial = this.aliSerial;
        }
        log.info("-------" + this.encryptionKey);
        log.info("-------" + this.decryptKey);
        log.info("-------" + this.orgId);
        log.info("-------" + this.hospitalId);
        log.info("-------" + this.busiCode);
        log.info("-------" + this.serial);
    }
}

