/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.his.common.enums.EntityKeyEnum;
import com.ebaiyihui.his.common.enums.MethodCodeEnum;
import com.ebaiyihui.his.pojo.dto.HISResponseDTO;
import com.ebaiyihui.his.pojo.dto.MainPayResDTO;
import com.ebaiyihui.his.pojo.dto.MainPushRepBodyDTO;
import com.ebaiyihui.his.pojo.dto.MainRefundResDTO;
import com.ebaiyihui.his.pojo.vo.MainMiddlePushRequestVO;
import com.ebaiyihui.his.pojo.vo.MainPayVO;
import com.ebaiyihui.his.pojo.vo.MainRefundVO;
import com.ebaiyihui.his.pojo.vo.MainWestPushRequestVO;
import com.ebaiyihui.his.pojo.vo.RevokeMainVO;
import com.ebaiyihui.his.pojo.vo.base.FrontRequest;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import com.ebaiyihui.his.service.HisRemoteService;
import com.ebaiyihui.his.service.IPrescriptionService;
import com.ebaiyihui.his.utils.HttpKit;
import com.ebaiyihui.his.utils.XmlUtil;
import java.util.HashMap;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class PrescriptionServiceImpl
implements IPrescriptionService {
    private static final Logger log = LoggerFactory.getLogger(PrescriptionServiceImpl.class);
    @Value(value="${remote.cloudMedicalUrl}")
    private String remoteCloudMedicalUrl;
    @Autowired
    private HisRemoteService hisRemoteService;

    public void revokeMain(String content) throws Exception {
        RevokeMainVO requestVO = (RevokeMainVO)XmlUtil.convertToJavaBean((String)content, RevokeMainVO.class);
        log.info("his\u8c03\u7528\u64a4\u9500\u5904\u65b9\u63a5\u53e3\uff0c\u8f6c\u5316\u540e\u7684\u8bf7\u6c42\u53c2\u6570\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)requestVO));
        try {
            log.info("\u8bf7\u6c42\u5730\u5740\u4e3a\uff1a{}", (Object)(this.remoteCloudMedicalUrl + "YCRMYY/medicalcloud/api/YCPrescription/v1/yc/revokeMain"));
            String body = HttpKit.jsonPost((String)(this.remoteCloudMedicalUrl + "YCRMYY/medicalcloud/api/YCPrescription/v1/yc/revokeMain"), (String)JSON.toJSONString((Object)requestVO));
            BaseResponse baseResponse = (BaseResponse)JSON.parseObject((String)body, BaseResponse.class);
            log.info("\u5904\u65b9\u64a4\u9500\u6210\u529f");
            if (!baseResponse.isSuccess()) {
                log.error("\u533b\u836f\u4e91\u670d\u52a1\u8c03\u7528\u6210\u529f\uff0c\u4f46\u662f\u5904\u65b9\u64a4\u9500\u5931\u8d25\uff0c\u8fd4\u56de\u503c\u4e3a{}", (Object)JSON.toJSONString((Object)baseResponse.getMsg()));
            }
            if (!(baseResponse = (BaseResponse)JSON.parseObject((String)(body = HttpKit.jsonPost((String)(this.remoteCloudMedicalUrl + "/prescription/YCRMYY/api/ncefyPrescription/v1/yc/revokeMain"), (String)JSON.toJSONString((Object)requestVO))), BaseResponse.class)).isSuccess()) {
                log.error("\u5904\u65b9\u6d41\u8f6c\u5e73\u53f0\u670d\u52a1\u8c03\u7528\u6210\u529f\uff0c\u4f46\u662f\u5904\u65b9\u64a4\u9500\u5931\u8d25\uff0c\u8fd4\u56de\u503c\u4e3a{}", (Object)JSON.toJSONString((Object)baseResponse.getMsg()));
            }
        }
        catch (Exception e) {
            log.error("\u533b\u836f\u4e91\u670d\u52a1\u8fdc\u7a0b\u8c03\u7528\u5f02\u5e38: {}", (Object)e.getMessage());
            throw new Exception("\u7f51\u7edc\u5f02\u5e38\uff0c \u8bf7\u91cd\u8bd5");
        }
        log.info("\u5904\u65b9\u64a4\u9500\u6210\u529f\u670d\u52a1\u8c03\u7528\u5b8c\u6210");
    }

    public MainPushRepBodyDTO westMainPush(String frontRequest) throws Exception {
        MainWestPushRequestVO requestVO = (MainWestPushRequestVO)XmlUtil.convertToJavaBean((String)frontRequest, MainWestPushRequestVO.class);
        if (Objects.isNull(requestVO)) {
            log.info("\u533b\u836f\u4e91\u4e2d\u836f\u63a8\u9001\u670d\u52a1\u8c03\u7528\u6210\u529f\uff0c\u4f46\u662f\u53c2\u6570\u4e3a\u7a7a\uff0c\u8bf7\u6c42\u53c2\u6570\u4e3a{}", (Object)frontRequest);
            throw new Exception("\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a");
        }
        requestVO.setMainDrugType(Integer.valueOf(1));
        log.info("his\u8c03\u7528\u63a8\u9001\u897f\u836f\u4e2d\u6210\u836f\u5904\u65b9\u63a8\u9001\u63a5\u53e3\uff0c\u8f6c\u5316\u540e\u7684\u8bf7\u6c42\u53c2\u6570\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)requestVO));
        MainPushRepBodyDTO mainPushRepBodyDTO = new MainPushRepBodyDTO();
        try {
            log.info("\u8bf7\u6c42\u5730\u5740\u4e3a\uff1a{}", (Object)(this.remoteCloudMedicalUrl + "YCRMYY/medicalcloud/api/YCPrescription/v1/yc/mainPush"));
            String body = HttpKit.jsonPost((String)(this.remoteCloudMedicalUrl + "YCRMYY/medicalcloud/api/YCPrescription/v1/yc/mainPush"), (String)JSON.toJSONString((Object)requestVO));
            BaseResponse baseResponse = (BaseResponse)JSON.parseObject((String)body, BaseResponse.class);
            log.info("\u4e2d\u6210\u836f\u63a8\u9001\u6210\u529f\uff0c\u533b\u836f\u4e91\u8fd4\u56de\u503c\u4e3a{}", (Object)JSON.toJSONString((Object)baseResponse.getData()));
            mainPushRepBodyDTO.setPresNo(((JSONObject)baseResponse.getData()).get((Object)"presNo").toString());
            if (!baseResponse.isSuccess()) {
                log.info("\u533b\u836f\u4e91\u670d\u52a1\u8c03\u7528\u6210\u529f\uff0c\u4f46\u662f\u8fd4\u56de\u5931\u8d25\uff0c\u8fd4\u56de\u503c\u4e3a{}", (Object)JSON.toJSONString((Object)baseResponse.getMsg()));
                throw new Exception(baseResponse.getMsg());
            }
        }
        catch (Exception e) {
            log.error("\u533b\u836f\u4e91\u670d\u52a1\u8fdc\u7a0b\u8c03\u7528\u5f02\u5e38: {}", (Object)e.getMessage());
            throw new Exception("\u7f51\u7edc\u5f02\u5e38\uff0c \u8bf7\u91cd\u8bd5");
        }
        return mainPushRepBodyDTO;
    }

    public MainPushRepBodyDTO middleMainPush(String frontRequest) throws Exception {
        MainMiddlePushRequestVO requestVO = (MainMiddlePushRequestVO)XmlUtil.convertToJavaBean((String)frontRequest, MainMiddlePushRequestVO.class);
        if (Objects.isNull(requestVO)) {
            log.info("\u533b\u836f\u4e91\u4e2d\u836f\u63a8\u9001\u670d\u52a1\u8c03\u7528\u6210\u529f\uff0c\u4f46\u662f\u53c2\u6570\u4e3a\u7a7a\uff0c\u8bf7\u6c42\u53c2\u6570\u4e3a{}", (Object)frontRequest);
            throw new Exception("\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a");
        }
        log.info("his\u8c03\u7528\u63a8\u9001\u4e2d\u836f\u5904\u65b9\u63a8\u9001\u63a5\u53e3\uff0c\u8f6c\u5316\u540e\u7684\u8bf7\u6c42\u53c2\u6570\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)requestVO));
        requestVO.setMainDrugType(Integer.valueOf(2));
        MainPushRepBodyDTO mainPushRepBodyDTO = new MainPushRepBodyDTO();
        try {
            log.info("\u8bf7\u6c42\u5730\u5740\u4e3a\uff1a{}", (Object)(this.remoteCloudMedicalUrl + "YCRMYY/medicalcloud/api/YCPrescription/v1/yc/mainPush"));
            String body = HttpKit.jsonPost((String)(this.remoteCloudMedicalUrl + "YCRMYY/medicalcloud/api/YCPrescription/v1/yc/mainPush"), (String)JSON.toJSONString((Object)requestVO));
            BaseResponse baseResponse = (BaseResponse)JSON.parseObject((String)body, BaseResponse.class);
            log.info("\u4e2d\u836f\u63a8\u9001\u6210\u529f\uff0c\u533b\u836f\u4e91\u8fd4\u56de\u503c\u4e3a{}", (Object)JSON.toJSONString((Object)baseResponse));
            log.info("\u5904\u65b9\u53f7\u4e3a:{}", (Object)JSON.toJSONString((Object)baseResponse.getData()));
            mainPushRepBodyDTO.setPresNo(((JSONObject)baseResponse.getData()).get((Object)"presNo").toString());
            if (!baseResponse.isSuccess()) {
                log.info("\u533b\u836f\u4e91\u4e2d\u836f\u63a8\u9001\u670d\u52a1\u8c03\u7528\u6210\u529f\uff0c\u4f46\u662f\u8fd4\u56de\u5931\u8d25\uff0c\u8fd4\u56de\u503c\u4e3a{}", (Object)JSON.toJSONString((Object)baseResponse.getMsg()));
                throw new Exception(baseResponse.getMsg());
            }
        }
        catch (Exception e) {
            log.error("\u533b\u836f\u4e91\u4e2d\u836f\u670d\u52a1\u8fdc\u7a0b\u8c03\u7528\u5f02\u5e38: {}", (Object)e.getMessage());
            throw new Exception("\u7f51\u7edc\u5f02\u5e38\uff0c \u8bf7\u91cd\u8bd5");
        }
        return mainPushRepBodyDTO;
    }

    public FrontResponse mainPay(FrontRequest<MainPayVO> frontRequest) {
        MainPayResDTO mainPayResDTO = new MainPayResDTO();
        mainPayResDTO.setBankTransNO(((MainPayVO)frontRequest.getBody()).getBankTransNO());
        mainPayResDTO.setFeeDate(((MainPayVO)frontRequest.getBody()).getFeeDate());
        mainPayResDTO.setHealCost(((MainPayVO)frontRequest.getBody()).getHealCost());
        mainPayResDTO.setHisRegNo(((MainPayVO)frontRequest.getBody()).getHisRegNo());
        mainPayResDTO.setPayMethod(((MainPayVO)frontRequest.getBody()).getHisRegNo());
        mainPayResDTO.setPresNoList(((MainPayVO)frontRequest.getBody()).getPresNoList());
        mainPayResDTO.setSelfCost(((MainPayVO)frontRequest.getBody()).getSelfCost());
        mainPayResDTO.setTotalCost(((MainPayVO)frontRequest.getBody()).getTotalCost());
        HashMap<String, MainPayResDTO> cardInfoMap = new HashMap<String, MainPayResDTO>(1);
        cardInfoMap.put(EntityKeyEnum.MAIN_PAY.getValue(), mainPayResDTO);
        FrontResponse queryCardInfoRes = this.hisRemoteService.requestHis("", frontRequest.getTransactionId(), MethodCodeEnum.MAIN_PAY.getValue(), cardInfoMap, HISResponseDTO.class);
        HISResponseDTO queryCardInfoResDTO = (HISResponseDTO)queryCardInfoRes.getBody();
        if (null == queryCardInfoResDTO) {
            return FrontResponse.error((String)queryCardInfoRes.getTransactionId(), (String)"0", (String)queryCardInfoRes.getMessage());
        }
        if (!"0".equals(queryCardInfoResDTO.getResultCode())) {
            return FrontResponse.error((String)queryCardInfoRes.getTransactionId(), (String)"0", (String)queryCardInfoResDTO.getResultMsg());
        }
        return FrontResponse.success((String)frontRequest.getTransactionId(), (Object)1);
    }

    public FrontResponse mainRefund(FrontRequest<MainRefundVO> frontRequest) {
        MainRefundResDTO mainRefundResDTO = new MainRefundResDTO();
        mainRefundResDTO.setCardNo(((MainRefundVO)frontRequest.getBody()).getCardNo());
        mainRefundResDTO.setPresNoList(((MainRefundVO)frontRequest.getBody()).getPresNoList());
        mainRefundResDTO.setRefundTime(((MainRefundVO)frontRequest.getBody()).getRefundTime());
        mainRefundResDTO.setRefundTotalAmount(((MainRefundVO)frontRequest.getBody()).getRefundTotalAmount());
        mainRefundResDTO.setRefundTransNO(((MainRefundVO)frontRequest.getBody()).getRefundTransNO());
        HashMap<String, MainRefundResDTO> cardInfoMap = new HashMap<String, MainRefundResDTO>(1);
        cardInfoMap.put(EntityKeyEnum.MAIN_REFUND.getValue(), mainRefundResDTO);
        FrontResponse queryCardInfoRes = this.hisRemoteService.requestHis("", frontRequest.getTransactionId(), MethodCodeEnum.MAIN_REFUND.getValue(), cardInfoMap, HISResponseDTO.class);
        HISResponseDTO queryCardInfoResDTO = (HISResponseDTO)queryCardInfoRes.getBody();
        if (null == queryCardInfoResDTO) {
            return FrontResponse.error((String)queryCardInfoRes.getTransactionId(), (String)"0", (String)queryCardInfoRes.getMessage());
        }
        if (!"0".equals(queryCardInfoResDTO.getResultCode())) {
            return FrontResponse.error((String)queryCardInfoRes.getTransactionId(), (String)"0", (String)queryCardInfoResDTO.getResultMsg());
        }
        return FrontResponse.success((String)frontRequest.getTransactionId(), (Object)1);
    }
}

