/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.service.impl;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.his.common.constant.BaseConstant;
import com.ebaiyihui.his.common.enums.EntityKeyEnum;
import com.ebaiyihui.his.common.enums.MethodCodeEnum;
import com.ebaiyihui.his.common.enums.ServiceEnums;
import com.ebaiyihui.his.pojo.dto.GetDeptDoctorReqDTO;
import com.ebaiyihui.his.pojo.dto.GetDeptDoctorResDTO;
import com.ebaiyihui.his.pojo.dto.GetDeptDoctorResItemDTO;
import com.ebaiyihui.his.pojo.dto.GetDocSourceScheduleResDTO;
import com.ebaiyihui.his.pojo.dto.GetScheduleTimInfoResDTO;
import com.ebaiyihui.his.pojo.vo.base.FrontRequest;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import com.ebaiyihui.his.pojo.vo.schedule.GetDeptDoctorInfoReqVO;
import com.ebaiyihui.his.pojo.vo.schedule.GetDeptDoctorInfoResVO;
import com.ebaiyihui.his.pojo.vo.schedule.GetScheduleReqVO;
import com.ebaiyihui.his.pojo.vo.schedule.GetScheduleResVO;
import com.ebaiyihui.his.pojo.vo.schedule.TimeArrangeReq;
import com.ebaiyihui.his.pojo.vo.schedule.TimeArrangeRes;
import com.ebaiyihui.his.pojo.vo.schedule.items.GetDeptDoctorInfoResItems;
import com.ebaiyihui.his.pojo.vo.schedule.items.GetScheduleResItems;
import com.ebaiyihui.his.service.HisRemoteService;
import com.ebaiyihui.his.service.ScheduleService;
import com.ebaiyihui.his.utils.DateUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class ScheduleServiceImpl
implements ScheduleService {
    private static final Logger log = LoggerFactory.getLogger(ScheduleServiceImpl.class);
    @Value(value="${hosp.hospName}")
    private String hospName;
    @Value(value="${hosp.hospCode}")
    private String hospCode;
    @Autowired
    private HisRemoteService hisRemoteService;

    public FrontResponse<GetScheduleResVO> getSchedule(FrontRequest<GetScheduleReqVO> param) {
        GetScheduleResVO getScheduleResVO = new GetScheduleResVO();
        ArrayList<GetScheduleResItems> items = new ArrayList<GetScheduleResItems>();
        HashMap<String, Object> docSourceScheduleMap = new HashMap<String, Object>(1);
        docSourceScheduleMap.put(EntityKeyEnum.DOC_SCHEDULE_SOURCE.getValue(), param.getBody());
        FrontResponse docSourceScheduleRes = this.hisRemoteService.requestHis(ServiceEnums.QUERY_SCHEDULE.getDisplay(), param.getTransactionId(), MethodCodeEnum.DOCTOR_SOURCE_LIST_TIMESLOT.getValue(), docSourceScheduleMap, GetDocSourceScheduleResDTO.class);
        if (null == docSourceScheduleRes) {
            return FrontResponse.error((String)docSourceScheduleRes.getTransactionId(), (String)"0", (String)docSourceScheduleRes.getMessage());
        }
        GetDocSourceScheduleResDTO body = (GetDocSourceScheduleResDTO)docSourceScheduleRes.getBody();
        if (null == body || !"1".equals(body.getState())) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u8c03\u7528\u63a5\u53e3\u5931\u8d25");
        }
        if (!"1".equals(body.getState())) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)body.getError());
        }
        List getOutPatientAdmResItemDTOList = body.getData().getItem();
        if (CollectionUtils.isEmpty((Collection)getOutPatientAdmResItemDTOList)) {
            return FrontResponse.error((String)docSourceScheduleRes.getTransactionId(), (String)"0", (String)"\u8c03\u7528\u63a5\u53e3\u5931\u8d25");
        }
        for (GetDocSourceScheduleResDTO.ItemDTO getDocSourceScheduleResItemDTO : getOutPatientAdmResItemDTOList) {
            GetScheduleResItems getScheduleResItems = new GetScheduleResItems();
            if (getDocSourceScheduleResItemDTO.getScheduleStatus() == 1 || getDocSourceScheduleResItemDTO.getRegAvailable() <= 0 || getDocSourceScheduleResItemDTO.getAdmDate().equals(DateUtil.getCurrentDateStr()) && ScheduleServiceImpl.judgeTime((String)getDocSourceScheduleResItemDTO.getEndTime(), (String)ScheduleServiceImpl.getCurrentTimeNoSecond())) continue;
            BeanUtils.copyProperties((Object)getDocSourceScheduleResItemDTO, (Object)getScheduleResItems);
            GetDocSourceScheduleResDTO.ItemInfoDTO itemInfo = getDocSourceScheduleResItemDTO.getItemInfo();
            getScheduleResItems.setDiagFee(itemInfo.getPreferentialPrice());
            getScheduleResItems.setStartTime(getDocSourceScheduleResItemDTO.getStartTime());
            getScheduleResItems.setEndTime(getDocSourceScheduleResItemDTO.getEndTime());
            getScheduleResItems.setRegFee("0");
            getScheduleResItems.setScheduleStatus(String.valueOf(getDocSourceScheduleResItemDTO.getScheduleStatus()));
            getScheduleResItems.setScheduleType(BaseConstant.Y_IS_TIMEARRANGE);
            getScheduleResItems.setHospitalArea(this.hospName);
            getScheduleResItems.setHospitalAreaCode(this.hospCode);
            getScheduleResItems.setIsTimeArrange(BaseConstant.Y_IS_TIMEARRANGE);
            getScheduleResItems.setAdmLocation(getDocSourceScheduleResItemDTO.getConsultingAddress());
            items.add(getScheduleResItems);
        }
        getScheduleResVO.setItems(items);
        return FrontResponse.success((String)param.getTransactionId(), (Object)getScheduleResVO);
    }

    public FrontResponse<TimeArrangeRes> getTimeInfo(FrontRequest<TimeArrangeReq> param) {
        log.info("\u5206\u65f6\u53f7\u6e90\u4fe1\u606f\u5165\u53c2\uff1a" + JSON.toJSONString(param));
        try {
            TimeArrangeRes timeArrangeRes = new TimeArrangeRes();
            HashMap<String, Object> docSourceScheduleMap = new HashMap<String, Object>(1);
            docSourceScheduleMap.put(EntityKeyEnum.SCHEDULE_SOURCE_TIME.getValue(), param.getBody());
            FrontResponse getTimeInfoRes = this.hisRemoteService.requestHis(ServiceEnums.QUERY_SOURCE.getDisplay(), param.getTransactionId(), MethodCodeEnum.SCHEDULE_SOURCE_TIME.getValue(), docSourceScheduleMap, GetScheduleTimInfoResDTO.class);
            if (null == getTimeInfoRes) {
                return FrontResponse.error((String)getTimeInfoRes.getTransactionId(), (String)"0", (String)getTimeInfoRes.getMessage());
            }
            GetScheduleTimInfoResDTO body = (GetScheduleTimInfoResDTO)getTimeInfoRes.getBody();
            if (null == body) {
                return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u8c03\u7528\u63a5\u53e3\u5931\u8d25");
            }
            if (!"1".equals(((GetScheduleTimInfoResDTO)getTimeInfoRes.getBody()).getState())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)body.getError());
            }
            List item = body.getData().getItem();
            item.removeIf(o -> o.getIsAppointment() == 0);
            item.removeIf(o -> ScheduleServiceImpl.judgeTime((String)o.getStartTime(), (String)ScheduleServiceImpl.getCurrentTimeNoSecond()) && o.getScheduleDate().equals(DateUtil.getCurrentDateStr()));
            timeArrangeRes.setItem(item);
            return FrontResponse.success((String)param.getTransactionId(), (Object)timeArrangeRes);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u5206\u65f6\u53f7\u6e90\u4fe1\u606f\u5f02\u5e38", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u5206\u65f6\u53f7\u6e90\u4fe1\u606f\u5f02\u5e38");
        }
    }

    public static String getCurrentTimeNoSecond() {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat df = new SimpleDateFormat("HH:mm");
        return df.format(calendar.getTime());
    }

    public static boolean judgeTime(String startStr, String endStr) {
        SimpleDateFormat df = new SimpleDateFormat("HH:mm");
        try {
            Date dt1 = df.parse(startStr);
            Date dt2 = df.parse(endStr);
            if (dt1.getTime() < dt2.getTime()) {
                return true;
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return false;
    }

    public FrontResponse<GetDeptDoctorInfoResVO> getDeptDoctorInfo(FrontRequest<GetDeptDoctorInfoReqVO> param) {
        GetDeptDoctorInfoResVO getDeptDoctorInfoResVO = new GetDeptDoctorInfoResVO();
        ArrayList<GetDeptDoctorInfoResItems> items = new ArrayList<GetDeptDoctorInfoResItems>();
        GetDeptDoctorReqDTO getDeptDoctorReqDTO = new GetDeptDoctorReqDTO();
        getDeptDoctorReqDTO.setDeptCode(((GetDeptDoctorInfoReqVO)param.getBody()).getDeptCode());
        HashMap<String, GetDeptDoctorReqDTO> deptDoctorInfo = new HashMap<String, GetDeptDoctorReqDTO>(1);
        deptDoctorInfo.put(EntityKeyEnum.DEPT_DOCTOR_INFO.getValue(), getDeptDoctorReqDTO);
        FrontResponse dtoFrontResponse = this.hisRemoteService.requestHis("", param.getTransactionId(), MethodCodeEnum.REGISTERED_DOCTOR_LIST.getValue(), deptDoctorInfo, GetDeptDoctorResDTO.class);
        if (null == dtoFrontResponse) {
            return FrontResponse.error((String)dtoFrontResponse.getTransactionId(), (String)"0", (String)dtoFrontResponse.getMessage());
        }
        if (!"0".equals(((GetDeptDoctorResDTO)dtoFrontResponse.getBody()).getResultCode())) {
            return FrontResponse.error((String)dtoFrontResponse.getTransactionId(), (String)"0", (String)((GetDeptDoctorResDTO)dtoFrontResponse.getBody()).getResultMsg());
        }
        List getDeptDoctorResItemDTOList = ((GetDeptDoctorResDTO)dtoFrontResponse.getBody()).getItem();
        if (CollectionUtils.isEmpty((Collection)getDeptDoctorResItemDTOList)) {
            return FrontResponse.error((String)dtoFrontResponse.getTransactionId(), (String)"0", (String)((GetDeptDoctorResDTO)dtoFrontResponse.getBody()).getResultMsg());
        }
        for (GetDeptDoctorResItemDTO getDeptDoctorResItemDTO : getDeptDoctorResItemDTOList) {
            GetDeptDoctorInfoResItems getDeptDoctorInfoResItems = new GetDeptDoctorInfoResItems();
            getDeptDoctorInfoResItems.setDoctorCode(getDeptDoctorResItemDTO.getDoctorCode());
            getDeptDoctorInfoResItems.setDoctorName(getDeptDoctorResItemDTO.getDoctorName());
            getDeptDoctorInfoResItems.setDoctorTitle(getDeptDoctorResItemDTO.getDoctorTitle());
            getDeptDoctorInfoResItems.setDoctorTitleCode(getDeptDoctorResItemDTO.getDoctorTitleCode());
            items.add(getDeptDoctorInfoResItems);
        }
        getDeptDoctorInfoResVO.setItems(items);
        return FrontResponse.success((String)param.getTransactionId(), (Object)getDeptDoctorInfoResVO);
    }
}

