/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.service.impl;

import com.ebaiyihui.his.common.enums.EntityKeyEnum;
import com.ebaiyihui.his.common.enums.MethodCodeEnum;
import com.ebaiyihui.his.common.enums.WaitingQueueStatusEnum;
import com.ebaiyihui.his.pojo.dto.GetWaitingQueueReqDTO;
import com.ebaiyihui.his.pojo.dto.GetWaitingQueueResDTO;
import com.ebaiyihui.his.pojo.dto.GetWaitingQueueResItemDTO;
import com.ebaiyihui.his.pojo.dto.WaitingReportReqDTO;
import com.ebaiyihui.his.pojo.vo.base.FrontRequest;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import com.ebaiyihui.his.pojo.vo.wait.GetWaitingQueueReqVO;
import com.ebaiyihui.his.pojo.vo.wait.GetWaitingQueueResVO;
import com.ebaiyihui.his.pojo.vo.wait.WaitingReportReqVO;
import com.ebaiyihui.his.pojo.vo.wait.WaitingReportResVO;
import com.ebaiyihui.his.pojo.vo.wait.items.GetWaitingQueueResItems;
import com.ebaiyihui.his.service.HisRemoteService;
import com.ebaiyihui.his.service.WaitingQueueService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class WaitingQueueServiceImpl
implements WaitingQueueService {
    @Autowired
    private HisRemoteService hisRemoteService;

    public FrontResponse<GetWaitingQueueResVO> getWaitingQueue(FrontRequest<GetWaitingQueueReqVO> param) {
        GetWaitingQueueResVO getWaitingQueueResVO = new GetWaitingQueueResVO();
        ArrayList<GetWaitingQueueResItems> itemList = new ArrayList<GetWaitingQueueResItems>();
        GetWaitingQueueReqDTO getWaitingQueueReqDTO = new GetWaitingQueueReqDTO();
        getWaitingQueueReqDTO.setCardNo(((GetWaitingQueueReqVO)param.getBody()).getCardNo());
        HashMap<String, GetWaitingQueueReqDTO> getWaitingQueueMap = new HashMap<String, GetWaitingQueueReqDTO>(1);
        getWaitingQueueMap.put(EntityKeyEnum.GET_WAITING_QUEUE.getValue(), getWaitingQueueReqDTO);
        FrontResponse waitingQueueRes = this.hisRemoteService.requestHis("", param.getTransactionId(), MethodCodeEnum.PATIENT_QUEUE_INFO_QUERY.getValue(), getWaitingQueueMap, GetWaitingQueueResDTO.class);
        GetWaitingQueueResDTO waitingQueueResDTO = (GetWaitingQueueResDTO)waitingQueueRes.getBody();
        if (null == waitingQueueResDTO) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)waitingQueueRes.getMessage());
        }
        if (!"0".equals(waitingQueueResDTO.getResultCode())) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)waitingQueueResDTO.getResultMsg());
        }
        List waitingQueueResItemDTO = waitingQueueResDTO.getItem();
        if (CollectionUtils.isEmpty((Collection)waitingQueueResItemDTO)) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)waitingQueueResDTO.getResultMsg());
        }
        for (GetWaitingQueueResItemDTO getWaitingQueueResItemDTO : waitingQueueResItemDTO) {
            GetWaitingQueueResItems getWaitingQueueResItems = new GetWaitingQueueResItems();
            BeanUtils.copyProperties((Object)getWaitingQueueResItemDTO, (Object)getWaitingQueueResItems);
            Integer seqNo = Integer.valueOf(getWaitingQueueResItemDTO.getSeqNo());
            getWaitingQueueResItems.setWaitingNum(getWaitingQueueResItemDTO.getSeqNo());
            if (0 < seqNo) {
                getWaitingQueueResItems.setWaitingStatus(WaitingQueueStatusEnum.WAITING.getValue());
            } else if (0 == seqNo) {
                getWaitingQueueResItems.setWaitingStatus(WaitingQueueStatusEnum.ADMING.getValue());
            } else {
                getWaitingQueueResItems.setWaitingStatus(WaitingQueueStatusEnum.ADMEND.getValue());
            }
            itemList.add(getWaitingQueueResItems);
        }
        getWaitingQueueResVO.setItems(itemList);
        return FrontResponse.success((String)param.getTransactionId(), (Object)getWaitingQueueResVO);
    }

    public FrontResponse<WaitingReportResVO> doWaitingReport(FrontRequest<WaitingReportReqVO> param) {
        WaitingReportResVO waitingReportResVO = new WaitingReportResVO();
        WaitingReportReqDTO waitingReportReqDTO = new WaitingReportReqDTO();
        waitingReportReqDTO.setAppointId(((WaitingReportReqVO)param.getBody()).getAppointId());
        HashMap<String, WaitingReportReqDTO> waitingReportMap = new HashMap<String, WaitingReportReqDTO>(1);
        waitingReportMap.put(EntityKeyEnum.WAITING_REPORT.getValue(), waitingReportReqDTO);
        FrontResponse waitingQueueRes = this.hisRemoteService.requestHis("", param.getTransactionId(), MethodCodeEnum.WAITING_REPORT.getValue(), waitingReportMap, GetWaitingQueueResDTO.class);
        GetWaitingQueueResDTO body = (GetWaitingQueueResDTO)waitingQueueRes.getBody();
        if (null == body) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)waitingQueueRes.getMessage());
        }
        if (!"0".equals(body.getResultCode())) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)body.getResultMsg());
        }
        BeanUtils.copyProperties((Object)body, (Object)waitingReportResVO);
        return FrontResponse.success((String)param.getTransactionId(), (Object)waitingReportResVO);
    }
}

