/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.utils;

import java.io.ByteArrayOutputStream;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import org.apache.commons.codec.binary.Base64;

public class RSAUtils {
    public static final String KEY_ALGORITHM = "RSA";
    public static final String SIGNATURE_ALGORITHM = "MD5withRSA";
    private static final String PUBLIC_KEY = "RSAPublicKey";
    private static final String PRIVATE_KEY = "RSAPrivateKey";
    private static final int MAX_ENCRYPT_BLOCK = 117;
    private static final int MAX_DECRYPT_BLOCK = 128;

    public static Map<String, Object> getKenPair() throws Exception {
        KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance(KEY_ALGORITHM);
        keyPairGen.initialize(1024);
        KeyPair keyPair = keyPairGen.generateKeyPair();
        RSAPublicKey publicKey = (RSAPublicKey)keyPair.getPublic();
        RSAPrivateKey privateKey = (RSAPrivateKey)keyPair.getPrivate();
        HashMap<String, Object> keyMap = new HashMap<String, Object>();
        keyMap.put(PUBLIC_KEY, publicKey);
        keyMap.put(PRIVATE_KEY, privateKey);
        return keyMap;
    }

    public static String sign(byte[] data, String privateKey) throws Exception {
        byte[] keyBytes = Base64.decodeBase64((String)privateKey);
        PKCS8EncodedKeySpec pkcs8Encode = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        PrivateKey privateKeyObj = keyFactory.generatePrivate(pkcs8Encode);
        Signature signture = Signature.getInstance(SIGNATURE_ALGORITHM);
        signture.initSign(privateKeyObj);
        signture.update(data);
        return Base64.encodeBase64String((byte[])signture.sign());
    }

    public static boolean verify(byte[] data, String publicKey, String sign) throws Exception {
        byte[] keyBytes = Base64.decodeBase64((String)publicKey);
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        PublicKey publicKeyObj = keyFactory.generatePublic(keySpec);
        Signature signture = Signature.getInstance(SIGNATURE_ALGORITHM);
        signture.initVerify(publicKeyObj);
        signture.update(data);
        return signture.verify(Base64.decodeBase64((String)sign));
    }

    public static byte[] decryptedByPirvateKey(byte[] encryptedData, String privateKey) throws Exception {
        byte[] keyBytes = Base64.decodeBase64((String)privateKey);
        PKCS8EncodedKeySpec pkcs8EncodeSpec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        PrivateKey privateK = keyFactory.generatePrivate(pkcs8EncodeSpec);
        Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
        cipher.init(2, privateK);
        int inputLen = encryptedData.length;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int offset = 0;
        int i = 0;
        while (inputLen - offset > 0) {
            byte[] cache = inputLen - offset > 128 ? cipher.doFinal(encryptedData, offset, 128) : cipher.doFinal(encryptedData, offset, inputLen - offset);
            out.write(cache, 0, cache.length);
            offset = ++i * 128;
        }
        byte[] decrytedData = out.toByteArray();
        out.close();
        return decrytedData;
    }

    public static byte[] decryptedByPublicKey(byte[] encryptedData, String publicKey) throws Exception {
        byte[] keyBytes = Base64.decodeBase64((String)publicKey);
        X509EncodedKeySpec x509EncodeSpec = new X509EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        PublicKey publicKeyObj = keyFactory.generatePublic(x509EncodeSpec);
        Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
        cipher.init(2, publicKeyObj);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int inputLen = encryptedData.length;
        int offset = 0;
        int i = 0;
        while (inputLen - offset > 0) {
            byte[] cache = inputLen - offset > 128 ? cipher.doFinal(encryptedData, offset, 128) : cipher.doFinal(encryptedData, offset, inputLen - offset);
            out.write(cache, 0, cache.length);
            offset = ++i * 128;
        }
        byte[] decryptedData = out.toByteArray();
        out.close();
        return decryptedData;
    }

    public static byte[] encryptedDataByPublicKey(byte[] data, String publicKey) throws Exception {
        byte[] keyBytes = Base64.decodeBase64((String)publicKey);
        X509EncodedKeySpec x509 = new X509EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        PublicKey publicKeyObj = keyFactory.generatePublic(x509);
        Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
        cipher.init(1, publicKeyObj);
        int inputLen = data.length;
        int offset = 0;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int i = 0;
        while (inputLen - offset > 0) {
            byte[] cache = inputLen - offset > 117 ? cipher.doFinal(data, offset, 117) : cipher.doFinal(data, offset, inputLen - offset);
            out.write(cache, 0, cache.length);
            offset = ++i * 117;
        }
        byte[] encryptedData = out.toByteArray();
        out.close();
        return encryptedData;
    }

    public static byte[] encryptedDataByPrivateKey(byte[] data, String privateKey) throws Exception {
        byte[] keyBytes = Base64.decodeBase64((String)privateKey);
        PKCS8EncodedKeySpec pkcs8Spec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        PrivateKey privateKeyObj = keyFactory.generatePrivate(pkcs8Spec);
        Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
        cipher.init(1, privateKeyObj);
        int inputLen = data.length;
        int offset = 0;
        int i = 0;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        while (inputLen - offset > 0) {
            byte[] cache = inputLen - offset > 117 ? cipher.doFinal(data, offset, 117) : cipher.doFinal(data, offset, inputLen - offset);
            out.write(cache, 0, cache.length);
            offset = ++i * 117;
        }
        byte[] encryptedData = out.toByteArray();
        out.close();
        return encryptedData;
    }

    public static String getPrivateKey(Map<String, Object> map) throws Exception {
        Key key = (Key)map.get(PRIVATE_KEY);
        return Base64.encodeBase64String((byte[])key.getEncoded());
    }

    public static String getPublicKey(Map<String, Object> map) throws Exception {
        Key key = (Key)map.get(PUBLIC_KEY);
        return Base64.encodeBase64String((byte[])key.getEncoded());
    }
}

