/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.service.impl;

import cn.hutool.core.date.DateUtil;
import com.ebaiyihui.his.common.enums.HospitalRegionEnum;
import com.ebaiyihui.his.common.enums.TransNoEnum;
import com.ebaiyihui.his.pojo.regulatoryPlatformVo.dto.DrugReqDTO;
import com.ebaiyihui.his.pojo.regulatoryPlatformVo.dto.DrugRequestDTO;
import com.ebaiyihui.his.pojo.regulatoryPlatformVo.dto.HisHeadDTO;
import com.ebaiyihui.his.pojo.regulatoryPlatformVo.dto.QueryDrugsDTO;
import com.ebaiyihui.his.pojo.regulatoryPlatformVo.vo.DrugsResVO;
import com.ebaiyihui.his.pojo.regulatoryPlatformVo.vo.DrugsVO;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import com.ebaiyihui.his.service.DrugService;
import com.ebaiyihui.his.service.HisRemoteService;
import com.ebaiyihui.his.utils.XmlUtil;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DrugServiceImpl
implements DrugService {
    private static final Logger log = LoggerFactory.getLogger(DrugServiceImpl.class);
    @Autowired
    private HisRemoteService hisRemoteService;

    public FrontResponse<List<DrugsResVO>> queryListDrugs(QueryDrugsDTO param) {
        DrugReqDTO drugReqDTO = new DrugReqDTO();
        BeanUtils.copyProperties((Object)param, (Object)drugReqDTO);
        drugReqDTO.setHospitalCode(HospitalRegionEnum.PJ.getValue());
        drugReqDTO.setOperCode("70019");
        drugReqDTO.setOperTime(DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        DrugRequestDTO drugRequestDTO = new DrugRequestDTO();
        HisHeadDTO headDTO = new HisHeadDTO();
        headDTO.setSource("HLWYY");
        headDTO.setTransNo(TransNoEnum.LIST_OF_DRUGS.getValue());
        drugRequestDTO.setHeadDTO(headDTO);
        drugRequestDTO.setDrugReqDTO(drugReqDTO);
        String converTomXml = XmlUtil.converTomXml((Object)drugRequestDTO);
        FrontResponse drugs = this.hisRemoteService.hisNewRequest(TransNoEnum.LIST_OF_DRUGS.getValue(), converTomXml, DrugsVO.class);
        DrugsVO body = (DrugsVO)drugs.getBody();
        if (null == body) {
            return FrontResponse.error((String)drugs.getTransactionId(), (String)"0", (String)body.getHeadVO().getHisReturnVO().getRetCont());
        }
        if (!"1".equals(body.getHeadVO().getHisReturnVO().getRetCode())) {
            return FrontResponse.error((String)drugs.getTransactionId(), (String)"0", (String)body.getHeadVO().getHisReturnVO().getRetCont());
        }
        List drugsResVO = body.getDrugsReqVO().getDrugsResVOS();
        return FrontResponse.success((String)drugs.getTransactionId(), (Object)drugsResVO);
    }
}

