/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.service.impl;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.his.common.enums.TransNoEnum;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import com.ebaiyihui.his.service.HisRemoteService;
import com.ebaiyihui.his.utils.CxfClientUtil;
import com.ebaiyihui.his.utils.XmlTemplateKit;
import com.ebaiyihui.his.utils.XmlUtil;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class HisRemoteServiceImpl
implements HisRemoteService {
    private static final Logger log = LoggerFactory.getLogger(HisRemoteServiceImpl.class);
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${debug}")
    private Boolean debug;

    public <T> FrontResponse<T> requestHis(String transactionId, String methodStr, Map map, Class<T> clazz) {
        String requestHisXml = XmlTemplateKit.process((String)methodStr, (Map)map);
        if (StringUtils.isEmpty((CharSequence)requestHisXml)) {
            return FrontResponse.error((String)transactionId, (String)"0", (String)"\u53c2\u6570\u6a21\u677f\u4e0d\u5b58\u5728");
        }
        String responseHisXml = "";
        responseHisXml = this.debug != false ? XmlTemplateKit.processDebug((String)methodStr) : new CxfClientUtil().send(methodStr, requestHisXml);
        if (StringUtils.isEmpty((CharSequence)responseHisXml)) {
            return FrontResponse.error((String)transactionId, (String)"0", (String)"his\u54cd\u5e94\u7ed3\u679c\u5931\u8d25");
        }
        Object resHisDTO = XmlUtil.convertToJavaBean((String)responseHisXml, clazz);
        this.logger.info("JAXB\u6267\u884c\u7ed3\u679c\uff1a" + JSON.toJSONString((Object)resHisDTO));
        if (null == resHisDTO) {
            return FrontResponse.error((String)transactionId, (String)"0", (String)"JAXB\u6267\u884c\u5931\u8d25");
        }
        return FrontResponse.success((String)transactionId, (Object)resHisDTO);
    }

    public <T> FrontResponse<T> hisRequest(String methodStr, String xml, Class<T> clazz, String decryptName) {
        String responseHisXml = "";
        if (this.debug.booleanValue()) {
            responseHisXml = XmlTemplateKit.processDebug((String)methodStr);
        } else {
            log.info("=================methodStr================>{}", (Object)JSON.toJSONString((Object)methodStr));
            log.info("=================xml================>{}", (Object)JSON.toJSONString((Object)xml));
            responseHisXml = new CxfClientUtil().send(methodStr, xml);
        }
        if (StringUtils.isEmpty((CharSequence)responseHisXml)) {
            return FrontResponse.error((String)methodStr, (String)"0", (String)"his\u54cd\u5e94\u7ed3\u679c\u5931\u8d25");
        }
        String decrypt = XmlUtil.getDecrypt((String)responseHisXml, (String)decryptName);
        String decryptXml = decrypt.substring(decrypt.indexOf("?>") + 2, decrypt.length());
        log.info("=================decryptXml================>{}", (Object)JSON.toJSONString((Object)decryptXml));
        Object resHisDTO = XmlUtil.convertToJavaBean((String)decryptXml, clazz);
        this.logger.info("JAXB\u6267\u884c\u7ed3\u679c\uff1a" + JSON.toJSONString((Object)resHisDTO));
        if (null == resHisDTO) {
            return FrontResponse.error((String)methodStr, (String)"0", (String)"JAXB\u6267\u884c\u5931\u8d25");
        }
        return FrontResponse.success((String)methodStr, (Object)resHisDTO);
    }

    public <T> FrontResponse<T> hisNewRequest(String methodStr, String xml, Class<T> clazz) {
        String responseHisXml = "";
        if (this.debug.booleanValue()) {
            responseHisXml = XmlTemplateKit.processDebug((String)methodStr);
        } else {
            log.info("=================methodStr================>{}", (Object)JSON.toJSONString((Object)methodStr));
            responseHisXml = new CxfClientUtil().newSend(methodStr, xml);
        }
        if (StringUtils.isEmpty((CharSequence)responseHisXml)) {
            return FrontResponse.error((String)methodStr, (String)"0", (String)"his\u54cd\u5e94\u7ed3\u679c\u5931\u8d25");
        }
        if (methodStr.equals(TransNoEnum.HIS_QUERY_JCYY.getValue()) || methodStr.equals(TransNoEnum.HIS_QUERY_YYSD.getValue()) || methodStr.equals(TransNoEnum.HIS_UPDATE_YYSJXG.getValue()) || methodStr.equals("HSC0348") || methodStr.equals("HSC0339")) {
            responseHisXml = responseHisXml.replace("&lt;", "<");
            responseHisXml = responseHisXml.replace("&gt;", ">");
            responseHisXml = responseHisXml.replace("</ns:return>", "");
            responseHisXml = responseHisXml.replace("<ns:return>", "");
            responseHisXml = responseHisXml.replace("<return>", "");
            responseHisXml = responseHisXml.replace("<Return>", "");
            responseHisXml = responseHisXml.replace("</return>", "");
            responseHisXml = responseHisXml.replace("</Return>", "");
            responseHisXml = responseHisXml.replace("</ns2:callResponse>", "");
            responseHisXml = responseHisXml.replace("</ns:selfServiceResponse>", "");
            responseHisXml = responseHisXml.replace("\n", "");
            responseHisXml = responseHisXml.replace("\\", "");
            responseHisXml = responseHisXml.replace("&amp;amp;lt;", "");
            responseHisXml = responseHisXml.replace("&amp;amp;gt;", "");
            responseHisXml = responseHisXml.replace("\u25a1", "");
            responseHisXml = responseHisXml.replace("&amp;#xD", "");
            responseHisXml = responseHisXml.replace("&#xD", "");
            responseHisXml = responseHisXml.replace("<ns:selfServiceResponse xmlns:ns=\"http://service.webservice.yy.dc.com\">", "");
            responseHisXml = responseHisXml.replace("<ns2:callResponse xmlns:ns2=\"http://firstHospitalOfSoochowUniversity.dataplatform.service\">", "");
        }
        Object resHisDTO = XmlUtil.convertToJavaBean((String)responseHisXml, clazz);
        this.logger.info("JAXB\u6267\u884c\u7ed3\u679c\uff1a" + JSON.toJSONString((Object)resHisDTO));
        if (null == resHisDTO) {
            return FrontResponse.error((String)methodStr, (String)"0", (String)"JAXB\u6267\u884c\u5931\u8d25");
        }
        return FrontResponse.success((String)methodStr, (Object)resHisDTO);
    }

    static {
        XmlTemplateKit.init();
    }
}

