/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.service.impl;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.ebaiyihui.his.common.enums.EntityKeyEnum;
import com.ebaiyihui.his.common.enums.HospitalRegionEnum;
import com.ebaiyihui.his.common.enums.MethodNameEnum;
import com.ebaiyihui.his.common.enums.TransNoEnum;
import com.ebaiyihui.his.pojo.dto.RequestHisDTO;
import com.ebaiyihui.his.pojo.hospitalization.vo.FeeBreakdownFee;
import com.ebaiyihui.his.pojo.hospitalization.vo.FeeBreakdownResVo;
import com.ebaiyihui.his.pojo.hospitalization.vo.FeeBreakdownVo;
import com.ebaiyihui.his.pojo.hospitalization.vo.RechargeRecordResVo;
import com.ebaiyihui.his.pojo.hospitalization.vo.RechargeRecordVo;
import com.ebaiyihui.his.pojo.hospitalization.vo.RechargeRecordsVo;
import com.ebaiyihui.his.pojo.hospitalization.vo.TotalCostInquiryResVO;
import com.ebaiyihui.his.pojo.hospitalization.vo.TotalCostInquiryVO;
import com.ebaiyihui.his.pojo.hospitalization.vo.prepaidDepositResVo;
import com.ebaiyihui.his.pojo.hospitalization.vo.prepaidDepositTopVo;
import com.ebaiyihui.his.pojo.regulatoryPlatformVo.dto.HisHeadDTO;
import com.ebaiyihui.his.pojo.regulatoryPlatformVo.vo.InpatientInformationResVo;
import com.ebaiyihui.his.pojo.regulatoryPlatformVo.vo.InpatientInformationVo;
import com.ebaiyihui.his.pojo.vo.base.FrontRequest;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import com.ebaiyihui.his.pojo.vo.hospitalization.DepositReq;
import com.ebaiyihui.his.pojo.vo.hospitalization.DepositRes;
import com.ebaiyihui.his.pojo.vo.hospitalization.GetIPDepositRecordsReq;
import com.ebaiyihui.his.pojo.vo.hospitalization.GetIPDepositRecordsRes;
import com.ebaiyihui.his.pojo.vo.hospitalization.GetInpAdmissionReq;
import com.ebaiyihui.his.pojo.vo.hospitalization.GetInpAdmissionRes;
import com.ebaiyihui.his.pojo.vo.hospitalization.GetInpDetailReq;
import com.ebaiyihui.his.pojo.vo.hospitalization.GetOrdItemsReq;
import com.ebaiyihui.his.pojo.vo.hospitalization.GetOrdItemsRes;
import com.ebaiyihui.his.pojo.vo.hospitalization.RechargeRecordReq;
import com.ebaiyihui.his.pojo.vo.hospitalization.TotalCostInquiryFeedetailReq;
import com.ebaiyihui.his.pojo.vo.hospitalization.TotalCostInquiryReq;
import com.ebaiyihui.his.pojo.vo.hospitalization.items.GetIPDepositRecordsItems;
import com.ebaiyihui.his.pojo.vo.hospitalization.items.GetInpAdmissionResItems;
import com.ebaiyihui.his.pojo.vo.hospitalization.items.GetOrdItemsResItemsDetail;
import com.ebaiyihui.his.pojo.vo.hospitalization.prepaidDepositReq;
import com.ebaiyihui.his.service.HisRemoteService;
import com.ebaiyihui.his.service.HospitalizationService;
import com.ebaiyihui.his.utils.CxfClientUtil;
import com.ebaiyihui.his.utils.SdyUtils;
import com.ebaiyihui.his.utils.XmlTemplateKit;
import com.ebaiyihui.his.utils.XmlUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HospitalizationServiceImpl
implements HospitalizationService {
    private static final Logger log = LoggerFactory.getLogger(HospitalizationServiceImpl.class);
    public static final String HIS_OUT_HOSP_STATUS = "1";
    public static final String BYH_OUT_HOSP_STATUS = "D";
    public static final String BYH_IN_HOSP_STATUS = "A";
    public static final int MAP_SIZE = 1;
    public static final String SUCCESS_FLAG = "0";
    private static final String PAY_SUCCESS = "Y";
    private static final String PAY_FAIL = "N";
    private static final String HIS_PAY_SUCCESS = "SUCCESS";
    private static final String HIS_PAY_FAIL = "FAIL";
    @Autowired
    private HisRemoteService hisRemoteService;

    public FrontResponse<GetInpAdmissionRes> getInpAdmission(FrontRequest<GetInpAdmissionReq> param) {
        try {
            GetInpAdmissionReq body = (GetInpAdmissionReq)param.getBody();
            GetInpDetailReq hisReq = new GetInpDetailReq();
            hisReq.setHospitalCode(body.getHospitalCode());
            hisReq.setCertNo(body.getCredNo());
            hisReq.setOperCode("70019");
            hisReq.setOperTime(DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
            HashMap<String, GetInpDetailReq> map = new HashMap<String, GetInpDetailReq>();
            map.put(EntityKeyEnum.GET_INP_ADMISSION.getValue(), hisReq);
            String requestHisXml = XmlTemplateKit.process((String)MethodNameEnum.GET_INP_ADMISSION.getValue(), map);
            log.info("XML===>" + requestHisXml);
            String hisRes = new CxfClientUtil().newSend(TransNoEnum.INPATIENT_INFORMATION_INQUIRY.getValue(), requestHisXml);
            hisRes = SdyUtils.getStr((String)hisRes);
            log.info("his\u51fa\u53c2\uff1a" + hisRes);
            InpatientInformationVo response = (InpatientInformationVo)XmlUtil.convertToJavaBean((String)hisRes, InpatientInformationVo.class);
            log.info("his\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)response));
            InpatientInformationResVo inpatientInformationResVo = response.getInpatientInformationResVo();
            if (!HIS_OUT_HOSP_STATUS.equals(response.getHeadVO().getHisReturnVO().getRetCode())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)response.getHeadVO().getHisReturnVO().getRetCont());
            }
            GetInpAdmissionRes getInpAdmissionRes = new GetInpAdmissionRes();
            ArrayList<GetInpAdmissionResItems> items = new ArrayList<GetInpAdmissionResItems>();
            GetInpAdmissionResItems getInpAdmissionResItems = new GetInpAdmissionResItems();
            getInpAdmissionResItems.setDeptName(inpatientInformationResVo.getDeptName());
            getInpAdmissionResItems.setBed(inpatientInformationResVo.getBedNo());
            getInpAdmissionResItems.setDocName(inpatientInformationResVo.getDoctorName());
            getInpAdmissionResItems.setCardNo(inpatientInformationResVo.getPID());
            getInpAdmissionResItems.setStartDate(inpatientInformationResVo.getAdmissDate());
            getInpAdmissionResItems.setNursingUnit(inpatientInformationResVo.getWardName());
            getInpAdmissionResItems.setPatientId(inpatientInformationResVo.getPID());
            getInpAdmissionResItems.setPatientName(inpatientInformationResVo.getPatientName());
            getInpAdmissionResItems.setInHospNo(inpatientInformationResVo.getIPID());
            getInpAdmissionResItems.setCurrentMoney(String.valueOf(new BigDecimal(inpatientInformationResVo.getAccount()).setScale(2, 1)));
            getInpAdmissionResItems.setTotalMoney(String.valueOf(new BigDecimal(inpatientInformationResVo.getTotalCharge()).setScale(2, 1)));
            BigDecimal subtract = new BigDecimal(getInpAdmissionResItems.getCurrentMoney()).add(new BigDecimal(getInpAdmissionResItems.getTotalMoney()));
            getInpAdmissionResItems.setDepost(String.valueOf(subtract));
            items.add(getInpAdmissionResItems);
            getInpAdmissionRes.setItems(items);
            return FrontResponse.success((String)param.getTransactionId(), (Object)getInpAdmissionRes);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u67e5\u8be2\u68c0\u67e5\u62a5\u544a\u8be6\u60c5\u5f02\u5e38{}", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u4f4f\u9662\u5c31\u8bca\u4fe1\u606f\u67e5\u8be2\u5f02\u5e38");
        }
    }

    public FrontResponse<InpatientInformationResVo> getInpDetail(FrontRequest<GetInpDetailReq> param) {
        String transNo = TransNoEnum.INPATIENT_INFORMATION_INQUIRY.getValue();
        ((GetInpDetailReq)param.getBody()).setHospitalCode(HospitalRegionEnum.PJ.getValue());
        ((GetInpDetailReq)param.getBody()).setOperCode("70019");
        ((GetInpDetailReq)param.getBody()).setOperTime(DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        RequestHisDTO reqRequestHis = new RequestHisDTO();
        HisHeadDTO headDTO = new HisHeadDTO();
        headDTO.setSource("HLWYY");
        headDTO.setTransNo(transNo);
        reqRequestHis.setHeadDTO(headDTO);
        reqRequestHis.setData(param.getBody());
        String converTomXml = XmlUtil.converTomXml((Object)reqRequestHis);
        FrontResponse queryDiagnosticInfoVORes = this.hisRemoteService.hisNewRequest(transNo, converTomXml, InpatientInformationVo.class);
        InpatientInformationVo queryDiagnosticInfoVOResBody = (InpatientInformationVo)queryDiagnosticInfoVORes.getBody();
        if (!HIS_OUT_HOSP_STATUS.equals(queryDiagnosticInfoVOResBody.getHeadVO().getHisReturnVO().getRetCode())) {
            return FrontResponse.error((String)queryDiagnosticInfoVORes.getTransactionId(), (String)SUCCESS_FLAG, (String)queryDiagnosticInfoVOResBody.getHeadVO().getHisReturnVO().getRetCont());
        }
        return FrontResponse.success((String)queryDiagnosticInfoVORes.getTransactionId(), (Object)queryDiagnosticInfoVOResBody.getInpatientInformationResVo());
    }

    public FrontResponse<TotalCostInquiryResVO> totalCostInquiry(FrontRequest<TotalCostInquiryReq> param) {
        TotalCostInquiryReq body = (TotalCostInquiryReq)param.getBody();
        body.setOperCode("70019");
        body.setOperTime(DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        HashMap<String, TotalCostInquiryReq> map = new HashMap<String, TotalCostInquiryReq>();
        map.put(EntityKeyEnum.GET_INP_TOTALFEE.getValue(), body);
        String requestHisXml = XmlTemplateKit.process((String)MethodNameEnum.GET_INP_TOTALFEE.getValue(), map);
        log.info("XML===>" + requestHisXml);
        String hisRes = new CxfClientUtil().newSend(TransNoEnum.TOTAL_COST_INQUIRY.getValue(), requestHisXml);
        hisRes = SdyUtils.getStr((String)hisRes);
        log.info("his\u51fa\u53c2\uff1a" + hisRes);
        TotalCostInquiryVO queryDiagnosticInfoVORes = (TotalCostInquiryVO)XmlUtil.convertToJavaBean((String)hisRes, TotalCostInquiryVO.class);
        if (!HIS_OUT_HOSP_STATUS.equals(queryDiagnosticInfoVORes.getHeadVO().getHisReturnVO().getRetCode())) {
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)queryDiagnosticInfoVORes.getHeadVO().getHisReturnVO().getRetCont());
        }
        return FrontResponse.success((String)param.getTransactionId(), (Object)queryDiagnosticInfoVORes.getTotalCostInquiryResVO());
    }

    public FrontResponse<FeeBreakdownResVo> inpatientBreakdownFeeInquiry(FrontRequest<TotalCostInquiryFeedetailReq> param) {
        String transNo = TransNoEnum.INPATIENT_BREAKDOWN_FEE_INQUIRY.getValue();
        ((TotalCostInquiryFeedetailReq)param.getBody()).setHospitalCode(HospitalRegionEnum.PJ.getValue());
        ((TotalCostInquiryFeedetailReq)param.getBody()).setOperCode("70019");
        ((TotalCostInquiryFeedetailReq)param.getBody()).setOperTime(DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        RequestHisDTO reqRequestHis = new RequestHisDTO();
        HisHeadDTO headDTO = new HisHeadDTO();
        headDTO.setSource("HLWYY");
        headDTO.setTransNo(transNo);
        reqRequestHis.setHeadDTO(headDTO);
        reqRequestHis.setData(param.getBody());
        String converTomXml = XmlUtil.converTomXml((Object)reqRequestHis);
        FrontResponse queryDiagnosticInfoVORes = this.hisRemoteService.hisNewRequest(transNo, converTomXml, FeeBreakdownVo.class);
        FeeBreakdownVo body = (FeeBreakdownVo)queryDiagnosticInfoVORes.getBody();
        if (!HIS_OUT_HOSP_STATUS.equals(body.getHeadVO().getHisReturnVO().getRetCode())) {
            return FrontResponse.error((String)queryDiagnosticInfoVORes.getTransactionId(), (String)SUCCESS_FLAG, (String)body.getHeadVO().getHisReturnVO().getRetCont());
        }
        return FrontResponse.success((String)queryDiagnosticInfoVORes.getTransactionId(), (Object)body.getTotalCostInquiryResVO());
    }

    public FrontResponse<RechargeRecordResVo> rechargeRecordQuery(FrontRequest<RechargeRecordReq> param) {
        String transNo = TransNoEnum.INQUIRY_PREPAID_DEPOSIT_RECORDS.getValue();
        ((RechargeRecordReq)param.getBody()).setHospitalCode(HospitalRegionEnum.PJ.getValue());
        ((RechargeRecordReq)param.getBody()).setOperCode("70019");
        ((RechargeRecordReq)param.getBody()).setOperTime(DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        RequestHisDTO reqRequestHis = new RequestHisDTO();
        HisHeadDTO headDTO = new HisHeadDTO();
        headDTO.setSource("HLWYY");
        headDTO.setTransNo(transNo);
        reqRequestHis.setHeadDTO(headDTO);
        reqRequestHis.setData(param.getBody());
        String converTomXml = XmlUtil.converTomXml((Object)reqRequestHis);
        FrontResponse queryDiagnosticInfoVORes = this.hisRemoteService.hisNewRequest(transNo, converTomXml, RechargeRecordVo.class);
        RechargeRecordVo body = (RechargeRecordVo)queryDiagnosticInfoVORes.getBody();
        if (!HIS_OUT_HOSP_STATUS.equals(body.getHeadVO().getHisReturnVO().getRetCode())) {
            return FrontResponse.error((String)queryDiagnosticInfoVORes.getTransactionId(), (String)SUCCESS_FLAG, (String)body.getHeadVO().getHisReturnVO().getRetCont());
        }
        return FrontResponse.success((String)queryDiagnosticInfoVORes.getTransactionId(), (Object)body.getRechargeRecordResVo());
    }

    public FrontResponse<prepaidDepositResVo> prepaidDepositResVo(FrontRequest<prepaidDepositReq> param) {
        String transNo = TransNoEnum.PREPAID_DEPOSIT_TOP_UP.getValue();
        ((prepaidDepositReq)param.getBody()).setHospitalCode(HospitalRegionEnum.PJ.getValue());
        ((prepaidDepositReq)param.getBody()).setOperCode("70019");
        ((prepaidDepositReq)param.getBody()).setOperTime(DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        RequestHisDTO reqRequestHis = new RequestHisDTO();
        HisHeadDTO headDTO = new HisHeadDTO();
        headDTO.setSource("HLWYY");
        headDTO.setTransNo(transNo);
        reqRequestHis.setHeadDTO(headDTO);
        reqRequestHis.setData(param.getBody());
        String converTomXml = XmlUtil.converTomXml((Object)reqRequestHis);
        FrontResponse queryDiagnosticInfoVORes = this.hisRemoteService.hisNewRequest(transNo, converTomXml, prepaidDepositTopVo.class);
        prepaidDepositTopVo body = (prepaidDepositTopVo)queryDiagnosticInfoVORes.getBody();
        if (!HIS_OUT_HOSP_STATUS.equals(body.getHeadVO().getHisReturnVO().getRetCode())) {
            return FrontResponse.error((String)queryDiagnosticInfoVORes.getTransactionId(), (String)SUCCESS_FLAG, (String)body.getHeadVO().getHisReturnVO().getRetCont());
        }
        return FrontResponse.success((String)queryDiagnosticInfoVORes.getTransactionId(), (Object)body.getPrepaidDepositResVo());
    }

    public FrontResponse<DepositRes> deposit(FrontRequest<DepositReq> param) {
        try {
            DepositReq body = (DepositReq)param.getBody();
            body.getRespmsg().setBusinessCode("70019");
            body.getRespmsg().setAccDate(DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
            HashMap<String, DepositReq> map = new HashMap<String, DepositReq>();
            map.put(EntityKeyEnum.IN_HOSP_DEPOSIT.getValue(), body);
            String requestHisXml = XmlTemplateKit.process((String)MethodNameEnum.GET_INP_ADMISSION_PAY.getValue(), map);
            log.info("XML===>" + requestHisXml);
            String hisRes = new CxfClientUtil().newSend(TransNoEnum.PREPAID_DEPOSIT_TOP_UP.getValue(), requestHisXml);
            hisRes = SdyUtils.getStr((String)hisRes);
            log.info("his\u51fa\u53c2\uff1a" + hisRes);
            prepaidDepositTopVo response = (prepaidDepositTopVo)XmlUtil.convertToJavaBean((String)hisRes, prepaidDepositTopVo.class);
            log.info("his\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)response));
            prepaidDepositResVo prepaidDepositResVo2 = response.getPrepaidDepositResVo();
            if (!HIS_OUT_HOSP_STATUS.equals(response.getHeadVO().getHisReturnVO().getRetCode())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)response.getHeadVO().getHisReturnVO().getRetCont());
            }
            DepositRes depositRes = new DepositRes();
            depositRes.setReceiptId(prepaidDepositResVo2.getReceiptNo());
            return FrontResponse.success((String)param.getTransactionId(), (Object)depositRes);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u4f4f\u9662\u9884\u4ea4\u91d1\u5145\u503c\u5f02\u5e38{}", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u4f4f\u9662\u9884\u4ea4\u91d1\u5145\u503c\u5f02\u5e38");
        }
    }

    public FrontResponse<GetIPDepositRecordsRes> getIPDepositRecords(FrontRequest<GetIPDepositRecordsReq> param) {
        try {
            GetIPDepositRecordsReq body = (GetIPDepositRecordsReq)param.getBody();
            body.setOperCode("70019");
            body.setOperTime(DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
            HashMap<String, GetIPDepositRecordsReq> map = new HashMap<String, GetIPDepositRecordsReq>();
            map.put(EntityKeyEnum.GET_IP_DEPOSIT_RECORDS.getValue(), body);
            String requestHisXml = XmlTemplateKit.process((String)MethodNameEnum.GET_INP_ADMISSION_PAY_RECORD.getValue(), map);
            log.info("XML===>" + requestHisXml);
            String hisRes = new CxfClientUtil().newSend(TransNoEnum.INQUIRY_PREPAID_DEPOSIT_RECORDS.getValue(), requestHisXml);
            hisRes = SdyUtils.getStr((String)hisRes);
            log.info("his\u51fa\u53c2\uff1a" + hisRes);
            RechargeRecordVo response = (RechargeRecordVo)XmlUtil.convertToJavaBean((String)hisRes, RechargeRecordVo.class);
            log.info("his\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)response));
            List records = response.getRechargeRecordResVo().getRecords();
            if (records.size() <= 0) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)response.getHeadVO().getHisReturnVO().getRetCont());
            }
            if (!HIS_OUT_HOSP_STATUS.equals(response.getHeadVO().getHisReturnVO().getRetCode())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)response.getHeadVO().getHisReturnVO().getRetCont());
            }
            GetIPDepositRecordsRes getIPDepositRecordsRes = new GetIPDepositRecordsRes();
            ArrayList<GetIPDepositRecordsItems> items = new ArrayList<GetIPDepositRecordsItems>();
            for (RechargeRecordsVo itemResDTO : records) {
                GetIPDepositRecordsItems getIPDepositRecordsItems = new GetIPDepositRecordsItems();
                getIPDepositRecordsItems.setPrePayDateTime(itemResDTO.getOperTime());
                getIPDepositRecordsItems.setAmout(itemResDTO.getAmount());
                getIPDepositRecordsItems.setPayChannel(itemResDTO.getPayType());
                items.add(getIPDepositRecordsItems);
            }
            getIPDepositRecordsRes.setItems(items);
            return FrontResponse.success((String)param.getTransactionId(), (Object)getIPDepositRecordsRes);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u4f4f\u9662\u9884\u4ea4\u91d1\u660e\u7ec6\u67e5\u8be2\u5f02\u5e38{}", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u4f4f\u9662\u9884\u4ea4\u91d1\u660e\u7ec6\u67e5\u8be2\u5f02\u5e38");
        }
    }

    public FrontResponse<GetOrdItemsRes> getOrdItems(FrontRequest<GetOrdItemsReq> param) {
        try {
            GetOrdItemsReq body = (GetOrdItemsReq)param.getBody();
            body.setOperCode("70019");
            body.setOperTime(DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
            HashMap<String, GetOrdItemsReq> map = new HashMap<String, GetOrdItemsReq>();
            map.put(EntityKeyEnum.IN_HOSP_FEE_DETAIL.getValue(), body);
            String requestHisXml = XmlTemplateKit.process((String)MethodNameEnum.GET_INP_ADMISSION_DETIL.getValue(), map);
            log.info("XML===>" + requestHisXml);
            String hisRes = new CxfClientUtil().newSend(TransNoEnum.INPATIENT_BREAKDOWN_FEE_INQUIRY.getValue(), requestHisXml);
            hisRes = SdyUtils.getStr((String)hisRes);
            log.info("his\u51fa\u53c2\uff1a" + hisRes);
            FeeBreakdownVo response = (FeeBreakdownVo)XmlUtil.convertToJavaBean((String)hisRes, FeeBreakdownVo.class);
            log.info("his\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)response));
            List records = response.getTotalCostInquiryResVO().getFeeObject();
            if (records.size() <= 0) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)response.getHeadVO().getHisReturnVO().getRetCont());
            }
            if (!HIS_OUT_HOSP_STATUS.equals(response.getHeadVO().getHisReturnVO().getRetCode())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)response.getHeadVO().getHisReturnVO().getRetCont());
            }
            GetOrdItemsRes getOrdItemsRes = new GetOrdItemsRes();
            ArrayList<GetOrdItemsResItemsDetail> getOrdItemsResItemsList = new ArrayList<GetOrdItemsResItemsDetail>();
            for (FeeBreakdownFee itemResDTO : records) {
                GetOrdItemsResItemsDetail getOrdItemsResItems = new GetOrdItemsResItemsDetail();
                getOrdItemsResItems.setFeeType(itemResDTO.getFeeName());
                getOrdItemsResItems.setItmMastName(itemResDTO.getItemName());
                getOrdItemsResItems.setQty(itemResDTO.getQty());
                getOrdItemsResItems.setPrice(String.valueOf(new BigDecimal(itemResDTO.getUnitPrice()).setScale(2, 1)));
                getOrdItemsResItems.setAmount(itemResDTO.getTotCost());
                getOrdItemsResItemsList.add(getOrdItemsResItems);
            }
            getOrdItemsRes.setDetail(getOrdItemsResItemsList);
            getOrdItemsRes.setName(response.getTotalCostInquiryResVO().getPatientName());
            getOrdItemsRes.setInHospNo(response.getTotalCostInquiryResVO().getIpId());
            return FrontResponse.success((String)param.getTransactionId(), (Object)getOrdItemsRes);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u4f4f\u9662\u8d39\u7528\u6e05\u5355\u67e5\u8be2\u5f02\u5e38{}", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u4f4f\u9662\u8d39\u7528\u6e05\u5355\u67e5\u8be2\u67e5\u8be2\u5f02\u5e38");
        }
    }
}

