/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.service.impl;

import com.ebaiyihui.his.pojo.regulatoryPlatformVo.dto.OutReachResVO;
import com.ebaiyihui.his.pojo.regulatoryPlatformVo.vo.HisReturnVO;
import com.ebaiyihui.his.service.MedicalOrderService;
import com.ebaiyihui.his.service.OutReachService;
import com.ebaiyihui.his.utils.XmlUtil;
import javax.jws.WebService;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.jaxws.endpoint.dynamic.JaxWsDynamicClientFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;

@WebService(serviceName="OutReachService", targetNamespace="http://service.his.ebaiyihui.com/", endpointInterface="com.ebaiyihui.his.service.OutReachService")
@Component
@Service
public class OutReachServiceImpl
implements OutReachService {
    private static final Logger log = LoggerFactory.getLogger(OutReachServiceImpl.class);
    private final MedicalOrderService prescriptionService;

    public String HIPMesssageServer(String message) {
        OutReachResVO outReachResVO = new OutReachResVO();
        OutReachResVO.ReturnDTO returnDTO = new OutReachResVO.ReturnDTO();
        HisReturnVO head = new HisReturnVO();
        head.setRetType("1");
        head.setTransNo("HTIP.CM.STATUS.0001");
        head.setSource("HIS");
        head.setRetCode("1");
        log.info("message->{}", (Object)message);
        try {
            HisReturnVO hisReturnVO = this.prescriptionService.addOrders(message);
            head.setRetCode(hisReturnVO.getRetCode());
            head.setRetCont(hisReturnVO.getRetCont());
        }
        catch (Exception e) {
            head.setRetCode("0");
            head.setRetCont(e.getMessage());
            returnDTO.setHead(head);
            outReachResVO.setReturnDTO(returnDTO);
            return XmlUtil.convertToXml((Object)outReachResVO);
        }
        returnDTO.setHead(head);
        outReachResVO.setReturnDTO(returnDTO);
        return XmlUtil.convertToXml((Object)outReachResVO);
    }

    public static void main(String[] args) throws Exception {
        JaxWsDynamicClientFactory dcflient = JaxWsDynamicClientFactory.newInstance();
        Client client = dcflient.createClient("http://localhost:9095/outReach/OutReachService.asmx?wsdl");
        String s = "<Request>\n    <Head>\n        <Userid></Userid>\n        <Password></Password>\n        <Source>LIS</Source>\n        <TransNo>HTIP.CM.STATUS.0001</TransNo>\n    </Head>\n    <Body>\n        <AppStatuss>\n            <RecordFlow>HLW171689008128096467520</RecordFlow>\n            <OrderSn>16377194812120169142</OrderSn>\n            <ApplyFlow>05726012584130</ApplyFlow>\n            <HospitalCode>pj</HospitalCode>\n            <TreatTypeCode>i</TreatTypeCode>\n            <TreatType>\u4f4f\u9662</TreatType>\n            <TreatTimes>1</TreatTimes>\n            <IPID>6364908</IPID>\n            <OPID/>\n            <EPID/>\n            <PID>0003706564</PID>\n            <PatientName>\u738b\u63f4\u671d</PatientName>\n            <OrderType>JY</OrderType>\n            <OrderStatus/>\n            <Status>CC</Status>\n            <TypeCode>\u68c0\u9a8c</TypeCode>\n            <OrderStatusTime/>\n            <OperatorID>83738</OperatorID>\n            <OperatorName>\u5f20\u653f</OperatorName>\n            <OperateTime>20211124103424</OperateTime>\n        </AppStatuss>\n        <AppStatuss>\n            <RecordFlow>171689008128096466966</RecordFlow>\n            <OrderSn>16377194812120171815</OrderSn>\n            <ApplyFlow>05726012585251</ApplyFlow>\n            <HospitalCode>pj</HospitalCode>\n            <TreatTypeCode>i</TreatTypeCode>\n            <TreatType>\u4f4f\u9662</TreatType>\n            <TreatTimes>1</TreatTimes>\n            <IPID>6364908</IPID>\n            <OPID/>\n            <EPID/>\n            <PID>0003706564</PID>\n            <PatientName>\u738b\u63f4\u671d</PatientName>\n            <OrderType>JY</OrderType>\n            <OrderStatus/>\n            <Status>CC</Status>\n            <TypeCode>\u68c0\u9a8c</TypeCode>\n            <OrderStatusTime/>\n            <OperatorID>83738</OperatorID>\n            <OperatorName>\u5f20\u653f</OperatorName>\n            <OperateTime>20211124103424</OperateTime>\n        </AppStatuss>\n    </Body>\n</Request>";
        Object[] objects = client.invoke("HIPMesssageServer", new Object[]{s});
        System.out.println("*******" + objects[0].toString());
    }

    @Autowired
    public OutReachServiceImpl(MedicalOrderService prescriptionService) {
        this.prescriptionService = prescriptionService;
    }
}

