/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.his.common.enums.PayApiTypeEnum;
import com.ebaiyihui.his.common.enums.ProductCodeEnum;
import com.ebaiyihui.his.config.NodeConfig;
import com.ebaiyihui.his.pojo.paymentPlatforms.dto.PayOrderDTO;
import com.ebaiyihui.his.pojo.paymentPlatforms.dto.PaymentRefundDTO;
import com.ebaiyihui.his.pojo.paymentPlatforms.dto.PaymentResultsDTO;
import com.ebaiyihui.his.pojo.paymentPlatforms.vo.PayOrderVO;
import com.ebaiyihui.his.pojo.paymentPlatforms.vo.PaymentInquiryVO;
import com.ebaiyihui.his.pojo.paymentPlatforms.vo.PaymentPlatformsFoundationVO;
import com.ebaiyihui.his.pojo.paymentPlatforms.vo.PaymentRefundVO;
import com.ebaiyihui.his.pojo.paymentPlatforms.vo.PaymentResultRefundVO;
import com.ebaiyihui.his.service.PaymentPlatformsService;
import com.ebaiyihui.his.utils.HttpUtils;
import com.ebaiyihui.his.utils.HttpsClient;
import com.ebaiyihui.his.utils.SignUtil;
import com.ebaiyihui.his.utils.des.AESUtil;
import com.ebaiyihui.his.utils.des.ThreeDESUtils;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PaymentPlatformsServiceImpl
implements PaymentPlatformsService {
    private static final Logger log = LoggerFactory.getLogger(PaymentPlatformsServiceImpl.class);
    @Autowired
    private NodeConfig nodeConfig;
    public static final String SUCCEED_CODE = "RMP0000";

    public BaseResponse<PayOrderDTO> payment(PayOrderVO payVO) {
        String paramBody;
        if (StringUtils.isEmpty((String)payVO.getDesc())) {
            payVO.setDesc("");
        }
        if (StringUtils.isEmpty((String)payVO.getBsOrdNo())) {
            payVO.setBsOrdNo("");
        }
        log.info("\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)payVO);
        payVO.setCashierNo("wechatMini");
        payVO.setCashierName("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f");
        Map map = SignUtil.getKeyAndValue((Object)payVO);
        String jsonBody = JSON.toJSONString((Object)payVO);
        PaymentPlatformsFoundationVO paymentPlatformsFoundationVO = new PaymentPlatformsFoundationVO();
        paymentPlatformsFoundationVO.setApiId(PayApiTypeEnum.ORDER_THE_INTERFACE.getValue());
        paymentPlatformsFoundationVO.setProductCode(ProductCodeEnum.WECHATPAY_MINI.getValue());
        try {
            paramBody = this.sendPaymentPlatforms(map, jsonBody, paymentPlatformsFoundationVO);
        }
        catch (Exception e) {
            return BaseResponse.error((String)e.getMessage());
        }
        log.info("\u3010\u5c0f\u7a0b\u5e8f\u652f\u4ed8\u4e0b\u5355\u63a5\u53e3\u3011\u652f\u4ed8\u5e73\u53f0\u89e3\u5bc6\u540e\u6570\u636e{}", (Object)paramBody);
        PayOrderDTO payDTO = (PayOrderDTO)JSON.parseObject((String)paramBody, PayOrderDTO.class);
        payDTO.setPackageValue((String)JSON.parseObject((String)paramBody).get((Object)"package"));
        return BaseResponse.success((Object)payDTO);
    }

    public BaseResponse<PayOrderDTO> paymentV2(PayOrderVO payVO) {
        String paramBody;
        if (StringUtils.isEmpty((String)payVO.getDesc())) {
            payVO.setDesc("");
        }
        if (StringUtils.isEmpty((String)payVO.getBsOrdNo())) {
            payVO.setBsOrdNo("");
        }
        log.info("\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)payVO);
        payVO.setExpireSecond("1800");
        payVO.setCashierNo("wechatMini");
        payVO.setCashierName("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f");
        payVO.setNotifyType("0");
        Map map = SignUtil.getKeyAndValue((Object)payVO);
        String jsonBody = JSON.toJSONString((Object)payVO);
        PaymentPlatformsFoundationVO paymentPlatformsFoundationVO = new PaymentPlatformsFoundationVO();
        paymentPlatformsFoundationVO.setApiId(PayApiTypeEnum.ORDER_THE_INTERFACE.getValue());
        paymentPlatformsFoundationVO.setProductCode(ProductCodeEnum.WECHATPAY_MINI.getValue());
        try {
            paramBody = this.sendPaymentPlatformsV2(map, jsonBody, paymentPlatformsFoundationVO);
        }
        catch (Exception e) {
            return BaseResponse.error((String)e.getMessage());
        }
        log.info("\u3010\u5c0f\u7a0b\u5e8f\u652f\u4ed8\u4e0b\u5355\u63a5\u53e3\u3011\u652f\u4ed8\u5e73\u53f0\u89e3\u5bc6\u540e\u6570\u636e{}", (Object)paramBody);
        PayOrderDTO payDTO = (PayOrderDTO)JSON.parseObject((String)paramBody, PayOrderDTO.class);
        payDTO.setPackageValue((String)JSON.parseObject((String)paramBody).get((Object)"package"));
        return BaseResponse.success((Object)payDTO);
    }

    public BaseResponse<PaymentResultsDTO> paymentResultInquiry(PaymentInquiryVO paymentInquiryVO) {
        String paramBody;
        Map map = SignUtil.getKeyAndValue((Object)paymentInquiryVO);
        String jsonBody = JSON.toJSONString((Object)paymentInquiryVO);
        PaymentPlatformsFoundationVO paymentPlatformsFoundationVO = new PaymentPlatformsFoundationVO();
        paymentPlatformsFoundationVO.setApiId(PayApiTypeEnum.PAYMENT_RESULTS.getValue());
        try {
            paramBody = this.sendPaymentPlatforms(map, jsonBody, paymentPlatformsFoundationVO);
        }
        catch (Exception e) {
            return BaseResponse.error((String)e.getMessage());
        }
        log.info("\u3010\u652f\u4ed8\u7ed3\u679c\u67e5\u8be2\u3011\u652f\u4ed8\u5e73\u53f0\u89e3\u5bc6\u540e\u6570\u636e{}", (Object)paramBody);
        PaymentResultsDTO payDTO = (PaymentResultsDTO)JSON.parseObject((String)paramBody, PaymentResultsDTO.class);
        return BaseResponse.success((Object)payDTO);
    }

    public BaseResponse<PaymentResultsDTO> paymentResultInquiryV2(PaymentInquiryVO paymentInquiryVO) {
        String paramBody;
        Map map = SignUtil.getKeyAndValue((Object)paymentInquiryVO);
        String jsonBody = JSON.toJSONString((Object)paymentInquiryVO);
        PaymentPlatformsFoundationVO paymentPlatformsFoundationVO = new PaymentPlatformsFoundationVO();
        paymentPlatformsFoundationVO.setApiId(PayApiTypeEnum.PAYMENT_RESULTS.getValue());
        try {
            paramBody = this.sendPaymentPlatformsV2(map, jsonBody, paymentPlatformsFoundationVO);
        }
        catch (Exception e) {
            return BaseResponse.error((String)e.getMessage());
        }
        log.info("\u3010\u652f\u4ed8\u7ed3\u679c\u67e5\u8be2\u3011\u652f\u4ed8\u5e73\u53f0\u89e3\u5bc6\u540e\u6570\u636e{}", (Object)paramBody);
        PaymentResultsDTO payDTO = (PaymentResultsDTO)JSON.parseObject((String)paramBody, PaymentResultsDTO.class);
        return BaseResponse.success((Object)payDTO);
    }

    public BaseResponse<PaymentResultsDTO> paymentRefund(PaymentRefundVO request) {
        String paramBody;
        log.info("\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)request);
        Map map = SignUtil.getKeyAndValue((Object)request);
        String jsonBody = JSON.toJSONString((Object)request);
        PaymentPlatformsFoundationVO paymentPlatformsFoundationVO = new PaymentPlatformsFoundationVO();
        paymentPlatformsFoundationVO.setApiId(PayApiTypeEnum.PAY_REFUND.getValue());
        try {
            paramBody = this.sendPaymentPlatforms(map, jsonBody, paymentPlatformsFoundationVO);
        }
        catch (Exception e) {
            return BaseResponse.error((String)e.getMessage());
        }
        log.info("\u3010\u652f\u4ed8\u9000\u6b3e\u3011\u652f\u4ed8\u5e73\u53f0\u89e3\u5bc6\u540e\u6570\u636e{}", (Object)paramBody);
        PaymentResultsDTO payDTO = (PaymentResultsDTO)JSON.parseObject((String)paramBody, PaymentResultsDTO.class);
        return BaseResponse.success((Object)payDTO);
    }

    public BaseResponse<PaymentResultsDTO> paymentRefundV2(PaymentRefundVO request) {
        String paramBody;
        log.info("\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)request);
        Map map = SignUtil.getKeyAndValue((Object)request);
        String jsonBody = JSON.toJSONString((Object)request);
        PaymentPlatformsFoundationVO paymentPlatformsFoundationVO = new PaymentPlatformsFoundationVO();
        paymentPlatformsFoundationVO.setApiId(PayApiTypeEnum.PAY_REFUND.getValue());
        try {
            paramBody = this.sendPaymentPlatformsV2(map, jsonBody, paymentPlatformsFoundationVO);
        }
        catch (Exception e) {
            return BaseResponse.error((String)e.getMessage());
        }
        log.info("\u3010\u652f\u4ed8\u9000\u6b3e\u3011\u652f\u4ed8\u5e73\u53f0\u89e3\u5bc6\u540e\u6570\u636e{}", (Object)paramBody);
        PaymentResultsDTO payDTO = (PaymentResultsDTO)JSON.parseObject((String)paramBody, PaymentResultsDTO.class);
        return BaseResponse.success((Object)payDTO);
    }

    public BaseResponse<PaymentResultsDTO> paymentResultRefund(PaymentResultRefundVO request) {
        String paramBody;
        Map map = SignUtil.getKeyAndValue((Object)request);
        String jsonBody = JSON.toJSONString((Object)request);
        PaymentPlatformsFoundationVO paymentPlatformsFoundationVO = new PaymentPlatformsFoundationVO();
        paymentPlatformsFoundationVO.setApiId(PayApiTypeEnum.REFUND_RESULTS.getValue());
        try {
            paramBody = this.sendPaymentPlatforms(map, jsonBody, paymentPlatformsFoundationVO);
        }
        catch (Exception e) {
            return BaseResponse.error((String)e.getMessage());
        }
        log.info("\u3010\u9000\u6b3e\u7ed3\u679c\u67e5\u8be2\u63a5\u53e3\u3011\u652f\u4ed8\u5e73\u53f0\u89e3\u5bc6\u540e\u6570\u636e{}", (Object)paramBody);
        PaymentResultsDTO payDTO = (PaymentResultsDTO)JSON.parseObject((String)paramBody, PaymentResultsDTO.class);
        return BaseResponse.success((Object)payDTO);
    }

    public BaseResponse<PaymentResultsDTO> paymentResultRefundV2(PaymentResultRefundVO request) {
        String paramBody;
        Map map = SignUtil.getKeyAndValue((Object)request);
        String jsonBody = JSON.toJSONString((Object)request);
        PaymentPlatformsFoundationVO paymentPlatformsFoundationVO = new PaymentPlatformsFoundationVO();
        paymentPlatformsFoundationVO.setApiId(PayApiTypeEnum.REFUND_RESULTS.getValue());
        try {
            paramBody = this.sendPaymentPlatformsV2(map, jsonBody, paymentPlatformsFoundationVO);
        }
        catch (Exception e) {
            return BaseResponse.error((String)e.getMessage());
        }
        log.info("\u3010\u9000\u6b3e\u7ed3\u679c\u67e5\u8be2\u63a5\u53e3\u3011\u652f\u4ed8\u5e73\u53f0\u89e3\u5bc6\u540e\u6570\u636e{}", (Object)paramBody);
        PaymentResultsDTO payDTO = (PaymentResultsDTO)JSON.parseObject((String)paramBody, PaymentResultsDTO.class);
        return BaseResponse.success((Object)payDTO);
    }

    public String payAsynchronousNotifications(PaymentResultsDTO payDTO) {
        log.info("==========>\u652f\u4ed8\u5f02\u6b65\u901a\u77e5:{}", (Object)JSON.toJSONString((Object)payDTO));
        try {
            log.info("==========>\u8bf7\u6c42\u4e92\u8054\u7f51\u533b\u9662\u5730\u5740\u652f\u4ed8\u56de\u8c03:{}", (Object)this.nodeConfig.getInternetHospitalPaymentCallbacksUrl());
            String str = HttpUtils.post((String)this.nodeConfig.getInternetHospitalPaymentCallbacksUrl(), null, (String)JSON.toJSONString((Object)payDTO));
            log.info("==========>\u4e92\u8054\u7f51\u533b\u9662\u8fd4\u56de\u539f\u59cb\u6570\u636e{}", (Object)str);
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42\u4e92\u8054\u7f51\u533b\u9662\u5730\u5740\u652f\u4ed8\u56de\u8c03\u5f02\u5e38", (Throwable)e);
            e.printStackTrace();
        }
        return "1";
    }

    public String refundAsynchronousNotification(PaymentRefundDTO payDTO) {
        log.info("==========>\u9000\u6b3e\u5f02\u6b65\u901a\u77e5:{}", (Object)JSON.toJSONString((Object)payDTO));
        try {
            log.info("==========>\u8bf7\u6c42\u4e92\u8054\u7f51\u533b\u9662\u5730\u5740\u9000\u6b3e\u56de\u8c03:{}", (Object)this.nodeConfig.getInternetHospitalRefundCallbacksUrl());
            String str = HttpUtils.post((String)this.nodeConfig.getInternetHospitalRefundCallbacksUrl(), null, (String)JSON.toJSONString((Object)payDTO));
            log.info("==========>\u4e92\u8054\u7f51\u533b\u9662\u8fd4\u56de\u539f\u59cb\u6570\u636e{}", (Object)str);
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42\u4e92\u8054\u7f51\u533b\u9662\u5730\u5740\u9000\u6b3e\u56de\u8c03\u51fa\u73b0\u9519\u8bef", (Throwable)e);
            e.printStackTrace();
        }
        return "1";
    }

    public String payPrescriptionAsynchronousNotifications(PaymentResultsDTO payDTO) {
        log.info("==========>\u652f\u4ed8\u5f02\u6b65\u901a\u77e5:{}", (Object)JSON.toJSONString((Object)payDTO));
        try {
            log.info("==========>\u8bf7\u6c42\u4e92\u8054\u7f51\u533b\u9662\u5730\u5740\u3010\u533b\u836f\u4e91\u3011\u652f\u4ed8\u56de\u8c03:{}", (Object)this.nodeConfig.getInternetPrescriptionHospitalPaymentCallbacksUrl());
            String str = HttpUtils.post((String)this.nodeConfig.getInternetPrescriptionHospitalPaymentCallbacksUrl(), null, (String)JSON.toJSONString((Object)payDTO));
            log.info("==========>\u4e92\u8054\u7f51\u533b\u9662\u8fd4\u56de\u539f\u59cb\u6570\u636e{}", (Object)str);
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42\u4e92\u8054\u7f51\u533b\u9662\u5730\u5740\u652f\u4ed8\u56de\u8c03\u5f02\u5e38", (Throwable)e);
            e.printStackTrace();
        }
        return "1";
    }

    public String sendPaymentPlatforms(Map<String, String> map, String jsonBody, PaymentPlatformsFoundationVO paymentPlatformsFoundationVO) throws Exception {
        PaymentPlatformsFoundationVO returnValue;
        try {
            log.info("V2\u7248\u672c\u6dfb\u52a0\u8bf7\u6c42\u5934\u90e8\u5b57\u6bb5, \u8bbe\u7f6eappkey\u548caeskey");
            log.info("sendPaymentPlatforms\u65b9\u6cd5\u53c2\u6570\u6253\u5370,map:{},jsonBody:{},paymentPlatformsFoundationVO:{}", new Object[]{JSONObject.toJSONString(map), jsonBody, JSONObject.toJSONString((Object)paymentPlatformsFoundationVO)});
            String sign = SignUtil.createSign(map, null);
            paymentPlatformsFoundationVO.setSignVal(sign);
            log.info("sendPaymentPlatforms\u751f\u6210\u9a8c\u7b7e:{}", (Object)sign);
            String encode = ThreeDESUtils.encode((String)jsonBody, (String)(paymentPlatformsFoundationVO.getThreeDesKey() + paymentPlatformsFoundationVO.getReqTm()));
            log.info("sendPaymentPlatforms\u52a0\u5bc6\u53c2\u6570:{}", (Object)encode);
            paymentPlatformsFoundationVO.setBody(encode);
        }
        catch (Exception e) {
            log.error("\u652f\u4ed8\u53c2\u6570\u52a0\u5bc6\u5931\u8d25!");
            log.error("sendPaymentPlatforms\u65b9\u6cd5\u53c2\u6570\u6253\u5370,map:{},jsonBody:{},paymentPlatformsFoundationVO:{}", new Object[]{JSONObject.toJSONString(map), jsonBody, JSONObject.toJSONString((Object)paymentPlatformsFoundationVO)});
            e.printStackTrace();
            throw new Exception("\u53c2\u6570\u52a0\u5bc6\u5931\u8d25" + e.getMessage());
        }
        try {
            log.info("==========>\u8bf7\u6c42\u652f\u4ed8\u5e73\u53f0\u5730\u5740:{}\u2014\u2014\u53c2\u6570:{}", (Object)this.nodeConfig.getPayUrl(), (Object)JSON.toJSONString((Object)paymentPlatformsFoundationVO));
            String str = this.nodeConfig.getMerNo().equals("sh000013") ? HttpUtils.post((String)this.nodeConfig.getPayUrl(), (String)JSON.toJSONString((Object)paymentPlatformsFoundationVO)) : HttpsClient.doJsonPost((String)this.nodeConfig.getPayUrl(), (String)JSON.toJSONString((Object)paymentPlatformsFoundationVO));
            log.info("==========>\u652f\u4ed8\u5e73\u53f0\u8fd4\u56de\u539f\u59cb\u6570\u636e{}", (Object)str);
            returnValue = (PaymentPlatformsFoundationVO)JSON.parseObject((String)str, PaymentPlatformsFoundationVO.class);
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42\u652f\u4ed8\u5e73\u53f0\u5f02\u5e38", (Throwable)e);
            throw new Exception("\u652f\u4ed8\u5e73\u53f0\u8bf7\u6c42\u5f02\u5e38" + e.getMessage());
        }
        if (ObjectUtil.isNull((Object)returnValue) || StringUtils.isEmpty((String)returnValue.getBody()) || !SUCCEED_CODE.equals(returnValue.getCode())) {
            log.info("\u652f\u4ed8\u5e73\u53f0\u8fd4\u56de\u5f02\u5e38{}", (Object)returnValue);
            throw new Exception(returnValue.getMsg());
        }
        log.info("==========>\u89e3\u5bc6\u8fd4\u56de\u53c2\u6570:{}", (Object)returnValue);
        String paramBody = "";
        try {
            paramBody = ThreeDESUtils.decode((String)returnValue.getBody(), (String)(returnValue.getThreeDesKey() + returnValue.getRespTm()));
        }
        catch (Exception e) {
            log.info("\u89e3\u5bc6\u5931\u8d25:{}" + JSON.toJSONString((Object)returnValue));
            e.printStackTrace();
            throw new Exception("\u89e3\u5bc6\u5931\u8d25" + e.getMessage());
        }
        return paramBody;
    }

    public String sendPaymentPlatformsV2(Map<String, String> map, String jsonBody, PaymentPlatformsFoundationVO paymentPlatformsFoundationVO) throws Exception {
        PaymentPlatformsFoundationVO returnValue;
        try {
            log.info("V2\u7248\u672c\u6dfb\u52a0\u8bf7\u6c42\u5934\u90e8\u5b57\u6bb5, \u8bbe\u7f6eappkey\u548caeskey");
            paymentPlatformsFoundationVO.setAppKey(this.nodeConfig.getAppKey());
            paymentPlatformsFoundationVO.setAesKey(this.nodeConfig.getAesKey());
            paymentPlatformsFoundationVO.setThreeDesKey(this.nodeConfig.getAesKey());
            log.info("sendPaymentPlatformsV2\u65b9\u6cd5\u53c2\u6570\u6253\u5370,map:{},jsonBody:{},paymentPlatformsFoundationVO:{}", new Object[]{JSONObject.toJSONString(map), jsonBody, JSONObject.toJSONString((Object)paymentPlatformsFoundationVO)});
            String sign = SignUtil.createSign(map, null);
            paymentPlatformsFoundationVO.setSignVal(sign);
            log.info("sendPaymentPlatformsV2\u751f\u6210\u9a8c\u7b7e:{}", (Object)sign);
            String encode = AESUtil.encode((String)jsonBody, (String)(paymentPlatformsFoundationVO.getThreeDesKey() + paymentPlatformsFoundationVO.getReqTm()));
            log.info("sendPaymentPlatformsV2\u52a0\u5bc6\u53c2\u6570:{}", (Object)encode);
            paymentPlatformsFoundationVO.setBody(encode);
        }
        catch (Exception e) {
            log.error("\u652f\u4ed8\u53c2\u6570\u52a0\u5bc6\u5931\u8d25!");
            log.error("sendPaymentPlatformsV2\u65b9\u6cd5\u53c2\u6570\u6253\u5370,map:{},jsonBody:{},paymentPlatformsFoundationVO:{}", new Object[]{JSONObject.toJSONString(map), jsonBody, JSONObject.toJSONString((Object)paymentPlatformsFoundationVO)});
            e.printStackTrace();
            throw new Exception("\u53c2\u6570\u52a0\u5bc6\u5931\u8d25" + e.getMessage());
        }
        try {
            log.info("==========>\u8bf7\u6c42\u652f\u4ed8\u5e73\u53f0\u5730\u5740:{}\u2014\u2014\u53c2\u6570:{}", (Object)this.nodeConfig.getPayUrl(), (Object)JSON.toJSONString((Object)paymentPlatformsFoundationVO));
            String str = this.nodeConfig.getMerNo().equals("sh000013") ? HttpUtils.post((String)this.nodeConfig.getPayUrl(), (String)JSON.toJSONString((Object)paymentPlatformsFoundationVO)) : HttpUtils.post((String)this.nodeConfig.getPayUrl(), (String)JSON.toJSONString((Object)paymentPlatformsFoundationVO));
            log.info("==========>\u652f\u4ed8\u5e73\u53f0\u8fd4\u56de\u539f\u59cb\u6570\u636e{}", (Object)str);
            returnValue = (PaymentPlatformsFoundationVO)JSON.parseObject((String)str, PaymentPlatformsFoundationVO.class);
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42\u652f\u4ed8\u5e73\u53f0\u5f02\u5e38", (Throwable)e);
            throw new Exception("\u652f\u4ed8\u5e73\u53f0\u8bf7\u6c42\u5f02\u5e38" + e.getMessage());
        }
        if (ObjectUtil.isNull((Object)returnValue) || StringUtils.isEmpty((String)returnValue.getBody()) || !SUCCEED_CODE.equals(returnValue.getCode())) {
            log.info("\u652f\u4ed8\u5e73\u53f0\u8fd4\u56de\u5f02\u5e38{}", (Object)returnValue);
            throw new Exception(returnValue.getMsg());
        }
        log.info("==========>\u89e3\u5bc6\u8fd4\u56de\u53c2\u6570:{}", (Object)returnValue);
        String paramBody = "";
        try {
            paramBody = AESUtil.decode((String)returnValue.getBody(), (String)(this.nodeConfig.getAesKey() + returnValue.getRespTm()));
        }
        catch (Exception e) {
            log.info("\u89e3\u5bc6\u5931\u8d25:{}" + JSON.toJSONString((Object)returnValue));
            e.printStackTrace();
            throw new Exception("\u89e3\u5bc6\u5931\u8d25" + e.getMessage());
        }
        return paramBody;
    }

    public String refundPrescriptionAsynchronousNotifications(PaymentRefundDTO payDTO) {
        log.info("==========>\u5904\u65b9\u9000\u6b3e\u5f02\u6b65\u901a\u77e5:{}", (Object)JSON.toJSONString((Object)payDTO));
        try {
            log.info("==========>\u8bf7\u6c42\u4e92\u8054\u7f51\u533b\u9662\u5904\u65b9\u5730\u5740\u9000\u6b3e\u56de\u8c03:{}\u2014\u2014\u53c2\u6570:{}", (Object)this.nodeConfig.getInternetHospitalRefundPrescriptionBacksUrl(), (Object)JSON.toJSONString((Object)payDTO));
            String str = HttpUtils.post((String)this.nodeConfig.getInternetHospitalRefundPrescriptionBacksUrl(), null, (String)JSON.toJSONString((Object)payDTO));
            log.info("==========>\u4e92\u8054\u7f51\u533b\u9662\u8fd4\u56de\u539f\u59cb\u6570\u636e{}", (Object)str);
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42\u4e92\u8054\u7f51\u533b\u9662\u5730\u5740\u5904\u65b9\u9000\u6b3e\u56de\u8c03\u51fa\u73b0\u9519\u8bef", (Throwable)e);
            e.printStackTrace();
        }
        return "1";
    }

    public String payInvoicRegister(PaymentResultsDTO request) {
        log.info("==========>\u81ea\u52a9\u5f00\u5355\u6302\u53f7\u652f\u4ed8\u56de\u8c03:{}", (Object)JSON.toJSONString((Object)request));
        try {
            log.info("==========>\u8bf7\u6c42\u4e92\u8054\u7f51\u533b\u9662\u81ea\u52a9\u5f00\u5355\u6302\u53f7\u652f\u4ed8\u56de\u8c03:{}\u2014\u2014\u53c2\u6570:{}", (Object)this.nodeConfig.getInternetInvoicRegisterPaymentCallbacksUrl(), (Object)JSON.toJSONString((Object)request));
            String str = HttpUtils.post((String)this.nodeConfig.getInternetInvoicRegisterPaymentCallbacksUrl(), null, (String)JSON.toJSONString((Object)request));
            log.info("==========>\u4e92\u8054\u7f51\u533b\u9662\u8fd4\u56de\u539f\u59cb\u6570\u636e{}", (Object)str);
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42\u4e92\u8054\u7f51\u533b\u9662\u5730\u5740\u81ea\u52a9\u5f00\u5355\u6302\u53f7\u652f\u4ed8\u56de\u8c03\u51fa\u73b0\u9519\u8bef", (Throwable)e);
            e.printStackTrace();
        }
        return "1";
    }

    public String refundInvoicRegister(PaymentResultsDTO request) {
        log.info("==========>\u81ea\u52a9\u5f00\u5355\u6302\u53f7\u652f\u4ed8\u56de\u8c03:{}", (Object)JSON.toJSONString((Object)request));
        try {
            log.info("==========>\u8bf7\u6c42\u4e92\u8054\u7f51\u533b\u9662\u81ea\u52a9\u5f00\u5355\u6302\u53f7\u652f\u4ed8\u56de\u8c03:{}\u2014\u2014\u53c2\u6570:{}", (Object)this.nodeConfig.getInternetInvoicRegisterPaymentCallbacksUrl(), (Object)JSON.toJSONString((Object)request));
            String str = HttpUtils.post((String)this.nodeConfig.getInternetInvoicRegisterPaymentCallbacksUrl(), null, (String)JSON.toJSONString((Object)request));
            log.info("==========>\u4e92\u8054\u7f51\u533b\u9662\u8fd4\u56de\u539f\u59cb\u6570\u636e{}", (Object)str);
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42\u4e92\u8054\u7f51\u533b\u9662\u5730\u5740\u81ea\u52a9\u5f00\u5355\u6302\u53f7\u652f\u4ed8\u56de\u8c03\u51fa\u73b0\u9519\u8bef", (Throwable)e);
            e.printStackTrace();
        }
        return "1";
    }
}

