/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.service.impl;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.ebaiyihui.his.common.enums.EntityKeyEnum;
import com.ebaiyihui.his.common.enums.MethodCodeEnum;
import com.ebaiyihui.his.common.enums.TransNoEnum;
import com.ebaiyihui.his.pojo.regulatoryPlatformVo.dto.HisHeadDTO;
import com.ebaiyihui.his.pojo.regulatoryPlatformVo.dto.ScheduleSourceDTO;
import com.ebaiyihui.his.pojo.regulatoryPlatformVo.dto.ScheduleSourceReqDTO;
import com.ebaiyihui.his.pojo.regulatoryPlatformVo.vo.ScheduleSourceVO;
import com.ebaiyihui.his.pojo.regulatoryPlatformVo.vo.ScheduleTimeQuaSourceResVO;
import com.ebaiyihui.his.pojo.vo.base.FrontRequest;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import com.ebaiyihui.his.pojo.vo.schedule.GetScheduleReqVO;
import com.ebaiyihui.his.pojo.vo.schedule.GetScheduleResVO;
import com.ebaiyihui.his.pojo.vo.schedule.items.GetScheduleResItems;
import com.ebaiyihui.his.pojo.vo.schedule.items.TimeArrangeItems;
import com.ebaiyihui.his.service.HisRemoteService;
import com.ebaiyihui.his.service.ScheduleService;
import com.ebaiyihui.his.utils.SnowflakeIdWorker;
import com.ebaiyihui.his.utils.XmlUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ScheduleServiceImpl
implements ScheduleService {
    private static final Logger log = LoggerFactory.getLogger(ScheduleServiceImpl.class);
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String SCHEDULE_STATUS = "1";
    @Value(value="${hosp.hospName}")
    private String hospName;
    @Value(value="${hosp.hospCode}")
    private String hospCode;
    @Autowired
    private HisRemoteService hisRemoteService;
    @Autowired
    private SnowflakeIdWorker snowflakeIdWorker;

    public FrontResponse<GetScheduleResVO> getScheduleSource(FrontRequest<GetScheduleReqVO> param) {
        try {
            ScheduleSourceReqDTO scheduleSourceReqDTO = new ScheduleSourceReqDTO();
            GetScheduleReqVO body = (GetScheduleReqVO)param.getBody();
            scheduleSourceReqDTO.setHospitalCode(body.getHospitalCode());
            scheduleSourceReqDTO.setSchDate(body.getBgDate());
            scheduleSourceReqDTO.setVisit(SCHEDULE_STATUS);
            scheduleSourceReqDTO.setDoctorId(body.getDocCode());
            scheduleSourceReqDTO.setDeptCode(body.getLocCode());
            scheduleSourceReqDTO.setOperCode("70019");
            scheduleSourceReqDTO.setOperTime(DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
            ScheduleSourceDTO scheduleSourceDTO = new ScheduleSourceDTO();
            HisHeadDTO headDTO = new HisHeadDTO();
            headDTO.setSource("HLWYY");
            headDTO.setTransNo(TransNoEnum.HIS_SCHEDULE_SOURCE_QUERY.getValue());
            scheduleSourceDTO.setHeadDTO(headDTO);
            scheduleSourceDTO.setScheduleSourceReqDTO(scheduleSourceReqDTO);
            String converTomXml = XmlUtil.converTomXml((Object)scheduleSourceDTO);
            FrontResponse scheduleSourceVORes = this.hisRemoteService.hisNewRequest(TransNoEnum.HIS_SCHEDULE_SOURCE_QUERY.getValue(), converTomXml, ScheduleSourceVO.class);
            ScheduleSourceVO scheduleSourceVO = (ScheduleSourceVO)scheduleSourceVORes.getBody();
            if (null == scheduleSourceVO) {
                return FrontResponse.error((String)scheduleSourceVORes.getTransactionId(), (String)"0", (String)scheduleSourceVO.getHeadVO().getHisReturnVO().getRetCont());
            }
            if (!SCHEDULE_STATUS.equals(scheduleSourceVO.getHeadVO().getHisReturnVO().getRetCode())) {
                return FrontResponse.error((String)scheduleSourceVORes.getTransactionId(), (String)"0", (String)scheduleSourceVO.getHeadVO().getHisReturnVO().getRetCont());
            }
            List scheduleItemSourceResVOS = scheduleSourceVO.getScheduleSourceResVO().getScheduleItemSourceResVOS();
            log.info("his\u67e5\u8be2\u6392\u73ed\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)scheduleItemSourceResVOS));
            GetScheduleResVO getScheduleResVO = new GetScheduleResVO();
            ArrayList<GetScheduleResItems> items = new ArrayList<GetScheduleResItems>();
            scheduleItemSourceResVOS.stream().forEach(date -> {
                GetScheduleResItems getScheduleResItems = new GetScheduleResItems();
                getScheduleResItems.setAdmDate(date.getSchDate());
                getScheduleResItems.setLocCode(date.getDeptCode());
                getScheduleResItems.setLocName(date.getDeptName());
                getScheduleResItems.setDocCode(date.getDoctorId());
                getScheduleResItems.setDocName(date.getDoctorName());
                if (date.getDoctorName().equals("")) {
                    getScheduleResItems.setDocCode(date.getLevelName());
                    getScheduleResItems.setDocName(date.getLevelName());
                }
                getScheduleResItems.setDiagFee("0");
                getScheduleResItems.setRegFee(date.getRegFee());
                getScheduleResItems.setRegAvailable(Integer.valueOf(date.getLeftNum()));
                getScheduleResItems.setAdmTimeRange(date.getAmPmFlag());
                getScheduleResItems.setScheduleLevelCode(date.getLevelCode());
                getScheduleResItems.setScheduleLevelName(date.getLevelName());
                getScheduleResItems.setRegTotal(Integer.valueOf(date.getTotal()));
                getScheduleResItems.setIsTimeArrange(Integer.valueOf(1));
                ArrayList<TimeArrangeItems> timeArrangeItems = new ArrayList<TimeArrangeItems>();
                for (ScheduleTimeQuaSourceResVO timeArrangeData : date.getScheduleTimeQuaSourceResVO()) {
                    TimeArrangeItems timeArrangeItem = new TimeArrangeItems();
                    timeArrangeItem.setEndTime(timeArrangeData.getEndTime());
                    timeArrangeItem.setStartTime(timeArrangeData.getBegTime());
                    timeArrangeItem.setScheduleItemCode(timeArrangeData.getSchemaId());
                    timeArrangeItem.setAvailableLeftNum(timeArrangeData.getLeftNum());
                    timeArrangeItem.setAvailableTotalNum(timeArrangeData.getTotal());
                    timeArrangeItems.add(timeArrangeItem);
                }
                timeArrangeItems.removeIf(o -> com.ebaiyihui.his.utils.DateUtil.compareTime((String)(getScheduleResItems.getAdmDate() + " " + o.getEndTime() + ":00")) == -1);
                timeArrangeItems.removeIf(o -> o.getAvailableLeftNum().equals("0"));
                getScheduleResItems.setTimeArrangeItems(timeArrangeItems);
                items.add(getScheduleResItems);
            });
            items.removeIf(o -> o.getTimeArrangeItems().size() <= 0);
            getScheduleResVO.setItems(items);
            log.info("\u67e5\u8be2\u6392\u73ed\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)getScheduleResVO));
            return FrontResponse.success((String)param.getTransactionId(), (Object)getScheduleResVO);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u67e5\u8be2\u6392\u73ed\u4fe1\u606f\u5f02\u5e38 {}", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u67e5\u8be2\u6392\u73ed\u4fe1\u606f\u5f02\u5e38");
        }
    }

    public FrontResponse queuing() {
        HashMap<String, Object> deptDoctorInfo = new HashMap<String, Object>(1);
        deptDoctorInfo.put(EntityKeyEnum.DEPT_DOCTOR_INFO.getValue(), null);
        FrontResponse dtoFrontResponse = this.hisRemoteService.requestHis(null, MethodCodeEnum.QUEUING.getValue(), deptDoctorInfo, null);
        return null;
    }
}

