/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.service.impl;

import com.ebaiyihui.framework.response.IError;
import com.ebaiyihui.framework.utils.JsonUtil;
import com.ebaiyihui.his.pojo.entity.HisBusinessConfigEntity;
import com.ebaiyihui.his.pojo.entity.HisBusinessLogEntity;
import com.ebaiyihui.his.pojo.entity.HisBusinessUrlEntity;
import com.ebaiyihui.his.pojo.vo.base.FrontRequest;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import com.ebaiyihui.his.pojo.vo.base.GatewayRequest;
import com.ebaiyihui.his.pojo.vo.base.GatewayResponse;
import com.ebaiyihui.his.repository.HisBusinessConfigRepository;
import com.ebaiyihui.his.repository.HisBusinessLogRepository;
import com.ebaiyihui.his.repository.HisBusinessUrlRepository;
import com.ebaiyihui.his.service.IRouteService;
import com.ebaiyihui.his.utils.HttpKit;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.ExecutionException;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RouteServiceImpl
implements IRouteService {
    private static final SimpleDateFormat FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private HisBusinessConfigRepository businessConfigRepository;
    @Resource
    private HisBusinessLogRepository businessLogRepository;
    @Resource
    private HisBusinessUrlRepository businessUrlRepository;

    @Transactional(rollbackFor={Exception.class})
    public <K, T> GatewayResponse<T> requestFront(GatewayRequest<K> parameter, Class<T> responseClass, String businessCode) {
        HisBusinessUrlEntity hisBusinessUrlEntity = this.businessUrlRepository.findByOrganCodeAndAndStatus(parameter.getOrganCode(), new Byte("1"));
        if (null == hisBusinessUrlEntity) {
            this.logger.error("Request Front Failed - \u67e5\u8be2his\u524d\u7f6e\u673aurl\u914d\u7f6e\u5931\u8d25 - organCode:{}", (Object)parameter.getOrganCode());
            return GatewayResponse.specialError((IError)IError.PARAM_CHECK_FAILD, (String)parameter.getTransactionId());
        }
        HisBusinessConfigEntity hisBusinessConfigEntity = this.businessConfigRepository.findFirstByBusinessCodeAndOrganCode(businessCode, parameter.getOrganCode());
        if (hisBusinessConfigEntity == null) {
            this.logger.error("Request Front Failed - \u67e5\u8be2\u524d\u7f6e\u673a\u8def\u7531\u914d\u7f6e\u5931\u8d25 - businessCode:{} organCode:{}", (Object)businessCode, (Object)parameter.getOrganCode());
            return GatewayResponse.specialError((IError)IError.PARAM_CHECK_FAILD, (String)parameter.getTransactionId());
        }
        FrontRequest request = new FrontRequest();
        request.setBody(parameter.getBody());
        request.setOrganCode(parameter.getOrganCode());
        request.setTransactionId(parameter.getTransactionId());
        request.setChannel(parameter.getChannel());
        request.setChannelName(parameter.getChannelName());
        String requestJson = JsonUtil.convertObject((Object)request);
        this.logger.info("Request Front Start - url:{} request:{} ", (Object)(hisBusinessUrlEntity.getHisFrontUrl() + hisBusinessConfigEntity.getHisConfig()), (Object)requestJson);
        String resultJson = null;
        try {
            resultJson = HttpKit.jsonPost((String)(hisBusinessUrlEntity.getHisFrontUrl() + hisBusinessConfigEntity.getHisConfig()), (String)requestJson);
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            this.logger.error(e.getMessage());
        }
        this.logger.info("Request Front End - response:{}", resultJson);
        HisBusinessLogEntity hisBusinessLogEntity = new HisBusinessLogEntity();
        hisBusinessLogEntity.setBusinessCode(businessCode);
        hisBusinessLogEntity.setDateSign(FORMAT.format(new Date()));
        hisBusinessLogEntity.setKeyWord(parameter.getKeyWord());
        hisBusinessLogEntity.setOrganCode(parameter.getOrganCode());
        hisBusinessLogEntity.setRequest(requestJson);
        hisBusinessLogEntity.setResponse(resultJson);
        this.businessLogRepository.saveAndFlush((Object)hisBusinessLogEntity);
        this.logger.info("Request Front log record - entity:{} ", (Object)hisBusinessLogEntity);
        if (StringUtils.isBlank((String)resultJson)) {
            this.logger.error("Request Front Failed - \u65e0\u54cd\u5e94 ");
            return GatewayResponse.specialError((IError)IError.FEIGN_FAIL, (String)parameter.getTransactionId());
        }
        FrontResponse frontResponse = (FrontResponse)JsonUtil.convertObject((String)resultJson, FrontResponse.class);
        if (frontResponse == null) {
            this.logger.error("Request Front Failed - \u54cd\u5e94\u8f6c\u6362\u5f02\u5e38");
            return GatewayResponse.specialError((IError)IError.DATA_ERROR, (String)parameter.getTransactionId());
        }
        if (!"1".equals(frontResponse.getCode())) {
            this.logger.error("Request Front Failed - \u8bf7\u6c42\u7ed3\u679c-\u5931\u8d25");
            GatewayResponse gatewayResponse = new GatewayResponse();
            gatewayResponse.setCode("0");
            gatewayResponse.setMsg(frontResponse.getMessage());
            gatewayResponse.setErrCode(frontResponse.getErrCode());
            gatewayResponse.setTransactionId(frontResponse.getTransactionId());
            return gatewayResponse;
        }
        Object body = null;
        if (frontResponse.getBody() != null && (body = JsonUtil.convertObject((String)JsonUtil.convertObject((Object)frontResponse.getBody()), responseClass)) == null) {
            this.logger.error("Request Front Failed - \u54cd\u5e94\u5b9e\u4f53\u8f6c\u6362\u5f02\u5e38 ");
            return GatewayResponse.specialError((IError)IError.DATA_ERROR, (String)frontResponse.getTransactionId());
        }
        return GatewayResponse.specialSuccess(body, (String)frontResponse.getTransactionId());
    }
}

