/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.config;

import java.util.HashSet;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisPoolConfig;

@Configuration
public class RedisConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(RedisConfiguration.class);
    @Value(value="${spring.redis.cluster.nodes}")
    private String clusterNodes;
    @Value(value="${spring.redis.timeout}")
    private int timeout;
    @Value(value="${spring.redis.jedis.pool.max-idle}")
    private int maxIdle;
    @Value(value="${spring.redis.jedis.pool.max-wait}")
    private long maxWaitMillis;
    @Value(value="${spring.redis.jedis.pool.max-active}")
    private int maxActive;
    @Value(value="${spring.redis.jedis.pool.min-idle}")
    private int minIdle;
    private static JedisCluster jedisCluster = null;

    @Bean
    public synchronized JedisCluster redisPoolFactory() {
        if (jedisCluster == null) {
            String[] serverArray = this.clusterNodes.split(",");
            HashSet<HostAndPort> nodes = new HashSet<HostAndPort>();
            for (String ipPort : serverArray) {
                String[] ipPortPair = ipPort.split(":");
                nodes.add(new HostAndPort(ipPortPair[0].trim(), Integer.valueOf(ipPortPair[1].trim()).intValue()));
            }
            LOGGER.info("JedisPool init successful\uff0chost -> [{}]\uff1bport -> [{}]", (Object)((Object)nodes).toString());
            JedisPoolConfig jedisPoolConfig = new JedisPoolConfig();
            jedisPoolConfig.setMaxIdle(this.maxIdle);
            jedisPoolConfig.setMaxWaitMillis(this.maxWaitMillis);
            jedisPoolConfig.setMinIdle(this.minIdle);
            jedisCluster = new JedisCluster(nodes, this.timeout, (GenericObjectPoolConfig)jedisPoolConfig);
        }
        return jedisCluster;
    }
}

