/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.service.impl;

import com.ebaiyihui.framework.response.IError;
import com.ebaiyihui.framework.utils.JsonUtil;
import com.ebaiyihui.his.config.RedisConfiguration;
import com.ebaiyihui.his.pojo.entity.HisBusinessConfigEntity;
import com.ebaiyihui.his.pojo.entity.HisBusinessLogEntity;
import com.ebaiyihui.his.pojo.entity.HisBusinessUrlEntity;
import com.ebaiyihui.his.pojo.vo.base.FrontRequest;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import com.ebaiyihui.his.pojo.vo.base.GatewayRequest;
import com.ebaiyihui.his.pojo.vo.base.GatewayResponse;
import com.ebaiyihui.his.repository.HisBusinessConfigRepository;
import com.ebaiyihui.his.repository.HisBusinessLogRepository;
import com.ebaiyihui.his.repository.HisBusinessUrlRepository;
import com.ebaiyihui.his.service.IRouteService;
import com.ebaiyihui.his.utils.HttpKit;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RouteServiceImpl
implements IRouteService {
    private static final SimpleDateFormat FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final List<String> LOG_BUSSINESSCODE = Arrays.asList("healthBackPay", "recharge", "dayPayRegistration", "dayRegister", "comfirmPayNew", "deposit", "confirmRegister");
    @Resource
    private HisBusinessConfigRepository businessConfigRepository;
    @Resource
    private HisBusinessLogRepository businessLogRepository;
    @Resource
    private HisBusinessUrlRepository businessUrlRepository;
    @Autowired
    private RedisConfiguration redisConfiguration;

    @Transactional(rollbackFor={Exception.class})
    public <K, T> GatewayResponse<T> requestFront(GatewayRequest<K> parameter, Class<T> responseClass, String businessCode) {
        String frontUrl = this.redisConfiguration.redisPoolFactory().get(parameter.getOrganCode() + "_BDDYZYY_HISGATEWAY");
        this.logger.info("\u65e5\u5fd7\u51fa\u53c2\u4eceredis\u83b7\u53d6\u524d\u7f6e\u673aurl==>{}", (Object)frontUrl);
        if (StringUtils.isEmpty((String)frontUrl)) {
            HisBusinessUrlEntity hisBusinessUrlEntity = this.businessUrlRepository.findByOrganCodeAndAndStatus(parameter.getOrganCode(), new Byte("1"));
            if (null == hisBusinessUrlEntity) {
                this.logger.error("Request Front Failed - \u67e5\u8be2his\u524d\u7f6e\u673aurl\u914d\u7f6e\u5931\u8d25 - organCode:{}", (Object)parameter.getOrganCode());
                return GatewayResponse.specialError((IError)IError.PARAM_CHECK_FAILD, (String)parameter.getTransactionId());
            }
            this.redisConfiguration.redisPoolFactory().set(parameter.getOrganCode() + "_BDDYZYY_HISGATEWAY", hisBusinessUrlEntity.getHisFrontUrl());
            frontUrl = hisBusinessUrlEntity.getHisFrontUrl();
        }
        String businessCodeUrl = this.redisConfiguration.redisPoolFactory().get(parameter.getOrganCode() + "_BDDYZYY_" + businessCode);
        this.logger.info("\u65e5\u5fd7\u51fa\u53c2\u4eceredis\u83b7\u53d6\u524d\u7f6e\u673a\u63a5\u53e3==>{}", (Object)businessCodeUrl);
        if (StringUtils.isEmpty((String)businessCodeUrl)) {
            HisBusinessConfigEntity hisBusinessConfigEntity = this.businessConfigRepository.findFirstByBusinessCodeAndOrganCode(businessCode, parameter.getOrganCode());
            if (null == hisBusinessConfigEntity) {
                this.logger.error("Request Front Failed - \u67e5\u8be2\u524d\u7f6e\u673a\u8def\u7531\u914d\u7f6e\u5931\u8d25 - businessCode:{} organCode:{}", (Object)businessCode, (Object)parameter.getOrganCode());
                return GatewayResponse.specialError((IError)IError.PARAM_CHECK_FAILD, (String)parameter.getTransactionId());
            }
            this.redisConfiguration.redisPoolFactory().set(parameter.getOrganCode() + "_BDDYZYY_" + businessCode, hisBusinessConfigEntity.getHisConfig());
            businessCodeUrl = hisBusinessConfigEntity.getHisConfig();
        }
        FrontRequest request = new FrontRequest();
        request.setBody(parameter.getBody());
        request.setOrganCode(parameter.getOrganCode());
        request.setTransactionId(parameter.getTransactionId());
        request.setChannel(parameter.getChannel());
        request.setChannelName(parameter.getChannelName());
        String requestJson = JsonUtil.convertObject((Object)request);
        this.logger.info("Request Front Start - url:{} request:{} ", (Object)(frontUrl + businessCodeUrl), (Object)requestJson);
        String resultJson = null;
        try {
            resultJson = HttpKit.jsonPost((String)(frontUrl + businessCodeUrl), (String)requestJson);
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            this.logger.error(e.getMessage());
        }
        this.logger.info("Request Front End - response:{}", (Object)resultJson);
        if (LOG_BUSSINESSCODE.contains(businessCode)) {
            HisBusinessLogEntity hisBusinessLogEntity = new HisBusinessLogEntity();
            hisBusinessLogEntity.setBusinessCode(businessCode);
            hisBusinessLogEntity.setDateSign(FORMAT.format(new Date()));
            hisBusinessLogEntity.setKeyWord(parameter.getKeyWord());
            hisBusinessLogEntity.setOrganCode(parameter.getOrganCode());
            hisBusinessLogEntity.setRequest(requestJson);
            hisBusinessLogEntity.setResponse(resultJson);
            this.businessLogRepository.saveAndFlush((Object)hisBusinessLogEntity);
            this.logger.info("Request Front log record - entity:{} ", (Object)hisBusinessLogEntity);
        }
        if (StringUtils.isBlank((String)resultJson)) {
            this.logger.error("Request Front Failed - \u65e0\u54cd\u5e94 ");
            return GatewayResponse.specialError((IError)IError.FEIGN_FAIL, (String)parameter.getTransactionId());
        }
        FrontResponse frontResponse = (FrontResponse)JsonUtil.convertObject((String)resultJson, FrontResponse.class);
        if (frontResponse == null) {
            this.logger.error("Request Front Failed - \u54cd\u5e94\u8f6c\u6362\u5f02\u5e38");
            return GatewayResponse.specialError((IError)IError.DATA_ERROR, (String)parameter.getTransactionId());
        }
        if (!"1".equals(frontResponse.getCode())) {
            this.logger.error("Request Front Failed - \u8bf7\u6c42\u7ed3\u679c-\u5931\u8d25");
            GatewayResponse gatewayResponse = new GatewayResponse();
            gatewayResponse.setCode("0");
            gatewayResponse.setMsg(frontResponse.getMessage());
            gatewayResponse.setErrCode(frontResponse.getErrCode());
            gatewayResponse.setTransactionId(frontResponse.getTransactionId());
            return gatewayResponse;
        }
        Object body = null;
        if (frontResponse.getBody() != null && (body = JsonUtil.convertObject((String)JsonUtil.convertObject((Object)frontResponse.getBody()), responseClass)) == null) {
            this.logger.error("Request Front Failed - \u54cd\u5e94\u5b9e\u4f53\u8f6c\u6362\u5f02\u5e38 ");
            return GatewayResponse.specialError((IError)IError.DATA_ERROR, (String)frontResponse.getTransactionId());
        }
        return GatewayResponse.specialSuccess(body, (String)frontResponse.getTransactionId());
    }

    @Transactional(rollbackFor={Exception.class})
    public <K, T> GatewayResponse<T> healthRequestFront(GatewayRequest<K> parameter, Class<T> responseClass, String businessCode) {
        String frontUrl = this.redisConfiguration.redisPoolFactory().get(parameter.getOrganCode() + "_BDDYZYY_HISGATEWAY");
        this.logger.info("\u65e5\u5fd7\u51fa\u53c2\u4eceredis\u83b7\u53d6\u524d\u7f6e\u673aurl==>{}", (Object)frontUrl);
        if (StringUtils.isEmpty((String)frontUrl)) {
            HisBusinessUrlEntity hisBusinessUrlEntity = this.businessUrlRepository.findByOrganCodeAndAndStatus(parameter.getOrganCode(), new Byte("1"));
            if (null == hisBusinessUrlEntity) {
                this.logger.error("Request Front Failed - \u67e5\u8be2his\u524d\u7f6e\u673aurl\u914d\u7f6e\u5931\u8d25 - organCode:{}", (Object)parameter.getOrganCode());
                return GatewayResponse.specialError((IError)IError.PARAM_CHECK_FAILD, (String)parameter.getTransactionId());
            }
            this.redisConfiguration.redisPoolFactory().set(parameter.getOrganCode() + "_BDDYZYY_HISGATEWAY", hisBusinessUrlEntity.getHisFrontUrl());
            frontUrl = hisBusinessUrlEntity.getHisFrontUrl();
        }
        String businessCodeUrl = this.redisConfiguration.redisPoolFactory().get(parameter.getOrganCode() + "_BDDYZYY_" + businessCode);
        this.logger.info("\u65e5\u5fd7\u51fa\u53c2\u4eceredis\u83b7\u53d6\u524d\u7f6e\u673a\u63a5\u53e3==>{}", (Object)businessCodeUrl);
        if (StringUtils.isEmpty((String)businessCodeUrl)) {
            HisBusinessConfigEntity hisBusinessConfigEntity = this.businessConfigRepository.findFirstByBusinessCodeAndOrganCode(businessCode, parameter.getOrganCode());
            if (null == hisBusinessConfigEntity) {
                this.logger.error("Request Front Failed - \u67e5\u8be2\u524d\u7f6e\u673a\u8def\u7531\u914d\u7f6e\u5931\u8d25 - businessCode:{} organCode:{}", (Object)businessCode, (Object)parameter.getOrganCode());
                return GatewayResponse.specialError((IError)IError.PARAM_CHECK_FAILD, (String)parameter.getTransactionId());
            }
            this.redisConfiguration.redisPoolFactory().set(parameter.getOrganCode() + "_BDDYZYY_" + businessCode, hisBusinessConfigEntity.getHisConfig());
            businessCodeUrl = hisBusinessConfigEntity.getHisConfig();
        }
        FrontRequest request = new FrontRequest();
        request.setBody(parameter.getBody());
        request.setOrganCode(parameter.getOrganCode());
        request.setTransactionId(parameter.getTransactionId());
        request.setChannel(parameter.getChannel());
        request.setChannelName(parameter.getChannelName());
        String requestJson = JsonUtil.convertObject((Object)request);
        this.logger.info("Request Front Start - url:{} request:{} ", (Object)(frontUrl + businessCodeUrl), (Object)requestJson);
        String resultJson = null;
        try {
            resultJson = HttpKit.postMethod((String)(frontUrl + businessCodeUrl), (String)requestJson);
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            this.logger.error(e.getMessage());
        }
        this.logger.info("Request Front End - response:{}", (Object)resultJson);
        if (LOG_BUSSINESSCODE.contains(businessCode)) {
            HisBusinessLogEntity hisBusinessLogEntity = new HisBusinessLogEntity();
            hisBusinessLogEntity.setBusinessCode(businessCode);
            hisBusinessLogEntity.setDateSign(FORMAT.format(new Date()));
            hisBusinessLogEntity.setKeyWord(parameter.getKeyWord());
            hisBusinessLogEntity.setOrganCode(parameter.getOrganCode());
            hisBusinessLogEntity.setRequest(requestJson);
            hisBusinessLogEntity.setResponse(resultJson);
            this.businessLogRepository.saveAndFlush((Object)hisBusinessLogEntity);
            this.logger.info("Request Front log record - entity:{} ", (Object)hisBusinessLogEntity);
        }
        if (StringUtils.isBlank((String)resultJson)) {
            this.logger.error("Request Front Failed - \u65e0\u54cd\u5e94 ");
            return GatewayResponse.specialError((IError)IError.FEIGN_FAIL, (String)parameter.getTransactionId());
        }
        FrontResponse frontResponse = (FrontResponse)JsonUtil.convertObject((String)resultJson, FrontResponse.class);
        if (frontResponse == null) {
            this.logger.error("Request Front Failed - \u54cd\u5e94\u8f6c\u6362\u5f02\u5e38");
            return GatewayResponse.specialError((IError)IError.DATA_ERROR, (String)parameter.getTransactionId());
        }
        if (!"1".equals(frontResponse.getCode())) {
            this.logger.error("Request Front Failed - \u8bf7\u6c42\u7ed3\u679c-\u5931\u8d25");
            GatewayResponse gatewayResponse = new GatewayResponse();
            gatewayResponse.setCode("0");
            gatewayResponse.setMsg(frontResponse.getMessage());
            gatewayResponse.setErrCode(frontResponse.getErrCode());
            gatewayResponse.setTransactionId(frontResponse.getTransactionId());
            return gatewayResponse;
        }
        Object body = null;
        if (frontResponse.getBody() != null && (body = JsonUtil.convertObject((String)JsonUtil.convertObject((Object)frontResponse.getBody()), responseClass)) == null) {
            this.logger.error("Request Front Failed - \u54cd\u5e94\u5b9e\u4f53\u8f6c\u6362\u5f02\u5e38 ");
            return GatewayResponse.specialError((IError)IError.DATA_ERROR, (String)frontResponse.getTransactionId());
        }
        return GatewayResponse.specialSuccess(body, (String)frontResponse.getTransactionId());
    }

    @PostConstruct
    public void cleanRedisCache() {
        List list = this.businessConfigRepository.findListByOrganCode("651");
        for (HisBusinessConfigEntity entity : list) {
            this.redisConfiguration.redisPoolFactory().del(entity.getOrganCode() + "_BDDYZYY_" + entity.getBusinessCode());
        }
        this.redisConfiguration.redisPoolFactory().del("651_BDDYZYY_HISGATEWAY");
        this.logger.info("======redis\u7f13\u5b58\u5df2\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u52a0\u8f7d========");
    }
}

