/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.log.aspect;

import com.alibaba.druid.util.DruidWebUtils;
import com.ebaiyihui.log.entity.Log;
import com.ebaiyihui.log.service.impl.LogService;
import com.ebaiyihui.log.util.RequestHolder;
import com.ebaiyihui.log.util.StringUtil;
import com.ebaiyihui.log.util.ThrowableUtil;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@Aspect
public class LogAspect {
    private static final Logger log = LoggerFactory.getLogger(LogAspect.class);
    private final LogService logService;
    ThreadLocal<Long> currentTime = new ThreadLocal();

    public LogAspect(LogService logService) {
        this.logService = logService;
    }

    @Pointcut(value="@annotation(com.ebaiyihui.log.annotation.Log)")
    public void logPointcut() {
    }

    @Around(value="logPointcut()")
    public Object logAround(ProceedingJoinPoint joinPoint) throws Throwable {
        this.currentTime.set(System.currentTimeMillis());
        Object result = joinPoint.proceed();
        Log log = new Log("INFO", System.currentTimeMillis() - this.currentTime.get());
        this.currentTime.remove();
        HttpServletRequest request = RequestHolder.getHttpServletRequest();
        String userViewId = request.getHeader("userId");
        this.logService.save(userViewId, StringUtil.getBrowser(request), DruidWebUtils.getRemoteAddr((HttpServletRequest)request), joinPoint, log);
        return result;
    }

    @AfterThrowing(pointcut="logPointcut()", throwing="e")
    public void logAfterThrowing(JoinPoint joinPoint, Throwable e) {
        log.info("========\u9519\u8bef\u4fe1\u606f======>{}", (Object)ThrowableUtil.getStackTrace(e));
        Log log = new Log("ERROR", System.currentTimeMillis() - this.currentTime.get());
        this.currentTime.remove();
        log.setExceptionDetail(ThrowableUtil.getStackTrace(e).getBytes());
        HttpServletRequest request = RequestHolder.getHttpServletRequest();
        String userViewId = request.getHeader("userId");
        this.logService.save(userViewId, StringUtil.getBrowser(request), DruidWebUtils.getRemoteAddr((HttpServletRequest)request), (ProceedingJoinPoint)joinPoint, log);
    }
}

