/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.medicarecore.ybBusiness.service.hisfront.impl;

import cn.hutool.http.HttpRequest;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ebaiyihui.his.pojo.vo.base.FrontRequest;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import com.ebaiyihui.medicarecore.util.tool.HttpKitUtil;
import com.ebaiyihui.medicarecore.ybBusiness.domain.ResultResponse;
import com.ebaiyihui.medicarecore.ybBusiness.domain.entity.DoctorYbInfoEntrty;
import com.ebaiyihui.medicarecore.ybBusiness.domain.entity.DrugYbInfoEntrty;
import com.ebaiyihui.medicarecore.ybBusiness.domain.entity.HisBusinessUrlEntity;
import com.ebaiyihui.medicarecore.ybBusiness.domain.entity.HisDoctorDto;
import com.ebaiyihui.medicarecore.ybBusiness.domain.entity.YbBillInfoEntity;
import com.ebaiyihui.medicarecore.ybBusiness.domain.nc.respones.HisDoctorVo;
import com.ebaiyihui.medicarecore.ybBusiness.domain.nc.respones.HisDrugInfoVo;
import com.ebaiyihui.medicarecore.ybBusiness.mapper.HisBusinessUrlEntityMapper;
import com.ebaiyihui.medicarecore.ybBusiness.service.hisfront.MedicalHisFrontService;
import com.ebaiyihui.medicarecore.ybBusiness.service.hisfront.impl.MedicalHisFrontServiceImpl;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class MedicalHisFrontServiceImpl
implements MedicalHisFrontService {
    private static final Logger log = LoggerFactory.getLogger(MedicalHisFrontServiceImpl.class);
    @Autowired
    private HisBusinessUrlEntityMapper hisBusinessUrlEntityMapper;
    private static final String TENANT_ID = "1";
    private static final String USER_ID = "1";
    private static final String USER_NAME = "\u8d85\u7ea7\u7ba1\u7406\u5458";
    private static final String DOCTOR_INFO_URL = "/appoint/queryDoctor";
    private static final String DRUG_INFO_URL = "/drug/query/drugInfo";

    public ResultResponse<DoctorYbInfoEntrty> getDoctorYbinfo(String organCode, String doctroCode) {
        HisBusinessUrlEntity hisBusinessUrlEntity = (HisBusinessUrlEntity)this.hisBusinessUrlEntityMapper.selectOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"organ_code", (Object)organCode)).eq((Object)"status", (Object)new Byte("1")));
        if (StringUtils.isEmpty((Object)hisBusinessUrlEntity)) {
            return ResultResponse.error((String)"\u672a\u83b7\u53d6\u5230\u8bbf\u95eeurl\u5730\u5740");
        }
        FrontResponse frontResponse = new FrontResponse();
        DoctorYbInfoEntrty doctorYbInfoEntrty = new DoctorYbInfoEntrty();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("doctorCode", doctroCode);
        map.put("deptCode", "");
        String result = HttpRequest.post((String)hisBusinessUrlEntity.getHisFrontUrl()).body(JSONObject.toJSONString(map)).execute().body();
        if (StringUtils.isEmpty((Object)result)) {
            return ResultResponse.error((String)"\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u533b\u751f\u7684\u533b\u4fdd\u4ee3\u7801");
        }
        1 typeReference = new /* Unavailable Anonymous Inner Class!! */;
        frontResponse = (FrontResponse)JSONObject.parseObject((String)result, (Type)typeReference.getType(), (Feature[])new Feature[0]);
        if (frontResponse.getCode().equals("0")) {
            return ResultResponse.error((String)"\u672a\u67e5\u8be2\u5230\u533b\u751f\u533b\u4fdd\u767b\u8bb0\u4fe1\u606f");
        }
        doctorYbInfoEntrty = (DoctorYbInfoEntrty)frontResponse.getBody();
        log.info("\u67e5\u8be2\u533b\u751f\u533b\u4fdd\u767b\u8bb0\u4fe1\u606f\u51fa\u53c2\uff1a" + doctorYbInfoEntrty);
        return ResultResponse.success((Object)doctorYbInfoEntrty);
    }

    public ResultResponse<DoctorYbInfoEntrty> getZKDoctorYbinfo(String organCode, String doctorCode, String doctorName) {
        HisBusinessUrlEntity hisBusinessUrlEntity = (HisBusinessUrlEntity)this.hisBusinessUrlEntityMapper.selectOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"organ_code", (Object)organCode)).eq((Object)"status", (Object)new Byte("1")));
        if (StringUtils.isEmpty((Object)hisBusinessUrlEntity)) {
            return ResultResponse.error((String)"\u672a\u83b7\u53d6\u5230\u8bbf\u95eeurl\u5730\u5740");
        }
        FrontResponse frontResponse = new FrontResponse();
        DoctorYbInfoEntrty doctorYbInfoEntrty = new DoctorYbInfoEntrty();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("doctorCode", "");
        map.put("doctorName", doctorName);
        map.put("deptCode", "");
        String result = HttpRequest.post((String)(hisBusinessUrlEntity.getHisFrontUrl() + "getYbDoctorInfo")).body(JSONObject.toJSONString(map)).execute().body();
        if (StringUtils.isEmpty((Object)result)) {
            return ResultResponse.error((String)"\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u533b\u751f\u7684\u533b\u4fdd\u4ee3\u7801");
        }
        2 typeReference = new /* Unavailable Anonymous Inner Class!! */;
        frontResponse = (FrontResponse)JSONObject.parseObject((String)result, (Type)typeReference.getType(), (Feature[])new Feature[0]);
        if (frontResponse.getCode().equals("0")) {
            return ResultResponse.error((String)"\u672a\u67e5\u8be2\u5230\u533b\u751f\u533b\u4fdd\u767b\u8bb0\u4fe1\u606f");
        }
        doctorYbInfoEntrty = (DoctorYbInfoEntrty)frontResponse.getBody();
        log.info("\u67e5\u8be2\u533b\u751f\u533b\u4fdd\u767b\u8bb0\u4fe1\u606f\u51fa\u53c2\uff1a" + doctorYbInfoEntrty);
        return ResultResponse.success((Object)doctorYbInfoEntrty);
    }

    public ResultResponse<DrugYbInfoEntrty> getZKDrugYbInfo(String organCode, String productCode, String productName) {
        HisBusinessUrlEntity hisBusinessUrlEntity = (HisBusinessUrlEntity)this.hisBusinessUrlEntityMapper.selectOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"organ_code", (Object)organCode)).eq((Object)"status", (Object)new Byte("1")));
        if (StringUtils.isEmpty((Object)hisBusinessUrlEntity)) {
            return ResultResponse.error((String)"\u672a\u83b7\u53d6\u5230\u8bbf\u95eeurl\u5730\u5740");
        }
        FrontResponse frontResponse = new FrontResponse();
        DrugYbInfoEntrty drugYbInfoEntrty = new DrugYbInfoEntrty();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("productCode", productCode);
        map.put("productName", "");
        String result = HttpRequest.post((String)(hisBusinessUrlEntity.getHisFrontUrl() + "getDrugDict")).body(JSONObject.toJSONString(map)).execute().body();
        log.info("\u8bbf\u95ee\u524d\u7f6e\u673a\u67e5\u8be2\u836f\u54c1\u4fe1\u606f\u51fa\u53c2\uff1a" + drugYbInfoEntrty);
        if (StringUtils.isEmpty((Object)result)) {
            return ResultResponse.error((String)"\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u836f\u54c1\u4fe1\u606f");
        }
        3 typeReference = new /* Unavailable Anonymous Inner Class!! */;
        frontResponse = (FrontResponse)JSONObject.parseObject((String)result, (Type)typeReference.getType(), (Feature[])new Feature[0]);
        if (frontResponse.getCode().equals("0")) {
            return ResultResponse.error((String)"\u672a\u67e5\u8be2\u5230\u836f\u54c1\u4fe1\u606f\u4fe1\u606f");
        }
        drugYbInfoEntrty = (DrugYbInfoEntrty)frontResponse.getBody();
        log.info("\u67e5\u8be2\u836f\u54c1\u4fe1\u606f\u51fa\u53c2\uff1a" + drugYbInfoEntrty);
        return ResultResponse.success((Object)drugYbInfoEntrty);
    }

    public ResultResponse<String> insertBillInfo(String organCode, YbBillInfoEntity ybBillInfoEntity) {
        HisBusinessUrlEntity hisBusinessUrlEntity = (HisBusinessUrlEntity)this.hisBusinessUrlEntityMapper.selectOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"organ_code", (Object)organCode)).eq((Object)"status", (Object)new Byte("1")));
        if (StringUtils.isEmpty((Object)hisBusinessUrlEntity)) {
            return ResultResponse.error((String)"\u672a\u83b7\u53d6\u5230\u8bbf\u95eeurl\u5730\u5740");
        }
        FrontResponse frontResponse = new FrontResponse();
        String result = HttpRequest.post((String)(hisBusinessUrlEntity.getHisFrontUrl() + "insertBillInfo")).body(JSONObject.toJSONString((Object)ybBillInfoEntity)).execute().body();
        log.info("\u8bbf\u95ee\u524d\u7f6e\u673a\u4fdd\u5b58\u533b\u4fdd\u8d26\u5355\u6570\u636e\u51fa\u53c2\uff1a" + result);
        if (StringUtils.isEmpty((Object)result)) {
            return ResultResponse.error((String)"\u4fdd\u5b58\u8d26\u5355\u6570\u636e\u51fa\u9519\uff01");
        }
        4 typeReference = new /* Unavailable Anonymous Inner Class!! */;
        frontResponse = (FrontResponse)JSONObject.parseObject((String)result, (Type)typeReference.getType(), (Feature[])new Feature[0]);
        if (frontResponse.getCode().equals("0")) {
            return ResultResponse.error((String)"\u4fdd\u5b58\u8d26\u5355\u6570\u636e\u51fa\u9519\uff01");
        }
        log.info("\u4fdd\u5b58\u533b\u4fdd\u8d26\u5355\u4fe1\u606f\u51fa\u53c2\uff1a" + (String)frontResponse.getBody());
        return ResultResponse.success((Object)frontResponse.getBody());
    }

    public ResultResponse<YbBillInfoEntity> queryBillInfo(String organCode, YbBillInfoEntity ybBillInfoEntity) {
        HisBusinessUrlEntity hisBusinessUrlEntity = (HisBusinessUrlEntity)this.hisBusinessUrlEntityMapper.selectOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"organ_code", (Object)organCode)).eq((Object)"status", (Object)new Byte("1")));
        if (StringUtils.isEmpty((Object)hisBusinessUrlEntity)) {
            return ResultResponse.error((String)"\u672a\u83b7\u53d6\u5230\u8bbf\u95eeurl\u5730\u5740");
        }
        FrontResponse frontResponse = new FrontResponse();
        String result = HttpRequest.post((String)(hisBusinessUrlEntity.getHisFrontUrl() + "queryBillInfo")).body(JSONObject.toJSONString((Object)ybBillInfoEntity)).execute().body();
        log.info("\u8bbf\u95ee\u524d\u7f6e\u673a\u67e5\u8be2\u533b\u4fdd\u8d26\u5355\u6570\u636e\u51fa\u53c2\uff1a" + result);
        if (StringUtils.isEmpty((Object)result)) {
            return ResultResponse.error((String)"\u67e5\u8be2\u8d26\u5355\u6570\u636e\u51fa\u9519\uff01");
        }
        5 typeReference = new /* Unavailable Anonymous Inner Class!! */;
        frontResponse = (FrontResponse)JSONObject.parseObject((String)result, (Type)typeReference.getType(), (Feature[])new Feature[0]);
        if (frontResponse.getCode().equals("0")) {
            return ResultResponse.error((String)"\u67e5\u8be2\u8d26\u5355\u6570\u636e\u51fa\u9519\uff01");
        }
        log.info("\u67e5\u8be2\u533b\u4fdd\u8d26\u5355\u4fe1\u606f\u51fa\u53c2\uff1a" + frontResponse.getBody());
        return ResultResponse.success((Object)frontResponse.getBody());
    }

    public ResultResponse<HisDoctorVo> getCloudHisDoctorInfo(String organCode, String doctorCode, String doctorName) {
        try {
            HisBusinessUrlEntity hisBusinessUrlEntity = (HisBusinessUrlEntity)this.hisBusinessUrlEntityMapper.selectOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"organ_code", (Object)organCode)).eq((Object)"status", (Object)new Byte("1")));
            if (StringUtils.isEmpty((Object)hisBusinessUrlEntity)) {
                return ResultResponse.error((String)"\u672a\u83b7\u53d6\u5230\u8bbf\u95eeurl\u5730\u5740");
            }
            String url = hisBusinessUrlEntity.getCloudHisUrl() + DOCTOR_INFO_URL;
            Map headerMap = this.buildHeaderMap();
            FrontRequest doctorDtoFrontRequest = new FrontRequest();
            HisDoctorDto hisDoctorDto = new HisDoctorDto();
            hisDoctorDto.setId(Integer.valueOf(doctorCode));
            hisDoctorDto.setName(doctorName);
            doctorDtoFrontRequest.setBody((Object)hisDoctorDto);
            log.info("\u4e91his=>\u533b\u751f\u8bf7\u6c42url:{},param:{}", (Object)url, (Object)JSON.toJSONString((Object)doctorDtoFrontRequest));
            String result = HttpKitUtil.jsonPost((String)url, (String)JSON.toJSONString((Object)doctorDtoFrontRequest), (Map)headerMap);
            FrontResponse frontResponse = (FrontResponse)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)result), FrontResponse.class);
            log.info("\u4e91his=>\u533b\u751f\u8bf7\u6c42\u8fd4\u56de\u503c:{}" + JSONObject.toJSONString((Object)frontResponse));
            if (!"1".equals(frontResponse.getCode())) {
                return ResultResponse.error((String)frontResponse.getMessage());
            }
            HisDoctorVo data = (HisDoctorVo)JSON.parseObject((String)JSON.toJSONString((Object)frontResponse.getBody()), HisDoctorVo.class);
            return ResultResponse.success((Object)data);
        }
        catch (Exception e) {
            log.error("\u533b\u4fdd\u533b\u751f\u4fe1\u606f\u5f02\u5e38:{}", (Object)e.getMessage());
            return ResultResponse.error((String)e.getMessage());
        }
    }

    public ResultResponse<List<HisDrugInfoVo>> getCloudHisDrugYbInfo(String organCode, String productCode) {
        try {
            HisBusinessUrlEntity hisBusinessUrlEntity = (HisBusinessUrlEntity)this.hisBusinessUrlEntityMapper.selectOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"organ_code", (Object)organCode)).eq((Object)"status", (Object)new Byte("1")));
            if (StringUtils.isEmpty((Object)hisBusinessUrlEntity)) {
                return ResultResponse.error((String)"\u672a\u83b7\u53d6\u5230\u8bbf\u95eeurl\u5730\u5740");
            }
            String url = hisBusinessUrlEntity.getCloudHisUrl() + DRUG_INFO_URL;
            Map headerMap = this.buildHeaderMap();
            FrontRequest drugFrontRequest = new FrontRequest();
            drugFrontRequest.setBody(Arrays.asList(productCode));
            log.info("\u4e91his=>\u836f\u54c1\u8bf7\u6c42url:{},param:{}", (Object)url, (Object)JSON.toJSONString((Object)drugFrontRequest));
            String result = HttpKitUtil.jsonPost((String)url, (String)JSON.toJSONString((Object)drugFrontRequest), (Map)headerMap);
            FrontResponse frontResponse = (FrontResponse)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)result), FrontResponse.class);
            log.info("\u4e91his=>\u836f\u54c1\u8bf7\u6c42\u8fd4\u56de\u503c:{}" + JSONObject.toJSONString((Object)frontResponse));
            if (!"1".equals(frontResponse.getCode())) {
                return ResultResponse.error((String)frontResponse.getMessage());
            }
            List hisDrugInfoVos = JSON.parseArray((String)JSON.toJSONString((Object)frontResponse.getBody()), HisDrugInfoVo.class);
            return ResultResponse.success((Object)hisDrugInfoVos);
        }
        catch (Exception e) {
            log.error("\u533b\u4fdd\u836f\u54c1\u4fe1\u606f\u5f02\u5e38:{}", (Object)e.getMessage());
            return ResultResponse.error((String)e.getMessage());
        }
    }

    private Map<String, String> buildHeaderMap() {
        HashMap<String, String> headerMap = new HashMap<String, String>(3);
        headerMap.put("tenantId", "1");
        headerMap.put("userId", "1");
        headerMap.put("userName", USER_NAME);
        return headerMap;
    }
}

