/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.medicarecore.ybBusiness.service.nc.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alipay.api.AlipayApiException;
import com.alipay.api.AlipayClient;
import com.alipay.api.AlipayRequest;
import com.alipay.api.domain.MedicalNationalPayAuthInfo;
import com.alipay.api.request.AlipayCommerceMedicalAuthinfoAuthQueryRequest;
import com.alipay.api.request.AlipaySystemOauthTokenRequest;
import com.alipay.api.request.AlipayTradeAppPayRequest;
import com.alipay.api.request.AlipayTradeCloseRequest;
import com.alipay.api.request.AlipayTradeFastpayRefundQueryRequest;
import com.alipay.api.request.AlipayTradeQueryRequest;
import com.alipay.api.request.AlipayTradeRefundApplyRequest;
import com.alipay.api.request.AlipayUserInfoShareRequest;
import com.alipay.api.response.AlipayCommerceMedicalAuthinfoAuthQueryResponse;
import com.alipay.api.response.AlipaySystemOauthTokenResponse;
import com.alipay.api.response.AlipayTradeAppPayResponse;
import com.alipay.api.response.AlipayTradeCloseResponse;
import com.alipay.api.response.AlipayTradeFastpayRefundQueryResponse;
import com.alipay.api.response.AlipayTradeQueryResponse;
import com.alipay.api.response.AlipayTradeRefundApplyResponse;
import com.alipay.api.response.AlipayUserInfoShareResponse;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ebaiyihui.medicarecore.util.tool.AlipayClientUtil;
import com.ebaiyihui.medicarecore.util.tool.SnowflakeIdWorker;
import com.ebaiyihui.medicarecore.ybBusiness.domain.ResultResponse;
import com.ebaiyihui.medicarecore.ybBusiness.domain.alipay.request.AliPayCreateOrderRequest;
import com.ebaiyihui.medicarecore.ybBusiness.domain.alipay.request.AliPayGetAuthNoRequest;
import com.ebaiyihui.medicarecore.ybBusiness.domain.alipay.request.AliPayGetTokenRequest;
import com.ebaiyihui.medicarecore.ybBusiness.domain.alipay.request.AliPayOrderCloseRequest;
import com.ebaiyihui.medicarecore.ybBusiness.domain.alipay.request.AliPayQueryRequest;
import com.ebaiyihui.medicarecore.ybBusiness.domain.alipay.request.AliPayRefuntQueryRequest;
import com.ebaiyihui.medicarecore.ybBusiness.domain.alipay.request.AliPayRefuntRequest;
import com.ebaiyihui.medicarecore.ybBusiness.domain.alipay.response.AliPayGetAuthNoResponse;
import com.ebaiyihui.medicarecore.ybBusiness.domain.alipay.response.AliPayGetTokenResponse;
import com.ebaiyihui.medicarecore.ybBusiness.domain.alipay.response.AliPayGetUserInfoShareResponse;
import com.ebaiyihui.medicarecore.ybBusiness.domain.alipay.response.AliPayOrderCloseResponse;
import com.ebaiyihui.medicarecore.ybBusiness.domain.alipay.response.AliPayRefuntResponse;
import com.ebaiyihui.medicarecore.ybBusiness.domain.database.AuthNoEntity;
import com.ebaiyihui.medicarecore.ybBusiness.domain.database.YbAliConfigEntrty;
import com.ebaiyihui.medicarecore.ybBusiness.domain.database.YbConfigEntity;
import com.ebaiyihui.medicarecore.ybBusiness.mapper.AuthNoMapper;
import com.ebaiyihui.medicarecore.ybBusiness.mapper.YbAliConfigMapper;
import com.ebaiyihui.medicarecore.ybBusiness.mapper.YbConfigMapper;
import com.ebaiyihui.medicarecore.ybBusiness.service.databsase.YdMedicalDataBaseService;
import com.ebaiyihui.medicarecore.ybBusiness.service.nc.AliBusinessService;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AliBusinessServiceImpl
implements AliBusinessService {
    private static final Logger log = LoggerFactory.getLogger(AliBusinessServiceImpl.class);
    @Autowired
    private YbConfigMapper ybConfigMapper;
    @Autowired
    private AuthNoMapper authNoMapper;
    @Autowired
    private YbAliConfigMapper ybAliConfigMapper;
    @Autowired
    private YdMedicalDataBaseService ydMedicalDataBaseService;
    @Autowired
    private SnowflakeIdWorker snowflakeIdWorker;

    public ResultResponse<YbConfigEntity> getYbConfig(String orgCode) {
        YbConfigEntity ybConfigEntity = (YbConfigEntity)this.ybConfigMapper.selectOne((Wrapper)new QueryWrapper().eq((Object)"organ_code", (Object)orgCode));
        if (Objects.isNull(ybConfigEntity)) {
            return ResultResponse.error((String)"\u83b7\u53d6\u533b\u4fdd\u914d\u7f6e\u4fe1\u606f\u5931\u8d25");
        }
        return ResultResponse.success((Object)ybConfigEntity);
    }

    public ResultResponse<YbAliConfigEntrty> getAliConfig(String orgCode) {
        YbAliConfigEntrty ybAliConfigEntrty = (YbAliConfigEntrty)this.ybAliConfigMapper.selectOne((Wrapper)new QueryWrapper().eq((Object)"organ_code", (Object)orgCode));
        if (Objects.isNull(ybAliConfigEntrty)) {
            return ResultResponse.error((String)"\u83b7\u53d6\u533b\u4fdd\u914d\u7f6e\u4fe1\u606f\u5931\u8d25");
        }
        return ResultResponse.success((Object)ybAliConfigEntrty);
    }

    public ResultResponse<AliPayGetTokenResponse> getAliPayOauthToken(AliPayGetTokenRequest aliPayGetAuthNoRequest) {
        AliPayGetTokenResponse aliPayGetTokenResponse = new AliPayGetTokenResponse();
        try {
            ResultResponse ybAliConfigResponse = this.getAliConfig(aliPayGetAuthNoRequest.getOrganCode());
            if (ybAliConfigResponse.getCode().equals("0")) {
                return ResultResponse.error((String)ybAliConfigResponse.getMessage());
            }
            YbAliConfigEntrty ybAliConfigEntrty = (YbAliConfigEntrty)ybAliConfigResponse.getBody();
            log.info("\u83b7\u53d6\u652f\u4ed8\u5b9d\u914d\u7f6e\u4fe1\u606f\u5185\u5bb9\u4e3a->{}", (Object)JSON.toJSONString((Object)ybAliConfigEntrty));
            AlipayClient alipayClient = AlipayClientUtil.getInstance((String)ybAliConfigEntrty.getAppId(), (String)ybAliConfigEntrty.getPrivateKey(), (String)ybAliConfigEntrty.getAliPublicKey());
            AlipaySystemOauthTokenRequest request = new AlipaySystemOauthTokenRequest();
            request.setGrantType(aliPayGetAuthNoRequest.getGrant_type());
            request.setCode(aliPayGetAuthNoRequest.getCode());
            request.setRefreshToken(aliPayGetAuthNoRequest.getRefresh_token());
            log.info("getAliPayOauthTokenq\u8bf7\u6c42\u652f\u4ed8\u5b9d\u5165\u53c2->{}", (Object)JSON.toJSONString((Object)request));
            AlipaySystemOauthTokenResponse response = (AlipaySystemOauthTokenResponse)alipayClient.execute((AlipayRequest)request);
            if (!response.isSuccess()) {
                return ResultResponse.error((String)response.getSubMsg());
            }
            aliPayGetTokenResponse.setUserId(response.getUserId());
            aliPayGetTokenResponse.setAccessToken(response.getAccessToken());
            aliPayGetTokenResponse.setExpiresIn(response.getExpiresIn());
            aliPayGetTokenResponse.setRefreshToken(response.getRefreshToken());
            aliPayGetTokenResponse.setReExpiresIn(response.getReExpiresIn());
            aliPayGetTokenResponse.setAuthStart(response.getAuthStart());
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u83b7\u53d6\u652f\u4ed8\u5b9dtoken\u5f02\u5e38");
            return ResultResponse.error((String)"\u83b7\u53d6\u652f\u4ed8\u5b9dtoken\u5f02\u5e38");
        }
        return ResultResponse.success((Object)aliPayGetTokenResponse);
    }

    public ResultResponse<AliPayGetUserInfoShareResponse> getAliPayUserInfo(AliPayGetTokenRequest aliPayGetAuthNoRequest) {
        AliPayGetUserInfoShareResponse aliPayGetUserInfoShareResponse = new AliPayGetUserInfoShareResponse();
        try {
            AlipayUserInfoShareRequest request;
            ResultResponse responseResultResponse = this.getAliPayOauthToken(aliPayGetAuthNoRequest);
            if (responseResultResponse.getCode().equals("0")) {
                return ResultResponse.error((String)responseResultResponse.getMessage());
            }
            ResultResponse ybAliConfigResponse = this.getAliConfig(aliPayGetAuthNoRequest.getOrganCode());
            if (ybAliConfigResponse.getCode().equals("0")) {
                return ResultResponse.error((String)ybAliConfigResponse.getMessage());
            }
            YbAliConfigEntrty ybAliConfigEntrty = (YbAliConfigEntrty)ybAliConfigResponse.getBody();
            AlipayClient alipayClient = AlipayClientUtil.getInstance((String)ybAliConfigEntrty.getAppId(), (String)ybAliConfigEntrty.getPrivateKey(), (String)ybAliConfigEntrty.getAliPublicKey());
            AlipayUserInfoShareResponse response = (AlipayUserInfoShareResponse)alipayClient.execute((AlipayRequest)(request = new AlipayUserInfoShareRequest()), ((AliPayGetTokenResponse)responseResultResponse.getBody()).getAccessToken());
            if (!response.isSuccess()) {
                return ResultResponse.error((String)response.getSubMsg());
            }
            aliPayGetUserInfoShareResponse.setUserId(response.getUserId());
            aliPayGetUserInfoShareResponse.setAvatar(response.getAvatar());
            aliPayGetUserInfoShareResponse.setCity(response.getCity());
            aliPayGetUserInfoShareResponse.setNickName(response.getNickName());
            aliPayGetUserInfoShareResponse.setProvince(response.getProvince());
            aliPayGetUserInfoShareResponse.setGender(response.getGender());
            aliPayGetUserInfoShareResponse.setCertType(response.getCertType());
            aliPayGetUserInfoShareResponse.setCertNo(response.getCertNo());
            aliPayGetUserInfoShareResponse.setUserName(response.getUserName());
            aliPayGetUserInfoShareResponse.setMobile(response.getMobile());
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u83b7\u53d6\u652f\u4ed8\u5b9d\u7528\u6237\u4fe1\u606f\u5f02\u5e38");
            return ResultResponse.error((String)"\u83b7\u53d6\u652f\u4ed8\u5b9d\u7528\u6237\u4fe1\u606f\u5f02\u5e38");
        }
        return ResultResponse.success((Object)aliPayGetUserInfoShareResponse);
    }

    public ResultResponse<AliPayGetAuthNoResponse> getMedicalAuthinfoAuth(AliPayGetAuthNoRequest getAuthNoRequest) {
        AliPayGetAuthNoResponse aliPayGetAuthNoResponse = new AliPayGetAuthNoResponse();
        try {
            ResultResponse ybConfigResponse = this.getYbConfig(getAuthNoRequest.getOrganCode());
            if (ybConfigResponse.getCode().equals("0")) {
                return ResultResponse.error((String)ybConfigResponse.getMessage());
            }
            YbConfigEntity ybConfigEntity = (YbConfigEntity)ybConfigResponse.getBody();
            AliPayGetTokenRequest aliPayGetAuthNoRequest = new AliPayGetTokenRequest();
            aliPayGetAuthNoRequest.setGrant_type(getAuthNoRequest.getGrant_type());
            aliPayGetAuthNoRequest.setRefresh_token(getAuthNoRequest.getRefresh_token());
            aliPayGetAuthNoRequest.setCode(getAuthNoRequest.getCode());
            aliPayGetAuthNoRequest.setOrganCode(getAuthNoRequest.getOrganCode());
            ResultResponse responseResultResponse = this.getAliPayOauthToken(aliPayGetAuthNoRequest);
            if (responseResultResponse.getCode().equals("0")) {
                return ResultResponse.error((String)responseResultResponse.getMessage());
            }
            ResultResponse ybAliConfigResponse = this.getAliConfig(getAuthNoRequest.getOrganCode());
            if (ybAliConfigResponse.getCode().equals("0")) {
                return ResultResponse.error((String)ybAliConfigResponse.getMessage());
            }
            YbAliConfigEntrty ybAliConfigEntrty = (YbAliConfigEntrty)ybAliConfigResponse.getBody();
            AlipayClient alipayClient = AlipayClientUtil.getInstance((String)ybAliConfigEntrty.getAppId(), (String)ybAliConfigEntrty.getPrivateKey(), (String)ybAliConfigEntrty.getAliPublicKey());
            AlipayCommerceMedicalAuthinfoAuthQueryRequest request = new AlipayCommerceMedicalAuthinfoAuthQueryRequest();
            JSONObject bizContent = new JSONObject();
            bizContent.put("auth_token", (Object)getAuthNoRequest.getAuth_token());
            bizContent.put("alipay_user_id", (Object)getAuthNoRequest.getAlipay_user_id());
            bizContent.put("req_biz_no", (Object)String.valueOf(this.snowflakeIdWorker.nextId()));
            bizContent.put("org_app_id", (Object)ybConfigEntity.getOrgAppId());
            bizContent.put("ins_code", (Object)"NATHSA");
            bizContent.put("org_code", (Object)ybConfigEntity.getInsuranceCode());
            bizContent.put("org_chnl_crtf_code", (Object)ybConfigEntity.getOrgChnlCrtfCod().replaceAll("\\r\\n|\\r|\\n", "").trim());
            bizContent.put("ol_biz_type_code", (Object)ybAliConfigEntrty.getBiztype());
            bizContent.put("call_url", (Object)getAuthNoRequest.getCall_url());
            JSONObject extendParams = new JSONObject();
            extendParams.put("sys_service_provider_id", (Object)"");
            bizContent.put("extend_params", (Object)extendParams);
            request.setBizContent(JSONObject.toJSONString((Object)bizContent));
            log.info("\u56fd\u5bb6\u533b\u4fdd\u5c40\u7ebf\u4e0a\u4e1a\u52a1\u8eab\u4efd\u6838\u9a8c\u4fe1\u606f\u6388\u6743\u67e5\u8be2\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)bizContent));
            AlipayCommerceMedicalAuthinfoAuthQueryResponse response = (AlipayCommerceMedicalAuthinfoAuthQueryResponse)alipayClient.execute((AlipayRequest)request, ((AliPayGetTokenResponse)responseResultResponse.getBody()).getAccessToken());
            log.info("\u56fd\u5bb6\u533b\u4fdd\u5c40\u7ebf\u4e0a\u4e1a\u52a1\u8eab\u4efd\u6838\u9a8c\u4fe1\u606f\u6388\u6743\u67e5\u8be2\u51fa\u53c2\uff1a" + JSONObject.toJSONString((Object)response));
            if (!response.isSuccess()) {
                return ResultResponse.error((String)response.getSubMsg());
            }
            MedicalNationalPayAuthInfo medicalNationalPayAuthInfo = response.getData();
            aliPayGetAuthNoResponse.setOpenapiAppId(medicalNationalPayAuthInfo.getOpenapiAppId());
            aliPayGetAuthNoResponse.setReqBizNo(medicalNationalPayAuthInfo.getReqBizNo());
            aliPayGetAuthNoResponse.setAuthUrl(medicalNationalPayAuthInfo.getAuthUrl());
            aliPayGetAuthNoResponse.setAuthStas(medicalNationalPayAuthInfo.getAuthStas());
            aliPayGetAuthNoResponse.setAuthTime(medicalNationalPayAuthInfo.getAuthTime());
            aliPayGetAuthNoResponse.setPayAuthNo(medicalNationalPayAuthInfo.getPayAuthNo());
            aliPayGetAuthNoResponse.setAuthNo(medicalNationalPayAuthInfo.getAuthNo());
            aliPayGetAuthNoResponse.setMedicalCardInstId(medicalNationalPayAuthInfo.getMedicalCardInstId());
            aliPayGetAuthNoResponse.setMedicalCardId(medicalNationalPayAuthInfo.getMedicalCardId());
            AuthNoEntity authNoEntity = new AuthNoEntity();
            authNoEntity.setAuthNo(medicalNationalPayAuthInfo.getAuthNo());
            authNoEntity.setPayAuthNo(medicalNationalPayAuthInfo.getPayAuthNo());
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u56fd\u5bb6\u533b\u4fdd\u5c40\u7ebf\u4e0a\u4e1a\u52a1\u8eab\u4efd\u6838\u9a8c\u4fe1\u606f\u6388\u6743\u67e5\u8be2\u5f02\u5e38");
            return ResultResponse.error((String)"\u56fd\u5bb6\u533b\u4fdd\u5c40\u7ebf\u4e0a\u4e1a\u52a1\u8eab\u4efd\u6838\u9a8c\u4fe1\u606f\u6388\u6743\u67e5\u8be2\u5f02\u5e38");
        }
        return ResultResponse.success((Object)aliPayGetAuthNoResponse);
    }

    public ResultResponse<String> alipayTradeAppPay(AliPayCreateOrderRequest aliPayCreateOrderRequest) {
        AlipayTradeAppPayResponse response = new AlipayTradeAppPayResponse();
        try {
            ResultResponse ybAliConfigResponse = this.getAliConfig(aliPayCreateOrderRequest.getOrganCode());
            if (ybAliConfigResponse.getCode().equals("0")) {
                return ResultResponse.error((String)ybAliConfigResponse.getMessage());
            }
            YbAliConfigEntrty ybAliConfigEntrty = (YbAliConfigEntrty)ybAliConfigResponse.getBody();
            AlipayClient alipayClient = AlipayClientUtil.getInstance((String)ybAliConfigEntrty.getAppId(), (String)ybAliConfigEntrty.getPrivateKey(), (String)ybAliConfigEntrty.getAliPublicKey());
            AlipayTradeAppPayRequest request = new AlipayTradeAppPayRequest();
            JSONObject bizContent = new JSONObject();
            bizContent.put("out_trade_no", (Object)aliPayCreateOrderRequest.getOut_trade_no());
            bizContent.put("total_amount", (Object)String.valueOf(aliPayCreateOrderRequest.getTotal_amount()));
            bizContent.put("subject", (Object)aliPayCreateOrderRequest.getSubject());
            bizContent.put("product_code", (Object)aliPayCreateOrderRequest.getProduct_code());
            bizContent.put("time_expire", (Object)aliPayCreateOrderRequest.getTime_expire());
            JSONObject extendParams = new JSONObject();
            extendParams.put("IS_INSURANCE_PAY", (Object)aliPayCreateOrderRequest.getExtend_params().getIsInsurancePay());
            extendParams.put("medical_card_inst_id", (Object)aliPayCreateOrderRequest.getExtend_params().getMedical_card_inst_id());
            extendParams.put("medical_card_id", (Object)aliPayCreateOrderRequest.getExtend_params().getMedical_card_id());
            JSONObject medicalRequesCotennt = new JSONObject();
            extendParams.put("medical_request_content", (Object)JSONObject.toJSONString((Object)medicalRequesCotennt));
            JSONObject medicalRequesExt = new JSONObject();
            medicalRequesExt.put("gmt_out_create", (Object)aliPayCreateOrderRequest.getExtend_params().getMedical_request_ext().getGmt_out_create());
            medicalRequesExt.put("out_trade_no", (Object)aliPayCreateOrderRequest.getExtend_params().getMedical_request_ext().getOut_trade_no());
            medicalRequesExt.put("serial_no", (Object)aliPayCreateOrderRequest.getExtend_params().getMedical_request_ext().getSerial_no());
            medicalRequesExt.put("bill_no", (Object)aliPayCreateOrderRequest.getExtend_params().getMedical_request_ext().getBill_no());
            medicalRequesExt.put("industry", (Object)aliPayCreateOrderRequest.getExtend_params().getMedical_request_ext().getIndustry());
            medicalRequesExt.put("org_no", (Object)ybAliConfigEntrty.getAliOrgCodg());
            medicalRequesExt.put("org_name", (Object)ybAliConfigEntrty.getOrganName());
            medicalRequesExt.put("pay_auth_no", (Object)aliPayCreateOrderRequest.getExtend_params().getMedical_request_ext().getPay_auth_no());
            medicalRequesExt.put("chinfo", (Object)aliPayCreateOrderRequest.getExtend_params().getMedical_request_ext().getChinfo());
            medicalRequesExt.put("scene", (Object)aliPayCreateOrderRequest.getExtend_params().getMedical_request_ext().getScene());
            medicalRequesExt.put("insurance_pay_scene", (Object)aliPayCreateOrderRequest.getExtend_params().getMedical_request_ext().getInsurance_pay_scene());
            medicalRequesExt.put("payment_city_code", (Object)aliPayCreateOrderRequest.getExtend_params().getMedical_request_ext().getPayment_city_code());
            extendParams.put("medical_request_ext", (Object)JSONObject.toJSONString((Object)medicalRequesExt));
            bizContent.put("extend_params", (Object)extendParams);
            request.setNotifyUrl(aliPayCreateOrderRequest.getNotifyUrl());
            request.setBizContent(JSONObject.toJSONString((Object)bizContent));
            log.info("\u652f\u4ed8\u5b9d\u6700\u7ec8\u4e0b\u5355\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)bizContent));
            log.info("\u652f\u4ed8\u5b9d\u6700\u7ec8\u4e0b\u5355\u5165\u53c2request\uff1a" + JSONObject.toJSONString((Object)request));
            response = (AlipayTradeAppPayResponse)alipayClient.sdkExecute((AlipayRequest)request);
            if (!response.isSuccess()) {
                return ResultResponse.error((String)response.getSubMsg());
            }
            log.info("\u652f\u4ed8\u5b9d\u6700\u7ec8\u4e0b\u5355\u51fa\u53c2\uff1a" + JSONObject.toJSONString((Object)response));
            this.ydMedicalDataBaseService.insetYbAliPayOrderInfo(aliPayCreateOrderRequest, response.getBody(), ybAliConfigEntrty);
        }
        catch (AlipayApiException e) {
            e.printStackTrace();
            log.info("\u652f\u4ed8\u5b9d\u4e0b\u5355\u5f02\u5e38");
            return ResultResponse.error((String)"\u652f\u4ed8\u5b9d\u4e0b\u5355\u5f02\u5e38");
        }
        return ResultResponse.success((Object)response.getBody());
    }

    public ResultResponse<AlipayTradeQueryResponse> queryAliPayOrderState(AliPayQueryRequest aliPayQueryRequesy) {
        AlipayTradeQueryResponse response = new AlipayTradeQueryResponse();
        try {
            ResultResponse ybAliConfigResponse = this.getAliConfig(aliPayQueryRequesy.getOrganCode());
            if (ybAliConfigResponse.getCode().equals("0")) {
                return ResultResponse.error((String)ybAliConfigResponse.getMessage());
            }
            YbAliConfigEntrty ybAliConfigEntrty = (YbAliConfigEntrty)ybAliConfigResponse.getBody();
            AlipayClient alipayClient = AlipayClientUtil.getInstance((String)ybAliConfigEntrty.getAppId(), (String)ybAliConfigEntrty.getPrivateKey(), (String)ybAliConfigEntrty.getAliPublicKey());
            AlipayTradeQueryRequest request = new AlipayTradeQueryRequest();
            JSONObject bizContent = new JSONObject();
            bizContent.put("out_trade_no", (Object)aliPayQueryRequesy.getOut_trade_no());
            bizContent.put("trade_no", (Object)aliPayQueryRequesy.getTrade_no());
            log.info("\u652f\u4ed8\u5b9d\u67e5\u8be2\u652f\u4ed8\u72b6\u6001\u6700\u7ec8\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)bizContent));
            request.setBizContent(bizContent.toString());
            response = (AlipayTradeQueryResponse)alipayClient.execute((AlipayRequest)request);
            log.info("\u652f\u4ed8\u5b9d\u67e5\u8be2\u652f\u4ed8\u72b6\u6001\u6700\u7ec8\u51fa\u53c2\uff1a" + JSONObject.toJSONString((Object)response));
            if (!response.isSuccess()) {
                return ResultResponse.error((String)response.getSubMsg());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u67e5\u8be2\u652f\u4ed8\u5b9d\u8ba2\u5355\u5f02\u5e38");
            return ResultResponse.error((String)"\u67e5\u8be2\u652f\u4ed8\u5b9d\u8ba2\u5355\u5f02\u5e38");
        }
        return ResultResponse.success((Object)response);
    }

    public ResultResponse<AliPayOrderCloseResponse> closeAliPayOrder(AliPayOrderCloseRequest payOrderCloseRequest) {
        AliPayOrderCloseResponse aliPayOrderCloseResponse = new AliPayOrderCloseResponse();
        try {
            ResultResponse ybAliConfigResponse = this.getAliConfig(payOrderCloseRequest.getOrganCode());
            if (ybAliConfigResponse.getCode().equals("0")) {
                return ResultResponse.error((String)ybAliConfigResponse.getMessage());
            }
            YbAliConfigEntrty ybAliConfigEntrty = (YbAliConfigEntrty)ybAliConfigResponse.getBody();
            AlipayClient alipayClient = AlipayClientUtil.getInstance((String)ybAliConfigEntrty.getAppId(), (String)ybAliConfigEntrty.getPrivateKey(), (String)ybAliConfigEntrty.getAliPublicKey());
            AlipayTradeCloseRequest request = new AlipayTradeCloseRequest();
            JSONObject bizContent = new JSONObject();
            bizContent.put("trade_no", (Object)payOrderCloseRequest.getTrade_no());
            request.setBizContent(bizContent.toString());
            AlipayTradeCloseResponse response = (AlipayTradeCloseResponse)alipayClient.execute((AlipayRequest)request);
            if (!response.isSuccess()) {
                return ResultResponse.error((String)response.getSubMsg());
            }
            aliPayOrderCloseResponse.setTradeNo(response.getTradeNo());
            aliPayOrderCloseResponse.setOutTradeNo(response.getOutTradeNo());
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u5173\u95ed\u652f\u4ed8\u5b9d\u8ba2\u5355\u5f02\u5e38");
            return ResultResponse.error((String)"\u5173\u95ed\u652f\u4ed8\u5b9d\u8ba2\u5355\u5f02\u5e38");
        }
        return ResultResponse.success((Object)aliPayOrderCloseResponse);
    }

    public ResultResponse<AliPayRefuntResponse> refuntAliPayOrder(AliPayRefuntRequest aliPayRefuntRequest) {
        AliPayRefuntResponse aliPayRefuntResponse = new AliPayRefuntResponse();
        ResultResponse resultResponse = new ResultResponse();
        try {
            ResultResponse ybAliConfigResponse = this.getAliConfig(aliPayRefuntRequest.getOrganCode());
            if (ybAliConfigResponse.getCode().equals("0")) {
                return ResultResponse.error((String)ybAliConfigResponse.getMessage());
            }
            YbAliConfigEntrty ybAliConfigEntrty = (YbAliConfigEntrty)ybAliConfigResponse.getBody();
            AlipayClient alipayClient = AlipayClientUtil.getInstance((String)ybAliConfigEntrty.getAppId(), (String)ybAliConfigEntrty.getPrivateKey(), (String)ybAliConfigEntrty.getAliPublicKey());
            String biz_content = "{\"extend_params\":{\"cancel_serial_no\":\"" + aliPayRefuntRequest.getExtend_params().getCancel_serial_no() + "\",\"cancel_bill_no\":\"" + aliPayRefuntRequest.getExtend_params().getCancel_bill_nol() + "\"},\"trade_no\":\"" + aliPayRefuntRequest.getTrade_no() + "\",\"out_trade_no\":\"" + aliPayRefuntRequest.getOut_trade_no() + "\",\"refund_amount\":\"" + aliPayRefuntRequest.getRefund_amount() + "\",\"out_request_no\":\"" + aliPayRefuntRequest.getOut_request_no() + "\",\"refund_reason\":\"" + aliPayRefuntRequest.getRefund_reason() + "\"}";
            AlipayTradeRefundApplyRequest request = new AlipayTradeRefundApplyRequest();
            request.setBizContent(biz_content);
            log.info("\u652f\u4ed8\u5b9d\u9000\u6b3e\u6700\u7ec8\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)aliPayRefuntRequest));
            AlipayTradeRefundApplyResponse response = (AlipayTradeRefundApplyResponse)alipayClient.execute((AlipayRequest)request);
            log.info("\u652f\u4ed8\u5b9d\u9000\u6b3e\u6700\u7ec8\u51fa\u53c2\uff1a" + JSONObject.toJSONString((Object)response));
            if (!response.isSuccess()) {
                return ResultResponse.error((String)response.getSubMsg());
            }
            aliPayRefuntResponse.setTradeNo(response.getTradeNo());
            aliPayRefuntResponse.setOutTradeNo(response.getOutTradeNo());
            aliPayRefuntResponse.setOutRequestNo(response.getOutRequestNo());
            aliPayRefuntResponse.setRefundAmount(response.getRefundAmount());
            aliPayRefuntResponse.setRefundStatus(response.getRefundStatus());
            switch (aliPayRefuntResponse.getRefundStatus()) {
                case "REFUND_PROCESSING": 
                case "REFUND_SUCCESS": {
                    resultResponse = ResultResponse.success((Object)aliPayRefuntResponse);
                    break;
                }
                case "REFUND_FAIL": {
                    resultResponse = ResultResponse.error((String)"\u9000\u6b3e\u5931\u8d25");
                    break;
                }
                default: {
                    resultResponse = ResultResponse.error((String)"\u9000\u6b3e\u72b6\u6001\u672a\u77e5");
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u652f\u4ed8\u5b9d\u9000\u6b3e\u5f02\u5e38");
            return ResultResponse.error((String)"\u652f\u4ed8\u5b9d\u9000\u6b3e\u5f02\u5e38");
        }
        return resultResponse;
    }

    public ResultResponse<AlipayTradeFastpayRefundQueryResponse> queryRefuntAliPayOrder(AliPayRefuntQueryRequest aliPayRefuntQueryRequest) {
        AlipayTradeFastpayRefundQueryResponse response = new AlipayTradeFastpayRefundQueryResponse();
        try {
            ResultResponse ybAliConfigResponse = this.getAliConfig(aliPayRefuntQueryRequest.getOrganCode());
            if (ybAliConfigResponse.getCode().equals("0")) {
                return ResultResponse.error((String)ybAliConfigResponse.getMessage());
            }
            YbAliConfigEntrty ybAliConfigEntrty = (YbAliConfigEntrty)ybAliConfigResponse.getBody();
            AlipayClient alipayClient = AlipayClientUtil.getInstance((String)ybAliConfigEntrty.getAppId(), (String)ybAliConfigEntrty.getPrivateKey(), (String)ybAliConfigEntrty.getAliPublicKey());
            AlipayTradeFastpayRefundQueryRequest request = new AlipayTradeFastpayRefundQueryRequest();
            JSONObject bizContent = new JSONObject();
            bizContent.put("trade_no", (Object)aliPayRefuntQueryRequest.getTrade_no());
            bizContent.put("out_request_no", (Object)aliPayRefuntQueryRequest.getOut_request_no());
            request.setBizContent(bizContent.toString());
            response = (AlipayTradeFastpayRefundQueryResponse)alipayClient.execute((AlipayRequest)request);
            if (!response.isSuccess()) {
                return ResultResponse.error((String)response.getSubMsg());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u652f\u4ed8\u5b9d\u9000\u6b3e\u67e5\u8be2\u5f02\u5e38");
            return ResultResponse.error((String)"\u652f\u4ed8\u5b9d\u9000\u6b3e\u67e5\u8be2\u5f02\u5e38");
        }
        return ResultResponse.success((Object)response);
    }
}

