/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.medicarecore.ybBusiness.service.nc.impl;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alipay.api.response.AlipayTradeQueryResponse;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ebaiyihui.medicarecore.util.tool.DateUtils;
import com.ebaiyihui.medicarecore.util.tool.RabbitMqUtils;
import com.ebaiyihui.medicarecore.ybBusiness.domain.ResultResponse;
import com.ebaiyihui.medicarecore.ybBusiness.domain.alipay.request.AliPayQueryRequest;
import com.ebaiyihui.medicarecore.ybBusiness.domain.alipay.request.AliPayRefuntExtendParamsEntrty;
import com.ebaiyihui.medicarecore.ybBusiness.domain.alipay.request.AliPayRefuntRequest;
import com.ebaiyihui.medicarecore.ybBusiness.domain.alipay.response.AliPayQueryOrderStateResponse;
import com.ebaiyihui.medicarecore.ybBusiness.domain.database.AliPayCreateOrderEntrty;
import com.ebaiyihui.medicarecore.ybBusiness.domain.database.MedDoctorInfoEntity;
import com.ebaiyihui.medicarecore.ybBusiness.domain.database.MedicalRevokeorderEntrty;
import com.ebaiyihui.medicarecore.ybBusiness.domain.database.YbConfigEntity;
import com.ebaiyihui.medicarecore.ybBusiness.domain.database.YbDrugDataEntity;
import com.ebaiyihui.medicarecore.ybBusiness.domain.database.YbPayMedicalOrderEntrty;
import com.ebaiyihui.medicarecore.ybBusiness.domain.entity.DoctorYbInfoEntrty;
import com.ebaiyihui.medicarecore.ybBusiness.domain.gz.request.UndoOrderRequest;
import com.ebaiyihui.medicarecore.ybBusiness.domain.gz.request.YdCreadOrderRequest;
import com.ebaiyihui.medicarecore.ybBusiness.domain.gz.response.YdBaseResponse;
import com.ebaiyihui.medicarecore.ybBusiness.domain.gz.response.YdCreadOrderResponse;
import com.ebaiyihui.medicarecore.ybBusiness.domain.nc.request.CreatePayMedicalOrderRequest;
import com.ebaiyihui.medicarecore.ybBusiness.domain.nc.request.MedicalCheckOrganRequest;
import com.ebaiyihui.medicarecore.ybBusiness.domain.nc.request.MedicalChronicRequest;
import com.ebaiyihui.medicarecore.ybBusiness.domain.nc.request.MedicalPaymentRequest;
import com.ebaiyihui.medicarecore.ybBusiness.domain.nc.request.MedicalRevokeorderRequest;
import com.ebaiyihui.medicarecore.ybBusiness.domain.nc.request.MoveUploadInfoDiseinfoListRequest;
import com.ebaiyihui.medicarecore.ybBusiness.domain.nc.request.MoveUploadInfoFeedetailListRequest;
import com.ebaiyihui.medicarecore.ybBusiness.domain.nc.request.MoveUploadInfoRequest;
import com.ebaiyihui.medicarecore.ybBusiness.domain.nc.request.QueryMedicalSettlementOrderRequest;
import com.ebaiyihui.medicarecore.ybBusiness.domain.nc.request.RefundOrderRequest;
import com.ebaiyihui.medicarecore.ybBusiness.domain.nc.request.RegistrationRequest;
import com.ebaiyihui.medicarecore.ybBusiness.domain.nc.request.RegistrationRevokeRequest;
import com.ebaiyihui.medicarecore.ybBusiness.domain.nc.respones.BaseMoveResponse;
import com.ebaiyihui.medicarecore.ybBusiness.domain.nc.respones.CreatePayMedicalOrderResponse;
import com.ebaiyihui.medicarecore.ybBusiness.domain.nc.respones.Datavo;
import com.ebaiyihui.medicarecore.ybBusiness.domain.nc.respones.HisDoctorVo;
import com.ebaiyihui.medicarecore.ybBusiness.domain.nc.respones.HisDrugInfoVo;
import com.ebaiyihui.medicarecore.ybBusiness.domain.nc.respones.MoveUploadInfoResponse;
import com.ebaiyihui.medicarecore.ybBusiness.domain.nc.respones.QueryMedicalSettlementOrderResponse;
import com.ebaiyihui.medicarecore.ybBusiness.domain.nc.respones.RefundOrderResponse;
import com.ebaiyihui.medicarecore.ybBusiness.domain.nc.respones.YbBaseResponse;
import com.ebaiyihui.medicarecore.ybBusiness.domain.nc.respones.YbRegistrationResponse;
import com.ebaiyihui.medicarecore.ybBusiness.mapper.MedDoctorInfoMapper;
import com.ebaiyihui.medicarecore.ybBusiness.mapper.YbDrugDataMapper;
import com.ebaiyihui.medicarecore.ybBusiness.service.databsase.YdMedicalDataBaseService;
import com.ebaiyihui.medicarecore.ybBusiness.service.gz.YdMedicalBusinessService;
import com.ebaiyihui.medicarecore.ybBusiness.service.hisfront.MedicalHisFrontService;
import com.ebaiyihui.medicarecore.ybBusiness.service.nc.AliBusinessService;
import com.ebaiyihui.medicarecore.ybBusiness.service.nc.MedicalBusinessService;
import com.ebaiyihui.medicarecore.ybBusiness.service.nc.MedicalPaymentService;
import com.ebaiyihui.medicarecore.ybBusiness.service.nc.TencentServicce;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class MedicalPaymentServiceImpl
implements MedicalPaymentService {
    private static final Logger log = LoggerFactory.getLogger(MedicalPaymentServiceImpl.class);
    @Autowired
    private MedicalBusinessService medicalBusinessService;
    @Autowired
    private YdMedicalBusinessService ydMedicalBusinessService;
    @Autowired
    private MedicalHisFrontService medicalHisFrontService;
    @Autowired
    private RabbitTemplate rabbitTemplate;
    @Autowired
    private AliBusinessService aliBusinessService;
    @Autowired
    private YbDrugDataMapper ybDrugDataMapper;
    @Autowired
    private MedDoctorInfoMapper medDoctorInfoMapper;
    @Autowired
    private TencentServicce tencentServicce;
    private ExecutorService executor = Executors.newCachedThreadPool();
    @Value(value="${zk.presdetailurl}")
    private String ZKPRESDETAILURL;
    public static final String SUCCESS = "1";
    @Autowired
    private YdMedicalDataBaseService ydMedicalDataBaseService;

    public ResultResponse<BaseMoveResponse<CreatePayMedicalOrderResponse>> medicalInsurancePayment(MedicalPaymentRequest medicalPaymentRequest) {
        ResultResponse resultResponse;
        if (StringUtils.isEmpty((Object)medicalPaymentRequest.getOrganCode())) {
            medicalPaymentRequest.setOrganCode("360ZFB");
        }
        String chrgBchno = "GN" + medicalPaymentRequest.getChrgBchno();
        String feedetlSn = "GNYFYHLWYY-" + System.currentTimeMillis();
        if ("130188".equals(medicalPaymentRequest.getOrganCode())) {
            resultResponse = this.medicalHisFrontService.getZKDoctorYbinfo(medicalPaymentRequest.getOrganCode(), medicalPaymentRequest.getDoctorCode(), medicalPaymentRequest.getDoctorName());
            chrgBchno = "ZK" + medicalPaymentRequest.getChrgBchno();
            feedetlSn = "NCZKHLWYY-" + System.currentTimeMillis();
        } else {
            resultResponse = this.medicalHisFrontService.getDoctorYbinfo(medicalPaymentRequest.getOrganCode(), medicalPaymentRequest.getDoctorCode());
        }
        if (resultResponse.getCode().equals("0")) {
            return ResultResponse.error((String)"\u672a\u67e5\u8be2\u5230\u533b\u751f\u533b\u4fdd\u767b\u8bb0\u4fe1\u606f");
        }
        DoctorYbInfoEntrty doctorYbInfoEntrty = (DoctorYbInfoEntrty)resultResponse.getBody();
        RegistrationRequest registrationRequest = new RegistrationRequest();
        registrationRequest.setInsuplc_admdvs(medicalPaymentRequest.getInsuplc_admdvs());
        registrationRequest.setPsn_no(medicalPaymentRequest.getPsn_no());
        registrationRequest.setInsutype(medicalPaymentRequest.getInsutype());
        registrationRequest.setBegntime(DateUtils.getTime());
        registrationRequest.setMdtrt_cert_type("02");
        registrationRequest.setPsn_type(medicalPaymentRequest.getPsnType());
        registrationRequest.setMdtrt_cert_no(medicalPaymentRequest.getMdtrt_cert_no());
        registrationRequest.setIpt_otp_no(medicalPaymentRequest.getIpt_otp_no());
        registrationRequest.setAtddr_no(doctorYbInfoEntrty.getDoctorYbCode());
        registrationRequest.setDr_name(doctorYbInfoEntrty.getDoctorYbName());
        registrationRequest.setDept_code(medicalPaymentRequest.getDeptCode());
        registrationRequest.setDept_name(medicalPaymentRequest.getDeptName());
        registrationRequest.setCaty(SUCCESS);
        registrationRequest.setOrganCode(medicalPaymentRequest.getOrganCode());
        ResultResponse ybRegistrationRespon = this.medicalBusinessService.ybRegistration(registrationRequest);
        if (ybRegistrationRespon.getCode().equals("0")) {
            return ResultResponse.error((String)("2201\u533b\u4fdd\u767b\u8bb0\uff1a" + ybRegistrationRespon.getMessage()));
        }
        Datavo ybRegistrationResponse = ((YbRegistrationResponse)((YbBaseResponse)ybRegistrationRespon.getBody()).getOutput()).getData();
        MoveUploadInfoRequest moveUploadInfoRequest = new MoveUploadInfoRequest();
        moveUploadInfoRequest.setOrganCode(medicalPaymentRequest.getOrganCode());
        moveUploadInfoRequest.setPayAuthNo(medicalPaymentRequest.getPay_auth_no());
        moveUploadInfoRequest.setPsnNo(ybRegistrationResponse.getPsn_no());
        moveUploadInfoRequest.setInsutype(medicalPaymentRequest.getInsutype());
        moveUploadInfoRequest.setInsuCode(medicalPaymentRequest.getInsuplc_admdvs());
        moveUploadInfoRequest.setMedOrgOrd(medicalPaymentRequest.getIpt_otp_no());
        moveUploadInfoRequest.setBegntime(DateUtils.getTime());
        moveUploadInfoRequest.setIdNo(medicalPaymentRequest.getMdtrt_cert_no());
        moveUploadInfoRequest.setUserName(medicalPaymentRequest.getPsn_name());
        moveUploadInfoRequest.setIdType("01");
        moveUploadInfoRequest.setMdtrtId(ybRegistrationResponse.getMdtrt_id());
        moveUploadInfoRequest.setMedType("12");
        moveUploadInfoRequest.setFeeType("01");
        moveUploadInfoRequest.setMedfeeSumamt(medicalPaymentRequest.getMedfeeSumamt());
        moveUploadInfoRequest.setAcctUsedFlag(SUCCESS);
        moveUploadInfoRequest.setEcToken("");
        moveUploadInfoRequest.setDiseCodg("");
        moveUploadInfoRequest.setDiseName("");
        moveUploadInfoRequest.setChrgBchno(chrgBchno);
        moveUploadInfoRequest.setUldLatlnt("0,0");
        moveUploadInfoRequest.setMdtrtCertType("01");
        ArrayList diseinfoList = new ArrayList();
        medicalPaymentRequest.getDiseinfoList().stream().forEach(str -> {
            MoveUploadInfoDiseinfoListRequest moveUploadInfoDiseinfoListRequest = new MoveUploadInfoDiseinfoListRequest();
            moveUploadInfoDiseinfoListRequest.setDiagType(SUCCESS);
            moveUploadInfoDiseinfoListRequest.setDiagSrtNo(SUCCESS);
            moveUploadInfoDiseinfoListRequest.setDiagCode("Z00.001");
            moveUploadInfoDiseinfoListRequest.setDiagName("\u5065\u5eb7\u67e5\u4f53");
            moveUploadInfoDiseinfoListRequest.setDiagDept(medicalPaymentRequest.getDeptName());
            moveUploadInfoDiseinfoListRequest.setDiseDorNo(doctorYbInfoEntrty.getDoctorYbCode());
            moveUploadInfoDiseinfoListRequest.setDiseDorName(doctorYbInfoEntrty.getDoctorYbName());
            moveUploadInfoDiseinfoListRequest.setDiagTime(DateUtils.getTime());
            moveUploadInfoDiseinfoListRequest.setValiFlag(SUCCESS);
            diseinfoList.add(moveUploadInfoDiseinfoListRequest);
        });
        moveUploadInfoRequest.setDiseinfoList(diseinfoList);
        ArrayList moveUploadInfoFeedetailList = new ArrayList();
        if (null != medicalPaymentRequest.getDrugsList() && medicalPaymentRequest.getDrugsList().size() > 0) {
            String finalFeedetlSn = feedetlSn;
            medicalPaymentRequest.getDrugsList().stream().forEach(s -> {
                MoveUploadInfoFeedetailListRequest moveUploadInfoFeedetailListRequest = new MoveUploadInfoFeedetailListRequest();
                moveUploadInfoFeedetailListRequest.setFeedetlSn(finalFeedetlSn);
                moveUploadInfoFeedetailListRequest.setMdtrtId(ybRegistrationResponse.getMdtrt_id());
                moveUploadInfoFeedetailListRequest.setPsnNo(ybRegistrationResponse.getPsn_no());
                moveUploadInfoFeedetailListRequest.setChrgBchno("GZ" + medicalPaymentRequest.getChrgBchno());
                moveUploadInfoFeedetailListRequest.setDiseCodg("");
                moveUploadInfoFeedetailListRequest.setDrordNo("0");
                moveUploadInfoFeedetailListRequest.setDscgTkdrugFlag("0");
                moveUploadInfoFeedetailListRequest.setEtipFlag("0");
                moveUploadInfoFeedetailListRequest.setRxCircFlag("0");
                moveUploadInfoFeedetailListRequest.setOrdersDrCode(doctorYbInfoEntrty.getDoctorYbCode());
                moveUploadInfoFeedetailListRequest.setOrdersDrName(doctorYbInfoEntrty.getDoctorYbName());
                moveUploadInfoFeedetailListRequest.setAcordDeptCodg(medicalPaymentRequest.getDeptCode());
                moveUploadInfoFeedetailListRequest.setAcordDeptName(medicalPaymentRequest.getDeptName());
                moveUploadInfoFeedetailListRequest.setRxCircFlag("0");
                moveUploadInfoFeedetailListRequest.setFeeOcurTime(DateUtils.getTime());
                moveUploadInfoFeedetailListRequest.setMedListCodg("001110000030000-I110200002");
                moveUploadInfoFeedetailListRequest.setMedinsListCodg("I110200002");
                moveUploadInfoFeedetailListRequest.setDetItemFeeSumamt(medicalPaymentRequest.getMedfeeSumamt());
                moveUploadInfoFeedetailListRequest.setCnt(SUCCESS);
                moveUploadInfoFeedetailListRequest.setPric(medicalPaymentRequest.getMedfeeSumamt());
                moveUploadInfoFeedetailListRequest.setBilgDeptCodg(medicalPaymentRequest.getDeptCode());
                moveUploadInfoFeedetailListRequest.setBilgDeptName(medicalPaymentRequest.getDeptName());
                moveUploadInfoFeedetailListRequest.setBilgDrCodg(doctorYbInfoEntrty.getDoctorYbCode());
                moveUploadInfoFeedetailListRequest.setBilgDrName(doctorYbInfoEntrty.getDoctorYbName());
                moveUploadInfoFeedetailListRequest.setHospApprFlag(SUCCESS);
                moveUploadInfoFeedetailListRequest.setMedType("12");
                moveUploadInfoFeedetailList.add(moveUploadInfoFeedetailListRequest);
            });
        }
        if (null != medicalPaymentRequest.getInspectList() && medicalPaymentRequest.getInspectList().size() > 0) {
            String finalFeedetlSn1 = feedetlSn;
            medicalPaymentRequest.getInspectList().stream().forEach(s -> {
                MoveUploadInfoFeedetailListRequest moveUploadInfoFeedetailListRequest = new MoveUploadInfoFeedetailListRequest();
                moveUploadInfoFeedetailListRequest.setFeedetlSn(finalFeedetlSn1 + "H");
                moveUploadInfoFeedetailListRequest.setMdtrtId(ybRegistrationResponse.getMdtrt_id());
                moveUploadInfoFeedetailListRequest.setPsnNo(ybRegistrationResponse.getPsn_no());
                moveUploadInfoFeedetailListRequest.setChrgBchno(medicalPaymentRequest.getChrgBchno());
                moveUploadInfoFeedetailListRequest.setDiseCodg("");
                moveUploadInfoFeedetailListRequest.setDrordNo("0");
                moveUploadInfoFeedetailListRequest.setDscgTkdrugFlag("0");
                moveUploadInfoFeedetailListRequest.setEtipFlag("0");
                moveUploadInfoFeedetailListRequest.setRxCircFlag("0");
                moveUploadInfoFeedetailListRequest.setOrdersDrCode(medicalPaymentRequest.getDoctorCode());
                moveUploadInfoFeedetailListRequest.setOrdersDrName(medicalPaymentRequest.getDoctorName());
                moveUploadInfoFeedetailListRequest.setAcordDeptCodg(medicalPaymentRequest.getDeptCode());
                moveUploadInfoFeedetailListRequest.setAcordDeptName(medicalPaymentRequest.getDeptName());
                moveUploadInfoFeedetailListRequest.setRxCircFlag("0");
                moveUploadInfoFeedetailListRequest.setFeeOcurTime(DateUtils.getTime());
                moveUploadInfoFeedetailListRequest.setMedListCodg("001102000010000-110200001");
                moveUploadInfoFeedetailListRequest.setMedinsListCodg("110200001");
                moveUploadInfoFeedetailListRequest.setDetItemFeeSumamt(medicalPaymentRequest.getMedfeeSumamt());
                moveUploadInfoFeedetailListRequest.setCnt(SUCCESS);
                moveUploadInfoFeedetailListRequest.setPric(medicalPaymentRequest.getMedfeeSumamt());
                moveUploadInfoFeedetailListRequest.setBilgDeptCodg(medicalPaymentRequest.getDeptCode());
                moveUploadInfoFeedetailListRequest.setBilgDeptName(medicalPaymentRequest.getDeptName());
                moveUploadInfoFeedetailListRequest.setBilgDrCodg(doctorYbInfoEntrty.getDoctorYbCode());
                moveUploadInfoFeedetailListRequest.setBilgDrName(doctorYbInfoEntrty.getDoctorYbName());
                moveUploadInfoFeedetailListRequest.setHospApprFlag(SUCCESS);
                moveUploadInfoFeedetailListRequest.setMedType("12");
                moveUploadInfoFeedetailList.add(moveUploadInfoFeedetailListRequest);
            });
        }
        moveUploadInfoRequest.setFeedetailList(moveUploadInfoFeedetailList);
        ResultResponse moveResponse = this.medicalBusinessService.moveUploadInfo(moveUploadInfoRequest);
        if (moveResponse.getCode().equals("0")) {
            RegistrationRevokeRequest registrationRevokeRequest = new RegistrationRevokeRequest();
            registrationRevokeRequest.setInsuplc_admdvs(medicalPaymentRequest.getInsuplc_admdvs());
            registrationRevokeRequest.setMdtrtarea_admvs(medicalPaymentRequest.getMdtrtarea_admvs());
            registrationRevokeRequest.setIpt_otp_no(medicalPaymentRequest.getIpt_otp_no());
            registrationRevokeRequest.setPsn_no(ybRegistrationResponse.getPsn_no());
            registrationRevokeRequest.setMdtrt_id(ybRegistrationResponse.getMdtrt_id());
            registrationRevokeRequest.setOrganCode(medicalPaymentRequest.getOrganCode());
            this.medicalBusinessService.ybRegistrationRevoke(registrationRevokeRequest);
            return ResultResponse.error((String)("6201\u533b\u4fdd\u660e\u7ec6\u4e0a\u4f20\uff1a" + moveResponse.getMessage()));
        }
        MoveUploadInfoResponse moveUploadInfoResponse = (MoveUploadInfoResponse)((BaseMoveResponse)moveResponse.getBody()).getData();
        CreatePayMedicalOrderRequest createPayMedicalOrderRequest = new CreatePayMedicalOrderRequest();
        createPayMedicalOrderRequest.setOrganCode(medicalPaymentRequest.getOrganCode());
        createPayMedicalOrderRequest.setChrgBchno(medicalPaymentRequest.getChrgBchno());
        createPayMedicalOrderRequest.setPayAuthNo(medicalPaymentRequest.getPay_auth_no());
        createPayMedicalOrderRequest.setPayOrdId(moveUploadInfoResponse.getPayOrdId());
        createPayMedicalOrderRequest.setOrgBizSer(medicalPaymentRequest.getIpt_otp_no());
        createPayMedicalOrderRequest.setMdtrtId(ybRegistrationResponse.getMdtrt_id());
        createPayMedicalOrderRequest.setPayToken(moveUploadInfoResponse.getPayToken());
        createPayMedicalOrderRequest.setFeeType("05");
        ResultResponse createPayMedicalResponse = this.medicalBusinessService.createPayMedicalOrder(createPayMedicalOrderRequest);
        if (createPayMedicalResponse.getCode().equals("0")) {
            MedicalRevokeorderRequest medicalRevokeorderRequest = new MedicalRevokeorderRequest();
            medicalRevokeorderRequest.setPayToken(((MoveUploadInfoResponse)((BaseMoveResponse)moveResponse.getBody()).getData()).getPayToken());
            medicalRevokeorderRequest.setUserName(medicalPaymentRequest.getPsn_name());
            medicalRevokeorderRequest.setIdType("01");
            medicalRevokeorderRequest.setIdNo(medicalPaymentRequest.getMdtrt_cert_no());
            medicalRevokeorderRequest.setOrganCode(medicalPaymentRequest.getOrganCode());
            medicalRevokeorderRequest.setPayOrdId(((MoveUploadInfoResponse)((BaseMoveResponse)moveResponse.getBody()).getData()).getPayOrdId());
            this.medicalBusinessService.medicalRevokeorder(medicalRevokeorderRequest);
            return ResultResponse.error((String)("6202\u533b\u4fdd\u4e0b\u5355\uff1a" + createPayMedicalResponse.getMessage()));
        }
        CreatePayMedicalOrderResponse createPayMedicalOrderResponse = (CreatePayMedicalOrderResponse)((BaseMoveResponse)createPayMedicalResponse.getBody()).getData();
        createPayMedicalOrderResponse.setMdtrtId(ybRegistrationResponse.getMdtrt_id());
        createPayMedicalOrderResponse.setPayToken(((MoveUploadInfoResponse)((BaseMoveResponse)moveResponse.getBody()).getData()).getPayToken());
        return createPayMedicalResponse;
    }

    public ResultResponse<BaseMoveResponse<CreatePayMedicalOrderResponse>> medicalInsurancePaymentNew(MedicalPaymentRequest medicalPaymentRequest) {
        ResultResponse resultResponse;
        if (StringUtils.isEmpty((Object)medicalPaymentRequest.getOrganCode())) {
            medicalPaymentRequest.setOrganCode("360ZFB");
        }
        MedicalChronicRequest medicalChronicRequest = new MedicalChronicRequest();
        medicalChronicRequest.setPsn_no(medicalPaymentRequest.getPsn_no());
        medicalChronicRequest.setOrganCode(medicalPaymentRequest.getOrganCode());
        log.info("+++++++\u67e5\u6162\u75c5\u7c7b\u578b\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)medicalChronicRequest));
        ResultResponse ybBaseResponseResultResponse = this.medicalBusinessService.medicalChronic(medicalChronicRequest);
        log.info("=======\u67e5\u6162\u75c5\u7c7b\u578b\u51fa\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)ybBaseResponseResultResponse));
        JSONObject medicalChronicResult = (JSONObject)JSONObject.parseObject((String)((List)((YbBaseResponse)ybBaseResponseResultResponse.getBody()).getOutput()).get(0).toString(), JSONObject.class);
        List feedetail = (List)JSONObject.parseObject((String)medicalChronicResult.get((Object)"feedetail").toString(), List.class);
        if (SUCCESS.equals(ybBaseResponseResultResponse.getCode()) && feedetail.size() > 0) {
            medicalPaymentRequest.setIsChronicisease(SUCCESS);
            medicalPaymentRequest.setDiseCodg(((JSONObject)feedetail.get(0)).get((Object)"opsp_dise_code").toString());
            medicalPaymentRequest.setDiseName(((JSONObject)feedetail.get(0)).get((Object)"opsp_dise_name").toString());
            MedicalCheckOrganRequest medicalCheckOrganRequest = new MedicalCheckOrganRequest();
            medicalCheckOrganRequest.setBiz_appy_type("01");
            medicalCheckOrganRequest.setOrganCode(medicalPaymentRequest.getOrganCode());
            medicalCheckOrganRequest.setPsn_no(medicalPaymentRequest.getPsn_no());
            ResultResponse checkOrganList = this.medicalBusinessService.checkOrgan(medicalCheckOrganRequest);
            JSONObject organListInfoJson = (JSONObject)JSONObject.parseObject((String)((List)((YbBaseResponse)checkOrganList.getBody()).getOutput()).get(0).toString(), JSONObject.class);
            List organList = (List)JSONObject.parseObject((String)organListInfoJson.get((Object)"psnfixmedin").toString(), List.class);
            if (!SUCCESS.equals(checkOrganList.getCode()) && organList.size() == 0) {
                if (!organList.stream().filter(item -> item.get((Object)"fixmedins_code").equals("H36070200017")).findAny().isPresent()) {
                    return ResultResponse.error((String)"\u5b9a\u70b9\u673a\u6784\u4e0d\u5339\u914d\uff01");
                }
                return ResultResponse.error((String)"\u672a\u67e5\u8be2\u5230\u5b9a\u70b9\u673a\u6784\uff01");
            }
        }
        String medType = "11";
        if (SUCCESS.equals(medicalPaymentRequest.getIsChronicisease())) {
            medType = "14";
        }
        if ((resultResponse = this.medicalHisFrontService.getDoctorYbinfo(medicalPaymentRequest.getOrganCode(), medicalPaymentRequest.getDoctorCode())).getCode().equals("0")) {
            return ResultResponse.error((String)"\u672a\u67e5\u8be2\u5230\u533b\u751f\u533b\u4fdd\u767b\u8bb0\u4fe1\u606f");
        }
        DoctorYbInfoEntrty doctorYbInfoEntrty = (DoctorYbInfoEntrty)resultResponse.getBody();
        RegistrationRequest registrationRequest = new RegistrationRequest();
        registrationRequest.setInsuplc_admdvs(medicalPaymentRequest.getInsuplc_admdvs());
        registrationRequest.setPsn_no(medicalPaymentRequest.getPsn_no());
        registrationRequest.setInsutype(medicalPaymentRequest.getInsutype());
        registrationRequest.setBegntime(DateUtils.getTime());
        registrationRequest.setMdtrt_cert_type("02");
        registrationRequest.setPsn_type(medicalPaymentRequest.getPsnType());
        registrationRequest.setMdtrt_cert_no(medicalPaymentRequest.getMdtrt_cert_no());
        registrationRequest.setIpt_otp_no(medicalPaymentRequest.getIpt_otp_no());
        registrationRequest.setAtddr_no(doctorYbInfoEntrty.getDoctorYbCode());
        registrationRequest.setDr_name(doctorYbInfoEntrty.getDoctorYbName());
        registrationRequest.setDept_code(medicalPaymentRequest.getDeptCode());
        registrationRequest.setDept_name(medicalPaymentRequest.getDeptName());
        registrationRequest.setCaty(SUCCESS);
        registrationRequest.setOrganCode(medicalPaymentRequest.getOrganCode());
        ResultResponse ybRegistrationRespon = this.medicalBusinessService.ybRegistration(registrationRequest);
        if (ybRegistrationRespon.getCode().equals("0")) {
            return ResultResponse.error((String)("2201\u533b\u4fdd\u767b\u8bb0\uff1a" + ybRegistrationRespon.getMessage()));
        }
        Datavo ybRegistrationResponse = ((YbRegistrationResponse)((YbBaseResponse)ybRegistrationRespon.getBody()).getOutput()).getData();
        MoveUploadInfoRequest moveUploadInfoRequest = new MoveUploadInfoRequest();
        moveUploadInfoRequest.setOrganCode(medicalPaymentRequest.getOrganCode());
        moveUploadInfoRequest.setPayAuthNo(medicalPaymentRequest.getPay_auth_no());
        moveUploadInfoRequest.setPsnNo(ybRegistrationResponse.getPsn_no());
        moveUploadInfoRequest.setInsutype(medicalPaymentRequest.getInsutype());
        moveUploadInfoRequest.setInsuCode(medicalPaymentRequest.getInsuplc_admdvs());
        moveUploadInfoRequest.setMedOrgOrd(medicalPaymentRequest.getIpt_otp_no());
        moveUploadInfoRequest.setBegntime(DateUtils.getTime());
        moveUploadInfoRequest.setIdNo(medicalPaymentRequest.getMdtrt_cert_no());
        moveUploadInfoRequest.setUserName(medicalPaymentRequest.getPsn_name());
        moveUploadInfoRequest.setIdType("01");
        moveUploadInfoRequest.setMdtrtId(ybRegistrationResponse.getMdtrt_id());
        moveUploadInfoRequest.setMedType(medType);
        moveUploadInfoRequest.setFeeType("05");
        moveUploadInfoRequest.setMedfeeSumamt(medicalPaymentRequest.getMedfeeSumamt());
        moveUploadInfoRequest.setAcctUsedFlag(SUCCESS);
        moveUploadInfoRequest.setEcToken("");
        moveUploadInfoRequest.setDiseCodg(medicalPaymentRequest.getDiseCodg());
        moveUploadInfoRequest.setDiseName(medicalPaymentRequest.getDiseName());
        moveUploadInfoRequest.setChrgBchno("GN" + medicalPaymentRequest.getChrgBchno());
        moveUploadInfoRequest.setUldLatlnt("0,0");
        moveUploadInfoRequest.setMdtrtCertType("01");
        ArrayList<MoveUploadInfoDiseinfoListRequest> diseinfoList = new ArrayList<MoveUploadInfoDiseinfoListRequest>();
        ArrayList<MoveUploadInfoFeedetailListRequest> moveUploadInfoFeedetailList = new ArrayList<MoveUploadInfoFeedetailListRequest>();
        List diseinfoList1 = medicalPaymentRequest.getDiseinfoList();
        for (String str : diseinfoList1) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("mainId", str);
            String param = JSONObject.toJSONString(map);
            log.info("\u67e5\u8be2\u5904\u65b9\u4fe1\u606f\u5165\u53c2url\uff1a{}======\u5165\u53c2{}", (Object)"http://192.168.0.114:8014/api/prescription/v1/presDetail", (Object)param);
            String resp = HttpUtil.post((String)"http://192.168.0.114:8014/api/prescription/v1/presDetail", (String)param);
            JSONObject respData = (JSONObject)JSON.parseObject((String)resp, JSONObject.class);
            if (!SUCCESS.equals(respData.get((Object)"code"))) {
                return ResultResponse.error((String)"\u67e5\u8be2\u5904\u65b9\u4fe1\u606f\u5931\u8d25\uff01");
            }
            JSONObject jsonObject = (JSONObject)JSON.parseObject((String)respData.get((Object)"data").toString(), JSONObject.class);
            log.info("===========\u5904\u65b9\u4fe1\u606f\uff1adata{}", (Object)JSONObject.toJSONString((Object)jsonObject));
            MoveUploadInfoDiseinfoListRequest moveUploadInfoDiseinfoListRequest = new MoveUploadInfoDiseinfoListRequest();
            moveUploadInfoDiseinfoListRequest.setDiagType(SUCCESS);
            moveUploadInfoDiseinfoListRequest.setDiagSrtNo(SUCCESS);
            moveUploadInfoDiseinfoListRequest.setDiagCode(jsonObject.get((Object)"icdCode").toString());
            moveUploadInfoDiseinfoListRequest.setDiagName(jsonObject.get((Object)"icdName").toString());
            moveUploadInfoDiseinfoListRequest.setDiagDept(medicalPaymentRequest.getDeptName());
            moveUploadInfoDiseinfoListRequest.setDiseDorNo(doctorYbInfoEntrty.getDoctorYbCode());
            moveUploadInfoDiseinfoListRequest.setDiseDorName(doctorYbInfoEntrty.getDoctorYbName());
            moveUploadInfoDiseinfoListRequest.setDiagTime(DateUtils.getTime());
            moveUploadInfoDiseinfoListRequest.setValiFlag(SUCCESS);
            diseinfoList.add(moveUploadInfoDiseinfoListRequest);
            List drugsList = (List)JSON.parseObject((String)jsonObject.get((Object)"drugDetailData").toString(), List.class);
            log.info("========\u836f\u54c1\u4fe1\u606f\u8be6\u60c5\uff1adrugDetailData{}", (Object)JSONObject.toJSONString((Object)drugsList));
            for (JSONObject drugs : drugsList) {
                YbDrugDataEntity ybDrugDataEntity = (YbDrugDataEntity)this.ybDrugDataMapper.selectOne((Wrapper)new QueryWrapper().eq((Object)"drug_code", (Object)drugs.get((Object)"drugId").toString()));
                if (ObjectUtils.isEmpty((Object)ybDrugDataEntity)) {
                    return ResultResponse.error((String)"\u67e5\u8be2\u836f\u54c1\u5bf9\u7167\u4fe1\u606f\u5931\u8d25\uff01");
                }
                MoveUploadInfoFeedetailListRequest moveUploadInfoFeedetailListRequest = new MoveUploadInfoFeedetailListRequest();
                moveUploadInfoFeedetailListRequest.setFeedetlSn("GNYFYHLWYY-" + System.currentTimeMillis());
                moveUploadInfoFeedetailListRequest.setMdtrtId(ybRegistrationResponse.getMdtrt_id());
                moveUploadInfoFeedetailListRequest.setPsnNo(ybRegistrationResponse.getPsn_no());
                moveUploadInfoFeedetailListRequest.setChrgBchno("GZ" + medicalPaymentRequest.getChrgBchno());
                moveUploadInfoFeedetailListRequest.setDiseCodg(medicalPaymentRequest.getDiseCodg());
                moveUploadInfoFeedetailListRequest.setDrordNo("");
                moveUploadInfoFeedetailListRequest.setDscgTkdrugFlag("0");
                moveUploadInfoFeedetailListRequest.setEtipFlag("0");
                moveUploadInfoFeedetailListRequest.setRxCircFlag("0");
                moveUploadInfoFeedetailListRequest.setOrdersDrCode(doctorYbInfoEntrty.getDoctorYbCode());
                moveUploadInfoFeedetailListRequest.setOrdersDrName(doctorYbInfoEntrty.getDoctorYbName());
                moveUploadInfoFeedetailListRequest.setAcordDeptCodg(medicalPaymentRequest.getDeptCode());
                moveUploadInfoFeedetailListRequest.setAcordDeptName(medicalPaymentRequest.getDeptName());
                moveUploadInfoFeedetailListRequest.setRxCircFlag("0");
                moveUploadInfoFeedetailListRequest.setFeeOcurTime(DateUtils.getTime());
                moveUploadInfoFeedetailListRequest.setMedListCodg(ybDrugDataEntity.getYbDrugCode());
                moveUploadInfoFeedetailListRequest.setMedinsListCodg(ybDrugDataEntity.getDrugCode());
                moveUploadInfoFeedetailListRequest.setMedListName(ybDrugDataEntity.getDrugName());
                moveUploadInfoFeedetailListRequest.setCnt(drugs.get((Object)"amount").toString());
                moveUploadInfoFeedetailListRequest.setPric(drugs.get((Object)"unitPrice").toString());
                BigDecimal amount = new BigDecimal(drugs.get((Object)"amount").toString());
                BigDecimal unitPrice = new BigDecimal(drugs.get((Object)"unitPrice").toString());
                BigDecimal count = amount.multiply(unitPrice);
                moveUploadInfoFeedetailListRequest.setDetItemFeeSumamt(count.toString());
                moveUploadInfoFeedetailListRequest.setBilgDeptCodg(medicalPaymentRequest.getDeptCode());
                moveUploadInfoFeedetailListRequest.setBilgDeptName(medicalPaymentRequest.getDeptName());
                moveUploadInfoFeedetailListRequest.setBilgDrCodg(doctorYbInfoEntrty.getDoctorYbCode());
                moveUploadInfoFeedetailListRequest.setBilgDrName(doctorYbInfoEntrty.getDoctorYbName());
                moveUploadInfoFeedetailListRequest.setHospApprFlag(SUCCESS);
                moveUploadInfoFeedetailListRequest.setMedType(medType);
                moveUploadInfoFeedetailList.add(moveUploadInfoFeedetailListRequest);
            }
        }
        moveUploadInfoRequest.setDiseinfoList(diseinfoList);
        moveUploadInfoRequest.setFeedetailList(moveUploadInfoFeedetailList);
        ResultResponse moveResponse = this.medicalBusinessService.moveUploadInfo(moveUploadInfoRequest);
        if (moveResponse.getCode().equals("0")) {
            RegistrationRevokeRequest registrationRevokeRequest = new RegistrationRevokeRequest();
            registrationRevokeRequest.setInsuplc_admdvs(medicalPaymentRequest.getInsuplc_admdvs());
            registrationRevokeRequest.setMdtrtarea_admvs(medicalPaymentRequest.getMdtrtarea_admvs());
            registrationRevokeRequest.setIpt_otp_no(medicalPaymentRequest.getIpt_otp_no());
            registrationRevokeRequest.setPsn_no(ybRegistrationResponse.getPsn_no());
            registrationRevokeRequest.setMdtrt_id(ybRegistrationResponse.getMdtrt_id());
            registrationRevokeRequest.setOrganCode(medicalPaymentRequest.getOrganCode());
            this.medicalBusinessService.ybRegistrationRevoke(registrationRevokeRequest);
            return ResultResponse.error((String)("6201\u533b\u4fdd\u660e\u7ec6\u4e0a\u4f20\uff1a" + moveResponse.getMessage()));
        }
        MoveUploadInfoResponse moveUploadInfoResponse = (MoveUploadInfoResponse)((BaseMoveResponse)moveResponse.getBody()).getData();
        CreatePayMedicalOrderRequest createPayMedicalOrderRequest = new CreatePayMedicalOrderRequest();
        createPayMedicalOrderRequest.setOrganCode(medicalPaymentRequest.getOrganCode());
        createPayMedicalOrderRequest.setChrgBchno(medicalPaymentRequest.getChrgBchno());
        createPayMedicalOrderRequest.setPayAuthNo(medicalPaymentRequest.getPay_auth_no());
        createPayMedicalOrderRequest.setPayOrdId(moveUploadInfoResponse.getPayOrdId());
        createPayMedicalOrderRequest.setOrgBizSer(medicalPaymentRequest.getIpt_otp_no());
        createPayMedicalOrderRequest.setMdtrtId(ybRegistrationResponse.getMdtrt_id());
        createPayMedicalOrderRequest.setPayToken(moveUploadInfoResponse.getPayToken());
        createPayMedicalOrderRequest.setFeeType("05");
        ResultResponse createPayMedicalResponse = this.medicalBusinessService.createPayMedicalOrder(createPayMedicalOrderRequest);
        if (createPayMedicalResponse.getCode().equals("0")) {
            MedicalRevokeorderRequest medicalRevokeorderRequest = new MedicalRevokeorderRequest();
            medicalRevokeorderRequest.setPayToken(((MoveUploadInfoResponse)((BaseMoveResponse)moveResponse.getBody()).getData()).getPayToken());
            medicalRevokeorderRequest.setUserName(medicalPaymentRequest.getPsn_name());
            medicalRevokeorderRequest.setIdType("01");
            medicalRevokeorderRequest.setIdNo(medicalPaymentRequest.getMdtrt_cert_no());
            medicalRevokeorderRequest.setOrganCode(medicalPaymentRequest.getOrganCode());
            medicalRevokeorderRequest.setPayOrdId(((MoveUploadInfoResponse)((BaseMoveResponse)moveResponse.getBody()).getData()).getPayOrdId());
            this.medicalBusinessService.medicalRevokeorder(medicalRevokeorderRequest);
            return ResultResponse.error((String)("6202\u533b\u4fdd\u4e0b\u5355\uff1a" + createPayMedicalResponse.getMessage()));
        }
        CreatePayMedicalOrderResponse createPayMedicalOrderResponse = (CreatePayMedicalOrderResponse)((BaseMoveResponse)createPayMedicalResponse.getBody()).getData();
        createPayMedicalOrderResponse.setMdtrtId(ybRegistrationResponse.getMdtrt_id());
        createPayMedicalOrderResponse.setPayToken(((MoveUploadInfoResponse)((BaseMoveResponse)moveResponse.getBody()).getData()).getPayToken());
        return createPayMedicalResponse;
    }

    public ResultResponse<YdBaseResponse<YdCreadOrderResponse>> gzydMedicalInsurancePayment(MedicalPaymentRequest medicalPaymentRequest) {
        ResultResponse resultResponse = this.medicalHisFrontService.getDoctorYbinfo(medicalPaymentRequest.getOrganCode(), medicalPaymentRequest.getDoctorCode());
        if (resultResponse.getCode().equals("0")) {
            return ResultResponse.error((String)"\u672a\u67e5\u8be2\u5230\u533b\u751f\u533b\u4fdd\u767b\u8bb0\u4fe1\u606f");
        }
        DoctorYbInfoEntrty doctorYbInfoEntrty = (DoctorYbInfoEntrty)resultResponse.getBody();
        YdCreadOrderRequest ydCreadOrderRequest = new YdCreadOrderRequest();
        ydCreadOrderRequest.setOrganCode(medicalPaymentRequest.getOrganCode());
        ydCreadOrderRequest.setPayAuthNo(medicalPaymentRequest.getPay_auth_no());
        ydCreadOrderRequest.setPsnNo(medicalPaymentRequest.getPsn_no());
        ydCreadOrderRequest.setInsutype(medicalPaymentRequest.getInsutype());
        ydCreadOrderRequest.setInsuCode(medicalPaymentRequest.getInsuplc_admdvs());
        ydCreadOrderRequest.setMedOrgOrd(medicalPaymentRequest.getIpt_otp_no());
        ydCreadOrderRequest.setIptOtpNo(medicalPaymentRequest.getIpt_otp_no());
        ydCreadOrderRequest.setOrgBizSer(medicalPaymentRequest.getIpt_otp_no());
        ydCreadOrderRequest.setPsnSetlway(SUCCESS);
        ydCreadOrderRequest.setBegntime(DateUtils.getTime());
        ydCreadOrderRequest.setIdNo(medicalPaymentRequest.getMdtrt_cert_no());
        ydCreadOrderRequest.setUserName(medicalPaymentRequest.getPsn_name());
        ydCreadOrderRequest.setIdType("01");
        ydCreadOrderRequest.setMdtrtId("");
        ydCreadOrderRequest.setMedType("11");
        ydCreadOrderRequest.setFeeType("01");
        ydCreadOrderRequest.setMedfeeSumamt(medicalPaymentRequest.getMedfeeSumamt());
        ydCreadOrderRequest.setAcctUsedFlag(SUCCESS);
        ydCreadOrderRequest.setEcToken("");
        ydCreadOrderRequest.setDiseCodg("");
        ydCreadOrderRequest.setDiseName("");
        ydCreadOrderRequest.setCaty(SUCCESS);
        ydCreadOrderRequest.setChrgBchno(medicalPaymentRequest.getChrgBchno());
        ydCreadOrderRequest.setUldLatlnt("0,0");
        ydCreadOrderRequest.setMdtrtCertType("01");
        ydCreadOrderRequest.setOrganCode(medicalPaymentRequest.getOrganCode());
        ydCreadOrderRequest.setChrgBchno(medicalPaymentRequest.getChrgBchno());
        ydCreadOrderRequest.setPayAuthNo(medicalPaymentRequest.getPay_auth_no());
        ydCreadOrderRequest.setOrgBizSer(medicalPaymentRequest.getIpt_otp_no());
        ydCreadOrderRequest.setChrgBchno(medicalPaymentRequest.getChrgBchno());
        ydCreadOrderRequest.setFeeType("01");
        ydCreadOrderRequest.setDeptName(medicalPaymentRequest.getDeptName());
        ydCreadOrderRequest.setDeptCode(medicalPaymentRequest.getDeptCode());
        ydCreadOrderRequest.setAdmDeptCodg(medicalPaymentRequest.getDeptCode());
        ydCreadOrderRequest.setAdmDeptName(medicalPaymentRequest.getDeptName());
        ArrayList diseinfoList = new ArrayList();
        medicalPaymentRequest.getDiseinfoList().stream().forEach(str -> {
            MoveUploadInfoDiseinfoListRequest moveUploadInfoDiseinfoListRequest = new MoveUploadInfoDiseinfoListRequest();
            moveUploadInfoDiseinfoListRequest.setDiagType(SUCCESS);
            moveUploadInfoDiseinfoListRequest.setDiagSrtNo(SUCCESS);
            moveUploadInfoDiseinfoListRequest.setDiagCode("Z00.001");
            moveUploadInfoDiseinfoListRequest.setDiagName("\u5065\u5eb7\u67e5\u4f53");
            moveUploadInfoDiseinfoListRequest.setDiagDept(medicalPaymentRequest.getDeptName());
            moveUploadInfoDiseinfoListRequest.setDiseDorNo(doctorYbInfoEntrty.getDoctorYbCode());
            moveUploadInfoDiseinfoListRequest.setDiseDorName(doctorYbInfoEntrty.getDoctorYbName());
            moveUploadInfoDiseinfoListRequest.setDiagTime(DateUtils.getTime());
            moveUploadInfoDiseinfoListRequest.setValiFlag(SUCCESS);
            diseinfoList.add(moveUploadInfoDiseinfoListRequest);
        });
        ydCreadOrderRequest.setDiseinfoList(diseinfoList);
        ArrayList moveUploadInfoFeedetailList = new ArrayList();
        if (null != medicalPaymentRequest.getDrugsList() && medicalPaymentRequest.getDrugsList().size() > 0) {
            medicalPaymentRequest.getDrugsList().stream().forEach(s -> {
                MoveUploadInfoFeedetailListRequest moveUploadInfoFeedetailListRequest = new MoveUploadInfoFeedetailListRequest();
                moveUploadInfoFeedetailListRequest.setFeedetlSn("GNYFYHLWYY-" + System.currentTimeMillis());
                moveUploadInfoFeedetailListRequest.setMdtrtId("");
                moveUploadInfoFeedetailListRequest.setPsnNo(medicalPaymentRequest.getPsn_no());
                moveUploadInfoFeedetailListRequest.setChrgBchno(medicalPaymentRequest.getChrgBchno());
                moveUploadInfoFeedetailListRequest.setDiseCodg("");
                moveUploadInfoFeedetailListRequest.setDrordNo("0");
                moveUploadInfoFeedetailListRequest.setDscgTkdrugFlag("0");
                moveUploadInfoFeedetailListRequest.setEtipFlag("0");
                moveUploadInfoFeedetailListRequest.setRxCircFlag("0");
                moveUploadInfoFeedetailListRequest.setOrdersDrCode(doctorYbInfoEntrty.getDoctorYbCode());
                moveUploadInfoFeedetailListRequest.setOrdersDrName(doctorYbInfoEntrty.getDoctorYbName());
                moveUploadInfoFeedetailListRequest.setAcordDeptCodg(medicalPaymentRequest.getDeptCode());
                moveUploadInfoFeedetailListRequest.setAcordDeptName(medicalPaymentRequest.getDeptName());
                moveUploadInfoFeedetailListRequest.setRxCircFlag("0");
                moveUploadInfoFeedetailListRequest.setFeeOcurTime(DateUtils.getTime());
                moveUploadInfoFeedetailListRequest.setMedListName("\u65e0");
                moveUploadInfoFeedetailListRequest.setMedListCodg("001102000010000-110200001");
                moveUploadInfoFeedetailListRequest.setMedinsListCodg("110200001");
                moveUploadInfoFeedetailListRequest.setDetItemFeeSumamt(medicalPaymentRequest.getMedfeeSumamt());
                moveUploadInfoFeedetailListRequest.setCnt(SUCCESS);
                moveUploadInfoFeedetailListRequest.setPric(medicalPaymentRequest.getMedfeeSumamt());
                moveUploadInfoFeedetailListRequest.setBilgDeptCodg(medicalPaymentRequest.getDeptCode());
                moveUploadInfoFeedetailListRequest.setBilgDeptName(medicalPaymentRequest.getDeptName());
                moveUploadInfoFeedetailListRequest.setBilgDrCodg(doctorYbInfoEntrty.getDoctorYbCode());
                moveUploadInfoFeedetailListRequest.setBilgDrName(doctorYbInfoEntrty.getDoctorYbName());
                moveUploadInfoFeedetailListRequest.setHospApprFlag(SUCCESS);
                moveUploadInfoFeedetailListRequest.setMedType("11");
                moveUploadInfoFeedetailList.add(moveUploadInfoFeedetailListRequest);
            });
        }
        if (null != medicalPaymentRequest.getInspectList() && medicalPaymentRequest.getInspectList().size() > 0) {
            medicalPaymentRequest.getInspectList().stream().forEach(s -> {
                MoveUploadInfoFeedetailListRequest moveUploadInfoFeedetailListRequest = new MoveUploadInfoFeedetailListRequest();
                moveUploadInfoFeedetailListRequest.setFeedetlSn("GNYFYHLWYY-" + System.currentTimeMillis());
                moveUploadInfoFeedetailListRequest.setMdtrtId("");
                moveUploadInfoFeedetailListRequest.setPsnNo(medicalPaymentRequest.getPsn_no());
                moveUploadInfoFeedetailListRequest.setChrgBchno(medicalPaymentRequest.getChrgBchno());
                moveUploadInfoFeedetailListRequest.setDiseCodg("");
                moveUploadInfoFeedetailListRequest.setDrordNo("0");
                moveUploadInfoFeedetailListRequest.setDscgTkdrugFlag("0");
                moveUploadInfoFeedetailListRequest.setEtipFlag("0");
                moveUploadInfoFeedetailListRequest.setRxCircFlag("0");
                moveUploadInfoFeedetailListRequest.setOrdersDrCode(doctorYbInfoEntrty.getDoctorYbCode());
                moveUploadInfoFeedetailListRequest.setOrdersDrName(doctorYbInfoEntrty.getDoctorYbName());
                moveUploadInfoFeedetailListRequest.setAcordDeptCodg(medicalPaymentRequest.getDeptCode());
                moveUploadInfoFeedetailListRequest.setAcordDeptName(medicalPaymentRequest.getDeptName());
                moveUploadInfoFeedetailListRequest.setRxCircFlag("0");
                moveUploadInfoFeedetailListRequest.setFeeOcurTime(DateUtils.getTime());
                moveUploadInfoFeedetailListRequest.setMedListName("\u65e0");
                moveUploadInfoFeedetailListRequest.setMedListCodg("001102000010000-110200001");
                moveUploadInfoFeedetailListRequest.setMedinsListCodg("110200001");
                moveUploadInfoFeedetailListRequest.setDetItemFeeSumamt(medicalPaymentRequest.getMedfeeSumamt());
                moveUploadInfoFeedetailListRequest.setCnt(SUCCESS);
                moveUploadInfoFeedetailListRequest.setPric(medicalPaymentRequest.getMedfeeSumamt());
                moveUploadInfoFeedetailListRequest.setBilgDeptCodg(medicalPaymentRequest.getDeptCode());
                moveUploadInfoFeedetailListRequest.setBilgDeptName(medicalPaymentRequest.getDeptName());
                moveUploadInfoFeedetailListRequest.setBilgDrCodg(doctorYbInfoEntrty.getDoctorYbCode());
                moveUploadInfoFeedetailListRequest.setBilgDrName(doctorYbInfoEntrty.getDoctorYbName());
                moveUploadInfoFeedetailListRequest.setHospApprFlag(SUCCESS);
                moveUploadInfoFeedetailListRequest.setMedType("11");
                moveUploadInfoFeedetailList.add(moveUploadInfoFeedetailListRequest);
            });
        }
        ydCreadOrderRequest.setFeedetailList(moveUploadInfoFeedetailList);
        return this.ydMedicalBusinessService.ydCreateOrder(ydCreadOrderRequest);
    }

    public ResultResponse<AliPayQueryOrderStateResponse> ybByAliPayOrderQuery(QueryMedicalSettlementOrderRequest medicalPaymentRequest) {
        AliPayQueryOrderStateResponse aliPayQueryOrderStateResponse = new AliPayQueryOrderStateResponse();
        QueryMedicalSettlementOrderRequest queryMedicalSettlementOrderRequest = new QueryMedicalSettlementOrderRequest();
        BeanUtils.copyProperties((Object)medicalPaymentRequest, (Object)queryMedicalSettlementOrderRequest);
        queryMedicalSettlementOrderRequest.setOutTradeNo("");
        ResultResponse resultResponse = this.medicalBusinessService.queryMedicalSettlementOrder(queryMedicalSettlementOrderRequest);
        ResultResponse responseMedicare = new ResultResponse();
        if (resultResponse.getCode().equals("0")) {
            responseMedicare = ResultResponse.error((String)resultResponse.getMessage());
        } else {
            QueryMedicalSettlementOrderResponse queryMedicalSettlementOrderResponse = (QueryMedicalSettlementOrderResponse)((BaseMoveResponse)resultResponse.getBody()).getData();
            responseMedicare = ResultResponse.success((Object)queryMedicalSettlementOrderResponse);
            if (queryMedicalSettlementOrderResponse.getOrdStas().equals("6")) {
                this.ydMedicalDataBaseService.updateYbPayMedicalOrderInfo(medicalPaymentRequest, queryMedicalSettlementOrderResponse, SUCCESS);
            }
        }
        ResultResponse responseAliPay = new ResultResponse();
        AliPayQueryRequest aliPayQueryRequesy = new AliPayQueryRequest();
        aliPayQueryRequesy.setOut_trade_no(medicalPaymentRequest.getOutTradeNo());
        aliPayQueryRequesy.setOrganCode(medicalPaymentRequest.getOrganCode());
        ResultResponse responseResultResponse = this.aliBusinessService.queryAliPayOrderState(aliPayQueryRequesy);
        if (responseResultResponse.getCode().equals("0")) {
            responseAliPay = ResultResponse.error((String)responseResultResponse.getMessage());
        } else {
            AlipayTradeQueryResponse alipayTradeQueryResponse = (AlipayTradeQueryResponse)responseResultResponse.getBody();
            responseAliPay = ResultResponse.success((Object)alipayTradeQueryResponse);
            if (alipayTradeQueryResponse.getTradeStatus().equals("TRADE_SUCCESS")) {
                this.ydMedicalDataBaseService.updateYbAliPayOrderInfo(aliPayQueryRequesy, SUCCESS);
            }
        }
        aliPayQueryOrderStateResponse.setQueryMedicalSettlementOrderResponse(responseMedicare);
        aliPayQueryOrderStateResponse.setAlipayTradeQueryResponse(responseAliPay);
        return ResultResponse.success((Object)aliPayQueryOrderStateResponse);
    }

    public ResultResponse<String> ybAliUndoOrder(UndoOrderRequest undoOrderRequest) {
        ResultResponse ybConfigResponse = this.medicalBusinessService.getYbConfig(undoOrderRequest.getOrganCode());
        if (ybConfigResponse.getCode().equals("0")) {
            return ResultResponse.error((String)ybConfigResponse.getMessage());
        }
        QueryMedicalSettlementOrderRequest medicalPaymentRequest = new QueryMedicalSettlementOrderRequest();
        medicalPaymentRequest.setPayOrdId(undoOrderRequest.getPayOrdId());
        medicalPaymentRequest.setPayToken(undoOrderRequest.getPayToken());
        medicalPaymentRequest.setOrganCode(undoOrderRequest.getOrganCode());
        ResultResponse ybPayMedicalOrderEntrtyResultResponse = this.ydMedicalDataBaseService.queryYbPayMedicalOrderInfo(medicalPaymentRequest, (YbConfigEntity)ybConfigResponse.getBody());
        if (ybPayMedicalOrderEntrtyResultResponse.getCode().equals("0")) {
            return ResultResponse.error((String)ybPayMedicalOrderEntrtyResultResponse.getMessage());
        }
        YbPayMedicalOrderEntrty ybPayMedicalOrderEntrty = (YbPayMedicalOrderEntrty)ybPayMedicalOrderEntrtyResultResponse.getBody();
        if (ybPayMedicalOrderEntrty.getOrderState().equals(SUCCESS)) {
            return ResultResponse.error((String)"\u533b\u4fdd\u8ba2\u5355\u72b6\u6001\u4e3a\u5df2\u7ed3\u7b97\uff0c\u4e0d\u5141\u8bb8\u64a4\u9500");
        }
        MedicalRevokeorderRequest medicalRevokeorderRequest = new MedicalRevokeorderRequest();
        medicalRevokeorderRequest.setOrgCodg(undoOrderRequest.getOrgCodg());
        medicalRevokeorderRequest.setPayToken(undoOrderRequest.getPayToken());
        medicalRevokeorderRequest.setUserName(undoOrderRequest.getUserName());
        medicalRevokeorderRequest.setIdNo(undoOrderRequest.getIdNo());
        medicalRevokeorderRequest.setIdType(undoOrderRequest.getIdType());
        medicalRevokeorderRequest.setOrganCode(undoOrderRequest.getOrganCode());
        medicalRevokeorderRequest.setPayOrdId(undoOrderRequest.getPayOrdId());
        ResultResponse responseResultResponse = this.medicalBusinessService.medicalRevokeorder(medicalRevokeorderRequest);
        if ("0".equals(responseResultResponse.getCode())) {
            return ResultResponse.error((String)responseResultResponse.getMessage());
        }
        return ResultResponse.success((Object)"\u64a4\u9500\u6210\u529f");
    }

    public ResultResponse<RefundOrderResponse> ybAliReturnOrder(RefundOrderRequest refundOrderRequest) {
        ResultResponse ybConfigResponse = this.medicalBusinessService.getYbConfig(refundOrderRequest.getOrganCode());
        if (ybConfigResponse.getCode().equals("0")) {
            return ResultResponse.error((String)ybConfigResponse.getMessage());
        }
        QueryMedicalSettlementOrderRequest medicalPaymentRequest = new QueryMedicalSettlementOrderRequest();
        medicalPaymentRequest.setPayOrdId(refundOrderRequest.getPayOrdId());
        medicalPaymentRequest.setOrganCode(refundOrderRequest.getOrganCode());
        ResultResponse ybPayMedicalOrderEntrtyResultResponse = this.ydMedicalDataBaseService.queryYbPayMedicalOrderInfo(medicalPaymentRequest, (YbConfigEntity)ybConfigResponse.getBody());
        if (ybPayMedicalOrderEntrtyResultResponse.getCode().equals("0")) {
            return ResultResponse.error((String)ybPayMedicalOrderEntrtyResultResponse.getMessage());
        }
        YbPayMedicalOrderEntrty ybPayMedicalOrderEntrty = (YbPayMedicalOrderEntrty)ybPayMedicalOrderEntrtyResultResponse.getBody();
        if (!ybPayMedicalOrderEntrty.getOrderState().equals(SUCCESS)) {
            return ResultResponse.error((String)"\u533b\u4fdd\u8ba2\u5355\u72b6\u6001\u672a\u7ed3\u7b97\uff0c\u4e0d\u5141\u8bb8\u9000\u8d39");
        }
        ResultResponse responseResultResponse = this.medicalBusinessService.refundOrder(refundOrderRequest);
        if (responseResultResponse.getCode().equals("0")) {
            return ResultResponse.error((String)responseResultResponse.getMessage());
        }
        this.ydMedicalDataBaseService.updateYbPayMedicalOrderInfo(medicalPaymentRequest, null, "2");
        AliPayCreateOrderEntrty aliPayCreateOrderEntrty = new AliPayCreateOrderEntrty();
        aliPayCreateOrderEntrty.setBill_no(refundOrderRequest.getPayOrdId());
        aliPayCreateOrderEntrty.setOrganCode(refundOrderRequest.getOrganCode());
        ResultResponse aliPayCreateOrderEntrtyResultResponse = this.ydMedicalDataBaseService.queryYbAliPayOrderInfo(aliPayCreateOrderEntrty);
        if ("0".equals(aliPayCreateOrderEntrtyResultResponse.getCode())) {
            return ResultResponse.error((String)aliPayCreateOrderEntrtyResultResponse.getMessage());
        }
        AliPayCreateOrderEntrty aliPayCreateOrderInfo = (AliPayCreateOrderEntrty)aliPayCreateOrderEntrtyResultResponse.getBody();
        AliPayRefuntRequest aliPayRefuntRequest = new AliPayRefuntRequest();
        AliPayRefuntExtendParamsEntrty aliPayRefuntExtendParamsEntrty = new AliPayRefuntExtendParamsEntrty();
        aliPayRefuntRequest.setOrganCode(medicalPaymentRequest.getOrganCode());
        aliPayRefuntRequest.setTrade_no("");
        aliPayRefuntRequest.setOut_trade_no(aliPayCreateOrderInfo.getOut_trade_no());
        aliPayRefuntRequest.setRefund_amount(String.valueOf(aliPayCreateOrderInfo.getTotal_amount()));
        aliPayRefuntRequest.setRefund_reason("\u60a3\u8005\u89e6\u53d1\u9000\u8d39");
        aliPayRefuntExtendParamsEntrty.setCancel_bill_nol(aliPayCreateOrderInfo.getOut_trade_no());
        aliPayRefuntExtendParamsEntrty.setCancel_serial_no(aliPayCreateOrderInfo.getOut_trade_no());
        aliPayRefuntRequest.setExtend_params(aliPayRefuntExtendParamsEntrty);
        ResultResponse aliPayRefuntResponseResultResponse = this.aliBusinessService.refuntAliPayOrder(aliPayRefuntRequest);
        if ("0".equals(aliPayRefuntResponseResultResponse.getCode())) {
            return ResultResponse.error((String)aliPayRefuntResponseResultResponse.getMessage());
        }
        MedicalRevokeorderEntrty medicalRevokeorderRequest = new MedicalRevokeorderEntrty();
        medicalRevokeorderRequest.setPayToken(ybPayMedicalOrderEntrty.getPayToken());
        medicalRevokeorderRequest.setUserName(refundOrderRequest.getUserName());
        medicalRevokeorderRequest.setIdNo(refundOrderRequest.getIdNo());
        medicalRevokeorderRequest.setIdType("01");
        medicalRevokeorderRequest.setPayOrdId(ybPayMedicalOrderEntrty.getPayOrdId());
        medicalRevokeorderRequest.setOrganCode(refundOrderRequest.getOrganCode());
        AliPayQueryRequest aliPayQueryRequest = new AliPayQueryRequest();
        aliPayQueryRequest.setOut_trade_no(aliPayCreateOrderInfo.getOut_trade_no());
        this.ydMedicalDataBaseService.updateYbAliPayOrderInfo(aliPayQueryRequest, "2");
        RefundOrderResponse refundOrderResponse = (RefundOrderResponse)((BaseMoveResponse)responseResultResponse.getBody()).getData();
        RabbitMqUtils.sendYbUndoorder((RabbitTemplate)this.rabbitTemplate, (String)JSON.toJSONString((Object)medicalRevokeorderRequest));
        return ResultResponse.success((Object)refundOrderResponse);
    }

    public ResultResponse<String> ybAliReturnOrderAndRevoke(RefundOrderRequest refundOrderRequest) {
        ResultResponse ybConfigResponse = this.medicalBusinessService.getYbConfig(refundOrderRequest.getOrganCode());
        if (ybConfigResponse.getCode().equals("0")) {
            return ResultResponse.error((String)ybConfigResponse.getMessage());
        }
        QueryMedicalSettlementOrderRequest medicalPaymentRequest = new QueryMedicalSettlementOrderRequest();
        medicalPaymentRequest.setPayOrdId(refundOrderRequest.getPayOrdId());
        medicalPaymentRequest.setOrganCode(refundOrderRequest.getOrganCode());
        ResultResponse ybPayMedicalOrderEntrtyResultResponse = this.ydMedicalDataBaseService.queryYbPayMedicalOrderInfo(medicalPaymentRequest, (YbConfigEntity)ybConfigResponse.getBody());
        if (ybPayMedicalOrderEntrtyResultResponse.getCode().equals("0")) {
            return ResultResponse.error((String)ybPayMedicalOrderEntrtyResultResponse.getMessage());
        }
        YbPayMedicalOrderEntrty ybPayMedicalOrderEntrty = (YbPayMedicalOrderEntrty)ybPayMedicalOrderEntrtyResultResponse.getBody();
        MedicalRevokeorderEntrty medicalRevokeorderEntrty = new MedicalRevokeorderEntrty();
        medicalRevokeorderEntrty.setPayToken(ybPayMedicalOrderEntrty.getPayToken());
        medicalRevokeorderEntrty.setUserName(refundOrderRequest.getUserName());
        medicalRevokeorderEntrty.setIdNo(refundOrderRequest.getIdNo());
        medicalRevokeorderEntrty.setIdType("01");
        medicalRevokeorderEntrty.setPayOrdId(ybPayMedicalOrderEntrty.getPayOrdId());
        medicalRevokeorderEntrty.setOrganCode(refundOrderRequest.getOrganCode());
        switch (ybPayMedicalOrderEntrty.getOrderState()) {
            case "0": 
            case "2": {
                RabbitMqUtils.sendYbUndoorder((RabbitTemplate)this.rabbitTemplate, (String)JSON.toJSONString((Object)medicalRevokeorderEntrty));
                break;
            }
            case "1": {
                ResultResponse responseResultResponse = this.medicalBusinessService.refundOrder(refundOrderRequest);
                if (responseResultResponse.getCode().equals("0")) {
                    return ResultResponse.error((String)responseResultResponse.getMessage());
                }
                this.ydMedicalDataBaseService.updateYbPayMedicalOrderInfo(medicalPaymentRequest, null, "2");
                RabbitMqUtils.sendYbUndoorder((RabbitTemplate)this.rabbitTemplate, (String)JSON.toJSONString((Object)medicalRevokeorderEntrty));
            }
        }
        AliPayCreateOrderEntrty aliPayCreateOrderEntrty = new AliPayCreateOrderEntrty();
        aliPayCreateOrderEntrty.setBill_no(refundOrderRequest.getPayOrdId());
        aliPayCreateOrderEntrty.setOrganCode(refundOrderRequest.getOrganCode());
        ResultResponse aliPayCreateOrderEntrtyResultResponse = this.ydMedicalDataBaseService.queryYbAliPayOrderInfo(aliPayCreateOrderEntrty);
        if ("0".equals(aliPayCreateOrderEntrtyResultResponse.getCode())) {
            return ResultResponse.error((String)aliPayCreateOrderEntrtyResultResponse.getMessage());
        }
        AliPayCreateOrderEntrty aliPayCreateOrderInfo = (AliPayCreateOrderEntrty)aliPayCreateOrderEntrtyResultResponse.getBody();
        if (aliPayCreateOrderInfo.getOrderState().equals(SUCCESS)) {
            AliPayRefuntRequest aliPayRefuntRequest = new AliPayRefuntRequest();
            AliPayRefuntExtendParamsEntrty aliPayRefuntExtendParamsEntrty = new AliPayRefuntExtendParamsEntrty();
            aliPayRefuntRequest.setOrganCode(medicalPaymentRequest.getOrganCode());
            aliPayRefuntRequest.setTrade_no("");
            aliPayRefuntRequest.setOut_trade_no(aliPayCreateOrderInfo.getOut_trade_no());
            aliPayRefuntRequest.setRefund_amount(String.valueOf(aliPayCreateOrderInfo.getTotal_amount()));
            aliPayRefuntRequest.setRefund_reason("\u60a3\u8005\u89e6\u53d1\u9000\u8d39");
            aliPayRefuntExtendParamsEntrty.setCancel_bill_nol(aliPayCreateOrderInfo.getOut_trade_no());
            aliPayRefuntExtendParamsEntrty.setCancel_serial_no(aliPayCreateOrderInfo.getOut_trade_no());
            aliPayRefuntRequest.setExtend_params(aliPayRefuntExtendParamsEntrty);
            ResultResponse aliPayRefuntResponseResultResponse = this.aliBusinessService.refuntAliPayOrder(aliPayRefuntRequest);
            if ("0".equals(aliPayRefuntResponseResultResponse.getCode())) {
                return ResultResponse.error((String)aliPayRefuntResponseResultResponse.getMessage());
            }
            AliPayQueryRequest aliPayQueryRequest = new AliPayQueryRequest();
            aliPayQueryRequest.setOut_trade_no(aliPayCreateOrderInfo.getOut_trade_no());
            this.ydMedicalDataBaseService.updateYbAliPayOrderInfo(aliPayQueryRequest, "2");
        }
        return ResultResponse.success((Object)"\u9000\u8d39\u6210\u529f");
    }

    public ResultResponse<String> ybWechatReturnOrderAndRevoke(RefundOrderRequest refundOrderRequest) {
        ResultResponse ybConfigResponse = this.medicalBusinessService.getYbConfig(refundOrderRequest.getOrganCode());
        if (ybConfigResponse.getCode().equals("0")) {
            return ResultResponse.error((String)ybConfigResponse.getMessage());
        }
        QueryMedicalSettlementOrderRequest medicalPaymentRequest = new QueryMedicalSettlementOrderRequest();
        medicalPaymentRequest.setPayOrdId(refundOrderRequest.getPayOrdId());
        medicalPaymentRequest.setOrganCode(refundOrderRequest.getOrganCode());
        ResultResponse ybPayMedicalOrderEntrtyResultResponse = this.ydMedicalDataBaseService.queryYbPayMedicalOrderInfo(medicalPaymentRequest, (YbConfigEntity)ybConfigResponse.getBody());
        if (ybPayMedicalOrderEntrtyResultResponse.getCode().equals("0")) {
            return ResultResponse.error((String)ybPayMedicalOrderEntrtyResultResponse.getMessage());
        }
        YbPayMedicalOrderEntrty ybPayMedicalOrderEntrty = (YbPayMedicalOrderEntrty)ybPayMedicalOrderEntrtyResultResponse.getBody();
        MedicalRevokeorderEntrty medicalRevokeorderEntrty = new MedicalRevokeorderEntrty();
        medicalRevokeorderEntrty.setPayToken(ybPayMedicalOrderEntrty.getPayToken());
        medicalRevokeorderEntrty.setUserName(refundOrderRequest.getUserName());
        medicalRevokeorderEntrty.setIdNo(refundOrderRequest.getIdNo());
        medicalRevokeorderEntrty.setIdType("01");
        medicalRevokeorderEntrty.setPayOrdId(ybPayMedicalOrderEntrty.getPayOrdId());
        medicalRevokeorderEntrty.setOrganCode(refundOrderRequest.getOrganCode());
        ResultResponse responseResultResponse = this.medicalBusinessService.refundOrder(refundOrderRequest);
        log.info("=-----\u533b\u4fdd\u9000\u6b3e\u51fa\u53c2" + JSONObject.toJSONString((Object)responseResultResponse));
        if (responseResultResponse.getCode().equals("0")) {
            return ResultResponse.error((String)responseResultResponse.getMessage());
        }
        this.ydMedicalDataBaseService.updateYbPayMedicalOrderInfo(medicalPaymentRequest, null, "2");
        ResultResponse tencentRefund = this.tencentServicce.tencentRefund(refundOrderRequest.getTencentRefundRequest());
        if (SUCCESS.equals(tencentRefund.getCode())) {
            RefundOrderResponse refundOrderResponse = (RefundOrderResponse)((BaseMoveResponse)responseResultResponse.getBody()).getData();
            this.executor.submit((Runnable)new /* Unavailable Anonymous Inner Class!! */);
            return ResultResponse.success((Object)"\u9000\u8d39\u6210\u529f");
        }
        return ResultResponse.error((String)"\u5fae\u4fe1\u9000\u8d39\u5931\u8d25");
    }

    public ResultResponse<String> queryYbAliReturnOrder(QueryMedicalSettlementOrderRequest medicalPaymentRequest) {
        AliPayQueryRequest aliPayQueryRequesy = new AliPayQueryRequest();
        aliPayQueryRequesy.setOut_trade_no(medicalPaymentRequest.getOutTradeNo());
        aliPayQueryRequesy.setOrganCode(medicalPaymentRequest.getOrganCode());
        ResultResponse resultAlipayTradeQueryResponseEntrty = new ResultResponse();
        ResultResponse responseResultResponse = this.aliBusinessService.queryAliPayOrderState(aliPayQueryRequesy);
        AlipayTradeQueryResponse alipayTradeQueryResponse = new AlipayTradeQueryResponse();
        if (responseResultResponse.getCode().equals("0")) {
            resultAlipayTradeQueryResponseEntrty = ResultResponse.error((String)responseResultResponse.getMessage());
        } else {
            alipayTradeQueryResponse = (AlipayTradeQueryResponse)responseResultResponse.getBody();
            switch (alipayTradeQueryResponse.getTradeStatus()) {
                case "WAIT_BUYER_PAY": {
                    resultAlipayTradeQueryResponseEntrty = ResultResponse.error((String)"\u4ea4\u6613\u521b\u5efa\uff0c\u7b49\u5f85\u4e70\u5bb6\u4ed8\u6b3e");
                    break;
                }
                case "TRADE_CLOSED": {
                    resultAlipayTradeQueryResponseEntrty = ResultResponse.success((Object)"\u672a\u4ed8\u6b3e\u4ea4\u6613\u8d85\u65f6\u5173\u95ed\uff0c\u6216\u652f\u4ed8\u5b8c\u6210\u540e\u5168\u989d\u9000\u6b3e");
                    break;
                }
                case "TRADE_SUCCESS": {
                    resultAlipayTradeQueryResponseEntrty = ResultResponse.error((String)"\u67e5\u8be2\u72b6\u6001\u4e3a\u5df2\u7ed3\u7b97");
                    break;
                }
                case "TRADE_FINISHED": {
                    resultAlipayTradeQueryResponseEntrty = ResultResponse.error((String)"\u4ea4\u6613\u7ed3\u675f\uff0c\u4e0d\u53ef\u9000\u6b3e");
                    break;
                }
                default: {
                    resultAlipayTradeQueryResponseEntrty = ResultResponse.error((String)("\u652f\u4ed8\u5b9d\u8ba2\u5355\u672a\u77e5\u72b6\u6001\uff1a" + alipayTradeQueryResponse.getTradeStatus()));
                }
            }
        }
        ResultResponse resultQueryMedicalResponseEntrty = new ResultResponse();
        ResultResponse resultResponse = this.medicalBusinessService.queryMedicalSettlementOrder(medicalPaymentRequest);
        if (resultResponse.getCode().equals("0")) {
            resultQueryMedicalResponseEntrty = ResultResponse.error((String)resultResponse.getMessage());
        } else {
            QueryMedicalSettlementOrderResponse queryMedicalSettlementOrderResponse = (QueryMedicalSettlementOrderResponse)((BaseMoveResponse)resultResponse.getBody()).getData();
            switch (queryMedicalSettlementOrderResponse.getOrdStas()) {
                case "0": {
                    resultQueryMedicalResponseEntrty = ResultResponse.error((String)"\u533b\u4fdd\u8ba2\u5355\u72b6\u6001\u4e3a\u5df2\u4fdd\u5b58");
                    break;
                }
                case "1": {
                    resultQueryMedicalResponseEntrty = ResultResponse.error((String)"\u9884\u7ed3\u7b97\u5b8c\u6210");
                    break;
                }
                case "2": {
                    resultQueryMedicalResponseEntrty = ResultResponse.error((String)"\u7ed3\u7b97\u4e2d");
                    break;
                }
                case "3": {
                    resultQueryMedicalResponseEntrty = ResultResponse.error((String)"\u81ea\u8d39\u5b8c\u6210");
                    break;
                }
                case "4": {
                    resultQueryMedicalResponseEntrty = ResultResponse.error((String)"\u533b\u4fdd\u652f\u4ed8\u5b8c\u6210");
                    break;
                }
                case "5": {
                    resultQueryMedicalResponseEntrty = ResultResponse.error((String)"\u9662\u5185\u7ed3\u7b97\u5b8c\u6210");
                    break;
                }
                case "6": {
                    resultQueryMedicalResponseEntrty = ResultResponse.error((String)"\u5df2\u7ed3\u7b97\u72b6\u6001");
                    break;
                }
                case "7": {
                    resultQueryMedicalResponseEntrty = ResultResponse.success((Object)"\u5df2\u9000\u6b3e");
                    break;
                }
                case "8": {
                    resultQueryMedicalResponseEntrty = ResultResponse.success((Object)"\u533b\u4fdd\u5168\u90e8\u9000\u6b3e");
                    break;
                }
                case "9": {
                    resultQueryMedicalResponseEntrty = ResultResponse.error((String)"\u4ec5\u81ea\u8d39\u5168\u90e8\u9000\u6b3e");
                    break;
                }
                case "10": {
                    resultQueryMedicalResponseEntrty = ResultResponse.error((String)"\u4ec5\u81ea\u8d39\u90e8\u5206\u9000\u6b3e");
                    break;
                }
                case "11": {
                    resultQueryMedicalResponseEntrty = ResultResponse.error((String)"\u533b\u4fdd\u5168\u90e8\u9000\u81ea\u8d39\u90e8\u5206\u9000\u6b3e");
                    break;
                }
                case "12": {
                    resultQueryMedicalResponseEntrty = ResultResponse.error((String)"\u5df2\u64a4\u9500");
                    break;
                }
                case "13": {
                    resultQueryMedicalResponseEntrty = ResultResponse.error((String)"\u533b\u4fdd\u5df2\u64a4\u9500");
                    break;
                }
                case "14": {
                    resultQueryMedicalResponseEntrty = ResultResponse.error((String)"\u5f02\u5e38");
                    break;
                }
                case "15": {
                    resultQueryMedicalResponseEntrty = ResultResponse.error((String)"\u7ed3\u7b97\u5931\u8d25");
                    break;
                }
                case "16": {
                    resultQueryMedicalResponseEntrty = ResultResponse.error((String)"\u533b\u4fdd\u7ed3\u7b97\u5931\u8d25\u81ea\u8d39\u51b2\u6b63\u5931\u8d25");
                    break;
                }
                case "17": {
                    resultQueryMedicalResponseEntrty = ResultResponse.error((String)("\u533b\u4fdd\u8ba2\u5355\u7ed3\u7b97\u5931\u8d25\uff1a" + medicalPaymentRequest.getPayOrdId()));
                    break;
                }
                default: {
                    resultQueryMedicalResponseEntrty = ResultResponse.error((String)("\u672a\u77e5\u72b6\u6001\u533b\u4fdd\u8ba2\u5355\u72b6\u6001\u4e3a\uff1a" + queryMedicalSettlementOrderResponse.getOrdStas()));
                }
            }
        }
        if (resultQueryMedicalResponseEntrty.getCode().equals("0") || resultAlipayTradeQueryResponseEntrty.getCode().equals("0")) {
            return ResultResponse.error((String)(resultQueryMedicalResponseEntrty.getMessage() + "||" + resultAlipayTradeQueryResponseEntrty.getMessage()));
        }
        return ResultResponse.success((Object)(resultQueryMedicalResponseEntrty.getMessage() + "||" + resultAlipayTradeQueryResponseEntrty.getMessage()));
    }

    public ResultResponse<BaseMoveResponse<CreatePayMedicalOrderResponse>> zkMedicalInsurancePayment(MedicalPaymentRequest medicalPaymentRequest) {
        MedicalChronicRequest medicalChronicRequest = new MedicalChronicRequest();
        medicalChronicRequest.setPsn_no(medicalPaymentRequest.getPsn_no());
        medicalChronicRequest.setOrganCode(medicalPaymentRequest.getOrganCode());
        log.info("+++++++\u67e5\u6162\u75c5\u7c7b\u578b\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)medicalChronicRequest));
        ResultResponse ybBaseResponseResultResponse = this.medicalBusinessService.medicalChronic(medicalChronicRequest);
        log.info("=======\u67e5\u6162\u75c5\u7c7b\u578b\u51fa\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)ybBaseResponseResultResponse));
        JSONObject medicalChronicResult = (JSONObject)JSONObject.parseObject((String)((List)((YbBaseResponse)ybBaseResponseResultResponse.getBody()).getOutput()).get(0).toString(), JSONObject.class);
        List feedetail = (List)JSONObject.parseObject((String)medicalChronicResult.get((Object)"feedetail").toString(), List.class);
        if (SUCCESS.equals(ybBaseResponseResultResponse.getCode()) && feedetail.size() > 0) {
            medicalPaymentRequest.setIsChronicisease(SUCCESS);
            medicalPaymentRequest.setDiseCodg(((JSONObject)feedetail.get(0)).get((Object)"opsp_dise_code").toString());
            medicalPaymentRequest.setDiseName(((JSONObject)feedetail.get(0)).get((Object)"opsp_dise_name").toString());
            MedicalCheckOrganRequest medicalCheckOrganRequest = new MedicalCheckOrganRequest();
            medicalCheckOrganRequest.setBiz_appy_type("01");
            medicalCheckOrganRequest.setOrganCode(medicalPaymentRequest.getOrganCode());
            medicalCheckOrganRequest.setPsn_no(medicalPaymentRequest.getPsn_no());
            ResultResponse checkOrganList = this.medicalBusinessService.checkOrgan(medicalCheckOrganRequest);
            JSONObject organListInfoJson = (JSONObject)JSONObject.parseObject((String)((List)((YbBaseResponse)checkOrganList.getBody()).getOutput()).get(0).toString(), JSONObject.class);
            List organList = (List)JSONObject.parseObject((String)organListInfoJson.get((Object)"psnfixmedin").toString(), List.class);
            if (!SUCCESS.equals(checkOrganList.getCode()) && organList.size() == 0) {
                if (!organList.stream().filter(item -> item.get((Object)"fixmedins_code").equals("H36010300622")).findAny().isPresent()) {
                    return ResultResponse.error((String)"\u5b9a\u70b9\u673a\u6784\u4e0d\u5339\u914d\uff01");
                }
                return ResultResponse.error((String)"\u672a\u67e5\u8be2\u5230\u5b9a\u70b9\u673a\u6784\uff01");
            }
        }
        String medType = "11";
        if (SUCCESS.equals(medicalPaymentRequest.getIsChronicisease())) {
            medType = "14";
        }
        DoctorYbInfoEntrty doctorYbInfoEntrty = new DoctorYbInfoEntrty();
        if ("\u5f20\u4f73\u946b".equals(medicalPaymentRequest.getDoctorName()) || "\u9ec4\u5e05\u5e05".equals(medicalPaymentRequest.getDoctorName()) || medicalPaymentRequest.getDoctorCode().contains("CS") || medicalPaymentRequest.getDoctorCode().contains("cs")) {
            doctorYbInfoEntrty.setDoctorYbCode("D360103016508");
            doctorYbInfoEntrty.setDoctorYbName("\u674e\u96ef\u971e");
        } else {
            ResultResponse resultResponse = this.medicalHisFrontService.getCloudHisDoctorInfo(medicalPaymentRequest.getOrganCode(), medicalPaymentRequest.getDoctorCode(), medicalPaymentRequest.getDoctorName());
            if (resultResponse.getCode().equals("0")) {
                MedDoctorInfoEntity medDoctorInfoEntity = (MedDoctorInfoEntity)this.medDoctorInfoMapper.selectOne((Wrapper)new QueryWrapper().eq((Object)"med_name", (Object)medicalPaymentRequest.getDoctorName()));
                if (Objects.isNull(medDoctorInfoEntity)) {
                    return ResultResponse.error((String)"\u672a\u67e5\u8be2\u5230\u533b\u751f\u533b\u4fdd\u767b\u8bb0\u4fe1\u606f");
                }
                doctorYbInfoEntrty.setDoctorYbName(medDoctorInfoEntity.getMedName());
                doctorYbInfoEntrty.setDoctorYbCode(medDoctorInfoEntity.getMedCode());
            } else {
                HisDoctorVo body = (HisDoctorVo)resultResponse.getBody();
                doctorYbInfoEntrty.setDoctorYbName(body.getUserName());
                doctorYbInfoEntrty.setDoctorYbCode(body.getHsCode());
            }
        }
        RegistrationRequest registrationRequest = new RegistrationRequest();
        registrationRequest.setInsuplc_admdvs(medicalPaymentRequest.getInsuplc_admdvs());
        registrationRequest.setPsn_no(medicalPaymentRequest.getPsn_no());
        registrationRequest.setInsutype(medicalPaymentRequest.getInsutype());
        registrationRequest.setBegntime(DateUtils.getTime());
        registrationRequest.setMdtrt_cert_type("02");
        registrationRequest.setPsn_type(medicalPaymentRequest.getPsnType());
        registrationRequest.setMdtrt_cert_no(medicalPaymentRequest.getMdtrt_cert_no());
        registrationRequest.setIpt_otp_no(medicalPaymentRequest.getIpt_otp_no());
        registrationRequest.setAtddr_no(doctorYbInfoEntrty.getDoctorYbCode());
        registrationRequest.setDr_name(doctorYbInfoEntrty.getDoctorYbName());
        registrationRequest.setDept_code(medicalPaymentRequest.getDeptCode());
        registrationRequest.setDept_name(medicalPaymentRequest.getDeptName());
        registrationRequest.setCaty(SUCCESS);
        registrationRequest.setOrganCode(medicalPaymentRequest.getOrganCode());
        ResultResponse ybRegistrationRespon = this.medicalBusinessService.ybRegistration(registrationRequest);
        if (ybRegistrationRespon.getCode().equals("0")) {
            return ResultResponse.error((String)("2201\u533b\u4fdd\u767b\u8bb0\uff1a" + ybRegistrationRespon.getMessage()));
        }
        Datavo ybRegistrationResponse = ((YbRegistrationResponse)((YbBaseResponse)ybRegistrationRespon.getBody()).getOutput()).getData();
        MoveUploadInfoRequest moveUploadInfoRequest = new MoveUploadInfoRequest();
        moveUploadInfoRequest.setOrganCode(medicalPaymentRequest.getOrganCode());
        moveUploadInfoRequest.setPayAuthNo(medicalPaymentRequest.getPay_auth_no());
        moveUploadInfoRequest.setPsnNo(ybRegistrationResponse.getPsn_no());
        moveUploadInfoRequest.setInsutype(medicalPaymentRequest.getInsutype());
        moveUploadInfoRequest.setInsuCode(medicalPaymentRequest.getInsuplc_admdvs());
        moveUploadInfoRequest.setMedOrgOrd(medicalPaymentRequest.getIpt_otp_no());
        moveUploadInfoRequest.setBegntime(DateUtils.getTime());
        moveUploadInfoRequest.setIdNo(medicalPaymentRequest.getMdtrt_cert_no());
        moveUploadInfoRequest.setUserName(medicalPaymentRequest.getPsn_name());
        moveUploadInfoRequest.setIdType("01");
        moveUploadInfoRequest.setMdtrtId(ybRegistrationResponse.getMdtrt_id());
        moveUploadInfoRequest.setMedType(medType);
        moveUploadInfoRequest.setFeeType("05");
        moveUploadInfoRequest.setMedfeeSumamt(medicalPaymentRequest.getMedfeeSumamt());
        moveUploadInfoRequest.setAcctUsedFlag(SUCCESS);
        moveUploadInfoRequest.setEcToken("");
        moveUploadInfoRequest.setDiseCodg(medicalPaymentRequest.getDiseCodg());
        moveUploadInfoRequest.setDiseName(medicalPaymentRequest.getDiseName());
        moveUploadInfoRequest.setChrgBchno("ZK" + medicalPaymentRequest.getChrgBchno());
        moveUploadInfoRequest.setUldLatlnt("0,0");
        moveUploadInfoRequest.setMdtrtCertType("01");
        ArrayList<MoveUploadInfoDiseinfoListRequest> diseinfoList = new ArrayList<MoveUploadInfoDiseinfoListRequest>();
        ArrayList<MoveUploadInfoFeedetailListRequest> moveUploadInfoFeedetailList = new ArrayList<MoveUploadInfoFeedetailListRequest>();
        List diseinfoList1 = medicalPaymentRequest.getDiseinfoList();
        for (String str : diseinfoList1) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("appChannel", medicalPaymentRequest.getAppCode());
            map.put("mainId", str);
            map.put("prescriptionSource", 0);
            map.put("type", "system");
            String param = JSONObject.toJSONString(map);
            String resp = HttpUtil.post((String)this.ZKPRESDETAILURL, (String)param);
            JSONObject respData = (JSONObject)JSON.parseObject((String)resp, JSONObject.class);
            if (!SUCCESS.equals(respData.get((Object)"code"))) {
                return ResultResponse.error((String)"\u67e5\u8be2\u5904\u65b9\u4fe1\u606f\u5931\u8d25\uff01");
            }
            JSONObject jsonObject = (JSONObject)JSON.parseObject((String)respData.get((Object)"data").toString(), JSONObject.class);
            log.info("===========\u5904\u65b9\u4fe1\u606f\uff1adata{}", (Object)JSONObject.toJSONString((Object)jsonObject));
            MoveUploadInfoDiseinfoListRequest moveUploadInfoDiseinfoListRequest = new MoveUploadInfoDiseinfoListRequest();
            moveUploadInfoDiseinfoListRequest.setDiagType(SUCCESS);
            moveUploadInfoDiseinfoListRequest.setDiagSrtNo(SUCCESS);
            moveUploadInfoDiseinfoListRequest.setDiagCode(jsonObject.get((Object)"icdCode").toString());
            moveUploadInfoDiseinfoListRequest.setDiagName(jsonObject.get((Object)"icdName").toString());
            moveUploadInfoDiseinfoListRequest.setDiagDept(medicalPaymentRequest.getDeptName());
            moveUploadInfoDiseinfoListRequest.setDiseDorNo(doctorYbInfoEntrty.getDoctorYbCode());
            moveUploadInfoDiseinfoListRequest.setDiseDorName(doctorYbInfoEntrty.getDoctorYbName());
            moveUploadInfoDiseinfoListRequest.setDiagTime(DateUtils.getTime());
            moveUploadInfoDiseinfoListRequest.setValiFlag(SUCCESS);
            diseinfoList.add(moveUploadInfoDiseinfoListRequest);
            List drugsList = (List)JSON.parseObject((String)jsonObject.get((Object)"drugDetailData").toString(), List.class);
            log.info("========\u836f\u54c1\u4fe1\u606f\u8be6\u60c5\uff1adrugDetailData{}", (Object)JSONObject.toJSONString((Object)drugsList));
            for (JSONObject drugs : drugsList) {
                ResultResponse hisDrugYbInfo = this.medicalHisFrontService.getCloudHisDrugYbInfo(medicalPaymentRequest.getOrganCode(), drugs.get((Object)"productCode").toString());
                if (hisDrugYbInfo.getCode().equals("0")) {
                    return ResultResponse.error((String)"\u67e5\u8be2\u836f\u54c1\u5bf9\u7167\u4fe1\u606f\u5931\u8d25\uff01");
                }
                List drugInfoVos = (List)hisDrugYbInfo.getBody();
                if (CollectionUtils.isEmpty((Collection)drugInfoVos)) {
                    return ResultResponse.error((String)"\u672a\u67e5\u8be2\u5230\u836f\u54c1\u5bf9\u7167\u4fe1\u606f!");
                }
                HisDrugInfoVo hisDrugInfoVo = (HisDrugInfoVo)drugInfoVos.get(0);
                MoveUploadInfoFeedetailListRequest moveUploadInfoFeedetailListRequest = new MoveUploadInfoFeedetailListRequest();
                moveUploadInfoFeedetailListRequest.setFeedetlSn("NCZKHLWYY-" + System.currentTimeMillis());
                moveUploadInfoFeedetailListRequest.setMdtrtId(ybRegistrationResponse.getMdtrt_id());
                moveUploadInfoFeedetailListRequest.setPsnNo(ybRegistrationResponse.getPsn_no());
                moveUploadInfoFeedetailListRequest.setChrgBchno("ZK" + medicalPaymentRequest.getChrgBchno());
                moveUploadInfoFeedetailListRequest.setDiseCodg(medicalPaymentRequest.getDiseCodg());
                moveUploadInfoFeedetailListRequest.setDrordNo("");
                moveUploadInfoFeedetailListRequest.setDscgTkdrugFlag("0");
                moveUploadInfoFeedetailListRequest.setEtipFlag("0");
                moveUploadInfoFeedetailListRequest.setRxCircFlag("0");
                moveUploadInfoFeedetailListRequest.setOrdersDrCode(doctorYbInfoEntrty.getDoctorYbCode());
                moveUploadInfoFeedetailListRequest.setOrdersDrName(doctorYbInfoEntrty.getDoctorYbName());
                moveUploadInfoFeedetailListRequest.setAcordDeptCodg(medicalPaymentRequest.getDeptCode());
                moveUploadInfoFeedetailListRequest.setAcordDeptName(medicalPaymentRequest.getDeptName());
                moveUploadInfoFeedetailListRequest.setRxCircFlag("0");
                moveUploadInfoFeedetailListRequest.setFeeOcurTime(DateUtils.getTime());
                moveUploadInfoFeedetailListRequest.setMedListCodg(hisDrugInfoVo.getMedicalInsuranceCode());
                moveUploadInfoFeedetailListRequest.setMedinsListCodg(hisDrugInfoVo.getInternalCode() + "");
                moveUploadInfoFeedetailListRequest.setMedListName(hisDrugInfoVo.getMedicalInsuranceName());
                BigDecimal packSpecification = new BigDecimal(hisDrugInfoVo.getPackSpecification());
                moveUploadInfoFeedetailListRequest.setCnt(String.valueOf(packSpecification.multiply(new BigDecimal(drugs.get((Object)"amount").toString()))));
                BigDecimal dividend = new BigDecimal(drugs.get((Object)"unitPrice").toString());
                MathContext mc = new MathContext(6);
                BigDecimal result = dividend.divide(packSpecification, mc);
                moveUploadInfoFeedetailListRequest.setPric(String.valueOf(result));
                BigDecimal amount = new BigDecimal(drugs.get((Object)"amount").toString());
                BigDecimal unitPrice = new BigDecimal(drugs.get((Object)"unitPrice").toString());
                BigDecimal count = amount.multiply(unitPrice);
                moveUploadInfoFeedetailListRequest.setDetItemFeeSumamt(count.toString());
                moveUploadInfoFeedetailListRequest.setBilgDeptCodg(medicalPaymentRequest.getDeptCode());
                moveUploadInfoFeedetailListRequest.setBilgDeptName(medicalPaymentRequest.getDeptName());
                moveUploadInfoFeedetailListRequest.setBilgDrCodg(doctorYbInfoEntrty.getDoctorYbCode());
                moveUploadInfoFeedetailListRequest.setBilgDrName(doctorYbInfoEntrty.getDoctorYbName());
                moveUploadInfoFeedetailListRequest.setHospApprFlag(SUCCESS);
                moveUploadInfoFeedetailListRequest.setMedType(medType);
                moveUploadInfoFeedetailList.add(moveUploadInfoFeedetailListRequest);
            }
        }
        moveUploadInfoRequest.setDiseinfoList(diseinfoList);
        moveUploadInfoRequest.setFeedetailList(moveUploadInfoFeedetailList);
        ResultResponse moveResponse = this.medicalBusinessService.moveUploadInfo(moveUploadInfoRequest);
        if (moveResponse.getCode().equals("0")) {
            RegistrationRevokeRequest registrationRevokeRequest = new RegistrationRevokeRequest();
            registrationRevokeRequest.setInsuplc_admdvs(medicalPaymentRequest.getInsuplc_admdvs());
            registrationRevokeRequest.setMdtrtarea_admvs(medicalPaymentRequest.getMdtrtarea_admvs());
            registrationRevokeRequest.setIpt_otp_no(medicalPaymentRequest.getIpt_otp_no());
            registrationRevokeRequest.setPsn_no(ybRegistrationResponse.getPsn_no());
            registrationRevokeRequest.setMdtrt_id(ybRegistrationResponse.getMdtrt_id());
            registrationRevokeRequest.setOrganCode(medicalPaymentRequest.getOrganCode());
            this.medicalBusinessService.ybRegistrationRevoke(registrationRevokeRequest);
            return ResultResponse.error((String)("6201\u533b\u4fdd\u660e\u7ec6\u4e0a\u4f20\uff1a" + moveResponse.getMessage()));
        }
        MoveUploadInfoResponse moveUploadInfoResponse = (MoveUploadInfoResponse)((BaseMoveResponse)moveResponse.getBody()).getData();
        CreatePayMedicalOrderRequest createPayMedicalOrderRequest = new CreatePayMedicalOrderRequest();
        createPayMedicalOrderRequest.setOrganCode(medicalPaymentRequest.getOrganCode());
        createPayMedicalOrderRequest.setChrgBchno(medicalPaymentRequest.getChrgBchno());
        createPayMedicalOrderRequest.setPayAuthNo(medicalPaymentRequest.getPay_auth_no());
        createPayMedicalOrderRequest.setPayOrdId(moveUploadInfoResponse.getPayOrdId());
        createPayMedicalOrderRequest.setOrgBizSer(medicalPaymentRequest.getIpt_otp_no());
        createPayMedicalOrderRequest.setMdtrtId(ybRegistrationResponse.getMdtrt_id());
        createPayMedicalOrderRequest.setPayToken(moveUploadInfoResponse.getPayToken());
        createPayMedicalOrderRequest.setFeeType("05");
        ResultResponse createPayMedicalResponse = this.medicalBusinessService.createPayMedicalOrder(createPayMedicalOrderRequest);
        if (createPayMedicalResponse.getCode().equals("0")) {
            MedicalRevokeorderRequest medicalRevokeorderRequest = new MedicalRevokeorderRequest();
            medicalRevokeorderRequest.setPayToken(((MoveUploadInfoResponse)((BaseMoveResponse)moveResponse.getBody()).getData()).getPayToken());
            medicalRevokeorderRequest.setUserName(medicalPaymentRequest.getPsn_name());
            medicalRevokeorderRequest.setIdType("01");
            medicalRevokeorderRequest.setIdNo(medicalPaymentRequest.getMdtrt_cert_no());
            medicalRevokeorderRequest.setOrganCode(medicalPaymentRequest.getOrganCode());
            medicalRevokeorderRequest.setPayOrdId(((MoveUploadInfoResponse)((BaseMoveResponse)moveResponse.getBody()).getData()).getPayOrdId());
            this.medicalBusinessService.medicalRevokeorder(medicalRevokeorderRequest);
            return ResultResponse.error((String)("6202\u533b\u4fdd\u4e0b\u5355\uff1a" + createPayMedicalResponse.getMessage()));
        }
        CreatePayMedicalOrderResponse createPayMedicalOrderResponse = (CreatePayMedicalOrderResponse)((BaseMoveResponse)createPayMedicalResponse.getBody()).getData();
        createPayMedicalOrderResponse.setMdtrtId(ybRegistrationResponse.getMdtrt_id());
        createPayMedicalOrderResponse.setPayToken(((MoveUploadInfoResponse)((BaseMoveResponse)moveResponse.getBody()).getData()).getPayToken());
        return createPayMedicalResponse;
    }

    public static void main(String[] args) {
        BigDecimal dividend = new BigDecimal("329.41");
        BigDecimal divisor = new BigDecimal("30");
        MathContext mc = new MathContext(6);
        BigDecimal result = dividend.divide(divisor, mc);
        System.out.println(result);
        String feedetial = "{\"body\":{\"inf_refmsgid\":\"360000202305241527082420964645\",\"infcode\":\"0\",\"output\":[{\"feedetail\":[]}],\"refmsg_time\":\"20230524152708069\",\"respond_time\":\"20230524152708091\"},\"code\":\"1\",\"errCode\":\"1\",\"message\":\"\u64cd\u4f5c\u6210\u529f\",\"transactionId\":\"\"}\n";
        JSONObject medicalChronicResult = (JSONObject)JSONObject.parseObject((String)feedetial, JSONObject.class);
        List feedetail = (List)JSONObject.parseObject((String)medicalChronicResult.get((Object)"feedetail").toString(), List.class);
    }

    static /* synthetic */ Logger access$000() {
        return log;
    }

    static /* synthetic */ YdMedicalDataBaseService access$100(MedicalPaymentServiceImpl x0) {
        return x0.ydMedicalDataBaseService;
    }

    static /* synthetic */ MedicalHisFrontService access$200(MedicalPaymentServiceImpl x0) {
        return x0.medicalHisFrontService;
    }
}

