/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.medicarecore.handle.exception;

import com.ebaiyihui.medicarecore.handle.annotation.Log;
import com.ebaiyihui.medicarecore.ybBusiness.domain.ResultResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.BindException;
import org.springframework.validation.ObjectError;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
public class GlobalExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandler.class);

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    public ResultResponse<String> handleException(HttpRequestMethodNotSupportedException e) {
        log.error(e.getMessage(), (Throwable)e);
        return ResultResponse.error((String)("\u4e0d\u652f\u6301' " + e.getMethod() + "'\u8bf7\u6c42"));
    }

    @ExceptionHandler(value={RuntimeException.class})
    public ResultResponse<String> notFount(RuntimeException e) {
        log.error("\u8fd0\u884c\u65f6\u5f02\u5e38:", (Throwable)e);
        return ResultResponse.error((String)("\u8fd0\u884c\u65f6\u5f02\u5e38:" + e.getMessage()));
    }

    @Log(name="\u8bf7\u6c42\u5f02\u5e38", code="00")
    @ExceptionHandler(value={Exception.class})
    public ResultResponse<String> handleException(Exception e) {
        log.error(e.getMessage(), (Throwable)e);
        return ResultResponse.error((String)"\u670d\u52a1\u5668\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
    }

    @ExceptionHandler(value={BindException.class})
    public ResultResponse<String> validatedBindException(BindException e) {
        log.error(e.getMessage(), (Throwable)e);
        String message = ((ObjectError)e.getAllErrors().get(0)).getDefaultMessage();
        return ResultResponse.error((String)message);
    }
}

