/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.gateway.filter;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.gateway.config.AuthorityConfig;
import com.ebaiyihui.gateway.config.RequestWrapper;
import com.netflix.zuul.ZuulFilter;
import com.netflix.zuul.context.RequestContext;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Component;

@Component
@RefreshScope
public class IllegalParamFilter
extends ZuulFilter {
    private static final Logger log = LoggerFactory.getLogger(IllegalParamFilter.class);
    @Autowired
    private AuthorityConfig authorityConfig;

    public boolean shouldFilter() {
        boolean enabled = this.authorityConfig.isEnabled();
        return enabled && !this.authorityConfig.getIllegalParamList().isEmpty();
    }

    public Object run() {
        RequestContext currentContext = RequestContext.getCurrentContext();
        HttpServletRequest request = currentContext.getRequest();
        if (StringUtils.isNotBlank((CharSequence)request.getContentType()) && request.getContentType().contains("multipart")) {
            log.info("\u8bf7\u6c42\u7c7b\u578bmultipart,\u4e0d\u505a\u6821\u9a8c");
            return null;
        }
        Map mapParams = StringUtils.isNotBlank((CharSequence)request.getContentType()) && request.getContentType().contains("application/json") ? JSON.parseObject((String)new RequestWrapper(request).getBody()) : this.convertDataMap(request);
        log.info("\u53c2\u6570{}", (Object)mapParams);
        if (!mapParams.isEmpty()) {
            for (Object obj : mapParams.keySet()) {
                String paramValue = mapParams.get(obj).toString();
                for (String illegalchar : this.authorityConfig.getIllegalParamList()) {
                    if (!StringUtils.isNotBlank((CharSequence)paramValue) || !paramValue.contains(illegalchar)) continue;
                    log.error("\u975e\u6cd5\u8bf7\u6c42\uff1a\u53c2\u6570{}\u7684\u503c{}\u5305\u542b\u975e\u6cd5\u5b57\u7b26{}", new Object[]{obj, paramValue, illegalchar});
                    HttpServletResponse response = currentContext.getResponse();
                    response.setContentType("text/html;charset=utf-8");
                    currentContext.setSendZuulResponse(false);
                    currentContext.setResponseStatusCode(200);
                    currentContext.setResponseBody("{\"data\":\"unauthorized\",\"code\":1110002, \"msg\":\"\u8bf7\u6c42\u53c2\u6570'" + obj + "'\u7684\u503c'" + paramValue + "'\u5305\u542b\u975e\u6cd5\u5b57\u7b26'" + illegalchar + "'\"}");
                    currentContext.set("illegal_param_filter_flag", (Object)true);
                    return null;
                }
            }
            log.info("\u53c2\u6570{}\u901a\u8fc7\u6821\u9a8c", (Object)mapParams);
        } else {
            log.info("\u53c2\u6570\u4e3a\u7a7a,\u65e0\u9700\u6821\u9a8c");
        }
        return null;
    }

    public String filterType() {
        return "pre";
    }

    public int filterOrder() {
        return -1;
    }

    private Map<String, Object> convertDataMap(HttpServletRequest request) {
        Map properties = request.getParameterMap();
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        Iterator entries = properties.entrySet().iterator();
        String value = "";
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            String name = (String)entry.getKey();
            Object valueObj = entry.getValue();
            if (null == valueObj) {
                value = "";
            } else if (valueObj instanceof String[]) {
                String[] values = (String[])valueObj;
                for (int i = 0; i < values.length; ++i) {
                    value = values[i] + ",";
                }
                value = value.substring(0, value.length() - 1);
            } else {
                value = valueObj.toString();
            }
            returnMap.put(name, value);
        }
        return returnMap;
    }
}

