/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.gateway.filter;

import com.ebaiyihui.gateway.enums.ErrorEnum;
import com.ebaiyihui.gateway.filter.IErrorFilter;
import com.netflix.client.ClientException;
import com.netflix.zuul.ZuulFilter;
import com.netflix.zuul.context.RequestContext;
import com.netflix.zuul.exception.ZuulException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.netflix.zuul.util.ZuulRuntimeException;

public class IErrorFilter
extends ZuulFilter {
    private static final Logger log = LoggerFactory.getLogger(IErrorFilter.class);
    private static final String ERROR_STATUS_CODE_KEY = "error.status_code";
    public static final String DEFAULT_ERR_MSG = "\u7cfb\u7edf\u7e41\u5fd9,\u8bf7\u7a0d\u540e\u518d\u8bd5";

    public String filterType() {
        return "error";
    }

    public int filterOrder() {
        return 0;
    }

    public boolean shouldFilter() {
        RequestContext ctx = RequestContext.getCurrentContext();
        log.info(ctx.getRequest().getRequestURL() + "");
        return true;
    }

    public Object run() {
        RequestContext ctx = RequestContext.getCurrentContext();
        log.info("======\u8fdb\u5165\u5f02\u5e38\u8fc7\u6ee4\u5668:{}", ctx.getThrowable());
        try {
            HttpServletRequest request = ctx.getRequest();
            Integer statusCode = (Integer)ctx.get((Object)ERROR_STATUS_CODE_KEY);
            String message = (String)ctx.get((Object)"error.message");
            if (ctx.containsKey((Object)"error.exception")) {
                Exception e = (Exception)ctx.get((Object)"error.exception");
                Throwable re = this.getOriginException((Throwable)e);
                if (re instanceof ConnectException) {
                    message = "Real Service Connection refused";
                    log.warn("uri:{},error:{}", (Object)request.getRequestURI(), (Object)re.getMessage());
                } else if (re instanceof SocketTimeoutException) {
                    message = "Real Service Timeout";
                    log.warn("uri:{},error:{}", (Object)request.getRequestURI(), (Object)re.getMessage());
                } else if (re instanceof ClientException) {
                    message = re.getMessage();
                    log.warn("uri:{},error:{}", (Object)request.getRequestURI(), (Object)re.getMessage());
                } else {
                    log.warn("ErrorEnum during filtering", (Throwable)e);
                }
            }
            if (StringUtils.isBlank((CharSequence)message)) {
                message = DEFAULT_ERR_MSG;
            }
            if (Objects.isNull(statusCode)) {
                statusCode = Integer.valueOf(ErrorEnum.NO_PERMISSION.getErrCode());
            }
            request.setAttribute("javax.servlet.error.status_code", (Object)statusCode);
            request.setAttribute("javax.servlet.error.message", (Object)message);
        }
        catch (Exception e) {
            String error = "ErrorEnum during filtering[ErrorFilter]";
            log.error(error, (Throwable)e);
        }
        return null;
    }

    private Throwable getOriginException(Throwable e) {
        e = e.getCause();
        while (e.getCause() != null) {
            e = e.getCause();
        }
        return e;
    }

    private ZuulException findZuulException(Throwable throwable) {
        if (ZuulRuntimeException.class.isInstance(throwable.getCause())) {
            return (ZuulException)throwable.getCause().getCause();
        }
        if (ZuulException.class.isInstance(throwable.getCause())) {
            return (ZuulException)throwable.getCause();
        }
        return ZuulException.class.isInstance(throwable) ? (ZuulException)throwable : new ZuulException(throwable, 500, (String)null);
    }

    IErrorFilter() {
    }

    public static IErrorFilterBuilder builder() {
        return new IErrorFilterBuilder();
    }
}

