/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.gateway.filter;

import com.ebaiyihui.gateway.config.AuthorityConfig;
import com.netflix.zuul.ZuulFilter;
import com.netflix.zuul.context.RequestContext;
import com.netflix.zuul.exception.ZuulException;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Component;

@Component
@RefreshScope
public class ResourceAccessFilter
extends ZuulFilter {
    private static final Logger log = LoggerFactory.getLogger(ResourceAccessFilter.class);
    @Autowired
    private AuthorityConfig authorityConfig;

    public String filterType() {
        return "pre";
    }

    public int filterOrder() {
        return -1;
    }

    public boolean shouldFilter() {
        boolean resourceFlag = this.authorityConfig.isResourceFlag();
        log.info("ResourceAccessFilter_resourceFlag:{}", (Object)resourceFlag);
        return resourceFlag;
    }

    public Object run() throws ZuulException {
        String[] pathsToMatch;
        RequestContext ctx = RequestContext.getCurrentContext();
        HttpServletRequest request = ctx.getRequest();
        String requestURI = request.getRequestURI();
        log.info("ResourceAccessFilter_requestURI:{}", (Object)requestURI);
        for (String path : pathsToMatch = new String[]{"/druid", "/v2/api-docs", "/swagger-resources", "/swagger-ui.html", "/actuator"}) {
            log.info("ResourceAccessFilter_path:{}", (Object)path);
            log.info("ResourceAccessFilter_requestURI.matches:{}", (Object)requestURI.matches("(?i)" + path));
            if (!requestURI.matches("(?i)" + path)) continue;
            ctx.setResponseStatusCode(403);
            ctx.addZuulResponseHeader("Content-Type", "text/plain;charset=UTF-8");
            ctx.setResponseBody("You do not have permission to access this resource.");
            ctx.setSendZuulResponse(false);
            return null;
        }
        return null;
    }
}

