/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.gateway.config;

import com.ebaiyihui.gateway.common.Constants;
import com.ebaiyihui.gateway.service.IgnoreService;
import com.ebaiyihui.gateway.service.IllegalParamService;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConfigurationProperties(prefix="authority")
public class AuthorityConfig {
    private static final Logger log = LoggerFactory.getLogger(AuthorityConfig.class);
    @Autowired
    private IgnoreService ignoreUrlService;
    @Autowired
    private IllegalParamService illegalParamService;
    private List<String> ignoreUrlList = new ArrayList();
    private List<String> whiteIpList = new ArrayList();
    private List<String> illegalParamList = new ArrayList();
    private boolean enabled = Boolean.TRUE;
    private String appCode;
    private String superAdminAuthUrl = "";
    private String cloudDoctorAuthUrl = "";

    @PostConstruct
    public void init() {
        log.info("\u7cfb\u7edf\u542f\u52a8\u4e2d\u3002\u3002\u3002");
        this.ignoreUrlService.getAll(Constants.TYPE_ONE);
        this.ignoreUrlService.getAll(Constants.TYPE_TWO);
    }

    public synchronized void putUrl(List<String> all) {
        if (all == null || all.isEmpty()) {
            return;
        }
        this.ignoreUrlList.addAll(all);
    }

    public synchronized void putIp(List<String> all) {
        if (all == null || all.isEmpty()) {
            return;
        }
        this.whiteIpList.addAll(all);
    }

    public synchronized void putIllegalParam(List<String> all) {
        if (all == null || all.isEmpty()) {
            return;
        }
        this.illegalParamList.addAll(all);
    }

    public void set(String name, Integer status) {
        if (status.equals(Constants.TYPE_ONE)) {
            this.ignoreUrlList.add(name);
        }
        if (status.equals(Constants.TYPE_TWO)) {
            this.whiteIpList.add(name);
        }
    }

    public void del(String name, Integer status) {
        if (status.equals(Constants.TYPE_ONE)) {
            this.ignoreUrlList.remove(name);
        }
        if (status.equals(Constants.TYPE_TWO)) {
            this.whiteIpList.remove(name);
        }
    }

    public void setIllegalParam(String name) {
        this.illegalParamList.add(name);
    }

    public void delIllegalParam(String name) {
        this.illegalParamList.remove(name);
    }

    public IgnoreService getIgnoreUrlService() {
        return this.ignoreUrlService;
    }

    public IllegalParamService getIllegalParamService() {
        return this.illegalParamService;
    }

    public List<String> getIgnoreUrlList() {
        return this.ignoreUrlList;
    }

    public List<String> getWhiteIpList() {
        return this.whiteIpList;
    }

    public List<String> getIllegalParamList() {
        return this.illegalParamList;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getAppCode() {
        return this.appCode;
    }

    public String getSuperAdminAuthUrl() {
        return this.superAdminAuthUrl;
    }

    public String getCloudDoctorAuthUrl() {
        return this.cloudDoctorAuthUrl;
    }

    public void setIgnoreUrlService(IgnoreService ignoreUrlService) {
        this.ignoreUrlService = ignoreUrlService;
    }

    public void setIllegalParamService(IllegalParamService illegalParamService) {
        this.illegalParamService = illegalParamService;
    }

    public void setIgnoreUrlList(List<String> ignoreUrlList) {
        this.ignoreUrlList = ignoreUrlList;
    }

    public void setWhiteIpList(List<String> whiteIpList) {
        this.whiteIpList = whiteIpList;
    }

    public void setIllegalParamList(List<String> illegalParamList) {
        this.illegalParamList = illegalParamList;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setAppCode(String appCode) {
        this.appCode = appCode;
    }

    public void setSuperAdminAuthUrl(String superAdminAuthUrl) {
        this.superAdminAuthUrl = superAdminAuthUrl;
    }

    public void setCloudDoctorAuthUrl(String cloudDoctorAuthUrl) {
        this.cloudDoctorAuthUrl = cloudDoctorAuthUrl;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuthorityConfig)) {
            return false;
        }
        AuthorityConfig other = (AuthorityConfig)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        IgnoreService this$ignoreUrlService = this.getIgnoreUrlService();
        IgnoreService other$ignoreUrlService = other.getIgnoreUrlService();
        if (this$ignoreUrlService == null ? other$ignoreUrlService != null : !this$ignoreUrlService.equals(other$ignoreUrlService)) {
            return false;
        }
        IllegalParamService this$illegalParamService = this.getIllegalParamService();
        IllegalParamService other$illegalParamService = other.getIllegalParamService();
        if (this$illegalParamService == null ? other$illegalParamService != null : !this$illegalParamService.equals(other$illegalParamService)) {
            return false;
        }
        List this$ignoreUrlList = this.getIgnoreUrlList();
        List other$ignoreUrlList = other.getIgnoreUrlList();
        if (this$ignoreUrlList == null ? other$ignoreUrlList != null : !((Object)this$ignoreUrlList).equals(other$ignoreUrlList)) {
            return false;
        }
        List this$whiteIpList = this.getWhiteIpList();
        List other$whiteIpList = other.getWhiteIpList();
        if (this$whiteIpList == null ? other$whiteIpList != null : !((Object)this$whiteIpList).equals(other$whiteIpList)) {
            return false;
        }
        List this$illegalParamList = this.getIllegalParamList();
        List other$illegalParamList = other.getIllegalParamList();
        if (this$illegalParamList == null ? other$illegalParamList != null : !((Object)this$illegalParamList).equals(other$illegalParamList)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        String this$appCode = this.getAppCode();
        String other$appCode = other.getAppCode();
        if (this$appCode == null ? other$appCode != null : !this$appCode.equals(other$appCode)) {
            return false;
        }
        String this$superAdminAuthUrl = this.getSuperAdminAuthUrl();
        String other$superAdminAuthUrl = other.getSuperAdminAuthUrl();
        if (this$superAdminAuthUrl == null ? other$superAdminAuthUrl != null : !this$superAdminAuthUrl.equals(other$superAdminAuthUrl)) {
            return false;
        }
        String this$cloudDoctorAuthUrl = this.getCloudDoctorAuthUrl();
        String other$cloudDoctorAuthUrl = other.getCloudDoctorAuthUrl();
        return !(this$cloudDoctorAuthUrl == null ? other$cloudDoctorAuthUrl != null : !this$cloudDoctorAuthUrl.equals(other$cloudDoctorAuthUrl));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AuthorityConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        IgnoreService $ignoreUrlService = this.getIgnoreUrlService();
        result = result * 59 + ($ignoreUrlService == null ? 43 : $ignoreUrlService.hashCode());
        IllegalParamService $illegalParamService = this.getIllegalParamService();
        result = result * 59 + ($illegalParamService == null ? 43 : $illegalParamService.hashCode());
        List $ignoreUrlList = this.getIgnoreUrlList();
        result = result * 59 + ($ignoreUrlList == null ? 43 : ((Object)$ignoreUrlList).hashCode());
        List $whiteIpList = this.getWhiteIpList();
        result = result * 59 + ($whiteIpList == null ? 43 : ((Object)$whiteIpList).hashCode());
        List $illegalParamList = this.getIllegalParamList();
        result = result * 59 + ($illegalParamList == null ? 43 : ((Object)$illegalParamList).hashCode());
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        String $appCode = this.getAppCode();
        result = result * 59 + ($appCode == null ? 43 : $appCode.hashCode());
        String $superAdminAuthUrl = this.getSuperAdminAuthUrl();
        result = result * 59 + ($superAdminAuthUrl == null ? 43 : $superAdminAuthUrl.hashCode());
        String $cloudDoctorAuthUrl = this.getCloudDoctorAuthUrl();
        result = result * 59 + ($cloudDoctorAuthUrl == null ? 43 : $cloudDoctorAuthUrl.hashCode());
        return result;
    }

    public String toString() {
        return "AuthorityConfig(ignoreUrlService=" + this.getIgnoreUrlService() + ", illegalParamService=" + this.getIllegalParamService() + ", ignoreUrlList=" + this.getIgnoreUrlList() + ", whiteIpList=" + this.getWhiteIpList() + ", illegalParamList=" + this.getIllegalParamList() + ", enabled=" + this.isEnabled() + ", appCode=" + this.getAppCode() + ", superAdminAuthUrl=" + this.getSuperAdminAuthUrl() + ", cloudDoctorAuthUrl=" + this.getCloudDoctorAuthUrl() + ")";
    }
}

