/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.gateway.filter;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.common.token.TokenJson;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.response.IError;
import com.ebaiyihui.gateway.config.AuthorityConfig;
import com.ebaiyihui.gateway.config.RequestWrapper;
import com.ebaiyihui.gateway.enums.ErrorEnum;
import com.ebaiyihui.gateway.service.AuthFeignClientAPI;
import com.ebaiyihui.gateway.service.LoginCheck;
import com.netflix.zuul.ZuulFilter;
import com.netflix.zuul.context.RequestContext;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
@RefreshScope
public class AuthorityFilter
extends ZuulFilter {
    private static final Logger log = LoggerFactory.getLogger(AuthorityFilter.class);
    public static final String LY_NODE = "LYCITYYS";
    public static final String DOCTOR_WEB = "doctor_web";
    public static final String CLOUD = "cloud";
    @Autowired
    private AuthorityConfig authorityConfig;
    @Autowired
    private LoginCheck loginCheckToken;
    @Autowired
    private AuthFeignClientAPI authFeignClientAPI;

    public boolean shouldFilter() {
        RequestContext currentContext = RequestContext.getCurrentContext();
        boolean illegalParamFilterFlag = currentContext.getBoolean("illegal_param_filter_flag", Boolean.FALSE.booleanValue());
        if (illegalParamFilterFlag) {
            return false;
        }
        HttpServletRequest request = currentContext.getRequest();
        boolean enabled = this.authorityConfig.isEnabled();
        List whiteIpList = this.authorityConfig.getWhiteIpList();
        List whiteUrlList = this.authorityConfig.getIgnoreUrlList();
        String ipAddress = AuthorityFilter.getIpAddress((HttpServletRequest)request);
        String urlAddress = this.getUrlAddress(request);
        log.info("\u8bf7\u6c42\u6765\u6e90\u7684ip\u5730\u5740:{},\u8bf7\u6c42\u6765\u6e90\u7684URL:{}", (Object)ipAddress, (Object)urlAddress);
        String appCode = request.getHeader("appCode");
        log.info("\u8bf7\u6c42\u6765\u6e90\u7684appCode:{}", (Object)appCode);
        String[] ipArray = ipAddress.split(",");
        if (ipAddress.length() > 0) {
            ipAddress = ipArray[0];
        }
        if (whiteIpList.contains(ipAddress)) {
            currentContext.set("isWhiteIp", (Object)true);
        }
        boolean contains = whiteUrlList.contains(urlAddress);
        if (!enabled || whiteIpList.contains(ipAddress) || contains) {
            log.info("\u767d\u540d\u5355ip\u6216\u5f00\u653e\u7684\u63a5\u53e3\u8c03\u7528 -> \u8bf7\u6c42\u65b9\u5f0f:{},\u8bf7\u6c42url:{}", (Object)request.getMethod(), (Object)request.getRequestURL().toString());
            currentContext.addZuulResponseHeader("X-Logged-In", "false");
            return false;
        }
        currentContext.addZuulResponseHeader("X-Logged-In", "true");
        return true;
    }

    public Object run() {
        RequestContext currentContext = RequestContext.getCurrentContext();
        HttpServletRequest request = currentContext.getRequest();
        log.info("\u8fdb\u5165\u767b\u5f55\u62e6\u622a\u68c0\u9a8c -> \u8bf7\u6c42\u65b9\u5f0f:{},\u8bf7\u6c42url:{}", (Object)request.getMethod(), (Object)request.getRequestURL().toString());
        String cloudAuth = request.getHeader("cloudAuth");
        String token = request.getHeader("token");
        String accessToken = request.getHeader("accessToken");
        String appChannel = request.getHeader("appChannel");
        String channelSource = request.getHeader("channelSource");
        String cloud = request.getHeader("cloud");
        log.info("\u89d2\u8272\u7aef:[{}],\u8d85\u7ba1\u68c0\u9a8c\u5934cloudAuth:[{}],\u533b\u751f\u6821\u9a8c\u5934appChannel:[{}]", new Object[]{channelSource, cloudAuth, appChannel});
        if (StringUtils.isNotBlank((CharSequence)cloud) && "cloud".equals(cloud)) {
            log.info("\u8ba4\u8bc1\u4e2d\u5fc3\u8d85\u7ba1\u767b\u5f55");
            this.authFeignClientAPI.validToken(token);
        } else if (StringUtils.isNotEmpty((CharSequence)cloudAuth) && "cloudAuth".equals(cloudAuth)) {
            log.info("\u4e91\u7aef\u6821\u9a8c\u8d85\u7ba1,token:[{}]", (Object)token);
            this.checkCloudAuth(currentContext, token);
        } else if (StringUtils.isNotEmpty((CharSequence)channelSource) && "integratedManagement".equalsIgnoreCase(channelSource)) {
            log.info("\u8282\u70b9\u6821\u9a8c\u7ba1\u7406\u5458,channelSource:{},token:[{}]", (Object)channelSource, (Object)token);
            this.checkNodeAuth(currentContext, token, true);
        } else if (StringUtils.isNotEmpty((CharSequence)channelSource) && "largeTerminal".equalsIgnoreCase(channelSource)) {
            log.info("\u8282\u70b9\u6821\u9a8c\u60a3\u8005,accessToken:[{}]", (Object)accessToken);
            this.checkNodeAuth(currentContext, accessToken == null ? token : accessToken, false);
        } else {
            log.info("\u4e91\u7aef\u6821\u9a8c\u533b\u751f,token:[{}]", (Object)token);
            this.checkCloudDoctor(currentContext, token);
        }
        if (!currentContext.getBoolean("isWhiteIp")) {
            this.validateDataSign(currentContext, request);
        }
        return null;
    }

    private void validateDataSign(RequestContext ctx, HttpServletRequest request) {
        String param;
        String channelSource = request.getHeader("channelSource");
        String doctorWeb = request.getHeader("appChannel");
        String cloudAuth = request.getHeader("cloudAuth");
        String appCode = request.getHeader("appCode");
        String sign = request.getHeader("signMsg");
        log.info("\u524d\u7aef\u4f20\u9012sign->{}", (Object)sign);
        if (StringUtils.isBlank((CharSequence)sign)) {
            HttpServletResponse response = ctx.getResponse();
            response.setContentType("text/html;charset=utf-8");
            ctx.setSendZuulResponse(false);
            ctx.setResponseStatusCode(200);
            ctx.setResponseBody("{\"data\":\"unauthorized\",\"code\":1110004, \"msg\":\"\u6570\u636e\u7b7e\u540d\u6821\u9a8c\u5931\u8d25\"}");
            return;
        }
        RequestWrapper requestWrapper = new RequestWrapper(request);
        String body = requestWrapper.getBody();
        String getParam = AuthorityFilter.getParamOfMethodGet((HttpServletRequest)request);
        if (StringUtils.isNotBlank((CharSequence)getParam)) {
            param = getParam;
            log.info("get\u8bf7\u6c42\u53c2\u6570\uff1a" + param);
            try {
                param = URLDecoder.decode(param, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                log.error("\u89e3\u7801\u53c2\u6570\u5f02\u5e38\uff1a " + e.getMessage());
            }
        } else {
            param = body;
            log.info("post\u8bf7\u6c42\u53c2\u6570\uff1a" + param);
            if (param.contains("=") && !param.contains(":")) {
                param = AuthorityFilter.convertParam((String)param);
                log.info("post\u8bf7\u6c42\u53c2\u6570 convertParam\u540e \uff1a" + param);
                try {
                    param = URLDecoder.decode(param, "UTF-8");
                    log.info("post\u8bf7\u6c42\u53c2\u6570 URLDecoder\u540e \uff1a" + param);
                }
                catch (UnsupportedEncodingException e) {
                    log.error("\u89e3\u7801\u53c2\u6570\u5f02\u5e38\uff1a " + e.getMessage());
                }
            }
            if (StringUtils.isNotBlank((CharSequence)request.getContentType()) && request.getContentType().contains("multipart")) {
                param = "";
            }
        }
        if (StringUtils.isNotBlank((CharSequence)param)) {
            String _signMsg = null;
            try {
                log.info("md5\u53c2\u6570\u52a0\u5bc6\u524d\u539f\u6587 => {}", (Object)param);
                _signMsg = this.md5(param);
            }
            catch (Exception e) {
                log.error("md5\u53c2\u6570\u52a0\u5bc6\u5931\u8d25 => {}", (Object)e.getMessage());
            }
            if (!_signMsg.equals(sign)) {
                log.info("\u53c2\u6570\u7b7e\u540d\u6821\u9a8c\u5931\u8d25\uff1a \u4f20\u53c2\u4e3a->{},  \u8ba1\u7b97\u5f97\u5230\u7684\u7ed3\u679csign->{},  \u524d\u7aef\u4f20\u9012sign->{}", new Object[]{param, _signMsg, sign});
                HttpServletResponse response = ctx.getResponse();
                response.setContentType("text/html;charset=utf-8");
                ctx.setSendZuulResponse(false);
                ctx.setResponseStatusCode(200);
                ctx.setResponseBody("{\"data\":\"unauthorized\",\"code\":1110004, \"msg\":\"\u6570\u636e\u7b7e\u540d\u6821\u9a8c\u5931\u8d25\"}");
            } else {
                log.info("\u53c2\u6570\u7b7e\u540d\u6821\u9a8c\u6210\u529f\uff1a sign->{}", (Object)sign);
            }
        }
    }

    private String md5(String data) {
        String stringToMD5 = DigestUtils.md5Hex((String)data);
        String md5codeBefore = stringToMD5.substring(0, 12);
        String md5codeRemaining = stringToMD5.substring(12, stringToMD5.length());
        String md5codeAfter = stringToMD5.substring(stringToMD5.length() - 10);
        String md5codeResults = md5codeRemaining.substring(0, md5codeRemaining.length() - 10);
        String stringToMD5New = DigestUtils.md5Hex((String)(md5codeAfter + md5codeResults + md5codeBefore));
        return stringToMD5New;
    }

    public static String getParamOfMethodGet(HttpServletRequest request) {
        if (null == request.getQueryString()) {
            return "";
        }
        String param = URLDecoder.decode(request.getQueryString());
        param = AuthorityFilter.convertParam((String)param);
        return param;
    }

    public static String convertParam(String param) {
        Object[] params = param.split("&");
        Arrays.sort(params);
        JSONObject json = new JSONObject(true);
        for (int i = 0; i < params.length; ++i) {
            String key = "";
            String value = "";
            key = ((String)params[i]).split("=")[0];
            if (((String)params[i]).split("=").length > 1) {
                value = ((String)params[i]).split("=")[1];
                json.put(key, (Object)value);
                continue;
            }
            json.put(key, (Object)"");
        }
        String javaScript = StringEscapeUtils.unescapeJavaScript((String)json.toString());
        return javaScript;
    }

    public String filterType() {
        return "pre";
    }

    public int filterOrder() {
        return 0;
    }

    public static String getIpAddress(HttpServletRequest request) {
        String ip = request.getHeader("X-Forwarded-For");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_CLIENT_IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }

    private String getUrlAddress(HttpServletRequest request) {
        String contextPath = request.getRequestURI();
        return contextPath;
    }

    private void checkNodeAuth(RequestContext currentContext, String accessToken, boolean loat) {
        BaseResponse baseResponse = new BaseResponse();
        HttpServletResponse httpResponse = currentContext.getResponse();
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            log.info("\u83b7\u53d6accessToken \u7a7a");
            currentContext.setSendZuulResponse(false);
            httpResponse.setContentType("text/html;charset=utf-8");
            currentContext.setResponseStatusCode(HttpStatus.OK.value());
            baseResponse.setCode(ErrorEnum.NO_PERMISSION.getErrCode());
            baseResponse.setMsg("\u83b7\u53d6\u767b\u5f55\u4fe1\u606f\u5931\u8d25,\u8bf7\u7a0d\u540e\u518d\u8bd5,\u6216\u8054\u7cfb\u7ba1\u7406\u5458");
            currentContext.setResponseBody(JSON.toJSONString((Object)baseResponse));
            return;
        }
        BaseResponse checkResult = this.loginCheckToken.check(accessToken);
        log.info("\u8c03\u7528\u8282\u70b9\u7528\u6237\u4e2d\u5fc3\u6821\u9a8c\u767b\u5f55\u8fd4\u56de\u6570\u636e:{}", (Object)JSON.toJSONString((Object)checkResult));
        log.info("getCode-->{}", (Object)checkResult.getCode());
        if (ErrorEnum.FEIGN_FAIL.getErrCode().equals(checkResult.getCode())) {
            log.info("\u8c03\u7528\u7528\u6237\u4e2d\u5fc3token\u5931\u8d25");
            currentContext.setSendZuulResponse(false);
            httpResponse.setContentType("text/html;charset=utf-8");
            currentContext.setResponseStatusCode(HttpStatus.INTERNAL_SERVER_ERROR.value());
            currentContext.setResponseBody(JSON.toJSONString((Object)BaseResponse.error((IError)IError.FEIGN_FAIL, (String)"\u8c03\u7528\u7528\u6237\u4e2d\u5fc3\u6821\u9a8cToken\u5f02\u5e38")));
        } else if (!checkResult.isSuccess()) {
            currentContext.setSendZuulResponse(false);
            httpResponse.setContentType("text/html;charset=utf-8");
            currentContext.setResponseStatusCode(HttpStatus.OK.value());
            baseResponse.setCode(ErrorEnum.NO_PERMISSION.getErrCode());
            baseResponse.setMsg(checkResult.getMsg());
            currentContext.setResponseBody(JSON.toJSONString((Object)baseResponse));
        }
        if (loat) {
            this.saveLoggingStored(checkResult, currentContext);
        }
    }

    private void checkCloudAuth(RequestContext currentContext, String cloudToken) {
        BaseResponse baseResponse = new BaseResponse();
        HttpServletResponse httpResponse = currentContext.getResponse();
        if (StringUtils.isBlank((CharSequence)cloudToken)) {
            log.info("\u83b7\u53d6\u8d85\u7ba1\u7aefcloudToken \u7a7a");
            currentContext.setSendZuulResponse(false);
            httpResponse.setContentType("text/html;charset=utf-8");
            currentContext.setResponseStatusCode(HttpStatus.OK.value());
            baseResponse.setCode(ErrorEnum.NO_PERMISSION.getErrCode());
            baseResponse.setMsg("\u83b7\u53d6\u767b\u5f55\u4fe1\u606f\u5931\u8d25,\u8bf7\u7a0d\u540e\u518d\u8bd5,\u6216\u8054\u7cfb\u7ba1\u7406\u5458");
            currentContext.setResponseBody(JSON.toJSONString((Object)baseResponse));
            return;
        }
        RestTemplate restTemplate = new RestTemplate();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        LinkedMultiValueMap param = new LinkedMultiValueMap();
        param.add((Object)"token", (Object)cloudToken);
        HttpEntity paramEntity = new HttpEntity((Object)param, (MultiValueMap)headers);
        BaseResponse authResponse = (BaseResponse)restTemplate.postForObject(this.authorityConfig.getSuperAdminAuthUrl(), (Object)paramEntity, baseResponse.getClass(), new Object[0]);
        log.info("\u8c03\u7528\u4e91\u4e0a\u6821\u9a8c\u8d85\u7ba1\u767b\u5f55\u8fd4\u56de\u6570\u636e:{}", (Object)JSON.toJSONString((Object)authResponse));
        if (Objects.isNull(authResponse) || ErrorEnum.SYSYTEM_UNKNOW.getErrCode().equals(authResponse.getErrCode())) {
            currentContext.setSendZuulResponse(false);
            httpResponse.setContentType("text/html;charset=utf-8");
            baseResponse.setCode(ErrorEnum.NO_PERMISSION.getErrCode());
            currentContext.setResponseStatusCode(HttpStatus.OK.value());
            baseResponse.setMsg(ErrorEnum.SYSYTEM_UNKNOW.getMsg());
            currentContext.setResponseBody(JSON.toJSONString((Object)baseResponse));
        } else if (ErrorEnum.NO_PERMISSION.getErrCode().equals(authResponse.getErrCode())) {
            currentContext.setSendZuulResponse(false);
            httpResponse.setContentType("text/html;charset=utf-8");
            baseResponse.setCode(ErrorEnum.NO_PERMISSION.getErrCode());
            currentContext.setResponseStatusCode(HttpStatus.OK.value());
            baseResponse.setMsg(authResponse.getMsg());
            currentContext.setResponseBody(JSON.toJSONString((Object)baseResponse));
        }
        this.saveLoggingStored(authResponse, currentContext);
    }

    private void checkCloudDoctor(RequestContext currentContext, String doctorAccessToken) {
        BaseResponse baseResponse = new BaseResponse();
        HttpServletResponse httpResponse = currentContext.getResponse();
        if (StringUtils.isBlank((CharSequence)doctorAccessToken)) {
            log.info("\u83b7\u53d6doctorAccessToken\u5931\u8d25 \u7a7a");
            currentContext.setSendZuulResponse(false);
            httpResponse.setContentType("text/html;charset=utf-8");
            currentContext.setResponseStatusCode(HttpStatus.OK.value());
            baseResponse.setCode(ErrorEnum.NO_PERMISSION.getErrCode());
            baseResponse.setMsg("\u83b7\u53d6\u767b\u5f55\u4fe1\u606f\u5931\u8d25,\u8bf7\u7a0d\u540e\u518d\u8bd5,\u6216\u8054\u7cfb\u7ba1\u7406\u5458");
            currentContext.setResponseBody(JSON.toJSONString((Object)baseResponse));
            log.info("\u4e91\u4e0a\u6743\u9650\u6821\u9a8c\u5b8c\u6bd5,\u8fd4\u56de\u6570\u636e:{}", (Object)currentContext.toString());
            return;
        }
        RestTemplate restTemplate = new RestTemplate();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        JSONObject param = new JSONObject();
        param.put("token", (Object)doctorAccessToken);
        param.put("customerFlag", (Object)"false");
        param.put("channelCode", (Object)"byh_node_gateWay");
        HttpEntity paramEntity = new HttpEntity((Object)param, (MultiValueMap)headers);
        log.info("\u8c03\u7528\u4e91\u4e0a\u6821\u9a8c\u533b\u751f,\u53d1\u8d77\u8bf7\u6c42Url:" + this.authorityConfig.getCloudDoctorAuthUrl());
        BaseResponse authResponse = (BaseResponse)restTemplate.postForObject(this.authorityConfig.getCloudDoctorAuthUrl(), (Object)paramEntity, baseResponse.getClass(), new Object[0]);
        log.info("\u8c03\u7528\u4e91\u4e0a\u6821\u9a8c\u533b\u751f\u767b\u5f55\u8fd4\u56de\u6570\u636e:{}", (Object)JSON.toJSONString((Object)authResponse));
        if (Objects.isNull(authResponse) || ErrorEnum.SYSYTEM_UNKNOW.getErrCode().equals(authResponse.getErrCode())) {
            currentContext.setSendZuulResponse(false);
            httpResponse.setContentType("text/html;charset=utf-8");
            baseResponse.setCode(ErrorEnum.NO_PERMISSION.getErrCode());
            currentContext.setResponseStatusCode(HttpStatus.OK.value());
            baseResponse.setMsg(ErrorEnum.SYSYTEM_UNKNOW.getMsg());
            currentContext.setResponseBody(JSON.toJSONString((Object)baseResponse));
        } else if (!authResponse.isSuccess()) {
            currentContext.setSendZuulResponse(false);
            httpResponse.setContentType("text/html;charset=utf-8");
            baseResponse.setCode(ErrorEnum.NO_PERMISSION.getErrCode());
            currentContext.setResponseStatusCode(HttpStatus.OK.value());
            baseResponse.setMsg(authResponse.getMsg());
            currentContext.setResponseBody(JSON.toJSONString((Object)baseResponse));
        }
        this.saveLoggingStored(authResponse, currentContext);
    }

    private void saveLoggingStored(BaseResponse baseResponse, RequestContext currentContext) {
        if ("1".equals(baseResponse.getCode().toString()) && !"true".equals(baseResponse.getData().toString())) {
            HttpServletRequest request = currentContext.getRequest();
            Object data = baseResponse.getData();
            String json = ((Map)JSON.parseObject((String)JSON.toJSONString((Object)data), Map.class)).get("tokenJson").toString();
            Map map = (Map)JSON.parseObject((String)json, Map.class);
            TokenJson tokenJson = new TokenJson();
            if (Objects.equals("APP", map.get("deviceType").toString()) || Objects.equals("WEB", map.get("deviceType").toString())) {
                tokenJson.setName("\u533b\u751f\u7aef");
                tokenJson.setAccountNo(map.get("accountId").toString());
            } else {
                tokenJson.setName(map.get("name").toString());
                tokenJson.setAccountNo(map.get("accountNo").toString());
            }
            this.loginCheckToken.loggingStored(tokenJson, currentContext, this.authorityConfig.getCloudDoctorAuthUrl());
        }
    }
}

