/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.api;

import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.onlineoutpatient.common.dto.FindPatientMedicalRecordDTO;
import com.ebaiyihui.onlineoutpatient.common.dto.InsertPatientMedicalRecordDTO;
import com.ebaiyihui.onlineoutpatient.common.dto.QueryByAdmissionIdDTO;
import com.ebaiyihui.onlineoutpatient.common.dto.QueryPatientMedicalRecordDetailsDTO;
import com.ebaiyihui.onlineoutpatient.common.dto.QueryRecordsByTimeReq;
import com.ebaiyihui.onlineoutpatient.common.util.ResultData;
import com.ebaiyihui.onlineoutpatient.common.vo.InsertPatientMedicalRecordVO;
import com.ebaiyihui.onlineoutpatient.common.vo.PatientMedicalRecordDetailsVo;
import com.ebaiyihui.onlineoutpatient.common.vo.PatientMedicalRecordVo;
import com.ebaiyihui.onlineoutpatient.common.vo.QueryAdmissionVo;
import com.ebaiyihui.onlineoutpatient.common.vo.QueryPatientMedicalRecordDetailsVO;
import com.ebaiyihui.onlineoutpatient.common.vo.QueryRecordsByTimeRes;
import com.ebaiyihui.onlineoutpatient.core.config.annotation.DoctorAppTag;
import com.ebaiyihui.onlineoutpatient.core.config.annotation.PatientAppTag;
import com.ebaiyihui.onlineoutpatient.core.dao.OrderMapper;
import com.ebaiyihui.onlineoutpatient.core.model.PatientEntity;
import com.ebaiyihui.onlineoutpatient.core.service.PatientMedicalRecordService;
import com.ebaiyihui.onlineoutpatient.core.vo.GetDoctorWebImPatientMedicalDetailVoReq;
import com.ebaiyihui.onlineoutpatient.core.vo.GetDoctorWebImPatientMedicalDetailVoRes;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/medicalRecord"})
@Api(tags={"\u60a3\u8005\u75c5\u5386API"})
public class PatientMedicalRecordController {
    private static final Logger log = LoggerFactory.getLogger(PatientMedicalRecordController.class);
    @Autowired
    private PatientMedicalRecordService patientMedicalRecordService;
    @Resource
    OrderMapper orderMapper;

    @PostMapping(value={"/insert"})
    @ApiOperation(value="\u65b0\u5efa\u75c5\u5386")
    @PatientAppTag
    public ResultData<InsertPatientMedicalRecordVO> insertPatientMedicalRecord(@RequestBody @Validated InsertPatientMedicalRecordDTO dto, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return new ResultData().error(bindingResult.getFieldError().getDefaultMessage());
        }
        log.info("\u65b0\u5efa\u75c5\u5386" + dto.toString());
        return this.patientMedicalRecordService.insertPatientMedicalRecord(dto);
    }

    @PostMapping(value={"/findByIdDetails"})
    @ApiOperation(value="im\u804a\u5929\u754c\u9762(\u533b\u751f\u7aef)", notes="im\u804a\u5929\u754c\u9762")
    @DoctorAppTag
    public ResultData<PatientMedicalRecordDetailsVo> findAdmissionByAdmissionId(@RequestBody @Validated QueryByAdmissionIdDTO dto, HttpServletRequest request) {
        dto.setAccessToken(request.getHeader("token"));
        log.info("getAccessToken:{}" + dto.getAccessToken());
        return this.patientMedicalRecordService.findAdmissionByAdmissionId(dto);
    }

    @PostMapping(value={"/findAdmission"})
    @ApiOperation(value="im\u804a\u5929\u754c\u9762(\u5927\u4f17\u7aef)", notes="im\u804a\u5929\u754c\u9762")
    @PatientAppTag
    public ResultData<QueryAdmissionVo> findAdmission(@RequestBody @Validated QueryByAdmissionIdDTO dto, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return new ResultData().error(bindingResult.getFieldError().getDefaultMessage());
        }
        return this.patientMedicalRecordService.findAdmission(dto);
    }

    @PostMapping(value={"/queryRecentRecords"})
    @ApiOperation(value="\u901a\u8fc7\u65f6\u95f4\u6bb5\u67e5\u8be2\u6307\u5b9a\u75c5\u4eba\u548c\u5f53\u524d\u533b\u751f\u7684\u54a8\u8be2\u8bb0\u5f55\u4e2d\u63d0\u4ea4\u7684\u75c5\u4f8b\u4fe1\u606f\u5217\u8868", notes="\u5982\u679c\u4e0d\u4f20\u65f6\u95f4\u9650\u5236\uff0c\u9ed8\u8ba4\u4e3a\u4e09\u5929\u5185")
    @DoctorAppTag
    public ResultData<List<QueryRecordsByTimeRes>> queryRecentRecords(@RequestBody @Validated QueryRecordsByTimeReq param, BindingResult bindingResult, HttpServletRequest request) {
        if (bindingResult.hasErrors()) {
            return new ResultData().error(bindingResult.getFieldError().getDefaultMessage());
        }
        Map mapValues = (Map)request.getAttribute("tokenValues");
        if (StringUtils.isBlank((String)((String)mapValues.get("doctorId")))) {
            return new ResultData().error("\u767b\u9646\u4fe1\u606f\u6709\u8bef,\u8bf7\u91cd\u65b0\u767b\u9646");
        }
        param.setDoctorId((String)mapValues.get("doctorId"));
        return this.patientMedicalRecordService.queryRecentRecords(param);
    }

    @PostMapping(value={"/queryRecordDetails"})
    @ApiOperation(value="\u67e5\u8be2\u75c5\u4f8b\u8be6\u60c5", notes="\u8d2d\u4e70\u6d41\u7a0b\u9009\u62e9\u75c5\u4f8b\u8fdb\u5165\u9884\u8bbe\u65b0\u5efa\u75c5\u4f8b\u9875\u9762")
    @PatientAppTag
    public ResultData<QueryPatientMedicalRecordDetailsVO> queryRecordDetails(@RequestBody @Validated QueryPatientMedicalRecordDetailsDTO param, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return new ResultData().error(bindingResult.getFieldError().getDefaultMessage());
        }
        return this.patientMedicalRecordService.queryRecordDetails(param);
    }

    @PostMapping(value={"/findByPatientIdList"})
    @ApiOperation(value="\u901a\u8fc7\u75c5\u4ebaid\u548c\u72b6\u6001\u67e5\u8be2\u6240\u6709\u75c5\u5386\u57fa\u672c\u4fe1\u606f\u5217\u8868")
    @PatientAppTag
    public ResultData<List<PatientMedicalRecordVo>> findByPatientIdPatientMedicalRecordDetails(@RequestBody @Validated FindPatientMedicalRecordDTO dto, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return new ResultData().error(bindingResult.getFieldError().getDefaultMessage());
        }
        return this.patientMedicalRecordService.findPatientMedicalRecord(dto);
    }

    @PostMapping(value={"/getDoctorWebImPatientMedicalDetail"})
    @ApiOperation(value="\u533b\u751fweb\u7aefim\u9875\u9762\u67e5\u8be2\u60a3\u8005\u75c5\u60c5\u8d44\u6599")
    @PatientAppTag
    public BaseResponse<GetDoctorWebImPatientMedicalDetailVoRes> getDoctorWebImPatientMedicalDetail(@RequestBody @Valid GetDoctorWebImPatientMedicalDetailVoReq getDoctorWebImPatientMedicalDetailVoReq, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.patientMedicalRecordService.getDoctorWebImPatientMedicalDetail(getDoctorWebImPatientMedicalDetailVoReq);
    }

    @GetMapping(value={"/getPatientInfo"})
    @ApiOperation(value="\u83b7\u53d6\u60a3\u8005\u4fe1\u606f")
    @PatientAppTag
    public BaseResponse<List<PatientEntity>> getPatientInfo(PatientEntity pojo) {
        return this.patientMedicalRecordService.getPatientInfo(pojo);
    }

    @GetMapping(value={"/getMedicalWord"})
    @ApiOperation(value="\u83b7\u53d6\u75c5\u5386url")
    public BaseResponse<String> getMedicalWord(@RequestParam(value="medicalRecordId") String medicalRecordId) {
        return this.patientMedicalRecordService.getMedicalWord(medicalRecordId);
    }
}

