/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.api;

import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.onlineoutpatient.common.dto.DoctorRequestRefundDTO;
import com.ebaiyihui.onlineoutpatient.common.util.ResultData;
import com.ebaiyihui.onlineoutpatient.common.vo.pay.MedicalPayDto;
import com.ebaiyihui.onlineoutpatient.common.vo.pay.PayCreateOrderVo;
import com.ebaiyihui.onlineoutpatient.common.vo.pay.RequestBusinessBillVo;
import com.ebaiyihui.onlineoutpatient.common.vo.pay.ResponseNotifyRestVo;
import com.ebaiyihui.onlineoutpatient.core.business.callbackrefundpaysuccess.CallbackRefundPaySuccessManage;
import com.ebaiyihui.onlineoutpatient.core.business.callbackwhilepaysuccess.CallbackWhilePaySuccessManage;
import com.ebaiyihui.onlineoutpatient.core.config.annotation.DoctorAppTag;
import com.ebaiyihui.onlineoutpatient.core.dao.OrderMapper;
import com.ebaiyihui.onlineoutpatient.core.model.OrderEntity;
import com.ebaiyihui.onlineoutpatient.core.model.ServicePayBillEntity;
import com.ebaiyihui.onlineoutpatient.core.service.PayCallBackService;
import com.ebaiyihui.onlineoutpatient.core.service.PaymentService;
import com.ebaiyihui.onlineoutpatient.core.service.SdyPaymentPlatformsService;
import com.ebaiyihui.onlineoutpatient.core.vo.MedicalNotifyReqVo;
import com.ebaiyihui.onlineoutpatient.core.vo.RequestRefundVo;
import com.ebaiyihui.onlineoutpatient.core.vo.sdyPaymentPlatforms.dto.PaymentRefundDTO;
import com.ebaiyihui.onlineoutpatient.core.vo.sdyPaymentPlatforms.dto.PaymentResultsDTO;
import com.ebaiyihui.onlineoutpatient.core.vo.sdyPaymentPlatforms.vo.PaymentInquiryVO;
import com.ebaiyihui.onlineoutpatient.core.vo.sdypay.MedicalNotifyReq;
import com.ebaiyihui.onlineoutpatient.core.vo.yibao.YdCreadOrderResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/pay"})
@Api(tags={"\u652f\u4ed8\u76f8\u5173API"})
public class PayController {
    @Autowired
    private PayCallBackService payCallBackService;
    @Autowired
    private PaymentService paymentService;
    @Autowired
    private CallbackWhilePaySuccessManage callbackWhilePaySuccessManage;
    @Autowired
    private CallbackRefundPaySuccessManage callbackRefundPaySuccessManage;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private SdyPaymentPlatformsService sdyPaymentPlatformsService;

    @ApiOperation(value="\u652f\u4ed8\u8c03\u7528", notes="\u652f\u4ed8\u8c03\u7528")
    @RequestMapping(value={"/paycalls"}, method={RequestMethod.POST})
    public BaseResponse payCalls(@RequestBody @Validated PayCreateOrderVo param) {
        return this.payCallBackService.payCalls(param);
    }

    @ApiOperation(value="\u533b\u4fdd\u4e0b\u5355", notes="\u7528\u4e8e\u8d63\u5357\u4e00\u9644\u9662\u652f\u4ed8\u5b9d\u533b\u4fdd")
    @RequestMapping(value={"/createMedicalOrder"}, method={RequestMethod.POST})
    public BaseResponse<YdCreadOrderResponse> createMedicalOrder(@RequestBody @Validated MedicalPayDto param) {
        return this.payCallBackService.createMedicalOrder(param);
    }

    @ApiOperation(value="\u652f\u4ed8\u6210\u529f\u540e\u56de\u8c03", notes="\u652f\u4ed8\u6210\u529f\u540e\u56de\u8c03")
    @RequestMapping(value={"/callbackWhilePaySuccess"}, method={RequestMethod.POST})
    public BaseResponse<String> callbackWhilePaySuccess(@RequestBody @Validated ResponseNotifyRestVo param, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.success((Object)"fail");
        }
        return this.callbackWhilePaySuccessManage.callbackWhilePaySuccess(param);
    }

    @ApiOperation(value="\u8d63\u5357\u533b\u4fdd\u652f\u4ed8\u5b9d\u6210\u529f\u540e\u56de\u8c03", notes="\u524d\u7aef\u56de\u8c03")
    @RequestMapping(value={"/medicalCallbackWhilePaySuccess"}, method={RequestMethod.POST})
    public BaseResponse medicalCallbackWhilePaySuccess(@RequestBody MedicalNotifyReqVo param) {
        return this.payCallBackService.medicalCallbackWhilePaySuccess(param);
    }

    @ApiOperation(value="\u9000\u6b3e\u6210\u529f\u540e\u56de\u8c03", notes="\u9000\u6b3e\u6210\u529f\u540e\u56de\u8c03")
    @RequestMapping(value={"/callbackRefundPaySuccess"}, method={RequestMethod.POST})
    public BaseResponse<String> callbackRefundPaySuccess(@RequestBody @Validated ResponseNotifyRestVo param, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.success((Object)"fail");
        }
        return this.callbackRefundPaySuccessManage.callbackRefundPaySuccess(param);
    }

    @ApiOperation(value="\u533b\u751f\u7533\u8bf7\u9000\u6b3e", notes="\u533b\u751f\u7533\u8bf7\u9000\u6b3e")
    @RequestMapping(value={"/doctor/allRefund"}, method={RequestMethod.POST})
    @DoctorAppTag
    public ResultData<String> doctorAllRefund(@RequestBody @Validated DoctorRequestRefundDTO doctorRequestRefundDTO) {
        return this.paymentService.doctorAllRefund(doctorRequestRefundDTO);
    }

    @ApiOperation(value="\u9000\u6b3e\u8c03\u7528", notes="\u9000\u6b3e\u8c03\u7528")
    @RequestMapping(value={"/refundcalls"}, method={RequestMethod.POST})
    public BaseResponse refundCalls(@RequestBody @Validated RequestRefundVo param) {
        return this.payCallBackService.refundCalls(param);
    }

    @ApiOperation(value="\u5728\u7ebf\u95ee\u8bca\u5bf9\u8d26\u4e1a\u52a1\u67e5\u8be2", notes="\u5728\u7ebf\u95ee\u8bca\u5bf9\u8d26\u4e1a\u52a1\u67e5\u8be2")
    @RequestMapping(value={"/businessBill"}, method={RequestMethod.POST})
    public BaseResponse<List<ServicePayBillEntity>> getBusinessBill(@RequestBody @Validated RequestBusinessBillVo param) {
        return this.paymentService.getBusinessBill(param);
    }

    @ApiOperation(value="\u82cf\u5927\u4e00\u533b\u4fdd\u652f\u4ed8\u56de\u8c03", notes="\u82cf\u5927\u4e00\u533b\u4fdd\u652f\u4ed8\u56de\u8c03")
    @RequestMapping(value={"/medicalCallbackSdy"}, method={RequestMethod.POST})
    public BaseResponse medicalCallback(@RequestBody MedicalNotifyReq medicalNotifyReq) {
        this.payCallBackService.doWhilePayCallBack(medicalNotifyReq);
        return BaseResponse.success();
    }

    @ApiOperation(value="\u82cf\u5927\u4e00\u83b7\u53d6\u533b\u4fdd\u652f\u4ed8\u53c2\u6570")
    @RequestMapping(value={"/medicalPay"}, method={RequestMethod.GET})
    public BaseResponse medicalPay(@RequestParam(value="orderId") String orderId, @RequestParam(value="businessType") String businessType) {
        OrderEntity orderEntity = this.orderMapper.findById(orderId);
        BaseResponse baseResponse = this.payCallBackService.medicalSdy(orderEntity.getClinicCode(), businessType);
        return baseResponse;
    }

    @ApiOperation(value="\u82cf\u5927\u4e00\u652f\u4ed8\u4e0b\u5355", notes="\u82cf\u5927\u4e00\u652f\u4ed8\u4e0b\u5355")
    @RequestMapping(value={"/sdyPayCalls"}, method={RequestMethod.POST})
    public BaseResponse sdyPayCalls(@RequestBody @Validated PayCreateOrderVo param) {
        return this.sdyPaymentPlatformsService.payment(param);
    }

    @ApiOperation(value="\u82cf\u5927\u4e00\u652f\u4ed8\u56de\u8c03", notes="\u652f\u4ed8\u56de\u8c03")
    @RequestMapping(value={"/sdyPayCallsBack"}, method={RequestMethod.POST})
    public BaseResponse sdyPayCallsBack(@RequestBody @Validated PaymentResultsDTO param) {
        return this.sdyPaymentPlatformsService.payNotify(param);
    }

    @ApiOperation(value="\u652f\u4ed8\u7ed3\u679c\u67e5\u8be2")
    @PostMapping(value={"/paymentResultInquiry"})
    public BaseResponse<PaymentResultsDTO> paymentResultInquiry(@RequestBody PaymentInquiryVO request) {
        return this.sdyPaymentPlatformsService.paymentResultInquiry(request);
    }

    @ApiOperation(value="\u82cf\u5927\u4e00\u9000\u6b3e\u56de\u8c03", notes="\u82cf\u5927\u4e00\u9000\u6b3e\u56de\u8c03")
    @RequestMapping(value={"/sdyRefundCallback"}, method={RequestMethod.POST})
    public BaseResponse sdyRefundCallbacks(@RequestBody @Validated PaymentRefundDTO param) {
        return this.sdyPaymentPlatformsService.sdyRefundCallbacks(param);
    }

    @ApiOperation(value="\u82cf\u5927\u4e00\u3010\u533b\u4fdd\u3011\u652f\u4ed8\u9000\u6b3e\u56de\u8c03", notes="\u82cf\u5927\u4e00\u3010\u533b\u4fdd\u3011\u652f\u4ed8\u56de\u8c03")
    @RequestMapping(value={"/prescriptionbackSdy"}, method={RequestMethod.POST})
    public BaseResponse prescriptionbackSdy(@RequestBody MedicalNotifyReq medicalNotifyReq) {
        this.sdyPaymentPlatformsService.prescriptionbackSdy(medicalNotifyReq);
        return BaseResponse.success();
    }
}

