/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.api;

import com.doctoruser.api.pojo.base.entity.DoctorEntity;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.onlineoutpatient.common.dto.PatientBookDTO;
import com.ebaiyihui.onlineoutpatient.common.vo.schedulerecord.PaientBookVo;
import com.ebaiyihui.onlineoutpatient.common.vo.schedulerecord.RequestGetScheduleForWeekVo;
import com.ebaiyihui.onlineoutpatient.common.vo.schedulerecord.RequestUpdateScheduleStatusVo;
import com.ebaiyihui.onlineoutpatient.common.vo.schedulerecord.ResponseGetScheduleForWeekVo;
import com.ebaiyihui.onlineoutpatient.common.vo.schedulerecord.UpdateScheduByDoc;
import com.ebaiyihui.onlineoutpatient.core.config.annotation.PatientAppTag;
import com.ebaiyihui.onlineoutpatient.core.service.ScheduleRecordService;
import com.ebaiyihui.onlineoutpatient.core.vo.DeptInfoResVo;
import com.ebaiyihui.onlineoutpatient.core.vo.InsertScheduleRecordReqVo;
import com.ebaiyihui.onlineoutpatient.core.vo.ScheduleForWeekNewReqVo;
import com.ebaiyihui.onlineoutpatient.core.vo.ScheduleForWeekNewResVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/schedulerecord"})
@Api(tags={"\u6392\u73edAPI"})
public class ScheduleRecordController {
    private static final Logger log = LoggerFactory.getLogger(ScheduleRecordController.class);
    @Autowired
    private ScheduleRecordService scheduleRecordService;

    @RequestMapping(value={"/insert"}, method={RequestMethod.POST})
    @ApiOperation(value="\u589e\u52a0\u6392\u73ed")
    public BaseResponse<String> insert(@RequestBody @Valid InsertScheduleRecordReqVo record) {
        return this.scheduleRecordService.insert(record);
    }

    @RequestMapping(value={"/updateStatus"}, method={RequestMethod.POST})
    @ApiOperation(value="\u533b\u751f\u505c/\u590d\u8bca")
    public BaseResponse<String> updateStatus(@RequestBody RequestUpdateScheduleStatusVo updateScheduleStatusVo) {
        return this.scheduleRecordService.updateStatus(updateScheduleStatusVo);
    }

    @RequestMapping(value={"/updateStatusAllDoc"}, method={RequestMethod.POST})
    @ApiOperation(value="\u533b\u751f\u505c/\u590d\u8bca")
    public BaseResponse<String> updateStatusAllDoc(@RequestBody UpdateScheduByDoc updateScheduleStatusVo) {
        return this.scheduleRecordService.updateStatusAllDoc(updateScheduleStatusVo);
    }

    @RequestMapping(value={"/getscheduleforweek"}, method={RequestMethod.POST})
    @ApiOperation(value="\u83b7\u53d6\u533b\u751f\u4e00\u5468\u7684\u6392\u73ed")
    public BaseResponse<List<ResponseGetScheduleForWeekVo>> getScheduleForWeek(@RequestBody RequestGetScheduleForWeekVo getScheduleForWeekVo) {
        return this.scheduleRecordService.getScheduleForWeek(getScheduleForWeekVo);
    }

    @RequestMapping(value={"/patientsubscribe"}, method={RequestMethod.POST})
    @ApiOperation(value="\u60a3\u8005\u7aef\u5224\u65ad\u662f\u5426\u53ef\u9884\u7ea6")
    @PatientAppTag
    public BaseResponse<PaientBookVo> patientSubscribe(@Valid @RequestBody PatientBookDTO dto, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        log.info("\u60a3\u8005\u7aef\u5224\u65ad\u662f\u5426\u53ef\u9884\u7ea6");
        return this.scheduleRecordService.patientSubscribe(dto);
    }

    @RequestMapping(value={"/scheduleForWeekNew"}, method={RequestMethod.POST})
    @ApiOperation(value="\u7ba1\u7406\u7aef\u6392\u73ed\u5217\u8868")
    public BaseResponse<List<ScheduleForWeekNewResVo>> scheduleForWeekNew(@RequestBody ScheduleForWeekNewReqVo scheduleForWeekNewReqVo) {
        return this.scheduleRecordService.scheduleForWeekNew(scheduleForWeekNewReqVo);
    }

    @RequestMapping(value={"/getDeptAndDoctorInfo"}, method={RequestMethod.GET})
    @ApiOperation(value="\u83b7\u53d6\u79d1\u5ba4\u4fe1\u606f\u53ca\u79d1\u5ba4\u4e0b\u533b\u751f\u4fe1\u606f")
    public BaseResponse<List<DeptInfoResVo>> DeptAndDoctorInfo(@RequestParam(value="organId") String organId, @RequestParam(value="serviceCode", defaultValue="") String serviceCode) {
        return this.scheduleRecordService.deptAndDoctorInfo(organId, serviceCode);
    }

    @RequestMapping(value={"/getDoctorInfo"}, method={RequestMethod.GET})
    @ApiOperation(value="\u83b7\u53d6\u79d1\u5ba4\u4e0b\u533b\u751f\u4fe1\u606f")
    public BaseResponse<List<DoctorEntity>> getDoctorInfo(@RequestParam(value="organId") String organId, @RequestParam(value="deptId") String deptId, @RequestParam(value="serviceCode", defaultValue="") String serviceCode) {
        return this.scheduleRecordService.getDoctorInfo(organId, deptId, serviceCode);
    }
}

