/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.api.doctor;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.onlineoutpatient.common.vo.DepartmentNode;
import com.ebaiyihui.onlineoutpatient.common.vo.DoctorSectionRelRemoveVo;
import com.ebaiyihui.onlineoutpatient.common.vo.DoctorSectionRelSaveVo;
import com.ebaiyihui.onlineoutpatient.common.vo.DoctorSectionSaveVo;
import com.ebaiyihui.onlineoutpatient.common.vo.SectionDoctorInfo;
import com.ebaiyihui.onlineoutpatient.core.model.DoctorSectionEntity;
import com.ebaiyihui.onlineoutpatient.core.model.DoctorSectionRelEntity;
import com.ebaiyihui.onlineoutpatient.core.service.impl.BaseDoctorSectionRelServiceImpl;
import com.ebaiyihui.onlineoutpatient.core.service.impl.BaseDoctorSectionServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/doctor_admission"})
@Api(tags={"\u533b\u751f\u4e13\u533a\u7ba1\u7406"})
public class DotorSectionController {
    private static final Logger log = LoggerFactory.getLogger(DotorSectionController.class);
    @Autowired
    private BaseDoctorSectionRelServiceImpl doctorSectionRelService;
    @Autowired
    private BaseDoctorSectionServiceImpl doctorSectionService;

    @ApiOperation(value="\u4e13\u533a\u65b0\u589e")
    @PostMapping(value={"/saveDoctorSection"})
    public BaseResponse saveDoctorSection(@RequestBody DoctorSectionSaveVo doctorSectionSaveVo) {
        DoctorSectionEntity doctorSectionEntity = new DoctorSectionEntity();
        BeanUtils.copyProperties((Object)doctorSectionSaveVo, (Object)doctorSectionEntity);
        doctorSectionEntity.setSectionCode("SDFYY_" + doctorSectionSaveVo.getSectionCode());
        Boolean result = this.doctorSectionService.save((Object)doctorSectionEntity);
        if (result.booleanValue()) {
            return BaseResponse.success();
        }
        return BaseResponse.error((String)"\u65b0\u589e\u533b\u751f\u4e13\u533a\u5931\u8d25");
    }

    @ApiOperation(value="\u4e13\u533a\u67e5\u8be2")
    @GetMapping(value={"/listDoctorSection"})
    public BaseResponse<List<DoctorSectionEntity>> listDoctorSection() {
        List list = this.doctorSectionService.list();
        return BaseResponse.success((Object)list);
    }

    @ApiOperation(value="\u4e13\u533a\u65b0\u589e\u533b\u751f")
    @PostMapping(value={"/saveDoctorSectionRel"})
    public BaseResponse saveDoctorSectionRel(@RequestBody DoctorSectionRelSaveVo doctorSectionRelSaveVo) {
        QueryWrapper queryWrapper = new QueryWrapper();
        DoctorSectionRelEntity sectionRelEntity = new DoctorSectionRelEntity();
        if (doctorSectionRelSaveVo.getSectionId() != null) {
            sectionRelEntity.setSectionId(doctorSectionRelSaveVo.getSectionId());
        }
        queryWrapper.setEntity((Object)sectionRelEntity);
        List doctorSectionRelEntities = this.doctorSectionRelService.list((Wrapper)queryWrapper);
        Set existingDoctorIds = doctorSectionRelEntities.stream().map(DoctorSectionRelEntity::getDoctorId).collect(Collectors.toSet());
        List filteredDoctorInfoList = doctorSectionRelSaveVo.getDoctorInfoList().stream().filter(doctorInfo -> !existingDoctorIds.contains(doctorInfo.getDoctorId())).collect(Collectors.toList());
        ArrayList<DoctorSectionRelEntity> list = new ArrayList<DoctorSectionRelEntity>();
        for (SectionDoctorInfo sectionDoctorInfo : filteredDoctorInfoList) {
            DoctorSectionRelEntity doctorSectionRelEntity = new DoctorSectionRelEntity();
            BeanUtils.copyProperties((Object)sectionDoctorInfo, (Object)doctorSectionRelEntity);
            doctorSectionRelEntity.setSectionId(doctorSectionRelSaveVo.getSectionId());
            doctorSectionRelEntity.setSectionName(doctorSectionRelSaveVo.getSectionName());
            doctorSectionRelEntity.setStatus(Integer.valueOf(1));
            list.add(doctorSectionRelEntity);
        }
        log.info("list{}", (Object)JSON.toJSONString(list));
        Boolean result = this.doctorSectionRelService.saveBatch(list);
        if (result.booleanValue()) {
            return BaseResponse.success();
        }
        return BaseResponse.error((String)"\u4e13\u533a\u65b0\u589e\u533b\u751f\u5931\u8d25");
    }

    @ApiOperation(value="\u4e13\u533a\u533b\u751f\u67e5\u8be2")
    @GetMapping(value={"/listDoctorSectionRel"})
    public BaseResponse<List<DoctorSectionRelEntity>> listDoctorSectionRel(@RequestParam(value="sectionId") Integer sectionId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        DoctorSectionRelEntity doctorSectionRelEntity = new DoctorSectionRelEntity();
        if (null != sectionId) {
            doctorSectionRelEntity.setSectionId(sectionId);
        }
        queryWrapper.setEntity((Object)doctorSectionRelEntity);
        List list = this.doctorSectionRelService.list((Wrapper)queryWrapper);
        return BaseResponse.success((Object)list);
    }

    @ApiOperation(value="\u4e13\u533a\u533b\u751f\u5220\u9664")
    @PostMapping(value={"/removeDoctorSectionRel"})
    public BaseResponse removeDoctorSectionRel(@RequestBody DoctorSectionRelRemoveVo doctorSectionRelRemoveVo) {
        QueryWrapper queryWrapper = new QueryWrapper();
        DoctorSectionRelEntity doctorSectionRelEntity = new DoctorSectionRelEntity();
        doctorSectionRelEntity.setDoctorId(doctorSectionRelRemoveVo.getDoctorId());
        doctorSectionRelEntity.setSectionId(Integer.valueOf(doctorSectionRelRemoveVo.getSectionId()));
        queryWrapper.setEntity((Object)doctorSectionRelEntity);
        Boolean result = this.doctorSectionRelService.remove((Wrapper)queryWrapper);
        if (result.booleanValue()) {
            return BaseResponse.success();
        }
        return BaseResponse.error((String)"\u4e13\u533a\u65b0\u589e\u533b\u751f\u5931\u8d25");
    }

    @ApiOperation(value="\u4e13\u533a\u79d1\u5ba4\u5217\u8868")
    @GetMapping(value={"/deptList"})
    public BaseResponse<List<DepartmentNode>> getDepartmentTree(@RequestParam(value="sectionId") String sectionId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        DoctorSectionEntity doctorSection = new DoctorSectionEntity();
        doctorSection.setSectionCode(sectionId);
        queryWrapper.setEntity((Object)doctorSection);
        DoctorSectionEntity doctorSectionEntity = (DoctorSectionEntity)this.doctorSectionService.getOne((Wrapper)queryWrapper);
        log.info("doctorSectionEntity{}", (Object)JSON.toJSONString((Object)doctorSectionEntity));
        return this.doctorSectionRelService.getDepartmentTreeBySectionId(doctorSectionEntity.getId());
    }
}

