/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.aspect;

import cn.hutool.http.HttpUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.ebaiyihui.onlineoutpatient.core.aspect.LogAspect;
import eu.bitwalker.useragentutils.Browser;
import eu.bitwalker.useragentutils.UserAgent;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.lionsoul.ip2region.DataBlock;
import org.lionsoul.ip2region.DbConfig;
import org.lionsoul.ip2region.DbSearcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

/*
 * Exception performing whole class analysis ignored.
 */
@Aspect
@Component
public class LogAspect {
    private static final Logger log = LoggerFactory.getLogger(LogAspect.class);
    Long createTime = 0L;
    String description;
    String method;
    String appCode;
    String url;
    String ip;
    String type;
    String requstParam;
    String userId;
    String address;
    String browser;
    String respParam;
    String useTime;
    private static boolean ipLocal = false;
    private static File file = null;
    private static DbConfig config;

    @Pointcut(value="execution(public * com.ebaiyihui.onlineoutpatient.core.api..*.*(..))")
    public void LogAspect() {
    }

    @Before(value="LogAspect()")
    public void doBefore(JoinPoint joinPoint) throws Throwable {
        this.createTime = System.currentTimeMillis();
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = attributes.getRequest();
        Method targetMethod = ((MethodSignature)joinPoint.getSignature()).getMethod();
        Method realMethod = joinPoint.getTarget().getClass().getDeclaredMethod(joinPoint.getSignature().getName(), targetMethod.getParameterTypes());
        ApiOperation operation = realMethod.getAnnotation(ApiOperation.class);
        this.description = operation.value();
        this.method = joinPoint.getSignature().getName();
        this.url = request.getRequestURL().toString();
        this.address = this.ip = LogAspect.getIpAddr((HttpServletRequest)request);
        this.type = request.getMethod();
        this.requstParam = JSON.toJSONString((Object)Arrays.toString(joinPoint.getArgs()));
        this.userId = request.getHeader("userId");
        this.appCode = request.getHeader("appCode");
        this.browser = LogAspect.getBrowser((HttpServletRequest)request);
        log.info("\n\u8bf7\u6c42\u5f00\u59cb===\u65b9\u6cd5\u63cf\u8ff0:{},\n\u8bf7\u6c42\u65b9\u6cd5:{},\n\u8bf7\u6c42\u5730\u5740:{},\n\u8bf7\u6c42ip:{},\n\u8bf7\u6c42\u7c7b\u578b:{},\n\u8bf7\u6c42\u53c2\u6570:{}", new Object[]{this.description, this.method, this.url, this.ip, this.type, this.requstParam});
    }

    @AfterReturning(returning="ret", pointcut="LogAspect()")
    public void doAfterReturning(Object ret) throws Throwable {
        this.respParam = JSON.toJSONString((Object)ret);
        this.useTime = JSON.toJSONString((Object)(System.currentTimeMillis() - this.createTime));
        log.info("\u8bf7\u6c42\u7ed3\u675f===\u8fd4\u56de\u503c==>{}", (Object)JSON.toJSONString((Object)ret));
        log.info("=======\u8bf7\u6c42\u63a5\u53e3\u6240\u9700\u65f6\u95f4====>{}", (Object)this.useTime);
        SystemLog systemLog = new SystemLog(this);
        systemLog.setDescription(this.description);
        systemLog.setMethod(this.method);
        systemLog.setType(this.type);
        systemLog.setIp(this.ip);
        systemLog.setUrl(this.url);
        systemLog.setRequstParam(this.requstParam);
        systemLog.setBrowser(this.browser);
        systemLog.setAddress(this.address);
        systemLog.setUserId(this.userId);
        systemLog.setCreateTime(this.createTime);
        systemLog.setRespParam(this.respParam);
        systemLog.setAppCode(this.appCode);
        systemLog.setUseTime(this.useTime);
    }

    public static String getIpAddr(HttpServletRequest request) {
        String ipAddress = request.getHeader("x-forwarded-for");
        if (StringUtils.isEmpty((String)ipAddress) || "unknown".equalsIgnoreCase(ipAddress)) {
            ipAddress = request.getHeader("Proxy-Client-IP");
        }
        if (StringUtils.isEmpty((String)ipAddress) || "unknown".equalsIgnoreCase(ipAddress)) {
            ipAddress = request.getHeader("WL-Proxy-Client-IP");
        }
        if ((StringUtils.isEmpty((String)ipAddress) || "unknown".equalsIgnoreCase(ipAddress)) && ("127.0.0.1".equals(ipAddress = request.getRemoteAddr()) || "0:0:0:0:0:0:0:1".equals(ipAddress))) {
            InetAddress inet = null;
            try {
                inet = InetAddress.getLocalHost();
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
            ipAddress = inet.getHostAddress();
        }
        if (ipAddress != null && ipAddress.length() > 15 && ipAddress.indexOf(",") > 0) {
            ipAddress = ipAddress.substring(0, ipAddress.indexOf(","));
        }
        return ipAddress;
    }

    public static String getBrowser(HttpServletRequest request) {
        UserAgent userAgent = UserAgent.parseUserAgentString((String)request.getHeader("User-Agent"));
        Browser browser = userAgent.getBrowser();
        return browser.getName();
    }

    public static String getCityInfo(String ip) {
        if (ipLocal) {
            return LogAspect.getLocalCityInfo((String)ip);
        }
        return LogAspect.getHttpCityInfo((String)ip);
    }

    public static String getHttpCityInfo(String ip) {
        String api = String.format("http://whois.pconline.com.cn/ipJson.jsp?ip=%s&json=true", ip);
        JSONObject object = JSONUtil.parseObj((String)HttpUtil.get((String)api));
        return (String)object.get((Object)"addr", String.class);
    }

    public static String getLocalCityInfo(String ip) {
        try {
            DataBlock dataBlock = new DbSearcher(config, file.getPath()).binarySearch(ip);
            String region = dataBlock.getRegion();
            String address = region.replace("0|", "");
            char symbol = '|';
            if (address.charAt(address.length() - 1) == symbol) {
                address = address.substring(0, address.length() - 1);
            }
            return address.equals("\u5185\u7f51IP|\u5185\u7f51IP") ? "\u5185\u7f51IP" : address;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return "";
        }
    }
}

