/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.business.allowcheck.core;

import com.doctoruser.api.pojo.base.dto.doctor.QueryPersonnelInfoReq;
import com.doctoruser.api.pojo.base.vo.doctor.PersonnelInfo;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.onlineoutpatient.common.vo.AllowBuyCheckReqVO;
import com.ebaiyihui.onlineoutpatient.common.vo.AllowBuyCheckRespVO;
import com.ebaiyihui.onlineoutpatient.common.vo.RegisteredRecordResVo;
import com.ebaiyihui.onlineoutpatient.core.common.enums.ImmediateConsultationVoTypeEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.ServiceTypeEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.WhetherEnum;
import com.ebaiyihui.onlineoutpatient.core.common.properties.ProjProperties;
import com.ebaiyihui.onlineoutpatient.core.dao.PatientMapper;
import com.ebaiyihui.onlineoutpatient.core.model.PatientEntity;
import com.ebaiyihui.onlineoutpatient.core.service.HisTemplateService;
import com.ebaiyihui.onlineoutpatient.core.service.client.DoctorInfofeignClient;
import com.ebaiyihui.onlineoutpatient.core.utils.DateUtils;
import com.ebaiyihui.onlineoutpatient.core.vo.GetNewAppointRecordReqDTO;
import com.ebaiyihui.onlineoutpatient.core.vo.MedicalRecordResVo;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MedicalCheckPublicService {
    private static final Logger log = LoggerFactory.getLogger(MedicalCheckPublicService.class);
    @Autowired
    private HisTemplateService hisTemplateService;
    @Autowired
    private DoctorInfofeignClient doctorClient;
    @Autowired
    private ProjProperties projProperties;
    @Autowired
    PatientMapper patientMapper;

    public BaseResponse<AllowBuyCheckRespVO> medicalCheck(AllowBuyCheckReqVO param) {
        AllowBuyCheckRespVO data = new AllowBuyCheckRespVO();
        if (param.getServType().equals(ServiceTypeEnum.NOS.getValue()) && param.getIsMedicare().equals(WhetherEnum.ALLOW.getValue())) {
            String t1 = "23:50:00";
            String t2 = DateUtils.getCurrentTime();
            String t3 = "24:00:00";
            Integer isUse = DateUtils.timeCompare((String)t1, (String)t2, (String)t3);
            if (!WhetherEnum.ALLOW.getValue().equals(isUse)) {
                data.setIsUse(isUse);
                return BaseResponse.success((Object)data);
            }
        }
        return null;
    }

    public BaseResponse<AllowBuyCheckRespVO> medicalHisCheck(AllowBuyCheckReqVO param) {
        QueryPersonnelInfoReq queryPersonnelInfoReq = new QueryPersonnelInfoReq();
        queryPersonnelInfoReq.setDoctorId(param.getDoctorId());
        BaseResponse doctorDetailsVoBaseResponse = this.doctorClient.queryPersonnelInfo(queryPersonnelInfoReq);
        if (null == doctorDetailsVoBaseResponse || null == doctorDetailsVoBaseResponse.getData()) {
            return BaseResponse.error((String)"\u67e5\u8be2\u4e2a\u4eba\u4fe1\u606f\u533b\u751f\u51fa\u9519");
        }
        if (param.getServType().equals(ServiceTypeEnum.HOS.getValue())) {
            return null;
        }
        PatientEntity patientEntity = this.patientMapper.findOneByPatientId(param.getPatientId());
        String url = this.projProperties.getSdyPayCenter() + "/appoint/newBack/record";
        GetNewAppointRecordReqDTO getNewAppointRecordReqDTO = new GetNewAppointRecordReqDTO();
        getNewAppointRecordReqDTO.setPid(patientEntity.getCardNo());
        getNewAppointRecordReqDTO.setSource("HLWYY");
        getNewAppointRecordReqDTO.setOperCode("70019");
        getNewAppointRecordReqDTO.setHospitalCode("pj");
        getNewAppointRecordReqDTO.setBegDate(DateUtils.dateToSimpleString((Date)DateUtils.getSubtractYear((Date)new Date(), (int)5)));
        getNewAppointRecordReqDTO.setEndDate(DateUtils.dateToSimpleString((Date)new Date()));
        getNewAppointRecordReqDTO.setOperTime(DateUtils.getCurrentDateTimeString());
        List registerRecord = this.hisTemplateService.getRegisterRecord(getNewAppointRecordReqDTO);
        if (null == registerRecord) {
            return null;
        }
        AllowBuyCheckRespVO data = new AllowBuyCheckRespVO();
        data.setType(ImmediateConsultationVoTypeEnum.OK.getValue());
        data.setRegisteredRecords(new ArrayList());
        data.setIsHis("1");
        return BaseResponse.success((Object)data);
    }

    private List<RegisteredRecordResVo> medicalRecordResVoToRegisteredRecordResVo(List<MedicalRecordResVo> medicalRecords, PersonnelInfo personnelInfo) {
        ArrayList<RegisteredRecordResVo> recordResVos = new ArrayList<RegisteredRecordResVo>();
        for (MedicalRecordResVo medicalRecordResVo : medicalRecords) {
            RegisteredRecordResVo registeredRecordResVo = new RegisteredRecordResVo();
            registeredRecordResVo.setClinicNO(medicalRecordResVo.getVisitnumber());
            registeredRecordResVo.setCardNo(medicalRecordResVo.getPatientid());
            registeredRecordResVo.setDeptName(medicalRecordResVo.getDeptname());
            registeredRecordResVo.setDoctCode(personnelInfo.getDoctorCode());
            registeredRecordResVo.setDoctName(personnelInfo.getDeptName());
            registeredRecordResVo.setRegDate(medicalRecordResVo.getVisitnumber());
            registeredRecordResVo.setSeeNo(medicalRecordResVo.getId());
            registeredRecordResVo.setAge(medicalRecordResVo.getPatientageyear());
            registeredRecordResVo.setName(medicalRecordResVo.getPatientname());
            registeredRecordResVo.setSex(medicalRecordResVo.getSexnumber());
            registeredRecordResVo.setMainSuit(medicalRecordResVo.getChiefcomplaint());
            registeredRecordResVo.setCurrentHistory(medicalRecordResVo.getHistoryofpresentillness());
            registeredRecordResVo.setPastHistory(medicalRecordResVo.getPasthistory());
            registeredRecordResVo.setRegDate(medicalRecordResVo.getOperationtime());
            registeredRecordResVo.setAdmDate(medicalRecordResVo.getVisitdatetime());
            registeredRecordResVo.setAdmId(medicalRecordResVo.getId());
            registeredRecordResVo.setPatientId(medicalRecordResVo.getPatientid());
            recordResVos.add(registeredRecordResVo);
        }
        return recordResVos;
    }
}

