/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.business.createorder.core;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.utils.HttpUtils;
import com.ebaiyihui.his.pojo.vo.base.FrontRequest;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import com.ebaiyihui.his.pojo.vo.card.QueryCardInfoReqVO;
import com.ebaiyihui.onlineoutpatient.common.dto.ImmediateConsultationDTO;
import com.ebaiyihui.onlineoutpatient.common.vo.ImmediateConsultationVo;
import com.ebaiyihui.onlineoutpatient.core.business.doctorreceive.vo.LockedNumDTO;
import com.ebaiyihui.onlineoutpatient.core.business.doctorreceive.vo.LockedNumVO;
import com.ebaiyihui.onlineoutpatient.core.common.properties.ProjProperties;
import com.ebaiyihui.onlineoutpatient.core.dao.AdmissionMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.OrderMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.PatientMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.ServicePayBillMapper;
import com.ebaiyihui.onlineoutpatient.core.model.AdmissionEntity;
import com.ebaiyihui.onlineoutpatient.core.model.OrderEntity;
import com.ebaiyihui.onlineoutpatient.core.model.PatientEntity;
import com.ebaiyihui.onlineoutpatient.core.model.ServicePayBillEntity;
import com.ebaiyihui.onlineoutpatient.core.service.remotecall.InternetHospitalDetailInfoService;
import com.ebaiyihui.onlineoutpatient.core.utils.DateUtils;
import com.ebaiyihui.onlineoutpatient.core.utils.HttpKit;
import com.ebaiyihui.onlineoutpatient.core.utils.RedisUtil;
import com.ebaiyihui.onlineoutpatient.core.vo.HisDeptAndDocCodeVo;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SdySettlementCheckPublicService {
    private static final Logger log = LoggerFactory.getLogger(SdySettlementCheckPublicService.class);
    @Autowired
    private InternetHospitalDetailInfoService internetHospitalDetailInfoService;
    @Autowired
    RedisUtil redisUtil;
    @Autowired
    private PatientMapper patientMapper;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private AdmissionMapper admissionMapper;
    @Autowired
    private ServicePayBillMapper servicePayBillMapper;
    @Autowired
    private ProjProperties projProperties;

    public BaseResponse<ImmediateConsultationVo> preSettlementCheck(ImmediateConsultationDTO orderCreateDTO, ImmediateConsultationVo immediateConsultationVo) {
        log.info("\u5165\u53c2immediateConsultationVo{}", (Object)JSON.toJSONString((Object)immediateConsultationVo));
        log.info("\u5165\u53c2orderCreateDTO{}", (Object)JSON.toJSONString((Object)orderCreateDTO));
        if (StringUtils.isBlank((String)orderCreateDTO.getScheduleId()) && StringUtils.isBlank((String)orderCreateDTO.getScheduleDate()) && orderCreateDTO.getServType().equals(3)) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            String format = simpleDateFormat.format(new Date());
            orderCreateDTO.setScheduleDate(format);
        }
        if (StringUtils.isEmpty((String)orderCreateDTO.getScheduleDate())) {
            orderCreateDTO.setScheduleDate(DateUtils.getCurrentDateSimpleToString());
        }
        PatientEntity patientEntity = this.patientMapper.selectById(orderCreateDTO.getPatientId());
        FrontRequest frontRequest = new FrontRequest();
        QueryCardInfoReqVO queryCardInfoReqVO = new QueryCardInfoReqVO();
        queryCardInfoReqVO.setCredNo(patientEntity.getIdcard());
        queryCardInfoReqVO.setCredType("0");
        frontRequest.setBody((Object)queryCardInfoReqVO);
        try {
            HttpUtils.post((String)(this.projProperties.getSdyPayCenter() + "/card/newQuery"), (String)JSON.toJSONString((Object)frontRequest));
        }
        catch (Exception e) {
            e.printStackTrace();
            return BaseResponse.error((String)"\u5c31\u8bca\u4eba\u6863\u6848\u6821\u9a8c\u5931\u8d25");
        }
        log.info("patientEntity{}", (Object)JSON.toJSONString((Object)patientEntity));
        if (null != immediateConsultationVo.getClinicCode()) {
            immediateConsultationVo.setPayCost("0.00");
            immediateConsultationVo.setTotCost(immediateConsultationVo.getPayAmount().toPlainString());
            immediateConsultationVo.setPubCost("0.00");
            immediateConsultationVo.setOwnCost(immediateConsultationVo.getPayAmount().toPlainString());
            immediateConsultationVo.setClinicCode(immediateConsultationVo.getClinicCode());
            return BaseResponse.success((Object)immediateConsultationVo);
        }
        LockedNumVO lockedNumVO = (LockedNumVO)this.LockedNum(orderCreateDTO, immediateConsultationVo, patientEntity).getData();
        OrderEntity order = new OrderEntity();
        order.setXId(immediateConsultationVo.getOrderId());
        immediateConsultationVo.setTotCost(immediateConsultationVo.getPayAmount().toPlainString());
        immediateConsultationVo.setClinicCode(lockedNumVO.getResponseType());
        order.setHospFlag(orderCreateDTO.getHospFlag());
        order.setClinicCode(lockedNumVO.getResponseType());
        order.setInvoiceNo(lockedNumVO.getDeptCode());
        order.setMerchantId(lockedNumVO.getDeptCode());
        this.orderMapper.updateById((Object)order);
        return BaseResponse.success((Object)immediateConsultationVo);
    }

    private BaseResponse<LockedNumVO> LockedNum(ImmediateConsultationDTO orderCreateDTO, ImmediateConsultationVo immediateConsultationVo, PatientEntity patientEntity) {
        HisDeptAndDocCodeVo hisDeptAndDocCode = this.internetHospitalDetailInfoService.getHisDeptAndDocCode(orderCreateDTO.getDeptId(), orderCreateDTO.getDoctorId());
        if (null == hisDeptAndDocCode) {
            return BaseResponse.error((String)"\u533b\u751f\u670d\u52a1\u8c03\u7528\u51fa\u9519");
        }
        LockedNumDTO dto = new LockedNumDTO();
        dto.setDeptCode(hisDeptAndDocCode.getDeptCode());
        dto.setDrCode(hisDeptAndDocCode.getDoctorCode());
        dto.setScheduleDate(orderCreateDTO.getScheduleDate());
        dto.setPatnId(patientEntity.getMedicalNO());
        dto.setPsnNo(patientEntity.getCardNo());
        dto.setRegFee(immediateConsultationVo.getPayAmount().toPlainString());
        dto.setRgstDate(DateUtils.getCurrentDateToString());
        String result = null;
        try {
            String url = this.projProperties.getSdyPayCenter() + "/appoint/register/occupancySign";
            result = HttpKit.jsonPost((String)url, (String)JSON.toJSONString((Object)dto));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        FrontResponse frontResponse = (FrontResponse)JSON.parseObject(result, FrontResponse.class);
        if ("0".equals(frontResponse.getCode())) {
            log.error("\u9501\u53f7\u5931\u8d25\uff1a" + frontResponse.getMessage());
            this.orderMapper.deleteById((Serializable)((Object)immediateConsultationVo.getOrderId()));
            log.info("\u5220\u9664\u9501\u53f7\u5931\u8d25\u8ba2\u5355\u6210\u529f");
            AdmissionEntity admissionEntity1 = this.admissionMapper.queryAdmByOrderId(immediateConsultationVo.getOrderId());
            if (null != admissionEntity1) {
                QueryWrapper queryWrapper = new QueryWrapper();
                AdmissionEntity admissionEntity = new AdmissionEntity();
                admissionEntity.setOrderId(immediateConsultationVo.getOrderId());
                queryWrapper.setEntity((Object)admissionEntity);
                this.admissionMapper.delete((Wrapper)queryWrapper);
                log.info("\u5220\u9664\u9501\u53f7\u5931\u8d25\u5c31\u8bca\u8bb0\u5f55\u6210\u529f");
            }
            QueryWrapper queryWrapperTemp = new QueryWrapper();
            ServicePayBillEntity servicePayBillEntity = new ServicePayBillEntity();
            servicePayBillEntity.setOutTradeNo(immediateConsultationVo.getOrderSeq());
            queryWrapperTemp.setEntity((Object)servicePayBillEntity);
            this.servicePayBillMapper.delete((Wrapper)queryWrapperTemp);
            log.info("\u5220\u9664\u8d26\u5355\u8bb0\u5f55\u6210\u529f");
            return BaseResponse.error((String)frontResponse.getMessage());
        }
        LockedNumVO vo = (LockedNumVO)JSON.parseObject((String)JSON.toJSONString((Object)frontResponse.getBody()), LockedNumVO.class);
        return BaseResponse.success((Object)vo);
    }
}

