/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.business.doctorreceive.service.impl;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import com.ebaiyihui.onlineoutpatient.core.business.doctorreceive.service.ReceiveOrderService;
import com.ebaiyihui.onlineoutpatient.core.common.enums.AdmissionStatusEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.OrderStatusEnum;
import com.ebaiyihui.onlineoutpatient.core.common.properties.ProjProperties;
import com.ebaiyihui.onlineoutpatient.core.dao.AdmissionMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.MedicalPayNotifyMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.OrderMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.PatientMapper;
import com.ebaiyihui.onlineoutpatient.core.model.AdmissionEntity;
import com.ebaiyihui.onlineoutpatient.core.model.OrderEntity;
import com.ebaiyihui.onlineoutpatient.core.model.PatientEntity;
import com.ebaiyihui.onlineoutpatient.core.sender.OrderSender;
import com.ebaiyihui.onlineoutpatient.core.service.OrderService;
import com.ebaiyihui.onlineoutpatient.core.service.PayCallBackService;
import com.ebaiyihui.onlineoutpatient.core.utils.HttpKit;
import com.ebaiyihui.onlineoutpatient.core.vo.InsuSettlementReqDTO;
import com.ebaiyihui.onlineoutpatient.core.vo.RegRecipeJsReqVO;
import com.ebaiyihui.onlineoutpatient.core.vo.RegRecipeJsResVO;
import com.ebaiyihui.onlineoutpatient.core.vo.RegRecipeYjsResVO;
import com.ebaiyihui.onlineoutpatient.core.vo.RequestRefundVo;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SdyReceiveOrderServiceImpl
implements ReceiveOrderService {
    private static final Logger log = LoggerFactory.getLogger(SdyReceiveOrderServiceImpl.class);
    @Autowired
    private ProjProperties projProperties;
    @Autowired
    private AdmissionMapper admissionMapper;
    @Autowired
    private OrderService orderService;
    @Autowired
    private MedicalPayNotifyMapper medicalPayNotifyMapper;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private OrderSender orderSender;
    @Autowired
    private PayCallBackService payCallBackService;
    @Autowired
    private PatientMapper patientMapper;

    public BaseResponse receiveOrder(OrderEntity orderEntity, AdmissionEntity admissionEntity) {
        BaseResponse baseResponse = this.register(orderEntity, admissionEntity);
        if (!baseResponse.isSuccess()) {
            return BaseResponse.error((String)"\u6302\u53f7\u5931\u8d25");
        }
        return BaseResponse.success();
    }

    private BaseResponse register(OrderEntity orderEntity, AdmissionEntity admissionEntity) {
        PatientEntity patientEntity = this.patientMapper.selectById(orderEntity.getPatientId());
        RegRecipeJsReqVO dto = new RegRecipeJsReqVO();
        dto.setRegType("4");
        dto.setHospitalCode("pj");
        dto.setPid(patientEntity.getCardNo());
        dto.setCertNo(patientEntity.getIdcard());
        dto.setResponseType(orderEntity.getFundType().equals("1") ? "1" : "9");
        if (orderEntity.getFundType().equals("4")) {
            dto.setResponseType("1");
        }
        dto.setTradeType("");
        dto.setOrderNo(orderEntity.getClinicCode());
        dto.setOwnCost(orderEntity.getOwnCost());
        dto.setOwnPayType("3");
        dto.setOwnPayTransNo(orderEntity.getDealSeq());
        dto.setPaymentSerialNo(orderEntity.getOrderSeq());
        if (dto.getResponseType().equals("9")) {
            InsuSettlementReqDTO insuSettlementReqDTO = new InsuSettlementReqDTO();
            String instr = orderEntity.getInsuSettlement();
            RegRecipeYjsResVO regRecipeYjsResVO = (RegRecipeYjsResVO)JSON.parseObject((String)instr, RegRecipeYjsResVO.class);
            BeanUtils.copyProperties((Object)regRecipeYjsResVO, (Object)insuSettlementReqDTO);
            insuSettlementReqDTO.setPsnSetlway("0.00");
            dto.setInsuSettlement(insuSettlementReqDTO);
        }
        String result = null;
        try {
            String url = this.projProperties.getSdyPayCenter() + "/medicalOrder/register/regRecipeJs";
            result = HttpKit.jsonPost((String)url, (String)JSON.toJSONString((Object)dto));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        FrontResponse frontResponse = (FrontResponse)JSON.parseObject(result, FrontResponse.class);
        RegRecipeJsResVO regRecipeJsResVO = (RegRecipeJsResVO)JSON.parseObject((String)JSON.toJSONString((Object)frontResponse.getBody()), RegRecipeJsResVO.class);
        if ("0".equals(frontResponse.getCode())) {
            log.error("\u6302\u53f7\u7ed3\u7b97\u5931\u8d25\uff1a{}", (Object)JSON.toJSONString((Object)frontResponse));
            RequestRefundVo requestRefundVo = new RequestRefundVo();
            requestRefundVo.setOrderId(orderEntity.getXId());
            BaseResponse baseResponse = this.payCallBackService.refundCalls(requestRefundVo);
            if (Objects.nonNull(baseResponse) && !baseResponse.isSuccess()) {
                return BaseResponse.error((String)"\u9000\u6b3e\u5931\u8d25");
            }
            this.orderService.updateStatusById(orderEntity.getXId(), OrderStatusEnum.REFUNDED.getValue());
            admissionEntity.setStatus(AdmissionStatusEnum.RETIRED.getValue());
            admissionEntity.setXRemark("\u6302\u53f7\u5931\u8d25");
            admissionEntity.setMessage("\u6302\u53f7\u5931\u8d25");
            this.admissionMapper.update(admissionEntity);
            return BaseResponse.error((String)frontResponse.getMessage());
        }
        orderEntity.setInvoiceNo(regRecipeJsResVO.getRegisterSn());
        orderEntity.setRegLeve("1");
        this.orderMapper.updateById((Object)orderEntity);
        return BaseResponse.success();
    }
}

