/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.business.offlinemedicalrecords.core;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.doctoruser.api.pojo.base.dto.doctor.QueryPersonnelInfoReq;
import com.doctoruser.api.pojo.base.vo.doctor.PersonnelInfo;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.onlineoutpatient.common.vo.RegisteredRecordResVo;
import com.ebaiyihui.onlineoutpatient.core.dao.InquiryMchCodeMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.PatientMapper;
import com.ebaiyihui.onlineoutpatient.core.model.InquiryMchCodeEntity;
import com.ebaiyihui.onlineoutpatient.core.model.PatientEntity;
import com.ebaiyihui.onlineoutpatient.core.service.HisTemplateService;
import com.ebaiyihui.onlineoutpatient.core.service.client.DoctorInfofeignClient;
import com.ebaiyihui.onlineoutpatient.core.vo.HisMedicalsReqVo;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class RegisteredRecordPublicService {
    private static final Logger log = LoggerFactory.getLogger(RegisteredRecordPublicService.class);
    @Autowired
    private PatientMapper patientMapper;
    @Autowired
    private InquiryMchCodeMapper inquiryMchCodeMapper;
    @Autowired
    private DoctorInfofeignClient doctorClient;
    @Autowired
    private HisTemplateService hisTemplateService;

    public BaseResponse<List<RegisteredRecordResVo>> getRegisterRecord(HisMedicalsReqVo hisMedicalsReqVo, PatientEntity patientEntity) {
        String patientIdCard = patientEntity.getIdcard();
        String patientName = patientEntity.getPatientName();
        QueryWrapper wrapper = new QueryWrapper();
        InquiryMchCodeEntity inquiryMchCodeEntity = new InquiryMchCodeEntity();
        inquiryMchCodeEntity.setAppCode(hisMedicalsReqVo.getAppCode());
        inquiryMchCodeEntity.setHospitalId(hisMedicalsReqVo.getHospitalId());
        log.info("inquiryMchCodeEntity:{}" + inquiryMchCodeEntity.toString());
        wrapper.setEntity((Object)inquiryMchCodeEntity);
        InquiryMchCodeEntity entity = (InquiryMchCodeEntity)this.inquiryMchCodeMapper.selectOne((Wrapper)wrapper);
        if (null == entity) {
            log.info("\u8bf7\u5728\u6570\u636e\u5e93\u4e2d\u914d\u7f6e\u6539\u533b\u9662\u76f8\u5173\u7684mchCode\u548chisUrl");
            return BaseResponse.error((String)"\u8bf7\u5728\u6570\u636e\u5e93\u4e2d\u914d\u7f6e\u6539\u533b\u9662\u76f8\u5173\u7684mchCode\u548chisUrl");
        }
        log.info("entity:{}" + entity.toString());
        if (StringUtils.isEmpty((String)entity.getHisUrl())) {
            log.info("\u67e5\u8be2\u7684\u590d\u8bca\u8c03\u7528his\u7684\u5730\u5740\u4e3a\u7a7a\uff0c\u68c0\u67e5\u6570\u636e\u5e93\u786e\u8ba4\u8be5\u533b\u9662\u662f\u5426\u5bf9\u63a5his");
            return null;
        }
        String hisUrl = entity.getHisUrl();
        QueryPersonnelInfoReq queryPersonnelInfoReq = new QueryPersonnelInfoReq();
        queryPersonnelInfoReq.setDoctorId(hisMedicalsReqVo.getDoctorId());
        BaseResponse doctorDetailsVOBaseResponse = this.doctorClient.queryPersonnelInfo(queryPersonnelInfoReq);
        if (!doctorDetailsVOBaseResponse.isSuccess() || null == doctorDetailsVOBaseResponse.getData()) {
            return BaseResponse.error((String)"\u67e5\u8be2\u4e2a\u4eba\u4fe1\u606f\u533b\u751f\u51fa\u9519");
        }
        String deptName = ((PersonnelInfo)doctorDetailsVOBaseResponse.getData()).getDeptName();
        String deptId = ((PersonnelInfo)doctorDetailsVOBaseResponse.getData()).getDeptId().toString();
        String doctorId = ((PersonnelInfo)doctorDetailsVOBaseResponse.getData()).getDoctorId();
        ((PersonnelInfo)doctorDetailsVOBaseResponse.getData()).getDeptId().toString();
        List registeredRecordList = this.hisTemplateService.getRegisteredRecord(patientIdCard, patientName, deptName, hisUrl, deptId, doctorId, patientEntity.getCardNo(), hisMedicalsReqVo.getAppCode());
        if (CollectionUtils.isEmpty((Collection)registeredRecordList)) {
            return null;
        }
        registeredRecordList.sort(Comparator.comparing(RegisteredRecordResVo::getRegToDate).reversed());
        return BaseResponse.success((Object)registeredRecordList);
    }
}

