/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.sender;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.framework.utils.HttpUtils;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import com.ebaiyihui.onlineoutpatient.core.common.properties.ProjProperties;
import com.ebaiyihui.onlineoutpatient.core.dao.ICDMapper;
import com.ebaiyihui.onlineoutpatient.core.exception.BusinessException;
import com.ebaiyihui.onlineoutpatient.core.model.OrderEntity;
import com.ebaiyihui.onlineoutpatient.core.model.PatientEntity;
import com.ebaiyihui.onlineoutpatient.core.utils.DateUtils;
import com.ebaiyihui.onlineoutpatient.core.vo.HisDeptAndDocCodeVo;
import com.ebaiyihui.onlineoutpatient.core.vo.sdyPaymentPlatforms.dto.IssuedDiagnosticInfoDTO;
import com.ebaiyihui.onlineoutpatient.core.vo.sdyPaymentPlatforms.dto.IssuedDiagnosticInfoNodeDTO;
import com.ebaiyihui.sysinfocloudcommon.vo.medical.PatientDynamicMedicalEntityVo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.http.Consts;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
@Component
public class PushSdyDiagnosisHisManage {
    private static final Logger log = LoggerFactory.getLogger(PushSdyDiagnosisHisManage.class);
    @Autowired
    private ProjProperties projProperties;
    @Autowired
    private ICDMapper icdMapper;

    public void diagnosticInformationPush(OrderEntity orderEntity, HisDeptAndDocCodeVo hisDeptAndDocCode, PatientDynamicMedicalEntityVo entityVo, PatientEntity patientEntity) throws BusinessException {
        if (orderEntity == null || hisDeptAndDocCode == null || entityVo == null || patientEntity == null) {
            log.error("\u82cf\u5927\u4e00\u4fe1\u606f\u7a7a");
            throw new BusinessException("\u4fe1\u606f\u7a7a");
        }
        log.info("======>\u82cf\u5927\u4e00His\u8bca\u65ad\u4fe1\u606f\u63a8\u9001");
        String generateViewId = "HLW" + DateUtils.getDateformat((Date)orderEntity.getXCreateTime()) + orderEntity.getXId().substring(orderEntity.getXId().length() - 5);
        log.info("\u751f\u6210\u7684[iOEPID\u3001visitserial]\u6d41\u6c34\u53f7\uff1a{}", (Object)generateViewId);
        IssuedDiagnosticInfoDTO pushData = new IssuedDiagnosticInfoDTO();
        pushData.setIoePid(generateViewId);
        pushData.setVisitSerialNo(generateViewId);
        pushData.setPid(orderEntity.getIdCard());
        pushData.setRegisterSn(orderEntity.getInvoiceNo());
        pushData.setStateOfIllness("");
        pushData.setDeptName(hisDeptAndDocCode.getDeptName());
        pushData.setDeptCode(hisDeptAndDocCode.getDeptCode());
        pushData.setWardName("");
        pushData.setWardCode("");
        pushData.setManageType("1");
        ArrayList<IssuedDiagnosticInfoNodeDTO> list = new ArrayList<IssuedDiagnosticInfoNodeDTO>();
        String diagSn = "HLW" + entityVo.getXId();
        log.info("\u751f\u6210\u7684[DiagSn]\u6d41\u6c34\u53f7\uff1a{}", (Object)diagSn);
        String[] arry = entityVo.getPrimaryDiagno().split("\uff1b");
        Integer i = 1;
        for (String icdname : arry) {
            ArrayList<String> namesList = new ArrayList<String>();
            namesList.add(icdname);
            List codeList = this.icdMapper.selctCodeByName(namesList);
            if (CollectionUtils.isEmpty((Collection)codeList) || codeList.size() != 1) {
                log.info("ICD\u67e5\u8be2\u5f02\u5e38\uff0c\u540d\u79f0{},\u7ed3\u679c{}", namesList, (Object)codeList);
            }
            String code = (String)codeList.get(0);
            IssuedDiagnosticInfoNodeDTO issuedDiagnosticInfoNodeDTO = new IssuedDiagnosticInfoNodeDTO();
            issuedDiagnosticInfoNodeDTO.setDiagSn(diagSn);
            issuedDiagnosticInfoNodeDTO.setOrdinal(i.toString());
            issuedDiagnosticInfoNodeDTO.setDiagCode(code);
            issuedDiagnosticInfoNodeDTO.setDiagName(icdname);
            issuedDiagnosticInfoNodeDTO.setIcdCode(code);
            issuedDiagnosticInfoNodeDTO.setIcdName(icdname);
            issuedDiagnosticInfoNodeDTO.setOutCome("");
            issuedDiagnosticInfoNodeDTO.setDiagTypeCode("");
            issuedDiagnosticInfoNodeDTO.setDefiniteFlag("");
            issuedDiagnosticInfoNodeDTO.setDefiniteTime("");
            issuedDiagnosticInfoNodeDTO.setDefiniteId("");
            issuedDiagnosticInfoNodeDTO.setDefiniteName("");
            issuedDiagnosticInfoNodeDTO.setCreateTime(DateUtils.dateToFullString((Date)orderEntity.getXCreateTime()));
            issuedDiagnosticInfoNodeDTO.setCreatorId(hisDeptAndDocCode.getDoctorCode());
            issuedDiagnosticInfoNodeDTO.setCreator(hisDeptAndDocCode.getDoctorName());
            issuedDiagnosticInfoNodeDTO.setModifyTime("");
            issuedDiagnosticInfoNodeDTO.setModifierId("");
            issuedDiagnosticInfoNodeDTO.setModifier("");
            list.add(issuedDiagnosticInfoNodeDTO);
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
        pushData.setIssuedDiagnosticInfoNodeDTOS(list);
        String httpResult = "";
        try {
            String url = this.projProperties.getSdyPayCenter() + "/patientCase/issued/diagnosticInfo";
            log.info("\u63a8\u9001url----------->{}", (Object)url);
            log.info("=======>\u82cf\u5927\u4e00His\u8bca\u65ad\u4fe1\u606f\u63a8\u9001\u53c2\u6570----->{}", (Object)JSON.toJSONString((Object)pushData));
            httpResult = HttpUtils.doPost((String)url, (String)JSON.toJSONString((Object)pushData), (String)Consts.UTF_8.name(), (String)ContentType.APPLICATION_JSON.getMimeType());
            log.info("=======>\u82cf\u5927\u4e00His\u8bca\u65ad\u4fe1\u606f\u63a8\u9001\u8fd4\u56de\u7ed3\u679c----->{}", (Object)httpResult);
        }
        catch (Exception e) {
            log.error("=======>\u82cf\u5927\u4e00His\u8bca\u65ad\u4fe1\u606f\u63a8\u9001 - \u83b7\u53d6\u5f02\u5e38", (Object)e.getMessage());
            throw new BusinessException("\u8bca\u65ad\u540c\u6b65\u533b\u9662\u5f02\u5e38");
        }
        FrontResponse frontResponse = (FrontResponse)JSON.parseObject((String)httpResult, FrontResponse.class);
        if (ObjectUtils.isEmpty((Object)frontResponse) || StringUtils.isEmpty((Object)frontResponse.getCode()) || frontResponse.getCode().equals("0")) {
            if (frontResponse.getMessage().contains("\u6570\u636e\u5e93\u5f02\u5e38")) {
                log.info("=======>\u3010\u5c1d\u8bd5\u89e3\u7ed1\u5c31\u8bca\u5361\u91cd\u65b0\u7ed1\u5b9a\uff0c\u91cd\u65b0\u8fdb\u884c\u533b\u751f\u95ee\u8bca\uff0c\u5f00\u5177\u5904\u65b9\u3011\uff08\u53ef\u80fd\u539f\u56e0\uff1a\u5c31\u8bca\u5361\u6570\u636e\u5e76\u6e05\uff0c\u6302\u53f7\u53f7\u4e0d\u662f\u8be5\u60a3\u8005\uff0c\u6302\u53f7\u79d1\u5ba4\u4e0e\u5f53\u524d\u79d1\u5ba4\u4e0d\u7b26\uff09\u68c0\u67e5his\u60a3\u8005\u5c31\u8bca\u5361\u8be6\u60c5\uff0c\u60a3\u8005\u5c31\u8bca\u5361\u662f\u5426\u6b63\u786e\uff1b\u68c0\u67e5\u6302\u53f7\u540e\u662f\u5426\u6b63\u786e");
            }
            throw new BusinessException("\u8bca\u65ad\u540c\u6b65\u533b\u9662\u5931\u8d25");
        }
        log.info("=======>\u82cf\u5927\u4e00His\u8bca\u65ad\u4fe1\u606f\u63a8\u9001\u5b8c\u6210");
    }
}

