/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.sender;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.framework.utils.HttpUtils;
import com.ebaiyihui.framework.utils.IdCardUtil;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import com.ebaiyihui.onlineoutpatient.core.common.properties.ProjProperties;
import com.ebaiyihui.onlineoutpatient.core.exception.BusinessException;
import com.ebaiyihui.onlineoutpatient.core.model.OrderEntity;
import com.ebaiyihui.onlineoutpatient.core.model.PatientEntity;
import com.ebaiyihui.onlineoutpatient.core.utils.DateUtils;
import com.ebaiyihui.onlineoutpatient.core.vo.HisDeptAndDocCodeVo;
import com.ebaiyihui.onlineoutpatient.core.vo.sdyPaymentPlatforms.dto.OrderReqDTO;
import com.ebaiyihui.sysinfocloudcommon.vo.medical.PatientDynamicMedicalEntityVo;
import java.util.Date;
import org.apache.http.Consts;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
@Component
public class PushSdyMedicalRcordHisManage {
    private static final Logger log = LoggerFactory.getLogger(PushSdyMedicalRcordHisManage.class);
    @Autowired
    private ProjProperties projProperties;

    public void medicalRecordInformationPush(OrderEntity orderEntity, HisDeptAndDocCodeVo hisDeptAndDocCode, PatientDynamicMedicalEntityVo entityVo, PatientEntity patientEntity) throws BusinessException {
        if (orderEntity == null || hisDeptAndDocCode == null || entityVo == null || patientEntity == null) {
            log.error("\u82cf\u5927\u4e00\u75c5\u5386\u4fe1\u606f\u7a7a");
            throw new BusinessException("\u4fe1\u606f\u7a7a\uff0c\u75c5\u5386\u4fe1\u606f\u63a8\u9001\u5931\u8d25");
        }
        log.info("======>\u82cf\u5927\u4e00His\u75c5\u5386\u4fe1\u606f\u63a8\u9001");
        OrderReqDTO pushData = new OrderReqDTO();
        pushData.setPid(orderEntity.getIdCard());
        pushData.setManageType("1");
        pushData.setCreateTime(DateUtils.dateToFullString((Date)orderEntity.getXCreateTime()));
        pushData.setDeptCode(hisDeptAndDocCode.getDeptCode());
        pushData.setDeptName(hisDeptAndDocCode.getDeptName());
        pushData.setRegisterSn(orderEntity.getInvoiceNo());
        pushData.setDoctorName(hisDeptAndDocCode.getDoctorName());
        pushData.setDoctorID(hisDeptAndDocCode.getDoctorCode());
        String medicalUserFills = entityVo.getMedicalUserFills();
        JSONObject jsonObject = JSONObject.parseObject((String)medicalUserFills);
        JSONObject medicalUserFillls = JSONObject.parseObject((String)entityVo.getMedicalUserFills());
        StringBuffer MedicalRcord = new StringBuffer();
        MedicalRcord.append("\u60a3\u8005\u59d3\u540d:").append(patientEntity.getPatientName()).append(";");
        MedicalRcord.append("\u60a3\u8005\u5e74\u9f84:").append(IdCardUtil.getAgeByIdCard((String)patientEntity.getIdcard())).append(";");
        MedicalRcord.append("\u533b\u751f\u59d3\u540d:").append(hisDeptAndDocCode.getDoctorName()).append(";");
        MedicalRcord.append("\u4e3b\u8bc9:").append(entityVo.getMainSuit()).append(";");
        MedicalRcord.append("\u8bca\u65ad:").append(entityVo.getPrimaryDiagno()).append(";");
        MedicalRcord.append("\u67e5\u4f53:").append(medicalUserFillls.get((Object)"physicalExamination") == null ? "\u6682\u65e0" : medicalUserFillls.get((Object)"physicalExamination")).append(";");
        MedicalRcord.append("\u73b0\u75c5\u53f2:").append(jsonObject.get((Object)"presentHistory") == null ? "\u6682\u65e0" : jsonObject.get((Object)"presentHistory").toString()).append(";");
        MedicalRcord.append("\u65e2\u5f80\u53f2:").append(jsonObject.get((Object)"pasttHistory") == null ? "\u6682\u65e0" : jsonObject.get((Object)"pasttHistory").toString()).append(";");
        MedicalRcord.append("\u5176\u4ed6\u75c5\u53f2:").append(jsonObject.get((Object)"ortherHistory") == null ? "\u6682\u65e0" : jsonObject.get((Object)"ortherHistory").toString()).append(";");
        MedicalRcord.append("\u8fc7\u654f\u53f2:").append(jsonObject.get((Object)"allergyHistory") == null ? "\u6682\u65e0" : jsonObject.get((Object)"allergyHistory").toString()).append(";");
        MedicalRcord.append("\u5631\u6258:").append(jsonObject.get((Object)"handle") == null ? "\u6682\u65e0" : jsonObject.get((Object)"handle").toString()).append(";");
        MedicalRcord.append("\u95e8\u8bca\u8bca\u65ad:").append(entityVo.getPrimaryDiagno());
        log.info("=============\u56de\u4f20\u75c5\u5386\u4fe1\u606fdata:", (Object)MedicalRcord);
        pushData.setText(String.valueOf(MedicalRcord));
        String httpResult = "";
        try {
            String url = this.projProperties.getSdyPayCenter() + "/patientCase//medical/recordsAreReported";
            log.info("\u63a8\u9001url----------->{}", (Object)url);
            log.info("=======>\u82cf\u5927\u4e00His\u75c5\u5386\u4fe1\u606f\u63a8\u9001\u53c2\u6570----->{}", (Object)JSON.toJSONString((Object)pushData));
            httpResult = HttpUtils.doPost((String)url, (String)JSON.toJSONString((Object)pushData), (String)Consts.UTF_8.name(), (String)ContentType.APPLICATION_JSON.getMimeType());
            log.info("=======>\u82cf\u5927\u4e00His\u75c5\u5386\u4fe1\u606f\u63a8\u9001\u8fd4\u56de\u7ed3\u679c----->{}", (Object)httpResult);
        }
        catch (Exception e) {
            log.error("=======>\u82cf\u5927\u4e00His\u75c5\u5386\u4fe1\u606f\u63a8\u9001 - \u83b7\u53d6\u5f02\u5e38", (Object)e.getMessage());
            throw new BusinessException("\u75c5\u5386\u540c\u6b65\u533b\u9662\u5f02\u5e38");
        }
        FrontResponse frontResponse = (FrontResponse)JSON.parseObject((String)httpResult, FrontResponse.class);
        if (ObjectUtils.isEmpty((Object)frontResponse) || StringUtils.isEmpty((Object)frontResponse.getCode()) || frontResponse.getCode().equals("0")) {
            throw new BusinessException("\u75c5\u5386\u540c\u6b65\u533b\u9662\u5931\u8d25");
        }
        log.info("=======>\u82cf\u5927\u4e00His\u75c5\u5386\u4fe1\u606f\u63a8\u9001\u5b8c\u6210");
    }
}

