/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.service;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.doctoruser.api.common.enums.DoctorTypeEnum;
import com.doctoruser.api.pojo.base.dto.doctor.QueryPersonnelInfoReq;
import com.doctoruser.api.pojo.base.vo.doctor.PersonnelInfo;
import com.doctoruser.api.pojo.vo.UserInfoByDoctorIdRespVO;
import com.doctoruser.api.pojo.vo.UserInfoByUserIdRespVO;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.imforward.client.vo.IMCreatGroupMemVO;
import com.ebaiyihui.imforward.client.vo.IMCreatGroupReqVO;
import com.ebaiyihui.imforward.client.vo.IMSaveSessionReqVO;
import com.ebaiyihui.imforward.client.vo.IMSessionMemberVO;
import com.ebaiyihui.onlineoutpatient.common.bo.uniformbo.ImAccountCreateReq;
import com.ebaiyihui.onlineoutpatient.common.dto.DoctorIdDTO;
import com.ebaiyihui.onlineoutpatient.core.common.constants.CommonConstants;
import com.ebaiyihui.onlineoutpatient.core.common.properties.ProjProperties;
import com.ebaiyihui.onlineoutpatient.core.dao.TeamDoctorInfoMapper;
import com.ebaiyihui.onlineoutpatient.core.exception.BusinessException;
import com.ebaiyihui.onlineoutpatient.core.model.AdmissionEntity;
import com.ebaiyihui.onlineoutpatient.core.model.OrderEntity;
import com.ebaiyihui.onlineoutpatient.core.model.TeamDoctorInfoEntity;
import com.ebaiyihui.onlineoutpatient.core.service.AliSmsPushService;
import com.ebaiyihui.onlineoutpatient.core.service.DoctorTemInfomService;
import com.ebaiyihui.onlineoutpatient.core.service.GoEasyPushService;
import com.ebaiyihui.onlineoutpatient.core.service.IMInformService;
import com.ebaiyihui.onlineoutpatient.core.service.SmallProgramPushService;
import com.ebaiyihui.onlineoutpatient.core.service.UmAppPushService;
import com.ebaiyihui.onlineoutpatient.core.service.client.DoctorInfofeignClient;
import com.ebaiyihui.onlineoutpatient.core.service.client.IMGroupApiFeugbClient;
import com.ebaiyihui.onlineoutpatient.core.service.client.ImApiFeignClient;
import com.ebaiyihui.onlineoutpatient.core.service.client.UserApiFeignClient;
import com.ebaiyihui.onlineoutpatient.core.utils.JsonUtil;
import com.ebaiyihui.onlineoutpatient.core.vo.GetPersonTeamDetialResVo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PayAsyncService {
    private static final Logger log = LoggerFactory.getLogger(PayAsyncService.class);
    @Autowired
    private UserApiFeignClient userApiFeignClient;
    @Resource
    private IMInformService iMInformService;
    @Resource
    private ImApiFeignClient imApiFeignClient;
    @Autowired
    private ProjProperties projProperties;
    @Autowired
    private AliSmsPushService aliSmsPushService;
    @Autowired
    private UmAppPushService umAppPushService;
    @Autowired
    private DoctorTemInfomService doctorTemInfomService;
    @Autowired
    private DoctorInfofeignClient doctorCilent;
    @Autowired
    private TeamDoctorInfoMapper teamDoctorInfoMapper;
    @Autowired
    private IMGroupApiFeugbClient imGroupApiFeugbClient;
    @Autowired
    private GoEasyPushService goEasyPushService;
    @Autowired
    private SmallProgramPushService smallProgramPushService;
    private ExecutorService executor = Executors.newCachedThreadPool();

    public void asyncTask(OrderEntity orderInfo, AdmissionEntity admissionEntity) {
        this.executor.submit((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        log.info("\u63a8\u9001\u7ed3\u675f\u65f6\u95f4\uff1a{}" + System.currentTimeMillis());
    }

    public BaseResponse createImSession(OrderEntity orderInfo, AdmissionEntity admissionEntity) {
        log.info("=======\u521b\u5efa\u4f1a\u8bdd\u5f00\u59cb=====");
        log.info("\u521b\u5efa\u4f1a\u8bdd\u5f00\u59cb\u65f6\u95f4\uff1a{}" + System.currentTimeMillis());
        log.info("orderinfo :{}", (Object)orderInfo);
        log.info("admission :{}", (Object)admissionEntity);
        BaseResponse response = this.createPersonalImSession(orderInfo, admissionEntity.getXId());
        log.info("\u521b\u5efa\u4f1a\u8bdd\u8fd4\u56de:{}" + JSON.toJSONString((Object)response));
        log.info("=======\u521b\u5efa\u4f1a\u8bdd\u7ed3\u675f=====");
        log.info("\u521b\u5efa\u4f1a\u8bdd\u7ed3\u675f\u65f6\u95f4\uff1a{}" + System.currentTimeMillis());
        return response;
    }

    public BaseResponse createPersonalImSession(OrderEntity orderInfo, String admissionId) {
        BaseResponse baseResponse = new BaseResponse();
        log.info("DoctorId:{}" + orderInfo.getDoctorId());
        UserInfoByUserIdRespVO docAccountInfo = this.queryDocAccountInfoNew(orderInfo.getDoctorId());
        if (docAccountInfo == null) {
            throw new BusinessException("\u521b\u5efaIMsession\u5931\u8d25,\u8c03\u7528\u67e5\u8be2\u533b\u751fuserId\u5931\u8d25\uff0c\u672a\u67e5\u8be2\u5230\u533b\u751f\u4fe1\u606f!");
        }
        if (DoctorTypeEnum.TEAM.getValue() == orderInfo.getDoctorType()) {
            log.info("\u5f00\u59cb\u521b\u5efa\u56e2\u961fim\u8d26\u53f7");
            List personTeamNew = this.doctorTemInfomService.getPersonTeamNewAll(orderInfo.getDoctorId());
            log.info("\u8fdc\u7a0b\u8c03\u7528\u56e2\u961f\u6210\u5458\u4fe1\u606f:" + JSON.toJSONString((Object)personTeamNew));
            ArrayList<UserInfoByUserIdRespVO> userIdRespVOList = new ArrayList<UserInfoByUserIdRespVO>();
            if (CollectionUtil.isNotEmpty((Collection)personTeamNew)) {
                for (GetPersonTeamDetialResVo respVO : personTeamNew) {
                    UserInfoByUserIdRespVO queryDocAccountInfoNew = this.queryDocAccountInfoNew(String.valueOf(respVO.getDoctorId()));
                    userIdRespVOList.add(queryDocAccountInfoNew);
                    this.saveTeamDoctorInfo(queryDocAccountInfoNew, respVO.getDoctorId().toString(), admissionId, ((GetPersonTeamDetialResVo)personTeamNew.get(0)).getTeamName());
                }
            }
            log.info("\u56e2\u961f\u6210\u5458\u8d26\u53f7\u4fe1\u606f:" + userIdRespVOList);
            baseResponse = this.createGroupImSession(orderInfo, admissionId, userIdRespVOList, docAccountInfo);
        } else {
            log.info("\u5f00\u59cb\u521b\u5efa\u5355\u4ebaim\u8d26\u53f7");
            baseResponse = this.createImSession(orderInfo, admissionId, docAccountInfo);
        }
        return baseResponse;
    }

    private BaseResponse createImSession(OrderEntity orderInfo, String admissionId, UserInfoByUserIdRespVO docAccountInfo) {
        DoctorIdDTO doctorIdVo = new DoctorIdDTO();
        doctorIdVo.setDoctorId(orderInfo.getDoctorId());
        ImAccountCreateReq imAccountCreateReq = new ImAccountCreateReq(admissionId, orderInfo.getDoctorId(), orderInfo.getPatientId(), docAccountInfo.getUserId(), orderInfo.getPatientUserId(), orderInfo.getAppCode());
        IMSaveSessionReqVO imSaveSessionReqVO = this.createImSessionParam(imAccountCreateReq);
        log.info("\u521b\u5efaim\u5165\u53c2{}", (Object)JSONObject.toJSONString((Object)imSaveSessionReqVO));
        BaseResponse imResponse = null;
        if (null == imSaveSessionReqVO) {
            throw new BusinessException("createImSession fail!");
        }
        log.info("\u521b\u5efaim\u8bf7\u6c42\u5f00\u59cb");
        imResponse = this.imApiFeignClient.saveIMSession(imSaveSessionReqVO);
        log.info("\u521b\u5efaim\u8bf7\u6c42\u7ed3\u679c\uff1a{}", (Object)JsonUtil.convertObject((Object)imResponse));
        return imResponse;
    }

    private BaseResponse createGroupImSession(OrderEntity orderInfo, String admissionId, List<UserInfoByUserIdRespVO> docAccountInfos, UserInfoByUserIdRespVO userInfoByUserIdRespVO) {
        IMCreatGroupReqVO imCreatGroupReqVO = new IMCreatGroupReqVO();
        ArrayList<IMCreatGroupMemVO> groupMemVOList = new ArrayList<IMCreatGroupMemVO>();
        imCreatGroupReqVO.setBusiCode("zxzx");
        imCreatGroupReqVO.setCreateUser(userInfoByUserIdRespVO.getUserId());
        imCreatGroupReqVO.setTreatmentId(admissionId);
        imCreatGroupReqVO.setMembers(groupMemVOList);
        for (UserInfoByUserIdRespVO docAccountInfo : docAccountInfos) {
            IMCreatGroupMemVO imCreatGroupMemVO = new IMCreatGroupMemVO();
            imCreatGroupMemVO.setUserId(docAccountInfo.getUserId());
            imCreatGroupMemVO.setAppCode("EHOS_DOCTOR");
            groupMemVOList.add(imCreatGroupMemVO);
        }
        IMCreatGroupMemVO imCreatGroupMemVO = new IMCreatGroupMemVO();
        imCreatGroupMemVO.setUserId(orderInfo.getPatientUserId());
        imCreatGroupMemVO.setAppCode("EHOS_PATIENT");
        groupMemVOList.add(imCreatGroupMemVO);
        log.info("\u521b\u5efa\u7fa4\u804aim\u8d26\u53f7\u5165\u53c2imCreatGroupReqVO:" + imCreatGroupReqVO);
        log.info("--------\u521b\u5efa\u7fa4\u4f53im\u8d26\u53f7\u5f00\u59cb-------");
        BaseResponse groupRes = this.imGroupApiFeugbClient.creatGroup(imCreatGroupReqVO);
        log.info("--------\u521b\u5efa\u7fa4\u4f53im\u8d26\u53f7\u7ed3\u675f-------");
        return groupRes;
    }

    private IMSaveSessionReqVO createImSessionParam(ImAccountCreateReq req) {
        IMSaveSessionReqVO reqVO = new IMSaveSessionReqVO();
        reqVO.setBusiCode("zxzx");
        reqVO.setSdkType(Short.valueOf((short)2));
        reqVO.setTreatmentId(req.getAdmId());
        reqVO.setBusiNodeCode(req.getAppCode());
        reqVO.setSaveType(true);
        IMSessionMemberVO memberOfDoc = new IMSessionMemberVO();
        ArrayList<IMSessionMemberVO> datas = new ArrayList<IMSessionMemberVO>();
        memberOfDoc.setAppCode("EHOS_DOCTOR");
        memberOfDoc.setDoctorId(CommonConstants.DOCTOR_TYPE.toString());
        memberOfDoc.setPatientId(CommonConstants.STATUS_INVALID.toString());
        memberOfDoc.setUserId(req.getDoctorUserId());
        datas.add(memberOfDoc);
        IMSessionMemberVO memberOfPatient = new IMSessionMemberVO();
        memberOfPatient.setAppCode("EHOS_PATIENT");
        memberOfPatient.setDoctorId(CommonConstants.STATUS_INVALID.toString());
        memberOfPatient.setPatientId(CommonConstants.PATIENT_TYPE.toString());
        memberOfPatient.setUserId(req.getPatientUserId());
        datas.add(memberOfPatient);
        reqVO.setMemberList(datas);
        return reqVO;
    }

    private UserInfoByUserIdRespVO queryDocAccountInfoNew(String doctorId) {
        BaseResponse response = this.userApiFeignClient.getUserInfoByDoctorId(doctorId);
        log.info("response:{}", (Object)JsonUtil.convertObject((Object)response));
        UserInfoByUserIdRespVO userInfoByUserIdRespVO = new UserInfoByUserIdRespVO();
        if (response.isSuccess()) {
            userInfoByUserIdRespVO.setUserId(((UserInfoByDoctorIdRespVO)response.getData()).getUserId());
            log.info("UserInfoByUserIdRespVO===>{}", (Object)JSON.toJSONString((Object)userInfoByUserIdRespVO));
            return userInfoByUserIdRespVO;
        }
        return null;
    }

    private void saveTeamDoctorInfo(UserInfoByUserIdRespVO userInfoByUserIdRespVO, String doctorId, String admId, String teamName) {
        log.info("\u4fdd\u5b58\u56e2\u961f\u8ba2\u5355\u533b\u751f\u4fe1\u606f:{}", (Object)doctorId);
        QueryPersonnelInfoReq queryPersonnelInfoReq = new QueryPersonnelInfoReq();
        queryPersonnelInfoReq.setDoctorId(doctorId);
        BaseResponse response = this.doctorCilent.queryPersonnelInfo(queryPersonnelInfoReq);
        if (Objects.isNull(response) || !response.isSuccess() || Objects.isNull(response.getData())) {
            return;
        }
        TeamDoctorInfoEntity teamDoctorInfoEntity = new TeamDoctorInfoEntity();
        teamDoctorInfoEntity.setAdmId(admId);
        teamDoctorInfoEntity.setDoctorId(doctorId);
        teamDoctorInfoEntity.setDoctorName(((PersonnelInfo)response.getData()).getDoctorName());
        teamDoctorInfoEntity.setTitle(((PersonnelInfo)response.getData()).getTitle());
        teamDoctorInfoEntity.setPortrait(((PersonnelInfo)response.getData()).getPortrait());
        teamDoctorInfoEntity.setUesrId(userInfoByUserIdRespVO.getUserId());
        teamDoctorInfoEntity.setTeamName(teamName);
        this.teamDoctorInfoMapper.insert((Object)teamDoctorInfoEntity);
    }

    static /* synthetic */ Logger access$000() {
        return log;
    }

    static /* synthetic */ IMInformService access$100(PayAsyncService x0) {
        return x0.iMInformService;
    }

    static /* synthetic */ AliSmsPushService access$200(PayAsyncService x0) {
        return x0.aliSmsPushService;
    }

    static /* synthetic */ SmallProgramPushService access$300(PayAsyncService x0) {
        return x0.smallProgramPushService;
    }
}

