/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.service.doctor.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.doctor.basedata.api.vo.BusinessDoctorListReqVo;
import com.doctor.basedata.api.vo.BusinessDoctorPageReqVo;
import com.doctor.basedata.api.vo.DepartmentDetailVo;
import com.doctor.basedata.api.vo.DoctorAlipayUploadRespVO;
import com.doctor.basedata.api.vo.DoctorAverageScoreRespVO;
import com.doctor.basedata.api.vo.DoctorBasicRespVO;
import com.doctor.basedata.api.vo.DoctorBusinessListReqVo;
import com.doctor.basedata.api.vo.ServiceCheckReqVo;
import com.doctoruser.api.common.enums.DoctorTypeEnum;
import com.doctoruser.api.pojo.base.bo.services.ZXWZServiceBo;
import com.doctoruser.api.pojo.base.dto.doctor.QueryPersonnelInfoReq;
import com.doctoruser.api.pojo.base.vo.doctor.DoctorBasicInfoVo;
import com.doctoruser.api.pojo.base.vo.doctor.PersonnelInfo;
import com.doctoruser.api.pojo.vo.DoctorRespVO;
import com.ebaiyihui.framework.page.PageResult;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.his.pojo.vo.schedule.items.GetScheduleResItems;
import com.ebaiyihui.onlineoutpatient.common.dto.DoctorScheduleDTO;
import com.ebaiyihui.onlineoutpatient.common.dto.QueryFamousDotDTO;
import com.ebaiyihui.onlineoutpatient.common.vo.DoctorListVo;
import com.ebaiyihui.onlineoutpatient.common.vo.NumberConsultationsVo;
import com.ebaiyihui.onlineoutpatient.common.vo.RequstDoctorListForScheduleVo;
import com.ebaiyihui.onlineoutpatient.common.vo.ResponseDoctorListForScheduleVo;
import com.ebaiyihui.onlineoutpatient.common.vo.ServiceConfigVo;
import com.ebaiyihui.onlineoutpatient.common.vo.doctor.RequestCountDoctorOrders;
import com.ebaiyihui.onlineoutpatient.common.vo.doctor.ResponseCountDoctorOrders;
import com.ebaiyihui.onlineoutpatient.common.vo.serviceconfig.RequestGetDoctorOfficeStatus;
import com.ebaiyihui.onlineoutpatient.common.vo.serviceconfig.RequestOnlineOrOfflineVo;
import com.ebaiyihui.onlineoutpatient.core.common.constants.CommonConstants;
import com.ebaiyihui.onlineoutpatient.core.common.enums.AdmissionStatusEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.OrganCodeEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.ServiceTypeEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.WhetherEnum;
import com.ebaiyihui.onlineoutpatient.core.common.properties.ProjProperties;
import com.ebaiyihui.onlineoutpatient.core.dao.InquiryServiceConfigMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.MedicalAdmissionRefMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.NcefyHisDeptMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.NcefyHisDoctorMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.OrderMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.ScheduleRecordMapper;
import com.ebaiyihui.onlineoutpatient.core.model.AdmissionEntity;
import com.ebaiyihui.onlineoutpatient.core.model.DoctorLabelEntity;
import com.ebaiyihui.onlineoutpatient.core.model.DoctorSectionEntity;
import com.ebaiyihui.onlineoutpatient.core.model.DoctorSectionRelEntity;
import com.ebaiyihui.onlineoutpatient.core.model.InquiryServiceConfigEntity;
import com.ebaiyihui.onlineoutpatient.core.model.NcefyHisDeptEntity;
import com.ebaiyihui.onlineoutpatient.core.model.NcefyHisDoctorEntity;
import com.ebaiyihui.onlineoutpatient.core.model.OrderEntity;
import com.ebaiyihui.onlineoutpatient.core.model.ScheduleRecordEntity;
import com.ebaiyihui.onlineoutpatient.core.service.DoctorTemInfomService;
import com.ebaiyihui.onlineoutpatient.core.service.HisTemplateService;
import com.ebaiyihui.onlineoutpatient.core.service.IMInformService;
import com.ebaiyihui.onlineoutpatient.core.service.InquiryServiceConfigService;
import com.ebaiyihui.onlineoutpatient.core.service.ScheduleRecordService;
import com.ebaiyihui.onlineoutpatient.core.service.client.DepartmentFeignClient;
import com.ebaiyihui.onlineoutpatient.core.service.client.DoctorDetailInfoFeignClient;
import com.ebaiyihui.onlineoutpatient.core.service.client.DoctorInfofeignClient;
import com.ebaiyihui.onlineoutpatient.core.service.client.DoctorUserEvaluationFeignClient;
import com.ebaiyihui.onlineoutpatient.core.service.client.DoctorWorkingServiceClient;
import com.ebaiyihui.onlineoutpatient.core.service.doctor.DoctorService;
import com.ebaiyihui.onlineoutpatient.core.service.impl.BaseDoctorSectionRelServiceImpl;
import com.ebaiyihui.onlineoutpatient.core.service.impl.BaseDoctorSectionServiceImpl;
import com.ebaiyihui.onlineoutpatient.core.service.impl.BaseInquiryAdmissionServiceImpl;
import com.ebaiyihui.onlineoutpatient.core.service.impl.BaseInquiryDoctorLabelServiceImpl;
import com.ebaiyihui.onlineoutpatient.core.service.impl.BaseInquiryOrderServiceImpl;
import com.ebaiyihui.onlineoutpatient.core.service.impl.BaseInquiryServiceConfigServiceImpl;
import com.ebaiyihui.onlineoutpatient.core.service.impl.BaseScheduleRecordServiceImpl;
import com.ebaiyihui.onlineoutpatient.core.service.remotecall.InternetHospitalDetailInfoService;
import com.ebaiyihui.onlineoutpatient.core.utils.DateUtils;
import com.ebaiyihui.onlineoutpatient.core.utils.ExcelUtils;
import com.ebaiyihui.onlineoutpatient.core.utils.RedisUtil;
import com.ebaiyihui.onlineoutpatient.core.vo.DoctorAliListVo;
import com.ebaiyihui.onlineoutpatient.core.vo.DoctorBasicVO;
import com.ebaiyihui.onlineoutpatient.core.vo.DoctorListForScheduleNewReqVo;
import com.ebaiyihui.onlineoutpatient.core.vo.DoctorListForScheduleNewResVo;
import com.ebaiyihui.onlineoutpatient.core.vo.DoctorReserveScheduleReqVo;
import com.ebaiyihui.onlineoutpatient.core.vo.DoctorReserveScheduleResVo;
import com.ebaiyihui.onlineoutpatient.core.vo.DoctorScheduleInfoResVo;
import com.ebaiyihui.onlineoutpatient.core.vo.DoctorScheduleNewReqVo;
import com.ebaiyihui.onlineoutpatient.core.vo.DoctorScheduleNewResVo;
import com.ebaiyihui.onlineoutpatient.core.vo.DoctorScheduleReqVo;
import com.ebaiyihui.onlineoutpatient.core.vo.DoctorScheduleResVo;
import com.ebaiyihui.onlineoutpatient.core.vo.DoctorStatisticsReqVo;
import com.ebaiyihui.onlineoutpatient.core.vo.DoctorStatisticsVo;
import com.ebaiyihui.onlineoutpatient.core.vo.HisDeptAndDocCodeVo;
import com.ebaiyihui.onlineoutpatient.core.vo.HospitalAndCountVo;
import com.ebaiyihui.onlineoutpatient.core.vo.HospitalAndDoctorInfoVo;
import com.ebaiyihui.onlineoutpatient.core.vo.QueryXGDoctorsDTO;
import com.ebaiyihui.onlineoutpatient.core.vo.ReferralDoctorFilterReqVo;
import com.ebaiyihui.onlineoutpatient.core.vo.ReferralDoctorFilterResVo;
import com.ebaiyihui.onlineoutpatient.core.vo.ReqSearchParamVo;
import com.ebaiyihui.onlineoutpatient.core.vo.ReqShowSearchRecordVo;
import com.ebaiyihui.onlineoutpatient.core.vo.ScheduleDateAndRangeVo;
import com.ebaiyihui.onlineoutpatient.core.vo.ScheduleForWeekNewReqVo;
import com.ebaiyihui.onlineoutpatient.core.vo.ScheduleForWeekNewResVo;
import com.ebaiyihui.onlineoutpatient.core.vo.ScheduleRangeAndCount;
import com.ebaiyihui.onlineoutpatient.core.vo.ScheduleRangeAndCountNewVo;
import com.ebaiyihui.onlineoutpatient.core.vo.ScheduleRangeAndCountVo;
import com.ebaiyihui.onlineoutpatient.core.vo.SearchDoctorDayScheduleReqVo;
import com.ebaiyihui.onlineoutpatient.core.vo.hisreqandresvo.ReqSaveDeptSearchRecordsVo;
import com.ebaiyihui.onlineoutpatient.core.vo.recommService.GetAppointMentReqVO;
import com.ebaiyihui.onlineoutpatient.core.vo.recommService.GetAppointMentResVO;
import com.ebaiyihui.onlineoutpatient.core.vo.recommService.RecommDoctorReqVO;
import com.ebaiyihui.onlineoutpatient.core.vo.recommService.RecommServiceReqVO;
import com.ebaiyihui.onlineoutpatient.core.vo.recommService.SerachDoctorReq;
import com.ebaiyihui.onlineoutpatient.core.vo.recommService.SerachDoctorRes;
import com.ebaiyihui.onlineoutpatient.core.vo.recommService.ServiceStatusReqVO;
import com.ebaiyihui.onlineoutpatient.core.vo.recommService.ServiceStatusResVO;
import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class DoctorServiceImpl
implements DoctorService {
    private static final Logger log = LoggerFactory.getLogger(DoctorServiceImpl.class);
    public static final String STR_ZERO = "0";
    @Autowired
    private DoctorInfofeignClient doctorCilent;
    @Autowired
    private DoctorWorkingServiceClient doctorWorkingServiceClient;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private BaseInquiryAdmissionServiceImpl baseInquiryAdmissionService;
    @Autowired
    private BaseInquiryDoctorLabelServiceImpl baseInquiryDoctorLabelService;
    @Resource
    private BaseInquiryOrderServiceImpl baseInquiryOrderService;
    @Autowired
    private ProjProperties projProperties;
    @Autowired
    private BaseInquiryServiceConfigServiceImpl inquiryServiceConfigService;
    @Autowired
    private BaseScheduleRecordServiceImpl baseScheduleRecordService;
    @Autowired
    private DoctorUserEvaluationFeignClient doctorUserEvaluationFeignClient;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private InternetHospitalDetailInfoService internetHospitalDetailInfoService;
    @Autowired
    private InquiryServiceConfigService inquiryServiceConfig;
    @Autowired
    private ScheduleRecordMapper scheduleRecordMapper;
    @Autowired
    private BaseInquiryServiceConfigServiceImpl baseInquiryServiceConfigService;
    @Autowired
    private ScheduleRecordService scheduleRecordService;
    @Autowired
    StringRedisTemplate stringRedisTemplate;
    @Autowired
    private DoctorDetailInfoFeignClient doctorDetailInfoApi;
    @Autowired
    private IMInformService imInformService;
    @Autowired
    private HisTemplateService hisTemplateService;
    @Autowired
    private NcefyHisDeptMapper ncefyHisDeptMapper;
    @Autowired
    private NcefyHisDoctorMapper ncefyHisDoctorMapper;
    private ExecutorService executor = Executors.newCachedThreadPool();
    @Autowired
    private InquiryServiceConfigMapper inquiryServiceConfigMapper;
    @Autowired
    private DepartmentFeignClient departmentInfoApi;
    @Autowired
    private DoctorTemInfomService doctorTemInfomService;
    @Autowired
    private MedicalAdmissionRefMapper medicalAdmissionRefMapper;
    @Autowired
    private BaseDoctorSectionServiceImpl doctorSectionService;
    @Autowired
    private BaseDoctorSectionRelServiceImpl doctorSectionRelService;

    public BaseResponse<List<ResponseDoctorListForScheduleVo>> getDoctorListForSchedule(RequstDoctorListForScheduleVo vo) {
        BusinessDoctorPageReqVo doctorPageReqVo = new BusinessDoctorPageReqVo();
        doctorPageReqVo.setOrganId(vo.getHospitalId());
        doctorPageReqVo.setPageNum(vo.getPageNum().intValue());
        doctorPageReqVo.setPageSize(vo.getPageSize().intValue());
        doctorPageReqVo.setServiceCode("zxmz");
        doctorPageReqVo.setStatus(1);
        doctorPageReqVo.setOrganDeptId(vo.getDeptId());
        log.info("doctorPageReqVo:{}" + JSON.toJSONString((Object)doctorPageReqVo));
        BaseResponse result = this.doctorWorkingServiceClient.getBusinessDoctorBaseInfoPage(doctorPageReqVo);
        log.info("doctorPageReqVo:{}" + JSON.toJSONString((Object)result));
        if (null == result || null == result.getData()) {
            return BaseResponse.error((String)"\u65e0\u5f00\u901a\u5728\u7ebf\u95ee\u8bca\u7684\u533b\u751f");
        }
        log.info("\u67e5\u8be2\u5f00\u901a\u5728\u7ebf\u95ee\u8bca\u533b\u751f\u5217\u8868{}", (Object)result.toString());
        PageResult pageResult = (PageResult)result.getData();
        List doctorBasicInfoVoList = pageResult.getContent();
        if (CollectionUtils.isEmpty((Collection)doctorBasicInfoVoList)) {
            return BaseResponse.error((String)"\u65e0\u5f00\u901a\u5728\u7ebf\u95ee\u8bca\u7684\u533b\u751f");
        }
        ArrayList<Long> doctorIds = new ArrayList<Long>();
        for (DoctorBasicInfoVo doctorBasicInfoVo : doctorBasicInfoVoList) {
            doctorIds.add(doctorBasicInfoVo.getXId());
        }
        if (CollectionUtils.isEmpty(doctorIds)) {
            return BaseResponse.error((String)"\u65e0\u5f00\u901a\u5728\u7ebf\u95ee\u8bca\u7684\u533b\u751f");
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        InquiryServiceConfigEntity inquiryServiceConfigEntity1 = new InquiryServiceConfigEntity();
        inquiryServiceConfigEntity1.setServiceCode("zxmz");
        queryWrapper.setEntity((Object)inquiryServiceConfigEntity1);
        queryWrapper.in((Object)"doctor_id", doctorIds);
        List entityList = this.inquiryServiceConfigService.list((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)entityList)) {
            return BaseResponse.error((String)"\u672a\u67e5\u8be2\u5230\u533b\u751f\u670d\u52a1\u4fe1\u606f");
        }
        log.info("\u67e5\u8be2\u5230\u533b\u751f\u670d\u52a1\u4fe1\u606f:" + JSON.toJSONString((Object)entityList));
        Iterator it = entityList.iterator();
        while (it.hasNext()) {
            InquiryServiceConfigEntity entity = (InquiryServiceConfigEntity)it.next();
            boolean isNeedRemovedFlag = false;
            if (entity.getIsSchedule().equals(1)) {
                it.remove();
                isNeedRemovedFlag = true;
            }
            QueryWrapper wrapper = new QueryWrapper();
            ScheduleRecordEntity scheduleRecordEntity = new ScheduleRecordEntity();
            scheduleRecordEntity.setHospitalId(vo.getHospitalId().toString());
            scheduleRecordEntity.setDoctorId(entity.getDoctorId());
            scheduleRecordEntity.setScheduleDate(vo.getScheduleDate());
            scheduleRecordEntity.setScheduleRange(vo.getScheduleRange());
            wrapper.setEntity((Object)scheduleRecordEntity);
            ScheduleRecordEntity recordEntity = (ScheduleRecordEntity)this.baseScheduleRecordService.getOne((Wrapper)wrapper);
            if (null == recordEntity || isNeedRemovedFlag) continue;
            it.remove();
        }
        List<ResponseDoctorListForScheduleVo> listForScheduleVos = new ArrayList();
        for (InquiryServiceConfigEntity inquiryServiceConfigEntity : entityList) {
            ResponseDoctorListForScheduleVo responseDoctorListForScheduleVo = new ResponseDoctorListForScheduleVo();
            String doctorId = inquiryServiceConfigEntity.getDoctorId();
            responseDoctorListForScheduleVo.setDoctorId(doctorId);
            responseDoctorListForScheduleVo.setPrice(inquiryServiceConfigEntity.getPrice());
            for (DoctorBasicInfoVo doctorBasicInfoVo : doctorBasicInfoVoList) {
                if (!doctorId.equals(doctorBasicInfoVo.getXId().toString())) continue;
                String name = doctorBasicInfoVo.getDoctorName();
                responseDoctorListForScheduleVo.setDoctorName(name);
            }
            listForScheduleVos.add(responseDoctorListForScheduleVo);
        }
        listForScheduleVos = listForScheduleVos.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<ResponseDoctorListForScheduleVo>(Comparator.comparing(o -> o.getDoctorId() + "#" + o.getDoctorName() + "#" + o.getPrice()))), ArrayList::new));
        return BaseResponse.success(listForScheduleVos);
    }

    public BaseResponse<PageResult<DoctorListVo>> getSatfaction(QueryXGDoctorsDTO reqVo) {
        log.info("\u67e5\u8be2\u533b\u751f\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)reqVo));
        if (StringUtils.isNotEmpty((String)reqVo.getSearchParam()) && StringUtils.isNotEmpty((String)reqVo.getUserId())) {
            this.redisHistory((QueryFamousDotDTO)reqVo);
        }
        if (ServiceTypeEnum.HOS.getValue().equals(reqVo.getType())) {
            reqVo.setServiceCodes(ServiceTypeEnum.HOS.getCode());
        }
        if (ServiceTypeEnum.NOS.getValue().equals(reqVo.getType())) {
            reqVo.setServiceCodes(ServiceTypeEnum.NOS.getCode());
        }
        String wOrganId = reqVo.getOrganId().toString();
        OrderEntity orderEntity = this.orderMapper.selectByUserIdAndOrganId(reqVo.getUserId(), reqVo.getOrganId().toString(), reqVo.getType());
        boolean lastSelectflag = false;
        log.info("\u60a3\u8005\u4e0a\u6b21\u5c31\u8bca\u8ba2\u5355-\u7528\u6765\u5904\u7406\u4e0a\u6b21\u9009\u62e9\u7684\u533b\u751f\uff1aorderEntity{}", (Object)JSON.toJSONString((Object)orderEntity));
        List allDoctorServTimes = this.getALLDoctorServTimes(wOrganId, reqVo.getType());
        List allDoctorPatient = this.orderMapper.getNumberConsultation(wOrganId, reqVo.getType());
        HashMap allDoctorServTimesMap = CollectionUtils.isEmpty((Collection)allDoctorServTimes) ? new HashMap() : allDoctorServTimes.stream().collect(Collectors.toMap(NumberConsultationsVo::getDoctorId, NumberConsultationsVo::getCount));
        HashMap allDoctorPatientMap = CollectionUtils.isEmpty((Collection)allDoctorPatient) ? new HashMap() : allDoctorPatient.stream().collect(Collectors.toMap(NumberConsultationsVo::getDoctorId, NumberConsultationsVo::getCount));
        List docBaseLists = this.getDoctors(reqVo, allDoctorServTimesMap, allDoctorPatientMap);
        PageResult pageResult = new PageResult();
        if (CollectionUtils.isEmpty((Collection)docBaseLists)) {
            pageResult.setContent(new ArrayList());
            pageResult.setPageNum(reqVo.getPageNum().intValue());
            pageResult.setPageSize(reqVo.getPageSize().intValue());
            return BaseResponse.success((Object)pageResult);
        }
        log.info("\u7528\u4e8e\u5faa\u73af\u7684\u96c6\u5408{}", (Object)JSON.toJSONString((Object)docBaseLists));
        List docBaseList = docBaseLists.stream().collect(Collectors.toMap(DoctorBasicInfoVo::getXId, doctor -> doctor, (existing, replacement) -> existing)).values().stream().collect(Collectors.toList());
        ArrayList<DoctorListVo> doctorListVos = new ArrayList<DoctorListVo>();
        List doctorIds = docBaseList.stream().map(DoctorBasicInfoVo::getXId).map(String::valueOf).collect(Collectors.toList());
        log.info("\u533b\u751f\u5217\u8868doctorIds:{}", (Object)JSON.toJSONString(doctorIds));
        BaseResponse doctorAverageScoreByDoctorIds = this.doctorUserEvaluationFeignClient.getDoctorAverageScoreByDoctorIds(doctorIds);
        log.info("\u67e5\u533b\u751f\u8bc4\u5206getDoctorAverageScoreByDoctorIds\u8fd4\u56de\u503c:{}", (Object)JSON.toJSONString((Object)doctorAverageScoreByDoctorIds));
        List doctorAverageScoreRespVOS = (List)doctorAverageScoreByDoctorIds.getData();
        Map<String, String> map = doctorAverageScoreRespVOS.stream().collect(Collectors.toMap(DoctorAverageScoreRespVO::getDoctorId, DoctorAverageScoreRespVO::getAverageScore));
        log.info("\u67e5\u533b\u751f\u8bc4\u5206map:{}", map);
        Map doctorPrescriptionMap = new HashMap();
        if (reqVo.getType() == 3) {
            doctorPrescriptionMap = this.getDoctorPrescriptionConfiguration(reqVo.getOrganId());
        }
        log.info("\u67e5\u533b\u751f\u5904\u65b9\u6743\u9650map:{}", map);
        ZXWZServiceBo doctorZxwzService = new ZXWZServiceBo();
        for (DoctorBasicVO dto : docBaseList) {
            Integer doctorId = dto.getXId().intValue();
            DoctorListVo doctorListVo = new DoctorListVo();
            QueryWrapper queryWrapper = new QueryWrapper();
            AdmissionEntity wrapperEntity = new AdmissionEntity();
            wrapperEntity.setDoctorId(doctorId.toString());
            ArrayList<Integer> list = new ArrayList<Integer>();
            list.add(1);
            list.add(2);
            wrapperEntity.setServType(reqVo.getType());
            queryWrapper.setEntity((Object)wrapperEntity);
            queryWrapper.in((Object)"status", list);
            int inService = this.baseInquiryAdmissionService.count((Wrapper)queryWrapper);
            doctorListVo.setInService(Integer.valueOf(inService));
            BeanUtils.copyProperties((Object)dto, (Object)doctorListVo);
            doctorListVo.setTitle(dto.getStandardTitle());
            doctorListVo.setDoctorId(doctorId.toString());
            doctorListVo.setOrganId(Integer.valueOf(wOrganId));
            doctorListVo.setDeptId(Integer.valueOf(dto.getDeptId().intValue()));
            doctorListVo.setPhoneNum(dto.getTelephone());
            String doctorScore = "5.0";
            String value = map.get(doctorListVo.getDoctorId());
            if (null != map && null != value) {
                doctorScore = "0.0".equals(value) ? "5.0" : value;
            }
            doctorListVo.setSatisfaction(doctorScore);
            doctorListVo.setServTimes(dto.getServTimes());
            doctorListVo.setPatientVolume(dto.getPatientVolume());
            doctorListVo.setLastSelect(new Integer("0"));
            ServiceConfigVo serviceConfigVo = new ServiceConfigVo();
            if (StringUtils.isEmpty((String)dto.getServiceConfig())) {
                log.info("\u65e0\u670d\u52a1\u914d\u7f6e\u4fe1\u606f\u7684\u533b\u751fID{}", (Object)JSON.toJSONString((Object)dto.getXId()));
                continue;
            }
            ZXWZServiceBo zxwzServiceBo = (ZXWZServiceBo)JSON.parseObject((String)dto.getServiceConfig(), ZXWZServiceBo.class);
            if (null == zxwzServiceBo) continue;
            serviceConfigVo.setPrice(zxwzServiceBo.getServicePrice());
            serviceConfigVo.setDailyLimit(zxwzServiceBo.getNumLimit());
            serviceConfigVo.setNumLimit(zxwzServiceBo.getReplyLimit());
            serviceConfigVo.setServTime(zxwzServiceBo.getEffectiveTime());
            doctorListVo.setServiceConfigData(serviceConfigVo);
            doctorListVo.setPrescriptionConfig(doctorPrescriptionMap.containsKey(dto.getXId()));
            this.getDoctorOfficeStatusAndDoctorLabel((QueryFamousDotDTO)reqVo, dto.getDeptId(), dto.getOrganId(), doctorId, doctorListVo);
            if (Objects.equals(OrganCodeEnum.NCEFY.getValue(), reqVo.getAppCode()) || Objects.equals(OrganCodeEnum.YCRMYY.getValue(), reqVo.getAppCode())) {
                BaseResponse docIsLearder = this.doctorTemInfomService.getDocIsLearder(doctorId.toString(), wOrganId);
                List personTeamNew = this.doctorTemInfomService.getPersonTeamNew(doctorId.toString());
                if (docIsLearder.isSuccess() && ((Boolean)docIsLearder.getData()).booleanValue() && personTeamNew != null) {
                    doctorListVo.setDoctorType(DoctorTypeEnum.TEAM.getValue());
                } else {
                    doctorListVo.setDoctorType(DoctorTypeEnum.PERSONAL.getValue());
                }
            }
            if (null != orderEntity && orderEntity.getDoctorId().equals(dto.getXId().toString()) && StringUtils.isEmpty((String)reqVo.getSearchParam()) && null == reqVo.getOrganDeptId()) {
                log.info("\u53bb\u9664\u6389\u4e0a\u6b21\u9009\u62e9\u7684\u533b\u751f======" + JSON.toJSONString((Object)dto));
                lastSelectflag = true;
                BeanUtils.copyProperties((Object)zxwzServiceBo, (Object)doctorZxwzService);
                continue;
            }
            if (null != orderEntity && orderEntity.getDoctorId().equals(dto.getXId().toString()) && (StringUtils.isNotEmpty((String)reqVo.getSearchParam()) || null != reqVo.getOrganDeptId())) {
                doctorListVo.setLastSelect(new Integer("1"));
                doctorListVos.add(0, doctorListVo);
                BeanUtils.copyProperties((Object)zxwzServiceBo, (Object)doctorZxwzService);
                continue;
            }
            doctorListVos.add(doctorListVo);
        }
        if (lastSelectflag) {
            Integer patientVolume = allDoctorPatientMap.get(orderEntity.getDoctorId()) == null ? Integer.valueOf(0) : (Integer)allDoctorPatientMap.get(orderEntity.getDoctorId());
            boolean prescription = doctorPrescriptionMap.containsKey(Long.valueOf(orderEntity.getDoctorId()));
            this.isLastSelect((QueryFamousDotDTO)reqVo, doctorListVos, wOrganId, orderEntity, doctorZxwzService, patientVolume, prescription);
        }
        if (reqVo.getSortType() != null && reqVo.getSortType() == 1) {
            doctorListVos.sort(Comparator.comparing(DoctorListVo::getServTimes).reversed());
        }
        if (reqVo.getSortType() != null && reqVo.getSortType() == 2) {
            doctorListVos.sort(Comparator.comparing(DoctorListVo::getPatientVolume).reversed());
        }
        pageResult.setPageNum(reqVo.getPageNum().intValue());
        pageResult.setPageSize(doctorListVos.size());
        pageResult.setContent(doctorListVos);
        return BaseResponse.success((Object)pageResult);
    }

    private Map<Long, String> getDoctorPrescriptionConfiguration(Long organId) {
        BusinessDoctorListReqVo doctorPageReqVo = new BusinessDoctorListReqVo();
        doctorPageReqVo.setOrganId(Long.valueOf(organId));
        doctorPageReqVo.setServiceCode(ServiceTypeEnum.KOS.getCode());
        doctorPageReqVo.setStatus(1);
        log.info("doctorPageReqVo:{}" + JSON.toJSONString((Object)doctorPageReqVo));
        BaseResponse response = this.doctorWorkingServiceClient.getBusinessDoctorList(doctorPageReqVo);
        log.info("\u67e5\u533b\u751f\u5904\u65b9\u914d\u7f6e\u8fd4\u56de\u503c:{}", (Object)JSON.toJSONString((Object)response));
        List data = (List)response.getData();
        return data.stream().collect(Collectors.toMap(DoctorBasicInfoVo::getXId, DoctorBasicRespVO::getServiceConfig));
    }

    private List<DoctorBasicVO> getDoctors(QueryXGDoctorsDTO reqVo, Map<String, Integer> allDoctorServTimesMap, Map<String, Integer> allDoctorPatientMap) {
        List<DoctorBasicVO> collect;
        ArrayList docBaseList = new ArrayList();
        ArrayList resultData = new ArrayList();
        List depts = reqVo.getDepts();
        if (StringUtils.isNotEmpty((String)reqVo.getReserveTime()) && !"1".equals(reqVo.getReserveTime())) {
            Date scheduleDate = DateUtils.strToDateNoTry((String)reqVo.getReserveTime());
            String hourAndSecond = DateUtils.getHourAndSecond();
            String nowDate = DateUtils.getCurrentDateSimpleToString();
            if (!nowDate.equals(reqVo.getReserveTime())) {
                hourAndSecond = null;
            }
            log.info("hourAndSecond{}", (Object)JSON.toJSONString((Object)hourAndSecond));
            List schList = this.scheduleRecordMapper.selectDocIds(reqVo.getOrganId().toString(), reqVo.getType(), scheduleDate, WhetherEnum.ALLOW.getValue(), hourAndSecond);
            List docList = this.inquiryServiceConfigMapper.selectDoctorId(reqVo.getOrganId().toString(), reqVo.getServiceCodes(), Integer.valueOf(2));
            List collect2 = Stream.of(docList, schList).flatMap(Collection::stream).distinct().collect(Collectors.toList());
            log.info("\u6709\u6392\u73ed\u7684\u533b\u751f" + JSON.toJSONString((Object)schList));
            log.info("\u6709\u4efb\u610f\u65f6\u95f4\u8bbe\u7f6e\u7684\u533b\u751f" + JSON.toJSONString((Object)docList));
            if (CollectionUtils.isEmpty(collect2)) {
                return new ArrayList<DoctorBasicVO>();
            }
            ArrayList docIds = new ArrayList();
            String organDeptId = reqVo.getOrganDeptId();
            if (StringUtils.isNotBlank((String)organDeptId) && organDeptId.toString().contains("SDFYY")) {
                List<Object> doctorIdList = new ArrayList();
                QueryWrapper queryWrapper = new QueryWrapper();
                DoctorSectionEntity sectionEntity = new DoctorSectionEntity();
                sectionEntity.setSectionCode(organDeptId);
                queryWrapper.setEntity((Object)sectionEntity);
                DoctorSectionEntity doctorSectionEntity = (DoctorSectionEntity)this.doctorSectionService.getOne((Wrapper)queryWrapper);
                QueryWrapper wrapper = new QueryWrapper();
                DoctorSectionRelEntity sectionRelEntity = new DoctorSectionRelEntity();
                sectionRelEntity.setSectionId(doctorSectionEntity.getId());
                wrapper.setEntity((Object)sectionRelEntity);
                List list = this.doctorSectionRelService.list((Wrapper)wrapper);
                List<Object> filteredList = new ArrayList();
                filteredList = null != depts && depts.size() > 0 ? list.stream().filter(entity -> ((Long)depts.get(0)).toString().equals(entity.getDoctorDeptId())).collect(Collectors.toList()) : list;
                List doctorIds = filteredList.stream().map(DoctorSectionRelEntity::getDoctorId).collect(Collectors.toList());
                doctorIdList = doctorIds.stream().filter(collect2::contains).collect(Collectors.toList());
                doctorIdList.stream().forEach(docId -> docIds.add(Long.valueOf(docId)));
            } else {
                collect2.stream().forEach(docId -> docIds.add(Long.valueOf(docId)));
            }
            BaseResponse businessByDocIdsAndServiceCode = new BaseResponse();
            ArrayList docs = new ArrayList();
            ArrayList docSchTimeListS = new ArrayList();
            DoctorBusinessListReqVo doctorBusinessListReqVo = new DoctorBusinessListReqVo();
            doctorBusinessListReqVo.setServiceCode(reqVo.getServiceCodes());
            doctorBusinessListReqVo.setStatus(1);
            doctorBusinessListReqVo.setSeq(1);
            doctorBusinessListReqVo.setDoctorIds(docIds);
            if (!(StringUtils.isNotBlank((String)organDeptId) && organDeptId.contains("SDFYY") || !StringUtils.isNotBlank((String)organDeptId))) {
                doctorBusinessListReqVo.setOrganDeptId(Long.valueOf(reqVo.getOrganDeptId()));
            }
            log.info("\u67e5\u8be2\u533b\u751f\u8be6\u60c5\u5165\u53c2" + JSON.toJSONString((Object)doctorBusinessListReqVo));
            businessByDocIdsAndServiceCode = this.doctorWorkingServiceClient.getBusinessByDocIdsAndServiceCode(doctorBusinessListReqVo);
            docSchTimeListS.addAll((Collection)businessByDocIdsAndServiceCode.getData());
            if (StringUtils.isNotBlank((String)organDeptId) && organDeptId.contains("SDFYY_002")) {
                doctorBusinessListReqVo.setServiceCode("53110");
                businessByDocIdsAndServiceCode = this.doctorWorkingServiceClient.getBusinessByDocIdsAndServiceCode(doctorBusinessListReqVo);
                docSchTimeListS.addAll((Collection)businessByDocIdsAndServiceCode.getData());
            }
            if (CollectionUtils.isEmpty(docSchTimeListS)) {
                return new ArrayList<DoctorBasicVO>();
            }
            businessByDocIdsAndServiceCode.setData(docSchTimeListS);
            List docSchTimeList = (List)businessByDocIdsAndServiceCode.getData();
            if (CollectionUtils.isEmpty((Collection)docSchTimeList)) {
                return new ArrayList<DoctorBasicVO>();
            }
            docBaseList.addAll(docSchTimeList);
        } else if (StringUtils.isNotBlank((String)reqVo.getOrganDeptId()) && reqVo.getOrganDeptId().contains("SDFYY")) {
            ArrayList docIds = new ArrayList();
            QueryWrapper queryWrapper = new QueryWrapper();
            DoctorSectionEntity sectionEntity = new DoctorSectionEntity();
            sectionEntity.setSectionCode(reqVo.getOrganDeptId());
            queryWrapper.setEntity((Object)sectionEntity);
            DoctorSectionEntity doctorSectionEntity = (DoctorSectionEntity)this.doctorSectionService.getOne((Wrapper)queryWrapper);
            QueryWrapper wrapper = new QueryWrapper();
            DoctorSectionRelEntity sectionRelEntity = new DoctorSectionRelEntity();
            sectionRelEntity.setSectionId(doctorSectionEntity.getId());
            wrapper.setEntity((Object)sectionRelEntity);
            List list = this.doctorSectionRelService.list((Wrapper)wrapper);
            List doctorIds = list.stream().map(DoctorSectionRelEntity::getDoctorId).collect(Collectors.toList());
            doctorIds.stream().forEach(docId -> docIds.add(Long.valueOf(docId)));
            DoctorBusinessListReqVo doctorBusinessListReqVo = new DoctorBusinessListReqVo();
            doctorBusinessListReqVo.setServiceCode(reqVo.getServiceCodes());
            doctorBusinessListReqVo.setStatus(1);
            doctorBusinessListReqVo.setSeq(1);
            doctorBusinessListReqVo.setDoctorIds(docIds);
            if (!(StringUtils.isNotBlank((String)reqVo.getOrganDeptId()) && reqVo.getOrganDeptId().contains("SDFYY") || !StringUtils.isNotBlank((String)reqVo.getOrganDeptId()))) {
                doctorBusinessListReqVo.setOrganDeptId(Long.valueOf(reqVo.getOrganDeptId()));
            }
            ArrayList docSchTimeListS = new ArrayList();
            List<Object> docSchTimeListSs = new ArrayList();
            log.info("\u67e5\u8be2\u533b\u751f\u8be6\u60c5\u5165\u53c2" + JSON.toJSONString((Object)doctorBusinessListReqVo));
            BaseResponse businessByDocIdsAndServiceCode = this.doctorWorkingServiceClient.getBusinessByDocIdsAndServiceCode(doctorBusinessListReqVo);
            docSchTimeListS.addAll((Collection)businessByDocIdsAndServiceCode.getData());
            if (StringUtils.isNotBlank((String)reqVo.getOrganDeptId()) && reqVo.getOrganDeptId().contains("SDFYY_002")) {
                doctorBusinessListReqVo.setServiceCode("53110");
                businessByDocIdsAndServiceCode = this.doctorWorkingServiceClient.getBusinessByDocIdsAndServiceCode(doctorBusinessListReqVo);
                docSchTimeListS.addAll((Collection)businessByDocIdsAndServiceCode.getData());
            }
            if (CollectionUtils.isEmpty(docSchTimeListS)) {
                return new ArrayList<DoctorBasicVO>();
            }
            docSchTimeListSs = null != depts && depts.size() > 0 ? docSchTimeListS.stream().filter(entity -> ((Long)depts.get(0)).equals(entity.getDeptId())).collect(Collectors.toList()) : docSchTimeListS;
            resultData.addAll(docSchTimeListSs);
            docBaseList.addAll(resultData);
        } else {
            BusinessDoctorPageReqVo businessDoctorPageReqVo = new BusinessDoctorPageReqVo();
            reqVo.setSeq(Integer.valueOf(1));
            reqVo.setStatus(Integer.valueOf(1));
            BeanUtils.copyProperties((Object)reqVo, (Object)businessDoctorPageReqVo);
            businessDoctorPageReqVo.setPageNum(1);
            businessDoctorPageReqVo.setPageSize(9999);
            businessDoctorPageReqVo.setServiceCode(reqVo.getServiceCodes());
            if (StringUtils.isNotBlank((String)reqVo.getOrganDeptId())) {
                businessDoctorPageReqVo.setOrganDeptId(Long.valueOf(reqVo.getOrganDeptId()));
            }
            log.info("\u533b\u751f\u6570\u636e\u5165\u53c2" + JSON.toJSONString((Object)businessDoctorPageReqVo));
            BaseResponse businessDoctorPage = this.doctorWorkingServiceClient.getBusinessDoctorBaseInfoPage(businessDoctorPageReqVo);
            if (null == businessDoctorPage.getData()) {
                return new ArrayList<DoctorBasicVO>();
            }
            resultData.addAll(((PageResult)businessDoctorPage.getData()).getContent());
            collect = resultData.stream().filter(vo -> "5".equals(vo.getAduitStatus())).collect(Collectors.toList());
            docBaseList.addAll(collect);
        }
        if (CollectionUtils.isEmpty(docBaseList)) {
            return new ArrayList<DoctorBasicVO>();
        }
        List doctorBasicVOList = docBaseList.stream().map(doctorBasicRespVO -> {
            DoctorBasicVO doctorBasicVO = new DoctorBasicVO();
            BeanUtils.copyProperties((Object)doctorBasicRespVO, (Object)doctorBasicVO);
            doctorBasicVO.setServTimes(Integer.valueOf(allDoctorServTimesMap.get(doctorBasicVO.getXId().toString()) == null ? 0 : (Integer)allDoctorServTimesMap.get(doctorBasicVO.getXId().toString())));
            doctorBasicVO.setPatientVolume(Integer.valueOf(allDoctorPatientMap.get(doctorBasicVO.getXId().toString()) == null ? 0 : (Integer)allDoctorPatientMap.get(doctorBasicVO.getXId().toString())));
            return doctorBasicVO;
        }).collect(Collectors.toList());
        List doctorBasicVOS = doctorBasicVOList.stream().collect(Collectors.toMap(DoctorBasicInfoVo::getXId, doctor -> doctor, (existing, replacement) -> existing)).values().stream().collect(Collectors.toList());
        if (reqVo.getSortType() != null && reqVo.getSortType() == 1) {
            doctorBasicVOS.sort(Comparator.comparing(DoctorBasicVO::getServTimes).reversed());
        }
        if (reqVo.getSortType() != null && reqVo.getSortType() == 2) {
            doctorBasicVOS.sort(Comparator.comparing(DoctorBasicVO::getPatientVolume).reversed());
        }
        if (CollectionUtils.isEmpty(collect = doctorBasicVOS.stream().skip((reqVo.getPageNum() - 1) * reqVo.getPageSize()).limit(reqVo.getPageSize().intValue()).collect(Collectors.toList()))) {
            return new ArrayList<DoctorBasicVO>();
        }
        log.info("\u5206\u9875" + JSON.toJSONString(collect));
        return collect;
    }

    private void isLastSelect(QueryFamousDotDTO reqVo, List<DoctorListVo> doctorListVos, String wOrganId, OrderEntity orderEntity, ZXWZServiceBo doctorZxwzService, Integer patientVolume, boolean prescription) {
        InquiryServiceConfigEntity inquiryServiceConfigEntity;
        QueryWrapper queryWrapper = new QueryWrapper();
        InquiryServiceConfigEntity wrapperEntity = new InquiryServiceConfigEntity();
        wrapperEntity.setDoctorId(orderEntity.getDoctorId());
        wrapperEntity.setOrganId(orderEntity.getHospitalId());
        wrapperEntity.setStatus(Integer.valueOf(CommonConstants.STATUS_VALID));
        wrapperEntity.setServiceCode(reqVo.getServiceCodes());
        wrapperEntity.setDeptId(orderEntity.getDeptId());
        log.info("wrapperEntity:{}" + JSON.toJSONString((Object)wrapperEntity));
        queryWrapper.setEntity((Object)wrapperEntity);
        queryWrapper.last("limit 1");
        if (StringUtils.isNotEmpty((String)reqVo.getReserveTime()) && !"1".equals(reqVo.getReserveTime())) {
            queryWrapper.in((Object)"is_schedule", new Object[]{2, 3});
        }
        if (null != (inquiryServiceConfigEntity = (InquiryServiceConfigEntity)this.inquiryServiceConfigService.getOne((Wrapper)queryWrapper))) {
            log.info("inquiryServiceConfigEntity:{}" + inquiryServiceConfigEntity.toString());
            QueryPersonnelInfoReq queryPersonnelInfoReq = new QueryPersonnelInfoReq();
            queryPersonnelInfoReq.setDoctorId(orderEntity.getDoctorId());
            BaseResponse personnelInfoBaseResponse = this.doctorCilent.queryPersonnelInfo(queryPersonnelInfoReq);
            log.info("req :{}", (Object)JSON.toJSONString((Object)personnelInfoBaseResponse));
            DoctorListVo doctorListVo = new DoctorListVo();
            BaseResponse docIsLearder = this.doctorTemInfomService.getDocIsLearder(orderEntity.getDoctorId(), wOrganId);
            List personTeamNew = this.doctorTemInfomService.getPersonTeamNew(orderEntity.getDoctorId());
            if (docIsLearder.isSuccess() && ((Boolean)docIsLearder.getData()).booleanValue() && personTeamNew != null) {
                doctorListVo.setDoctorType(DoctorTypeEnum.TEAM.getValue());
            } else {
                doctorListVo.setDoctorType(DoctorTypeEnum.PERSONAL.getValue());
            }
            PersonnelInfo baseResponseData = (PersonnelInfo)personnelInfoBaseResponse.getData();
            BeanUtils.copyProperties((Object)baseResponseData, (Object)doctorListVo);
            ServiceConfigVo serviceConfigVo = new ServiceConfigVo();
            serviceConfigVo.setPrice(doctorZxwzService.getServicePrice());
            serviceConfigVo.setDailyLimit(doctorZxwzService.getNumLimit());
            serviceConfigVo.setNumLimit(doctorZxwzService.getReplyLimit());
            serviceConfigVo.setServTime(doctorZxwzService.getEffectiveTime());
            doctorListVo.setServiceConfigData(serviceConfigVo);
            doctorListVo.setOrganId(Integer.valueOf(wOrganId));
            doctorListVo.setLastSelect(new Integer("1"));
            doctorListVo.setDoctorId(baseResponseData.getDoctorId());
            String doctorScorel = "5.0";
            BaseResponse doctorAverageScorel = this.doctorUserEvaluationFeignClient.getDoctorAverageScore(doctorListVo.getDoctorId());
            if (null != doctorAverageScorel && null != doctorAverageScorel.getData()) {
                doctorScorel = "0.0".equals(doctorAverageScorel.getData()) ? "5.0" : (String)doctorAverageScorel.getData();
            }
            doctorListVo.setSatisfaction(doctorScorel);
            doctorListVo.setServTimes(this.getDoctorServTimes(orderEntity.getDoctorId(), orderEntity.getOrganId(), orderEntity.getServType()));
            doctorListVo.setPatientVolume(patientVolume);
            QueryWrapper query = new QueryWrapper();
            AdmissionEntity wrapper = new AdmissionEntity();
            wrapper.setDoctorId(baseResponseData.getDoctorId());
            ArrayList<Integer> list = new ArrayList<Integer>();
            list.add(1);
            list.add(2);
            wrapper.setServType(orderEntity.getServType());
            query.setEntity((Object)wrapper);
            query.in((Object)"status", list);
            int inService = this.baseInquiryAdmissionService.count((Wrapper)query);
            Long deptId = baseResponseData.getDeptId().longValue();
            Long organId = baseResponseData.getOrganId().longValue();
            Integer doctorId = Integer.parseInt(baseResponseData.getDoctorId());
            this.getDoctorOfficeStatusAndDoctorLabel(reqVo, deptId, organId, doctorId, doctorListVo);
            doctorListVo.setInService(Integer.valueOf(inService));
            doctorListVo.setPrescriptionConfig(prescription);
            doctorListVos.add(0, doctorListVo);
        }
    }

    private void getDoctorOfficeStatusAndDoctorLabel(QueryFamousDotDTO reqVo, Long deptId, Long organId, Integer doctorId, DoctorListVo doctorListVo) {
        RequestGetDoctorOfficeStatus requestGetDoctorOfficeStatus = new RequestGetDoctorOfficeStatus();
        requestGetDoctorOfficeStatus.setAppCode(reqVo.getAppCode());
        requestGetDoctorOfficeStatus.setDoctorId(doctorId.toString());
        requestGetDoctorOfficeStatus.setHospitalId(reqVo.getOrganId().toString());
        BaseResponse requestOnlineOrOfflineVo = this.inquiryServiceConfig.getDoctorOfficeStatus(requestGetDoctorOfficeStatus);
        if (null != requestOnlineOrOfflineVo.getData()) {
            doctorListVo.setOfficeStatus(((RequestOnlineOrOfflineVo)requestOnlineOrOfflineVo.getData()).getOfficeStatus());
            log.info("\u533b\u751f\u662f\u5426\u5728\u7ebf:" + ((RequestOnlineOrOfflineVo)requestOnlineOrOfflineVo.getData()).getOfficeStatus());
        }
        QueryWrapper wrapper = new QueryWrapper();
        DoctorLabelEntity doctorLabelEntity = new DoctorLabelEntity();
        doctorLabelEntity.setDoctorId(doctorId.toString());
        doctorLabelEntity.setDeptId(Integer.valueOf(deptId.intValue()));
        doctorLabelEntity.setHospitalId(JSON.toJSONString((Object)organId));
        doctorLabelEntity.setAppCode(reqVo.getAppCode());
        wrapper.setEntity((Object)doctorLabelEntity);
        log.info("\u6dfb\u52a0\u533b\u751f\u6807\u7b7e\u7684\u5165\u53c2\uff1a{}" + JSON.toJSONString((Object)doctorLabelEntity));
        DoctorLabelEntity entity = (DoctorLabelEntity)this.baseInquiryDoctorLabelService.getOne((Wrapper)wrapper);
        if (null != entity) {
            doctorListVo.setDoctorLabelName(entity.getLabelName());
            log.info("\u6dfb\u52a0\u533b\u751f\u6807\u7b7e\u6210\u529f\uff1a{}" + entity.getLabelName());
        }
    }

    public BaseResponse<List<String>> deleteSearchRecord(ReqSearchParamVo reqSearchParamVo) {
        ArrayList list = new ArrayList();
        if (null == reqSearchParamVo.getUserId()) {
            return BaseResponse.error((String)"userId\u4e3a\u7a7a");
        }
        String userId = reqSearchParamVo.getUserId();
        String deptSearch = reqSearchParamVo.getDeptSearch();
        String key = userId;
        if (null != deptSearch) {
            key = key + deptSearch;
        }
        if (StringUtils.isEmpty((String)reqSearchParamVo.getFuzzyName())) {
            log.info("\u4f20\u5165\u7684\u53c2\u6570\u4e3anull,\u5219\u9ed8\u8ba4\u5220\u9664\u6240\u6709\u641c\u7d22\u8bb0\u5f55");
            this.redisUtil.delete(key);
            String json = this.redisUtil.get(key);
            Map redisMap = (Map)JSONObject.parseObject((String)json, Map.class);
            log.info("\u5220\u9664\u4e4b\u540eredis\u4e2d\u7684map\u4e3a" + redisMap);
            return BaseResponse.success(list);
        }
        String json = this.redisUtil.get(key);
        Map redisMap = (Map)JSONObject.parseObject((String)json, Map.class);
        log.info("\u5220\u9664redis\u7684map\u4e2d\u503c,key\u662f" + reqSearchParamVo.getFuzzyName());
        redisMap.remove(reqSearchParamVo.getFuzzyName());
        String jsonString = JSON.toJSONString((Object)redisMap);
        log.info("\u5220\u9664redis\u4e4b\u540e,map\u662f" + jsonString);
        this.redisUtil.set(key, jsonString);
        Map mapResult = DoctorServiceImpl.sortByValue((Map)redisMap, (boolean)true);
        mapResult.forEach((k, v) -> list.add(k));
        return BaseResponse.success(list);
    }

    public BaseResponse<List<String>> showSearchRecord(ReqShowSearchRecordVo reqShowSearchRecordVo) {
        String userId1 = reqShowSearchRecordVo.getUserId();
        if (null == userId1) {
            return BaseResponse.success(new ArrayList());
        }
        String userId = reqShowSearchRecordVo.getUserId();
        String deptSearch = reqShowSearchRecordVo.getDeptSearch();
        String key = userId;
        if (null != reqShowSearchRecordVo.getDeptSearch()) {
            key = key + deptSearch;
        }
        String redisValue = this.redisUtil.get(key);
        ArrayList list = new ArrayList();
        String json = this.redisUtil.get(key);
        if (StringUtils.isEmpty((String)json)) {
            return BaseResponse.success(list);
        }
        Map redisMap = (Map)JSONObject.parseObject((String)json, Map.class);
        log.info("\u83b7\u53d6\u5230\u7684redis\u4e2d\u7684map\u96c6\u5408\u4e3a" + redisMap);
        if (redisMap.isEmpty()) {
            return BaseResponse.success(list);
        }
        Map mapResult = DoctorServiceImpl.sortByValue((Map)redisMap, (boolean)true);
        mapResult.forEach((k, v) -> list.add(k));
        log.info("\u641c\u83b7\u663e\u793a\u7684\u7ed3\u679c\u4e3a:" + ((Object)list).toString());
        return BaseResponse.success(list);
    }

    public BaseResponse<String> checkDoctorService(DoctorScheduleDTO doctorScheduleDTO) {
        BusinessDoctorPageReqVo doctorPageReqVo = new BusinessDoctorPageReqVo();
        doctorPageReqVo.setOrganId(Long.valueOf(doctorScheduleDTO.getOrganId()));
        doctorPageReqVo.setPageNum(1);
        doctorPageReqVo.setPageSize(100000);
        doctorPageReqVo.setServiceCode("zxmz");
        doctorPageReqVo.setStatus(1);
        doctorPageReqVo.setOrganDeptId(Long.valueOf(doctorScheduleDTO.getDeptId().intValue()));
        log.info("doctorPageReqVo:{}" + JSON.toJSONString((Object)doctorPageReqVo));
        BaseResponse result = this.doctorWorkingServiceClient.getBusinessDoctorBaseInfoPage(doctorPageReqVo);
        log.info("doctorPageReqVo:{}" + JSON.toJSONString((Object)result));
        if (null == result || null == result.getData()) {
            return BaseResponse.error((String)"\u8be5\u533b\u751f\u672a\u5f00\u901a\u672c\u670d\u52a1");
        }
        log.info("\u67e5\u8be2\u5f00\u901a\u5728\u7ebf\u95ee\u8bca\u533b\u751f\u5217\u8868{}", (Object)result.toString());
        PageResult pageResult = (PageResult)result.getData();
        List doctorBasicInfoVoList = pageResult.getContent();
        if (CollectionUtils.isEmpty((Collection)doctorBasicInfoVoList)) {
            return BaseResponse.error((String)"\u8be5\u533b\u751f\u672a\u5f00\u901a\u672c\u670d\u52a1");
        }
        List filterDoctorBasicInfoVoList = doctorBasicInfoVoList.stream().filter(doctorBasicInfoVo -> doctorBasicInfoVo.getDoctorCode().equals(doctorScheduleDTO.getDoctorId())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty((Collection)doctorBasicInfoVoList)) {
            return BaseResponse.error((String)"\u8be5\u533b\u751f\u672a\u5f00\u901a\u672c\u670d\u52a1");
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        InquiryServiceConfigEntity wrapperEntity = new InquiryServiceConfigEntity();
        wrapperEntity.setDoctorId(doctorScheduleDTO.getDoctorId());
        wrapperEntity.setOrganId(doctorScheduleDTO.getOrganId());
        queryWrapper.setEntity((Object)wrapperEntity);
        queryWrapper.last("limit 1");
        InquiryServiceConfigEntity inquiryServiceConfigEntity = (InquiryServiceConfigEntity)this.inquiryServiceConfigService.getOne((Wrapper)queryWrapper);
        if (null == inquiryServiceConfigEntity) {
            return BaseResponse.error((String)"\u533b\u751f\u670d\u52a1\u4e0d\u53ef\u8d2d\u4e70");
        }
        return BaseResponse.success((Object)"\u8be5\u533b\u751f\u5df2\u5f00\u901a\u672c\u670d\u52a1,\u5e76\u4e14\u53ef\u4ee5\u8d2d\u4e70");
    }

    public BaseResponse<ResponseCountDoctorOrders> countDoctorOrders(RequestCountDoctorOrders requestCountDoctorOrders) {
        QueryWrapper queryWrapper = new QueryWrapper();
        AdmissionEntity wrapperEntity = new AdmissionEntity();
        wrapperEntity.setDoctorId(requestCountDoctorOrders.getDoctorId().toString());
        wrapperEntity.setOrganId(requestCountDoctorOrders.getOrganId().toString());
        wrapperEntity.setServType(requestCountDoctorOrders.getServType());
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(AdmissionStatusEnum.TO_BE_RECEIVED.getValue());
        list.add(AdmissionStatusEnum.IN_CONSULTATION.getValue());
        queryWrapper.setEntity((Object)wrapperEntity);
        queryWrapper.in((Object)"status", list);
        Integer inService = this.baseInquiryAdmissionService.count((Wrapper)queryWrapper);
        QueryWrapper query = new QueryWrapper();
        ArrayList<Integer> admList = new ArrayList<Integer>();
        admList.add(AdmissionStatusEnum.FINISH_APPLY.getValue());
        admList.add(AdmissionStatusEnum.FINISH_TIME_OUT.getValue());
        admList.add(AdmissionStatusEnum.FINISH_APPLY_REVIEWED.getValue());
        query.setEntity((Object)wrapperEntity);
        query.in((Object)"status", admList);
        Integer totalOrders = this.baseInquiryAdmissionService.count((Wrapper)query);
        ResponseCountDoctorOrders responseCountDoctorOrders = new ResponseCountDoctorOrders();
        responseCountDoctorOrders.setAppCode(requestCountDoctorOrders.getAppCode());
        responseCountDoctorOrders.setDoctorId(requestCountDoctorOrders.getDoctorId());
        responseCountDoctorOrders.setOrganId(requestCountDoctorOrders.getOrganId());
        responseCountDoctorOrders.setInService(inService);
        responseCountDoctorOrders.setTotalOrders(totalOrders);
        return BaseResponse.success((Object)responseCountDoctorOrders);
    }

    public BaseResponse<List<DoctorScheduleResVo>> doctorScheduleList(DoctorScheduleReqVo doctorScheduleReqVo) {
        DoctorScheduleNewReqVo doctorScheduleNewReqVo = new DoctorScheduleNewReqVo();
        doctorScheduleNewReqVo.setServType(ServiceTypeEnum.HOS.getValue());
        doctorScheduleNewReqVo.setDoctorId(doctorScheduleReqVo.getDoctorId());
        doctorScheduleNewReqVo.setHospitalId(doctorScheduleReqVo.getHospitalId());
        doctorScheduleNewReqVo.setDeptId(doctorScheduleReqVo.getDeptId());
        BaseResponse listBaseResponse = this.doctorScheduleListNew(doctorScheduleNewReqVo);
        if (!listBaseResponse.isSuccess()) {
            return BaseResponse.error((String)"\u533b\u751f\u79d1\u5ba4\u6392\u73ed\u8c03\u7528\u5931\u8d25");
        }
        if (CollectionUtils.isEmpty((Collection)((Collection)listBaseResponse.getData()))) {
            return BaseResponse.success(new ArrayList());
        }
        List scheduleDateAndRangeVos = ((DoctorScheduleNewResVo)((List)listBaseResponse.getData()).get(0)).getScheduleDateAndRangeVos();
        HospitalAndDoctorInfoVo hospitalAndDoctorInfoVo = new HospitalAndDoctorInfoVo();
        Integer id = ((ScheduleRangeAndCountNewVo)((ScheduleDateAndRangeVo)scheduleDateAndRangeVos.get(0)).getScheduleRangeAndCountList().get(0)).getId();
        QueryWrapper queryWrapper = new QueryWrapper();
        ScheduleRecordEntity scheduleRecordEntity = new ScheduleRecordEntity();
        scheduleRecordEntity.setId(id);
        queryWrapper.setEntity((Object)scheduleRecordEntity);
        ScheduleRecordEntity scheduleRecordEntity1 = (ScheduleRecordEntity)this.scheduleRecordMapper.selectOne((Wrapper)queryWrapper);
        BeanUtils.copyProperties((Object)scheduleRecordEntity1, (Object)hospitalAndDoctorInfoVo);
        QueryWrapper configQuery = new QueryWrapper();
        InquiryServiceConfigEntity configEntity = new InquiryServiceConfigEntity();
        configEntity.setOrganId(scheduleRecordEntity1.getHospitalId());
        configEntity.setDoctorId(scheduleRecordEntity1.getDoctorId());
        configQuery.setEntity((Object)configEntity);
        configQuery.last("limit 1");
        InquiryServiceConfigEntity inquiryServiceConfigEntity = (InquiryServiceConfigEntity)this.baseInquiryServiceConfigService.getOne((Wrapper)configQuery);
        hospitalAndDoctorInfoVo.setPrice(inquiryServiceConfigEntity.getPrice());
        ArrayList<DoctorScheduleResVo> doctorScheduleResVoList = new ArrayList<DoctorScheduleResVo>();
        for (ScheduleDateAndRangeVo doctorScheduleNewResVo : scheduleDateAndRangeVos) {
            DoctorScheduleResVo doctorScheduleResVo = new DoctorScheduleResVo();
            HospitalAndCountVo hospitalAndCountVo = new HospitalAndCountVo();
            if (CollectionUtils.isEmpty((Collection)doctorScheduleNewResVo.getScheduleRangeAndCountList())) continue;
            Date date = null;
            try {
                date = DateUtils.strToDate((String)doctorScheduleNewResVo.getScheduleDate(), (String)"yyyy-MM-dd");
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            BeanUtils.copyProperties((Object)hospitalAndDoctorInfoVo, (Object)hospitalAndCountVo);
            hospitalAndCountVo.setScheduleDate(date);
            hospitalAndCountVo.setWeek(DateUtils.getForWeek((String)doctorScheduleNewResVo.getScheduleDate()));
            int totalCount = 0;
            ArrayList<ScheduleRangeAndCountVo> scheduleRangeAndCountVos = new ArrayList<ScheduleRangeAndCountVo>();
            for (ScheduleRangeAndCountNewVo scheduleRangeAndCountNewVo : doctorScheduleNewResVo.getScheduleRangeAndCountList()) {
                ScheduleRangeAndCountVo scheduleRangeAndCountVo = new ScheduleRangeAndCountVo();
                BeanUtils.copyProperties((Object)scheduleRangeAndCountNewVo, (Object)scheduleRangeAndCountVo);
                scheduleRangeAndCountVo.setStatus(WhetherEnum.ALLOW.getValue());
                scheduleRangeAndCountVos.add(scheduleRangeAndCountVo);
                totalCount += scheduleRangeAndCountNewVo.getTotalCount().intValue();
            }
            hospitalAndCountVo.setScheduleTotalCount(Integer.valueOf(totalCount));
            hospitalAndCountVo.setScheduleRangeAndCountVoList(scheduleRangeAndCountVos);
            doctorScheduleResVo.setHospitalAndCountVo(hospitalAndCountVo);
            doctorScheduleResVoList.add(doctorScheduleResVo);
        }
        return BaseResponse.success(doctorScheduleResVoList);
    }

    public static <K, V extends Comparable<? super V>> Map<K, V> sortByValue(Map<K, V> map, boolean isDesc) {
        LinkedHashMap result = Maps.newLinkedHashMap();
        if (isDesc) {
            map.entrySet().stream().sorted(Map.Entry.comparingByValue().reversed()).forEach(e -> {
                Comparable cfr_ignored_0 = (Comparable)result.put(e.getKey(), e.getValue());
            });
        } else {
            map.entrySet().stream().sorted(Map.Entry.comparingByValue()).forEachOrdered(e -> {
                Comparable cfr_ignored_0 = (Comparable)result.put(e.getKey(), e.getValue());
            });
        }
        return result;
    }

    private Integer getDoctorServTimes(String docId, String organId, Integer type) {
        QueryWrapper queryWrapper = new QueryWrapper();
        OrderEntity orderEntity = new OrderEntity();
        orderEntity.setDoctorId(docId);
        orderEntity.setOrganId(organId);
        orderEntity.setServType(type);
        queryWrapper.setEntity((Object)orderEntity);
        queryWrapper.notIn((Object)"status", new Object[]{-1});
        return this.baseInquiryOrderService.count((Wrapper)queryWrapper);
    }

    private void redisHistory(QueryFamousDotDTO reqVo) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        String value = simpleDateFormat.format(new Date());
        log.info("===========value===========:" + value);
        String redisValue = this.redisUtil.get(reqVo.getUserId());
        if (null == redisValue) {
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            map.put(reqVo.getSearchParam(), value);
            log.info("map\u7684\u5927\u5c0f\u4e3a:" + map.size());
            String jsonString = JSON.toJSONString(map);
            this.redisUtil.set(reqVo.getUserId(), jsonString);
        } else {
            Map redisMap = (Map)JSONObject.parseObject((String)redisValue, Map.class);
            if (redisMap.size() < 5) {
                boolean flag = redisMap.containsKey(reqVo.getSearchParam());
                if (!flag) {
                    redisMap.put(reqVo.getSearchParam(), value);
                } else {
                    redisMap.remove(reqVo.getSearchParam());
                    redisMap.put(reqVo.getSearchParam(), value);
                }
                redisMap.put(reqVo.getSearchParam(), value);
                String jsonString = JSON.toJSONString((Object)redisMap);
                this.redisUtil.set(reqVo.getUserId(), jsonString);
                log.info("redis\u4e2dsize<5\u7684map\u7684\u5927\u5c0f\u4e3a:" + redisMap.size());
            } else {
                Map mapResult = DoctorServiceImpl.sortByValue((Map)redisMap, (boolean)true);
                log.info("\u6392\u5e8f\u540e\u7684map\u6709\u5e8fmap\u4e3a:" + mapResult);
                boolean flag = mapResult.containsKey(reqVo.getSearchParam());
                if (!flag) {
                    Field tail = null;
                    try {
                        tail = mapResult.getClass().getDeclaredField("tail");
                    }
                    catch (NoSuchFieldException e) {
                        e.printStackTrace();
                    }
                    tail.setAccessible(true);
                    Map.Entry entry = null;
                    try {
                        entry = (Map.Entry)tail.get(mapResult);
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                    String key = (String)entry.getKey();
                    log.info("\u5220\u9664\u7684\u6700\u65e9\u7684\u4e00\u6761\u8bb0\u5f55\u7684key\u662f:" + key);
                    mapResult.remove(key);
                    log.info("\u5220\u9664\u4e00\u6761\u8bb0\u5f55\u7684map\u4e3a" + mapResult);
                    mapResult.put(reqVo.getSearchParam(), value);
                } else {
                    mapResult.remove(reqVo.getSearchParam());
                    mapResult.put(reqVo.getSearchParam(), value);
                }
                log.info("\u91cd\u65b0\u653e\u5165\u4e00\u6761\u8bb0\u5f55\u7684map\u4e3a" + mapResult);
                String jsonString = JSON.toJSONString((Object)mapResult);
                this.redisUtil.set(reqVo.getUserId(), jsonString);
                log.info("redis\u4e2dmap\u7684\u5927\u5c0f\u4e3a:" + redisMap.size());
            }
        }
    }

    private BaseResponse<List<DoctorBasicRespVO>> doctorServiceCheck(DoctorScheduleNewReqVo doctorScheduleNewReqVo) {
        BusinessDoctorListReqVo doctorPageReqVo = new BusinessDoctorListReqVo();
        doctorPageReqVo.setOrganId(Long.valueOf(doctorScheduleNewReqVo.getHospitalId()));
        if (ServiceTypeEnum.HOS.getValue().equals(doctorScheduleNewReqVo.getServType())) {
            doctorPageReqVo.setServiceCode(ServiceTypeEnum.HOS.getCode());
        }
        if (ServiceTypeEnum.NOS.getValue().equals(doctorScheduleNewReqVo.getServType())) {
            doctorPageReqVo.setServiceCode(ServiceTypeEnum.NOS.getCode());
        }
        doctorPageReqVo.setStatus(1);
        log.info("doctorPageReqVo:{}" + JSON.toJSONString((Object)doctorPageReqVo));
        BaseResponse result = this.doctorWorkingServiceClient.getBusinessDoctorList(doctorPageReqVo);
        return result;
    }

    public BaseResponse<List<DoctorScheduleNewResVo>> doctorScheduleListNew(DoctorScheduleNewReqVo doctorScheduleNewReqVo) {
        String currentDate = DateUtils.getCurrentDateSimpleToString();
        Date dateNow = null;
        try {
            dateNow = DateUtils.strToDate((String)currentDate, (String)"yyyy-MM-dd");
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        Date dateAfter = DateUtils.getDateAfter((Date)dateNow, (int)6);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        List recordEntityList = this.getScheduleRecordEntities(doctorScheduleNewReqVo);
        if (CollectionUtils.isEmpty((Collection)recordEntityList)) {
            return BaseResponse.success(new ArrayList());
        }
        Map<String, List<ScheduleRecordEntity>> collect = recordEntityList.stream().collect(Collectors.groupingBy(ScheduleRecordEntity::getDeptId));
        ArrayList<DoctorScheduleNewResVo> doctorScheduleNewResList = new ArrayList<DoctorScheduleNewResVo>();
        for (String key : collect.keySet()) {
            List<ScheduleRecordEntity> scheduleRecordList = collect.get(key);
            log.info("\u6b64\u533b\u751f\u67d0\u79d1\u5ba4\u6392\u73ed{}", (Object)JSON.toJSONString(scheduleRecordList));
            ArrayList<ScheduleRecordEntity> scheduleFilterList = new ArrayList<ScheduleRecordEntity>();
            for (ScheduleRecordEntity scheduleRecordEntity : scheduleRecordList) {
                boolean overlap = DateUtils.overlap((Date)scheduleRecordEntity.getScheduleDate(), (Date)scheduleRecordEntity.getScheduleDate(), (Date)dateNow, (Date)dateAfter);
                if (!overlap) continue;
                scheduleFilterList.add(scheduleRecordEntity);
            }
            if (CollectionUtils.isEmpty(scheduleFilterList)) continue;
            log.info("\u8303\u56f4\u5185\u7684\u6392\u73ed{}", (Object)JSON.toJSONString(scheduleFilterList));
            DoctorScheduleNewResVo doctorScheduleNewResVo = new DoctorScheduleNewResVo();
            doctorScheduleNewResVo.setDeptId(key);
            doctorScheduleNewResVo.setDeptName(scheduleRecordList.get(0).getDeptName());
            List<Object> scheduleDateAndRangeVos = new ArrayList();
            int i = 0;
            for (i = 0; i < 7; ++i) {
                Date nowDate = DateUtils.getDateAfter((Date)dateNow, (int)i);
                String format = simpleDateFormat.format(nowDate);
                String date = format + " 00:00:00";
                log.info("\u7b2c\u51e0\u5929:" + date);
                Long l = DateUtils.StringTolong((String)date);
                ScheduleDateAndRangeVo scheduleDateAndRangeVo2 = new ScheduleDateAndRangeVo();
                scheduleDateAndRangeVo2.setScheduleDate(format);
                scheduleDateAndRangeVo2.setScheduleDateTemp(l.toString());
                ArrayList scheduleRangeAndCountNewVos = new ArrayList();
                Map<Date, List<ScheduleRecordEntity>> oneDaySch = scheduleFilterList.stream().collect(Collectors.groupingBy(ScheduleRecordEntity::getScheduleDate));
                for (Date oneDate : oneDaySch.keySet()) {
                    List<ScheduleRecordEntity> scheduleFilterOneDay = oneDaySch.get(oneDate);
                    boolean overlap = DateUtils.overlap((Date)scheduleFilterOneDay.get(0).getScheduleDate(), (Date)scheduleFilterOneDay.get(0).getScheduleDate(), (Date)nowDate, (Date)nowDate);
                    if (!overlap) continue;
                    scheduleFilterOneDay.sort(Comparator.comparing(ScheduleRecordEntity::getStartTime));
                    scheduleFilterOneDay.stream().forEach(s -> {
                        ScheduleRangeAndCountNewVo scheduleRangeAndCountNewVo = new ScheduleRangeAndCountNewVo();
                        BeanUtils.copyProperties((Object)s, (Object)scheduleRangeAndCountNewVo);
                        scheduleRangeAndCountNewVos.add(scheduleRangeAndCountNewVo);
                    });
                }
                scheduleDateAndRangeVo2.setScheduleRangeAndCountList(scheduleRangeAndCountNewVos);
                scheduleDateAndRangeVos.add(scheduleDateAndRangeVo2);
            }
            doctorScheduleNewResVo.setScheduleDateAndRangeForPatient(scheduleDateAndRangeVos);
            log.info("\u4e00\u5468\u7684\u6392\u73ed{}", (Object)scheduleDateAndRangeVos.toString());
            scheduleDateAndRangeVos = scheduleDateAndRangeVos.stream().filter(scheduleDateAndRangeVo -> !CollectionUtils.isEmpty((Collection)scheduleDateAndRangeVo.getScheduleRangeAndCountList())).collect(Collectors.toList());
            log.info("\u4e00\u5468\u6709\u503c\u7684\u6392\u73ed{}", (Object)JSON.toJSONString(scheduleDateAndRangeVos));
            doctorScheduleNewResVo.setScheduleDateAndRangeVos(scheduleDateAndRangeVos);
            doctorScheduleNewResList.add(doctorScheduleNewResVo);
        }
        if (CollectionUtils.isEmpty(doctorScheduleNewResList)) {
            return BaseResponse.success(new ArrayList());
        }
        return BaseResponse.success(doctorScheduleNewResList);
    }

    private InquiryServiceConfigEntity getInquiryServiceConfigEntity(DoctorScheduleNewReqVo doctorScheduleNewReqVo, String key) {
        QueryWrapper queryWrapper = new QueryWrapper();
        InquiryServiceConfigEntity wrapperEntity = new InquiryServiceConfigEntity();
        wrapperEntity.setDoctorId(doctorScheduleNewReqVo.getDoctorId());
        wrapperEntity.setOrganId(doctorScheduleNewReqVo.getHospitalId());
        wrapperEntity.setDeptId(Long.valueOf(Long.parseLong(key)));
        if (ServiceTypeEnum.HOS.getValue().equals(doctorScheduleNewReqVo.getServType())) {
            wrapperEntity.setServiceCode(ServiceTypeEnum.HOS.getCode());
        }
        if (ServiceTypeEnum.NOS.getValue().equals(doctorScheduleNewReqVo.getServType())) {
            wrapperEntity.setServiceCode(ServiceTypeEnum.NOS.getCode());
        }
        queryWrapper.setEntity((Object)wrapperEntity);
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(2);
        list.add(3);
        queryWrapper.in((Object)"is_schedule", list);
        log.info("wrapperEntity:{}" + JSON.toJSONString((Object)wrapperEntity));
        return (InquiryServiceConfigEntity)this.baseInquiryServiceConfigService.getOne((Wrapper)queryWrapper);
    }

    private List<ScheduleRangeAndCountNewVo> getScheduleRangeAndCountNewVos(Date nowDate, Map<Integer, List<ScheduleRecordEntity>> collectRange) {
        ArrayList<ScheduleRangeAndCountNewVo> scheduleRangeAndCountNewVos = new ArrayList<ScheduleRangeAndCountNewVo>();
        for (Integer rangeKey : collectRange.keySet()) {
            List<ScheduleRecordEntity> scheduleRecordEntities = collectRange.get(rangeKey);
            scheduleRecordEntities.sort(Comparator.comparing(ScheduleRecordEntity::getScheduleDate));
            for (ScheduleRecordEntity scheduleRecord : scheduleRecordEntities) {
                boolean overlap = DateUtils.overlap((Date)scheduleRecord.getScheduleDate(), (Date)scheduleRecord.getScheduleDate(), (Date)nowDate, (Date)nowDate);
                if (!overlap) continue;
                ScheduleRangeAndCountNewVo scheduleRangeAndCountNewVo = new ScheduleRangeAndCountNewVo();
                BeanUtils.copyProperties((Object)scheduleRecord, (Object)scheduleRangeAndCountNewVo);
                scheduleRangeAndCountNewVos.add(scheduleRangeAndCountNewVo);
            }
        }
        return scheduleRangeAndCountNewVos;
    }

    private List<ScheduleDateAndRangeVo> getScheduleDateAndRangeVos(List<ScheduleDateAndRangeVo> scheduleDateAndRangeVos) {
        ArrayList<ScheduleDateAndRangeVo> scheduleDateAndRangeList = new ArrayList<ScheduleDateAndRangeVo>();
        scheduleDateAndRangeVos.stream().forEach(s -> {
            ScheduleDateAndRangeVo scheduleDateAndRangeVo = new ScheduleDateAndRangeVo();
            ArrayList scheduleRangeList = new ArrayList();
            s.getScheduleRangeAndCountList().stream().forEach(range -> {
                ScheduleRangeAndCountNewVo scheduleRangeAndCountNewVo = new ScheduleRangeAndCountNewVo();
                BeanUtils.copyProperties((Object)range, (Object)scheduleRangeAndCountNewVo);
                scheduleRangeList.add(scheduleRangeAndCountNewVo);
            });
            BeanUtils.copyProperties((Object)s, (Object)scheduleDateAndRangeVo);
            scheduleDateAndRangeVo.setScheduleRangeAndCountList(scheduleRangeList);
            scheduleDateAndRangeList.add(scheduleDateAndRangeVo);
        });
        return scheduleDateAndRangeList;
    }

    private List<ScheduleRecordEntity> getScheduleRecordEntities(DoctorScheduleNewReqVo doctorScheduleNewReqVo) {
        QueryWrapper wrapper = new QueryWrapper();
        ScheduleRecordEntity entity = new ScheduleRecordEntity();
        entity.setHospitalId(doctorScheduleNewReqVo.getHospitalId());
        entity.setServType(doctorScheduleNewReqVo.getServType());
        entity.setDoctorId(doctorScheduleNewReqVo.getDoctorId());
        entity.setStatus(WhetherEnum.ALLOW.getValue());
        if (StringUtils.isNotEmpty((String)doctorScheduleNewReqVo.getDeptId())) {
            entity.setDeptId(doctorScheduleNewReqVo.getDeptId());
        }
        wrapper.setEntity((Object)entity);
        return this.baseScheduleRecordService.list((Wrapper)wrapper);
    }

    public BaseResponse<List<DoctorListForScheduleNewResVo>> getDoctorListForScheduleNew(DoctorListForScheduleNewReqVo vo) {
        BaseResponse result;
        BusinessDoctorPageReqVo businessDoctorPageReqVo = new BusinessDoctorPageReqVo();
        businessDoctorPageReqVo.setSeq(1);
        businessDoctorPageReqVo.setStatus(1);
        businessDoctorPageReqVo.setOrganId(vo.getHospitalId());
        businessDoctorPageReqVo.setPageNum(1);
        businessDoctorPageReqVo.setPageSize(9999);
        if (ServiceTypeEnum.HOS.getValue().equals(vo.getServType())) {
            businessDoctorPageReqVo.setServiceCode(ServiceTypeEnum.HOS.getCode());
        }
        if (ServiceTypeEnum.NOS.getValue().equals(vo.getServType())) {
            businessDoctorPageReqVo.setServiceCode(ServiceTypeEnum.NOS.getCode());
        }
        if (!(result = this.doctorWorkingServiceClient.getBusinessDoctorBaseInfoPage(businessDoctorPageReqVo)).isSuccess()) {
            return BaseResponse.error((String)"\u533b\u751f\u67e5\u8be2\u5931\u8d25");
        }
        if (null == result || null == result.getData()) {
            return BaseResponse.error((String)"\u65e0\u5f00\u901a\u5728\u7ebf\u95ee\u8bca\u7684\u533b\u751f");
        }
        log.info("\u67e5\u8be2\u5f00\u901a\u5728\u7ebf\u95ee\u8bca\u533b\u751f\u5217\u8868{}", (Object)JSON.toJSONString((Object)((PageResult)result.getData()).getContent()));
        ArrayList listForScheduleVos = new ArrayList();
        for (DoctorBasicRespVO doctorBasicRespVO : ((PageResult)result.getData()).getContent()) {
            QueryWrapper queryWrapper = new QueryWrapper();
            InquiryServiceConfigEntity inquiryServiceConfig = new InquiryServiceConfigEntity();
            if (ServiceTypeEnum.HOS.getValue().equals(vo.getServType())) {
                inquiryServiceConfig.setServiceCode(ServiceTypeEnum.HOS.getCode());
                inquiryServiceConfig.setDeptId(doctorBasicRespVO.getDeptId());
            }
            if (ServiceTypeEnum.NOS.getValue().equals(vo.getServType())) {
                inquiryServiceConfig.setServiceCode(ServiceTypeEnum.NOS.getCode());
            }
            inquiryServiceConfig.setDoctorId(doctorBasicRespVO.getXId().toString());
            inquiryServiceConfig.setOrganId(doctorBasicRespVO.getOrganId().toString());
            inquiryServiceConfig.setStatus(Integer.valueOf(1));
            queryWrapper.setEntity((Object)inquiryServiceConfig);
            ArrayList<Integer> list = new ArrayList<Integer>();
            list.add(2);
            list.add(3);
            queryWrapper.in((Object)"is_schedule", list);
            List serviceConfigEntities = this.inquiryServiceConfigMapper.selectList((Wrapper)queryWrapper);
            if (CollectionUtils.isEmpty((Collection)serviceConfigEntities)) {
                log.info("\u672a\u67e5\u8be2\u5230\u533b\u751f\u670d\u52a1\u4fe1\u606f,\u6216\u6b64\u533b\u751f\u672a\u5f00\u901a\u6392\u73ed");
                continue;
            }
            serviceConfigEntities.stream().forEach(one -> {
                ServiceCheckReqVo serviceCheckReqVo = new ServiceCheckReqVo();
                serviceCheckReqVo.setDoctorId(doctorBasicRespVO.getXId());
                serviceCheckReqVo.setOrganId(doctorBasicRespVO.getOrganId());
                serviceCheckReqVo.setDeptId(one.getDeptId());
                serviceCheckReqVo.setServiceCode(inquiryServiceConfig.getServiceCode());
                BaseResponse response = this.doctorWorkingServiceClient.checkDoctorServiceByCode(serviceCheckReqVo);
                if (!response.isSuccess() || !((Boolean)response.getData()).booleanValue()) {
                    log.info("\u533b\u751f\u8be5\u79d1\u5ba4\u672a\u5f00\u901a\u590d\u8bca\u670d\u52a1:{}", (Object)one.getDeptId());
                    return;
                }
                if (StringUtils.isEmpty((String)one.getDoctorPortrait()) || StringUtils.isEmpty((String)one.getDoctorProfession())) {
                    InquiryServiceConfigEntity inquiryServiceUpdate = new InquiryServiceConfigEntity();
                    inquiryServiceUpdate.setDoctorPortrait(doctorBasicRespVO.getPortrait());
                    inquiryServiceUpdate.setDoctorProfession(doctorBasicRespVO.getStandardTitle());
                    inquiryServiceUpdate.setXId(one.getXId());
                    this.inquiryServiceConfigService.updateById((Object)inquiryServiceUpdate);
                }
                DoctorListForScheduleNewResVo doctorForScheduleVo = new DoctorListForScheduleNewResVo();
                doctorForScheduleVo.setDoctorId(doctorBasicRespVO.getXId().toString());
                doctorForScheduleVo.setDoctorName(doctorBasicRespVO.getDoctorName());
                BaseResponse departmentDetail = this.departmentInfoApi.getDepartmentDetail(Long.valueOf(one.getDeptId()));
                doctorForScheduleVo.setDeptName(((DepartmentDetailVo)departmentDetail.getData()).getDeptName());
                doctorForScheduleVo.setDeptName(doctorBasicRespVO.getDeptName());
                doctorForScheduleVo.setDeptId(one.getDeptId().toString());
                listForScheduleVos.add(doctorForScheduleVo);
            });
        }
        return BaseResponse.success(listForScheduleVos);
    }

    public BaseResponse<DoctorScheduleInfoResVo> searchDoctorDaySchedule(SearchDoctorDayScheduleReqVo searchDoctorDayScheduleReqVo) {
        BaseResponse pageResultBaseResponse;
        DoctorScheduleInfoResVo doctorScheduleInfoResVo = new DoctorScheduleInfoResVo();
        doctorScheduleInfoResVo.setScheduleTime(searchDoctorDayScheduleReqVo.getScheduleTime());
        ScheduleForWeekNewReqVo scheduleForWeek = new ScheduleForWeekNewReqVo();
        scheduleForWeek.setHospitalId(searchDoctorDayScheduleReqVo.getHospitalId());
        scheduleForWeek.setServType(searchDoctorDayScheduleReqVo.getServType());
        scheduleForWeek.setWeek(searchDoctorDayScheduleReqVo.getWeek());
        if (StringUtils.isNotEmpty((String)searchDoctorDayScheduleReqVo.getDoctorName())) {
            scheduleForWeek.setDoctorName(searchDoctorDayScheduleReqVo.getDoctorName());
        }
        if (!(pageResultBaseResponse = this.scheduleRecordService.scheduleForWeekNew(scheduleForWeek)).isSuccess()) {
            return BaseResponse.error((String)"\u5355\u5468\u6392\u73ed\u8c03\u7528\u5931\u8d25");
        }
        List content = (List)pageResultBaseResponse.getData();
        if (CollectionUtils.isEmpty((Collection)content)) {
            return BaseResponse.success();
        }
        if (CollectionUtils.isEmpty(content = content.stream().filter(scheduleForWeekNew -> scheduleForWeekNew.getScheduleTime().compareTo(searchDoctorDayScheduleReqVo.getScheduleTime()) == 0).collect(Collectors.toList()))) {
            return BaseResponse.success();
        }
        log.info("\u8fc7\u6ee4\u51fa\u5f53\u524d\u9009\u62e9\u65e5\u671f\u7684content\u53ea\u6709\u4e00\u6761{}", (Object)content.toString());
        ArrayList scheduleInfos = new ArrayList();
        ((ScheduleForWeekNewResVo)content.get(0)).getScheduleInfos().stream().forEach(schedule -> scheduleInfos.add(schedule));
        doctorScheduleInfoResVo.setScheduleInfos(scheduleInfos);
        return BaseResponse.success((Object)doctorScheduleInfoResVo);
    }

    public BaseResponse<List<DoctorReserveScheduleResVo>> doctorReserveSchedule(DoctorReserveScheduleReqVo doctorReserveScheduleReqVo) {
        InquiryServiceConfigEntity one = this.getInquiryServiceConfigPatient(doctorReserveScheduleReqVo);
        if (null == one) {
            return BaseResponse.error((String)"\u6b64\u533b\u751f\u5f53\u524d\u79d1\u5ba4\u672a\u5f00\u901a\u6392\u73ed");
        }
        DoctorScheduleNewReqVo doctorScheduleNewReqVo = new DoctorScheduleNewReqVo();
        BeanUtils.copyProperties((Object)doctorReserveScheduleReqVo, (Object)doctorScheduleNewReqVo);
        BaseResponse listBaseResponse = this.doctorScheduleListNew(doctorScheduleNewReqVo);
        if (!listBaseResponse.isSuccess()) {
            return BaseResponse.error((String)"\u533b\u751f\u6392\u73ed\u67e5\u8be2\u5931\u8d25");
        }
        if (CollectionUtils.isEmpty((Collection)((Collection)listBaseResponse.getData()))) {
            ArrayList<DoctorReserveScheduleResVo> doctorReserveScheduleResVos = new ArrayList<DoctorReserveScheduleResVo>();
            Date date = null;
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            for (int i = 0; i < 7; ++i) {
                DoctorReserveScheduleResVo scheduleTimeRes = new DoctorReserveScheduleResVo();
                String currentDateSimpleToString = DateUtils.getCurrentDateSimpleToString();
                try {
                    date = DateUtils.strToDate((String)currentDateSimpleToString, (String)"yyyy-MM-dd");
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                Date dateAfter = DateUtils.getDateAfter((Date)date, (int)i);
                String format = simpleDateFormat.format(dateAfter);
                scheduleTimeRes.setScheduleTime(format);
                scheduleTimeRes.setScheduleRangeAndCounts(new ArrayList());
                doctorReserveScheduleResVos.add(scheduleTimeRes);
            }
            return BaseResponse.success(doctorReserveScheduleResVos);
        }
        List data = (List)listBaseResponse.getData();
        if (CollectionUtils.isEmpty(data = data.stream().filter(doctorScheduleNewResVo -> doctorScheduleNewResVo.getDeptId().equals(doctorReserveScheduleReqVo.getDeptId())).collect(Collectors.toList()))) {
            return BaseResponse.success(new ArrayList());
        }
        log.info("data{}", (Object)data.toString());
        List scheduleList = ((DoctorScheduleNewResVo)data.get(0)).getScheduleDateAndRangeForPatient();
        ArrayList<DoctorReserveScheduleResVo> doctorReserveScheduleRes = new ArrayList<DoctorReserveScheduleResVo>();
        for (ScheduleDateAndRangeVo schedule : scheduleList) {
            List scheduleRangeAndCountList = schedule.getScheduleRangeAndCountList();
            DoctorReserveScheduleResVo scheduleDateAndRangeVo = new DoctorReserveScheduleResVo();
            scheduleDateAndRangeVo.setScheduleTime(schedule.getScheduleDate());
            ArrayList<ScheduleRangeAndCount> scheduleRangeAndCountNewVos = new ArrayList<ScheduleRangeAndCount>();
            for (ScheduleRangeAndCountNewVo scheduleAndrange : scheduleRangeAndCountList) {
                boolean b;
                Date date = null;
                Date date1 = null;
                Date hourAndSecond = null;
                Date endTime = null;
                String currentDateSimpleToString = DateUtils.getCurrentDateSimpleToString();
                try {
                    date = DateUtils.strToDate((String)schedule.getScheduleDate(), (String)"yyyy-MM-dd");
                    date1 = DateUtils.strToDate((String)currentDateSimpleToString, (String)"yyyy-MM-dd");
                    hourAndSecond = DateUtils.strToDate((String)DateUtils.getHourAndSecond(), (String)"HH:mm");
                    endTime = DateUtils.strToDate((String)scheduleAndrange.getEndTime(), (String)"HH:mm");
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                boolean bl = b = endTime.equals(hourAndSecond) || endTime.before(hourAndSecond);
                if (date.equals(date1) && b) continue;
                ScheduleRangeAndCount scheduleRangeAndCountNewVo = new ScheduleRangeAndCount();
                BeanUtils.copyProperties((Object)scheduleAndrange, (Object)scheduleRangeAndCountNewVo);
                int i = DateUtils.minuteBetween((Date)hourAndSecond, (Date)endTime);
                if (date.equals(date1) && i <= 10) {
                    scheduleRangeAndCountNewVo.setTenMinute(WhetherEnum.FORBID.getValue());
                } else {
                    scheduleRangeAndCountNewVo.setTenMinute(WhetherEnum.ALLOW.getValue());
                }
                scheduleRangeAndCountNewVos.add(scheduleRangeAndCountNewVo);
            }
            scheduleDateAndRangeVo.setScheduleRangeAndCounts(scheduleRangeAndCountNewVos);
            doctorReserveScheduleRes.add(scheduleDateAndRangeVo);
        }
        return BaseResponse.success(doctorReserveScheduleRes);
    }

    private InquiryServiceConfigEntity getInquiryServiceConfigPatient(DoctorReserveScheduleReqVo doctorReserveScheduleReqVo) {
        QueryWrapper wrapper = new QueryWrapper();
        InquiryServiceConfigEntity inquiryServiceConfigEntity = new InquiryServiceConfigEntity();
        inquiryServiceConfigEntity.setDoctorId(doctorReserveScheduleReqVo.getDoctorId());
        inquiryServiceConfigEntity.setDeptId(Long.valueOf(doctorReserveScheduleReqVo.getDeptId()));
        if (doctorReserveScheduleReqVo.getServType().equals(ServiceTypeEnum.NOS.getValue())) {
            inquiryServiceConfigEntity.setServiceCode(ServiceTypeEnum.NOS.getCode());
        }
        if (doctorReserveScheduleReqVo.getServType().equals(ServiceTypeEnum.HOS.getValue())) {
            inquiryServiceConfigEntity.setServiceCode(ServiceTypeEnum.HOS.getCode());
        }
        inquiryServiceConfigEntity.setOrganId(doctorReserveScheduleReqVo.getHospitalId());
        wrapper.setEntity((Object)inquiryServiceConfigEntity);
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(2);
        list.add(3);
        wrapper.in((Object)"is_schedule", list);
        return (InquiryServiceConfigEntity)this.inquiryServiceConfigService.getOne((Wrapper)wrapper);
    }

    public BaseResponse<String> saveDeptSearchRecords(ReqSaveDeptSearchRecordsVo reqSaveDeptSearchRecordsVo) {
        if (StringUtils.isNotEmpty((String)reqSaveDeptSearchRecordsVo.getSearchParam()) && StringUtils.isNotEmpty((String)reqSaveDeptSearchRecordsVo.getUserId())) {
            this.redisHistoryNew(reqSaveDeptSearchRecordsVo);
            return BaseResponse.success();
        }
        return BaseResponse.error((String)"");
    }

    private void redisHistoryNew(ReqSaveDeptSearchRecordsVo reqSaveDeptSearchRecordsVo) {
        String redisValue;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        String value = simpleDateFormat.format(new Date());
        log.info("===========value===========:" + value);
        String userId = reqSaveDeptSearchRecordsVo.getUserId();
        String deptSearch = reqSaveDeptSearchRecordsVo.getDeptSearch();
        String key = userId;
        if (null != reqSaveDeptSearchRecordsVo.getDeptSearch()) {
            key = key + deptSearch;
        }
        if (null == (redisValue = this.redisUtil.get(key))) {
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            map.put(reqSaveDeptSearchRecordsVo.getSearchParam(), value);
            log.info("map\u7684\u5927\u5c0f\u4e3a:" + map.size());
            String jsonString = JSON.toJSONString(map);
            this.redisUtil.set(key, jsonString);
        } else {
            Map redisMap = (Map)JSONObject.parseObject((String)redisValue, Map.class);
            if (redisMap.size() < 5) {
                boolean flag = redisMap.containsKey(reqSaveDeptSearchRecordsVo.getSearchParam());
                if (!flag) {
                    redisMap.put(reqSaveDeptSearchRecordsVo.getSearchParam(), value);
                } else {
                    redisMap.remove(reqSaveDeptSearchRecordsVo.getSearchParam());
                    redisMap.put(reqSaveDeptSearchRecordsVo.getSearchParam(), value);
                }
                redisMap.put(reqSaveDeptSearchRecordsVo.getSearchParam(), value);
                String jsonString = JSON.toJSONString((Object)redisMap);
                this.redisUtil.set(key, jsonString);
                log.info("redis\u4e2dsize<5\u7684map\u7684\u5927\u5c0f\u4e3a:" + redisMap.size());
            } else {
                Map mapResult = DoctorServiceImpl.sortByValue((Map)redisMap, (boolean)true);
                log.info("\u6392\u5e8f\u540e\u7684map\u6709\u5e8fmap\u4e3a:" + mapResult);
                boolean flag = mapResult.containsKey(reqSaveDeptSearchRecordsVo.getSearchParam());
                if (!flag) {
                    Field tail = null;
                    try {
                        tail = mapResult.getClass().getDeclaredField("tail");
                    }
                    catch (NoSuchFieldException e) {
                        e.printStackTrace();
                    }
                    tail.setAccessible(true);
                    Map.Entry entry = null;
                    try {
                        entry = (Map.Entry)tail.get(mapResult);
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                    String key1 = (String)entry.getKey();
                    log.info("\u5220\u9664\u7684\u6700\u65e9\u7684\u4e00\u6761\u8bb0\u5f55\u7684key\u662f:" + key1);
                    mapResult.remove(key1);
                    log.info("\u5220\u9664\u4e00\u6761\u8bb0\u5f55\u7684map\u4e3a" + mapResult);
                    mapResult.put(reqSaveDeptSearchRecordsVo.getSearchParam(), value);
                } else {
                    mapResult.remove(reqSaveDeptSearchRecordsVo.getSearchParam());
                    mapResult.put(reqSaveDeptSearchRecordsVo.getSearchParam(), value);
                }
                log.info("\u91cd\u65b0\u653e\u5165\u4e00\u6761\u8bb0\u5f55\u7684map\u4e3a" + mapResult);
                String jsonString = JSON.toJSONString((Object)mapResult);
                this.redisUtil.set(key, jsonString);
                log.info("redis\u4e2dmap\u7684\u5927\u5c0f\u4e3a:" + redisMap.size());
            }
        }
    }

    public BaseResponse<List<ReferralDoctorFilterResVo>> referralDoctorFilter(ReferralDoctorFilterReqVo referralDoctorFilterReqVo) {
        BusinessDoctorListReqVo doctorPageReqVo = new BusinessDoctorListReqVo();
        doctorPageReqVo.setOrganId(Long.valueOf(referralDoctorFilterReqVo.getHospitalId()));
        if (ServiceTypeEnum.HOS.getValue().equals(referralDoctorFilterReqVo.getServType())) {
            doctorPageReqVo.setServiceCode(ServiceTypeEnum.HOS.getCode());
        }
        if (ServiceTypeEnum.NOS.getValue().equals(referralDoctorFilterReqVo.getServType())) {
            doctorPageReqVo.setServiceCode(ServiceTypeEnum.NOS.getCode());
        }
        doctorPageReqVo.setStatus(1);
        doctorPageReqVo.setOrganDeptId(StringUtils.isEmpty((String)referralDoctorFilterReqVo.getDeptId()) ? null : Long.valueOf(referralDoctorFilterReqVo.getDeptId()));
        log.info("\u67e5\u8be2\u5f00\u901a\u670d\u52a1\u533b\u751f\u5165\u53c2:{}" + JSON.toJSONString((Object)doctorPageReqVo));
        BaseResponse doctorBasicResBase = this.doctorWorkingServiceClient.getBusinessDoctorList(doctorPageReqVo);
        if (!doctorBasicResBase.isSuccess()) {
            return BaseResponse.error((String)"\u533b\u751f\u57fa\u7840\u670d\u52a1\u8c03\u7528\u5931\u8d25");
        }
        if (CollectionUtils.isEmpty((Collection)((Collection)doctorBasicResBase.getData()))) {
            return BaseResponse.success(new ArrayList());
        }
        log.info("\u67e5\u8be2\u5f00\u901a\u670d\u52a1\u533b\u751f\u51fa\u53c2:{}" + JSON.toJSONString((Object)doctorBasicResBase));
        List collect = ((List)doctorBasicResBase.getData()).stream().filter(d -> !referralDoctorFilterReqVo.getDoctorId().equals(d.getXId().toString())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(collect)) {
            return BaseResponse.success(new ArrayList());
        }
        ArrayList referralDoctorFilterResList = new ArrayList();
        collect.stream().forEach(res -> {
            ReferralDoctorFilterResVo referralDoctorFilterResVo = new ReferralDoctorFilterResVo();
            referralDoctorFilterResVo.setDeptId(res.getDeptId().toString());
            referralDoctorFilterResVo.setDoctorId(res.getXId().toString());
            referralDoctorFilterResVo.setDeptName(res.getDeptName());
            referralDoctorFilterResVo.setDoctorName(res.getDoctorName());
            referralDoctorFilterResList.add(referralDoctorFilterResVo);
        });
        return BaseResponse.success(referralDoctorFilterResList);
    }

    public BaseResponse<List<ServiceStatusResVO>> findServiceStatus(ServiceStatusReqVO serviceStatusReqVO) {
        OrderEntity orderEntity = this.orderMapper.findByAdmId(serviceStatusReqVO.getAdmId());
        ArrayList<ServiceStatusResVO> resVoList = new ArrayList<ServiceStatusResVO>();
        ServiceCheckReqVo serviceCheckReqVo = new ServiceCheckReqVo();
        serviceCheckReqVo.setDoctorId(Long.valueOf(Long.parseLong(serviceStatusReqVO.getDoctorId())));
        serviceCheckReqVo.setOrganId(Long.valueOf(Long.parseLong(orderEntity.getOrganId())));
        serviceCheckReqVo.setDeptId(Long.valueOf(Long.parseLong(serviceStatusReqVO.getDeptId())));
        serviceCheckReqVo.setServiceCode("53110");
        ServiceStatusResVO serviceStatusResVO1 = new ServiceStatusResVO();
        serviceStatusResVO1.setServiceType("\u5728\u7ebf\u590d\u8bca");
        BaseResponse response = this.doctorWorkingServiceClient.checkDoctorServiceByCode(serviceCheckReqVo);
        log.info(JSON.toJSONString((Object)response));
        if (((Boolean)response.getData()).booleanValue()) {
            QueryWrapper queryWrapper = new QueryWrapper();
            InquiryServiceConfigEntity wrapperEntity = new InquiryServiceConfigEntity();
            wrapperEntity.setDoctorId(serviceStatusReqVO.getDoctorId());
            wrapperEntity.setOrganId(orderEntity.getOrganId());
            wrapperEntity.setStatus(Integer.valueOf(CommonConstants.STATUS_VALID));
            wrapperEntity.setDeptId(Long.valueOf(Long.parseLong(serviceStatusReqVO.getDeptId())));
            wrapperEntity.setServiceCode("53110");
            log.info("wrapperEntity:{}" + JSON.toJSONString((Object)wrapperEntity));
            queryWrapper.setEntity((Object)wrapperEntity);
            queryWrapper.in((Object)"is_schedule", new Object[]{1, 2, 3});
            List list1 = this.inquiryServiceConfigService.list((Wrapper)queryWrapper);
            if (!CollectionUtils.isEmpty((Collection)list1)) {
                serviceStatusResVO1.setServiceStatus("1");
                serviceStatusResVO1.setServTime(DateUtils.toDayHourMinuteString((int)((InquiryServiceConfigEntity)list1.get(0)).getServTime()));
                serviceStatusResVO1.setNumLimit(((InquiryServiceConfigEntity)list1.get(0)).getNumLimit().toString());
                serviceStatusResVO1.setOrderTime(DateUtils.toDayHourMinuteString((int)((InquiryServiceConfigEntity)list1.get(0)).getOrderTime()));
                String orderTime = DateUtils.toDayHourMinuteString((int)((InquiryServiceConfigEntity)list1.get(0)).getOrderTime());
                switch (((InquiryServiceConfigEntity)list1.get(0)).getIsSchedule()) {
                    case 1: {
                        serviceStatusResVO1.setOrderTime(orderTime);
                        break;
                    }
                    case 2: {
                        serviceStatusResVO1.setOrderTime("\u9884\u7ea6\u65f6\u95f4");
                        break;
                    }
                    case 3: {
                        serviceStatusResVO1.setOrderTime(orderTime + "/\u9884\u7ea6\u65f6\u95f4");
                    }
                }
                serviceStatusResVO1.setServiceStatus("1");
                serviceStatusResVO1.setServTime(DateUtils.toDayHourMinuteString((int)((InquiryServiceConfigEntity)list1.get(0)).getServTime()));
                serviceStatusResVO1.setNumLimit(((InquiryServiceConfigEntity)list1.get(0)).getNumLimit().toString());
                serviceStatusResVO1.setPrice(((InquiryServiceConfigEntity)list1.get(0)).getPrice().toString());
            } else {
                serviceStatusResVO1.setServiceStatus("-1");
            }
        } else {
            serviceStatusResVO1.setServiceStatus("-1");
        }
        resVoList.add(serviceStatusResVO1);
        serviceCheckReqVo.setServiceCode("51110");
        ServiceStatusResVO serviceStatusResVO3 = new ServiceStatusResVO();
        serviceStatusResVO3.setServiceType("\u8fdc\u7a0b\u4f1a\u8bca");
        response = this.doctorWorkingServiceClient.checkDoctorServiceByCode(serviceCheckReqVo);
        log.info(JSON.toJSONString((Object)response));
        if (((Boolean)response.getData()).booleanValue()) {
            serviceStatusResVO3.setServiceType("\u8fdc\u7a0b\u4f1a\u8bca");
            serviceStatusResVO3.setServiceStatus("1");
        } else {
            serviceStatusResVO3.setServiceStatus("-1");
        }
        resVoList.add(serviceStatusResVO3);
        return BaseResponse.success(resVoList);
    }

    public BaseResponse<Boolean> recommService(RecommServiceReqVO recommServiceReqVO) {
        this.executor.submit((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        return BaseResponse.success((Object)true);
    }

    public BaseResponse<Boolean> recommDoctor(RecommDoctorReqVO recommDoctorReqVO) {
        this.executor.submit((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        return BaseResponse.success((Object)true);
    }

    public BaseResponse<List<SerachDoctorRes>> serachDoctor(SerachDoctorReq serachDoctorReq) {
        OrderEntity orderEntity = this.orderMapper.findByAdmId(serachDoctorReq.getAdmId());
        ArrayList<SerachDoctorRes> resVoList = new ArrayList<SerachDoctorRes>();
        QueryFamousDotDTO queryFamousDotDTO = new QueryFamousDotDTO();
        queryFamousDotDTO.setUserId(serachDoctorReq.getDoctorId());
        queryFamousDotDTO.setSearchParam(serachDoctorReq.getSearchParam());
        this.redisHistory(queryFamousDotDTO);
        BusinessDoctorPageReqVo doctorPageReqVo = new BusinessDoctorPageReqVo();
        doctorPageReqVo.setOrganId(Long.valueOf(Long.parseLong(orderEntity.getOrganId())));
        if ("3".equals(serachDoctorReq.getServiceType())) {
            doctorPageReqVo.setServiceCode("53110");
        } else if ("2".equals(serachDoctorReq.getServiceType())) {
            doctorPageReqVo.setServiceCode("zxmz");
        }
        ArrayList doctorBasicRespVoList1 = new ArrayList();
        String searchParam = "";
        searchParam = serachDoctorReq.getSearchParam();
        Long stdFirstDeptId = null;
        Long stdSecondDeptId = null;
        Long hospitalDeptId = null;
        Long professionCode = null;
        String organId = orderEntity.getOrganId();
        Long status = 5L;
        String startTime = "";
        String endTime = "";
        Integer page = 1;
        Integer size = 1000;
        String appCode = orderEntity.getAppCode();
        BaseResponse result1 = this.doctorDetailInfoApi.getDoctorList("", stdFirstDeptId, stdSecondDeptId, hospitalDeptId, professionCode, organId, status, startTime, endTime, page, size, appCode);
        if (null != result1 && null != result1.getData()) {
            Map data = (Map)result1.getData();
            String json = JSONObject.toJSONString(data.get("pageData"));
            LinkedList doctorBasicInfoVoList = (LinkedList)JSONObject.parseObject((String)json, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
            String finalSearchParam = searchParam;
            List<Object> doctorBasicInfoVoListNew = new ArrayList();
            doctorBasicInfoVoListNew = doctorBasicInfoVoList.stream().filter(DoctorRespVO2 -> DoctorRespVO2.getHospitalDeptName().contains(finalSearchParam)).collect(Collectors.toList());
            doctorBasicRespVoList1.addAll(doctorBasicInfoVoListNew);
        }
        BaseResponse result = this.doctorDetailInfoApi.getDoctorList(searchParam, stdFirstDeptId, stdSecondDeptId, hospitalDeptId, professionCode, organId, status, startTime, endTime, page, size, appCode);
        log.info("doctorPageReqVo:{}" + JSON.toJSONString((Object)result));
        if (null != result && null != result.getData()) {
            Map data = (Map)result.getData();
            String json = JSONObject.toJSONString(data.get("pageData"));
            log.info("\u5f00\u901a\u670d\u52a1\u7684\u533b\u751f{}", (Object)json);
            LinkedList doctorBasicInfoVoList = (LinkedList)JSONObject.parseObject((String)json, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
            doctorBasicRespVoList1.addAll(doctorBasicInfoVoList);
        }
        if (CollectionUtils.isEmpty(doctorBasicRespVoList1)) {
            return BaseResponse.error((String)"\u65e0\u5f00\u901a\u670d\u52a1\u7684\u533b\u751f");
        }
        for (DoctorRespVO doctorBasicRespVO : doctorBasicRespVoList1) {
            if (serachDoctorReq.getDoctorId().equals(doctorBasicRespVO.getDoctorId())) continue;
            SerachDoctorRes serachDoctorRes = new SerachDoctorRes();
            serachDoctorRes.setDeptName(doctorBasicRespVO.getHospitalDeptName());
            serachDoctorRes.setDoctorId(doctorBasicRespVO.getDoctorId());
            serachDoctorRes.setDoctorName(doctorBasicRespVO.getName());
            serachDoctorRes.setOrganName(doctorBasicRespVO.getHospitalName());
            serachDoctorRes.setTitleName(doctorBasicRespVO.getProfession());
            serachDoctorRes.setPortrait(doctorBasicRespVO.getHeadPortrait());
            serachDoctorRes.setProfession(doctorBasicRespVO.getSpeciality());
            resVoList.add(serachDoctorRes);
        }
        return BaseResponse.success(resVoList);
    }

    public BaseResponse<ServiceStatusResVO> getAppointMent(ServiceStatusReqVO serviceStatusReqVO) {
        OrderEntity orderEntity = this.orderMapper.findByAdmId(serviceStatusReqVO.getAdmId());
        ServiceStatusResVO serviceStatusResVO = new ServiceStatusResVO();
        serviceStatusResVO.setServiceType("\u9884\u7ea6\u6302\u53f7");
        serviceStatusResVO.setServiceStatus("-1");
        GetAppointMentReqVO getAppointMentReqVO = new GetAppointMentReqVO();
        HisDeptAndDocCodeVo hisDeptAndDocCode = this.internetHospitalDetailInfoService.getHisDeptAndDocCode(orderEntity.getDeptId().toString(), orderEntity.getDoctorId());
        log.info("hisDeptAndDocCode:{}", (Object)hisDeptAndDocCode);
        getAppointMentReqVO.setDocCode(hisDeptAndDocCode.getDoctorCode());
        getAppointMentReqVO.setLocCode(hisDeptAndDocCode.getDeptCode());
        if ("NCEFY".equals(orderEntity.getAppCode())) {
            NcefyHisDeptEntity ncefyHisDeptEntity = (NcefyHisDeptEntity)this.ncefyHisDeptMapper.selectOne((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(NcefyHisDeptEntity::getHisDeptCode, (Object)hisDeptAndDocCode.getDeptCode())).eq(NcefyHisDeptEntity::getHospCode, (Object)orderEntity.getOrganId()));
            log.info("his\u79d1\u5ba4:{}", (Object)ncefyHisDeptEntity);
            NcefyHisDoctorEntity ncefyHisDoctorEntity = (NcefyHisDoctorEntity)this.ncefyHisDoctorMapper.selectOne((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(NcefyHisDoctorEntity::getHisDoctorCode, (Object)hisDeptAndDocCode.getDoctorCode())).eq(NcefyHisDoctorEntity::getHospCode, (Object)orderEntity.getOrganId()));
            log.info("his\u533b\u751f:{}", (Object)ncefyHisDoctorEntity);
            if (ncefyHisDeptEntity != null && ncefyHisDoctorEntity != null) {
                getAppointMentReqVO.setDocCode(ncefyHisDoctorEntity.getHisDoctorId());
                getAppointMentReqVO.setLocCode(ncefyHisDeptEntity.getHisDeptId());
            }
        }
        Date beginDate = new Date();
        Date endDate = DateUtils.getAfterCurrentDay((int)30);
        String begin = DateUtils.dateToSimpleString((Date)beginDate);
        String end = DateUtils.dateToSimpleString((Date)endDate);
        getAppointMentReqVO.setBgDate(begin);
        getAppointMentReqVO.setEdDate(end);
        GetAppointMentResVO appointMent = this.hisTemplateService.getAppointMent(getAppointMentReqVO);
        if (null == appointMent) {
            return BaseResponse.success((Object)serviceStatusResVO);
        }
        List items = appointMent.getItems();
        if (CollectionUtils.isEmpty((Collection)items)) {
            return BaseResponse.success((Object)serviceStatusResVO);
        }
        for (GetScheduleResItems item : items) {
            if (item.getRegAvailable() <= 0) continue;
            serviceStatusResVO.setServiceStatus("1");
            Integer price = Integer.parseInt(item.getDiagFee()) + Integer.parseInt(item.getRegFee());
            serviceStatusResVO.setPrice(price.toString());
            break;
        }
        return BaseResponse.success((Object)serviceStatusResVO);
    }

    public BaseResponse<PageResult<DoctorAliListVo>> getSatfactionAndIdentity(QueryFamousDotDTO reqVo) {
        if (StringUtils.isNotEmpty((String)reqVo.getSearchParam()) && StringUtils.isNotEmpty((String)reqVo.getUserId())) {
            this.redisHistory(reqVo);
        }
        if (ServiceTypeEnum.HOS.getValue().equals(reqVo.getType())) {
            reqVo.setServiceCodes(ServiceTypeEnum.HOS.getCode());
        }
        if (ServiceTypeEnum.NOS.getValue().equals(reqVo.getType())) {
            reqVo.setServiceCodes(ServiceTypeEnum.NOS.getCode());
        }
        String wOrganId = reqVo.getOrganId().toString();
        PageResult pageResult = new PageResult();
        List docBaseList = this.getDoctorsAndIdentity(reqVo);
        if (CollectionUtils.isEmpty((Collection)docBaseList)) {
            pageResult.setContent(new ArrayList());
            pageResult.setPageNum(reqVo.getPageNum().intValue());
            pageResult.setPageSize(reqVo.getPageSize().intValue());
            return BaseResponse.success((Object)pageResult);
        }
        log.info("\u7528\u4e8e\u5faa\u73af\u7684\u96c6\u5408{}", (Object)JSON.toJSONString((Object)docBaseList));
        ArrayList<DoctorAliListVo> doctorListVos = new ArrayList<DoctorAliListVo>();
        List doctorIds = docBaseList.stream().map(DoctorBasicInfoVo::getXId).map(String::valueOf).collect(Collectors.toList());
        log.info("\u533b\u751f\u5217\u8868doctorIds:{}", (Object)JSON.toJSONString(doctorIds));
        BaseResponse doctorAverageScoreByDoctorIds = this.doctorUserEvaluationFeignClient.getDoctorAverageScoreByDoctorIds(doctorIds);
        log.info("\u67e5\u533b\u751f\u8bc4\u5206getDoctorAverageScoreByDoctorIds\u8fd4\u56de\u503c:{}", (Object)JSON.toJSONString((Object)doctorAverageScoreByDoctorIds));
        List doctorAverageScoreRespVOS = (List)doctorAverageScoreByDoctorIds.getData();
        Map<String, String> map = doctorAverageScoreRespVOS.stream().collect(Collectors.toMap(DoctorAverageScoreRespVO::getDoctorId, DoctorAverageScoreRespVO::getAverageScore));
        log.info("\u67e5\u533b\u751f\u8bc4\u5206map:{}", map);
        ZXWZServiceBo doctorZxwzService = new ZXWZServiceBo();
        for (DoctorAlipayUploadRespVO dto : docBaseList) {
            Integer doctorId = dto.getXId().intValue();
            DoctorAliListVo doctorListVo = new DoctorAliListVo();
            QueryWrapper queryWrapper = new QueryWrapper();
            AdmissionEntity wrapperEntity = new AdmissionEntity();
            wrapperEntity.setDoctorId(doctorId.toString());
            ArrayList<Integer> list = new ArrayList<Integer>();
            list.add(1);
            list.add(2);
            wrapperEntity.setServType(reqVo.getType());
            queryWrapper.setEntity((Object)wrapperEntity);
            queryWrapper.in((Object)"status", list);
            int inService = this.baseInquiryAdmissionService.count((Wrapper)queryWrapper);
            doctorListVo.setInService(Integer.valueOf(inService));
            BeanUtils.copyProperties((Object)dto, (Object)doctorListVo);
            doctorListVo.setTitle(dto.getStandardTitle());
            doctorListVo.setDoctorId(doctorId.toString());
            doctorListVo.setOrganId(Integer.valueOf(wOrganId));
            doctorListVo.setDeptId(Integer.valueOf(dto.getDeptId().intValue()));
            doctorListVo.setPhoneNum(dto.getTelephone());
            doctorListVo.setIdCard(dto.getIdCard());
            String doctorScore = "5.0";
            String value = map.get(doctorListVo.getDoctorId());
            log.info("\u533b\u751f\u8bc4\u5206value:{}", (Object)value);
            if (null != map && null != value) {
                doctorScore = "0.0".equals(value) ? "5.0" : value;
            }
            doctorListVo.setSatisfaction(doctorScore);
            doctorListVo.setServTimes(this.getDoctorServTimes(doctorId.toString(), dto.getOrganId().toString(), reqVo.getType()));
            doctorListVo.setLastSelect(new Integer("0"));
            ServiceConfigVo serviceConfigVo = new ServiceConfigVo();
            if (StringUtils.isEmpty((String)dto.getServiceConfig())) {
                log.info("\u65e0\u670d\u52a1\u914d\u7f6e\u4fe1\u606f\u7684\u533b\u751fID{}", (Object)JSON.toJSONString((Object)dto.getXId()));
                continue;
            }
            ZXWZServiceBo zxwzServiceBo = (ZXWZServiceBo)JSON.parseObject((String)dto.getServiceConfig(), ZXWZServiceBo.class);
            if (null == zxwzServiceBo) continue;
            log.info("zxwzServiceBo{}", (Object)JSON.toJSONString((Object)zxwzServiceBo));
            serviceConfigVo.setPrice(zxwzServiceBo.getServicePrice());
            serviceConfigVo.setDailyLimit(zxwzServiceBo.getNumLimit());
            serviceConfigVo.setNumLimit(zxwzServiceBo.getReplyLimit());
            serviceConfigVo.setServTime(zxwzServiceBo.getEffectiveTime());
            DoctorAliListVo.ServiceConfigVo serviceConfig = new DoctorAliListVo.ServiceConfigVo();
            BeanUtils.copyProperties((Object)serviceConfigVo, (Object)serviceConfig);
            doctorListVo.setServiceConfigData(serviceConfig);
            DoctorListVo doctorList = new DoctorListVo();
            BeanUtils.copyProperties((Object)doctorListVo, (Object)doctorList);
            this.getDoctorOfficeStatusAndDoctorLabel(reqVo, dto.getDeptId(), dto.getOrganId(), doctorId, doctorList);
            doctorListVo.setOfficeStatus(doctorList.getOfficeStatus());
            if (Objects.equals(OrganCodeEnum.NCEFY.getValue(), reqVo.getAppCode()) || Objects.equals(OrganCodeEnum.YCRMYY.getValue(), reqVo.getAppCode())) {
                BaseResponse docIsLearder = this.doctorTemInfomService.getDocIsLearder(doctorId.toString(), wOrganId);
                List personTeamNew = this.doctorTemInfomService.getPersonTeamNew(doctorId.toString());
                if (docIsLearder.isSuccess() && ((Boolean)docIsLearder.getData()).booleanValue() && personTeamNew != null) {
                    doctorListVo.setDoctorType(DoctorTypeEnum.TEAM.getValue());
                } else {
                    doctorListVo.setDoctorType(DoctorTypeEnum.PERSONAL.getValue());
                }
            }
            doctorListVos.add(doctorListVo);
        }
        pageResult.setPageNum(reqVo.getPageNum().intValue());
        pageResult.setPageSize(doctorListVos.size());
        pageResult.setContent(doctorListVos);
        return BaseResponse.success((Object)pageResult);
    }

    private List<DoctorAlipayUploadRespVO> getDoctorsAndIdentity(QueryFamousDotDTO reqVo) {
        ArrayList<DoctorAlipayUploadRespVO> docBaseList = new ArrayList<DoctorAlipayUploadRespVO>();
        BusinessDoctorPageReqVo businessDoctorPageReqVo = new BusinessDoctorPageReqVo();
        reqVo.setSeq(Integer.valueOf(1));
        reqVo.setStatus(Integer.valueOf(1));
        BeanUtils.copyProperties((Object)reqVo, (Object)businessDoctorPageReqVo);
        businessDoctorPageReqVo.setServiceCode(reqVo.getServiceCodes());
        log.info("\u533b\u751f\u6570\u636e\u5165\u53c2" + JSON.toJSONString((Object)businessDoctorPageReqVo));
        BaseResponse businessDoctorPage = this.doctorWorkingServiceClient.getDoctorListForAlipayUpload(businessDoctorPageReqVo);
        log.info("\u533b\u751f\u6570\u636e\u51fa\u53c2" + JSON.toJSONString((Object)businessDoctorPage.getData()));
        if (null == businessDoctorPage.getData()) {
            return new ArrayList<DoctorAlipayUploadRespVO>();
        }
        List content = ((PageResult)businessDoctorPage.getData()).getContent();
        content = content.stream().filter(vo -> "5".equals(vo.getAduitStatus())).collect(Collectors.toList());
        docBaseList.addAll(content);
        return docBaseList;
    }

    public BaseResponse<PageResult<DoctorStatisticsVo>> getDoctorMonitoringStatistics(DoctorStatisticsReqVo reqVo) {
        log.info("\u67e5\u8be2\u533b\u751f\u7edf\u8ba1\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)reqVo));
        if (ServiceTypeEnum.HOS.getValue().equals(reqVo.getType())) {
            reqVo.setServiceCodes(ServiceTypeEnum.HOS.getCode());
        }
        if (ServiceTypeEnum.NOS.getValue().equals(reqVo.getType())) {
            reqVo.setServiceCodes(ServiceTypeEnum.NOS.getCode());
        }
        PageResult pageResult = new PageResult();
        BusinessDoctorPageReqVo businessDoctorPageReqVo = new BusinessDoctorPageReqVo();
        reqVo.setSeq(Integer.valueOf(1));
        reqVo.setStatus(Integer.valueOf(1));
        BeanUtils.copyProperties((Object)reqVo, (Object)businessDoctorPageReqVo);
        businessDoctorPageReqVo.setOrganDeptId(reqVo.getDeptId());
        businessDoctorPageReqVo.setServiceCode(reqVo.getServiceCodes());
        businessDoctorPageReqVo.setOrganId(reqVo.getHospitalId());
        log.info("\u533b\u751f\u6570\u636e\u5165\u53c2" + JSON.toJSONString((Object)businessDoctorPageReqVo));
        BaseResponse businessDoctorPage = this.doctorWorkingServiceClient.getBusinessDoctorBaseInfoPage(businessDoctorPageReqVo);
        log.info("\u533b\u751f\u6570\u636e\u51fa\u53c2" + JSON.toJSONString((Object)businessDoctorPage.getData()));
        if (null == businessDoctorPage.getData()) {
            pageResult.setContent(new ArrayList());
            pageResult.setPageNum(reqVo.getPageNum());
            pageResult.setPageSize(reqVo.getPageSize());
            pageResult.setTotal(0);
            return BaseResponse.success((Object)pageResult);
        }
        List docBaseList = ((PageResult)businessDoctorPage.getData()).getContent();
        log.info("\u7528\u4e8e\u5faa\u73af\u7684\u96c6\u5408{}", (Object)JSON.toJSONString((Object)docBaseList));
        List doctorIds = docBaseList.stream().map(DoctorBasicInfoVo::getXId).map(String::valueOf).collect(Collectors.toList());
        log.info("\u533b\u751f\u5217\u8868doctorIds:{}", (Object)JSON.toJSONString(doctorIds));
        reqVo.setDoctorIds(doctorIds);
        reqVo.setEndTime(StringUtils.isEmpty((String)reqVo.getEndTime()) ? null : DateUtils.getNumAfterDate((String)reqVo.getEndTime(), (int)1));
        List doctorsScreenedByOrder = this.medicalAdmissionRefMapper.getDoctorsScreenedByOrder(reqVo);
        List doctorsPatientByOrder = this.medicalAdmissionRefMapper.getDoctorsPatientByOrder(reqVo);
        List doctorsShiftLength = this.scheduleRecordMapper.getDoctorsShiftLength(reqVo);
        log.info("\u6570\u636e\u67e5\u8be2\u5b8c\u6210");
        Map doctorsOneMap = doctorsScreenedByOrder.stream().collect(Collectors.toMap(DoctorStatisticsVo::getDoctorId, Function.identity(), (key1, key2) -> key2));
        Map doctorsTwoMap = doctorsPatientByOrder.stream().collect(Collectors.toMap(DoctorStatisticsVo::getDoctorId, Function.identity(), (key1, key2) -> key2));
        Map doctorsThreeMap = doctorsShiftLength.stream().collect(Collectors.toMap(DoctorStatisticsVo::getDoctorId, Function.identity(), (key1, key2) -> key2));
        ArrayList<DoctorStatisticsVo> doctorListVo = new ArrayList<DoctorStatisticsVo>();
        for (DoctorBasicRespVO dto : docBaseList) {
            RequestGetDoctorOfficeStatus requestGetDoctorOfficeStatus = new RequestGetDoctorOfficeStatus();
            requestGetDoctorOfficeStatus.setAppCode(reqVo.getAppCode());
            requestGetDoctorOfficeStatus.setDoctorId(dto.getXId().toString());
            requestGetDoctorOfficeStatus.setHospitalId(reqVo.getHospitalId().toString());
            BaseResponse requestOnlineOrOfflineVo = this.inquiryServiceConfig.getDoctorOfficeStatus(requestGetDoctorOfficeStatus);
            DoctorStatisticsVo doctorStatisticsVo = new DoctorStatisticsVo();
            doctorStatisticsVo.setDoctorId(dto.getXId());
            doctorStatisticsVo.setDoctorName(dto.getDoctorName());
            doctorStatisticsVo.setDeptName(dto.getDeptName());
            doctorStatisticsVo.setReservationOrderVolume(ObjectUtils.isEmpty(doctorsOneMap.get(dto.getXId())) ? "0" : ((DoctorStatisticsVo)doctorsOneMap.get(dto.getXId())).getReservationOrderVolume());
            doctorStatisticsVo.setOrderVolume(ObjectUtils.isEmpty(doctorsOneMap.get(dto.getXId())) ? "0" : ((DoctorStatisticsVo)doctorsOneMap.get(dto.getXId())).getOrderVolume());
            doctorStatisticsVo.setNumberOfPatientsReceived(ObjectUtils.isEmpty(doctorsTwoMap.get(dto.getXId())) ? "0" : ((DoctorStatisticsVo)doctorsTwoMap.get(dto.getXId())).getNumberOfPatientsReceived());
            doctorStatisticsVo.setLengthOfConsultation(ObjectUtils.isEmpty(doctorsThreeMap.get(dto.getXId())) ? "0" : ((DoctorStatisticsVo)doctorsThreeMap.get(dto.getXId())).getLengthOfConsultation());
            doctorStatisticsVo.setConsultationIsAppropriate(ObjectUtils.isEmpty(doctorsOneMap.get(dto.getXId())) ? "0" : ((DoctorStatisticsVo)doctorsOneMap.get(dto.getXId())).getConsultationIsAppropriate());
            if (null != requestOnlineOrOfflineVo.getData()) {
                doctorStatisticsVo.setOfficeStatus(((RequestOnlineOrOfflineVo)requestOnlineOrOfflineVo.getData()).getOfficeStatus());
                log.info("\u533b\u751f\u662f\u5426\u5728\u7ebf:" + ((RequestOnlineOrOfflineVo)requestOnlineOrOfflineVo.getData()).getOfficeStatus());
            }
            doctorListVo.add(doctorStatisticsVo);
        }
        pageResult.setPageNum(reqVo.getPageNum());
        pageResult.setPageSize(reqVo.getPageSize());
        pageResult.setTotal(((PageResult)businessDoctorPage.getData()).getTotal());
        pageResult.setContent(doctorListVo);
        return BaseResponse.success((Object)pageResult);
    }

    public void exportDoctorMonitoringStatistics(DoctorStatisticsReqVo reqVo, HttpServletResponse response) {
        BaseResponse doctorMonitoringStatistics = this.getDoctorMonitoringStatistics(reqVo);
        if (ObjectUtils.isEmpty((Object)doctorMonitoringStatistics.getData())) {
            return;
        }
        if (CollectionUtils.isEmpty((Collection)((PageResult)doctorMonitoringStatistics.getData()).getContent())) {
            log.info("\u67e5\u51fa\u7ed3\u679c\u4e3a\u7a7a");
            return;
        }
        List content = ((PageResult)doctorMonitoringStatistics.getData()).getContent();
        log.info("\u5728\u7ebf\u95ee\u8bca\u7684\u5bfc\u51faexcel\u4e3a:{}" + JSON.toJSONString((Object)content));
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        String dateTime = simpleDateFormat.format(new Date());
        String fileName = "\u533b\u751f\u76d1\u63a7\u6570\u636e" + dateTime;
        ExcelUtils.exportExcel((List)content, null, null, DoctorStatisticsVo.class, (String)fileName, (boolean)true, (HttpServletResponse)response);
    }

    private List<NumberConsultationsVo> getALLDoctorServTimes(String organId, Integer type) {
        return this.orderMapper.getNumberConsultations(organId, type);
    }

    static /* synthetic */ IMInformService access$000(DoctorServiceImpl x0) {
        return x0.imInformService;
    }

    static /* synthetic */ Logger access$100() {
        return log;
    }
}

